/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation;

import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.Removal;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import org.objectweb.asm.MethodVisitor;

public enum SuperMethodCall implements Implementation.Composable
{
    INSTANCE;


    @Override
    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        return instrumentedType;
    }

    @Override
    public ByteCodeAppender appender(Implementation.Target implementationTarget) {
        return new Appender(implementationTarget, Appender.TerminationHandler.RETURNING);
    }

    @Override
    public Implementation andThen(Implementation implementation) {
        return new Implementation.Compound(WithoutReturn.INSTANCE, implementation);
    }

    protected static class Appender
    implements ByteCodeAppender {
        private final Implementation.Target implementationTarget;
        private final TerminationHandler terminationHandler;

        protected Appender(Implementation.Target implementationTarget, TerminationHandler terminationHandler) {
            this.implementationTarget = implementationTarget;
            this.terminationHandler = terminationHandler;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            Implementation.SpecialMethodInvocation superMethodCall = this.implementationTarget.invokeDominant(instrumentedMethod.asSignatureToken());
            if (!superMethodCall.isValid()) {
                throw new IllegalStateException("Cannot call super (or default) method for " + instrumentedMethod);
            }
            StackManipulation.Size stackSize = new StackManipulation.Compound(MethodVariableAccess.allArgumentsOf(instrumentedMethod).prependThisReference(), superMethodCall, this.terminationHandler.of(instrumentedMethod)).apply(methodVisitor, implementationContext);
            return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Appender)) {
                return false;
            }
            Appender other = (Appender)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Implementation.Target this$implementationTarget = this.implementationTarget;
            Implementation.Target other$implementationTarget = other.implementationTarget;
            if (this$implementationTarget == null ? other$implementationTarget != null : !this$implementationTarget.equals(other$implementationTarget)) {
                return false;
            }
            TerminationHandler this$terminationHandler = this.terminationHandler;
            TerminationHandler other$terminationHandler = other.terminationHandler;
            return !(this$terminationHandler == null ? other$terminationHandler != null : !((Object)((Object)this$terminationHandler)).equals((Object)other$terminationHandler));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Appender;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Implementation.Target $implementationTarget = this.implementationTarget;
            result = result * 59 + ($implementationTarget == null ? 43 : $implementationTarget.hashCode());
            TerminationHandler $terminationHandler = this.terminationHandler;
            result = result * 59 + ($terminationHandler == null ? 43 : ((Object)((Object)$terminationHandler)).hashCode());
            return result;
        }

        protected static enum TerminationHandler {
            RETURNING{

                @Override
                protected StackManipulation of(MethodDescription methodDescription) {
                    return MethodReturn.of(methodDescription.getReturnType());
                }
            }
            ,
            DROPPING{

                @Override
                protected StackManipulation of(MethodDescription methodDescription) {
                    return Removal.of(methodDescription.getReturnType());
                }
            };


            protected abstract StackManipulation of(MethodDescription var1);
        }
    }

    protected static enum WithoutReturn implements Implementation
    {
        INSTANCE;


        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return new Appender(implementationTarget, Appender.TerminationHandler.DROPPING);
        }
    }
}

