/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.description.type;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericSignatureFormatError;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.description.ByteCodeElement;
import net.bytebuddy.description.ModifierReviewable;
import net.bytebuddy.description.TypeVariableSource;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.annotation.AnnotationSource;
import net.bytebuddy.description.enumeration.EnumerationDescription;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.type.PackageDescription;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.description.type.TypeVariableToken;
import net.bytebuddy.dynamic.TargetType;
import net.bytebuddy.implementation.bytecode.StackSize;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.CompoundList;
import net.bytebuddy.utility.JavaType;
import net.bytebuddy.utility.privilege.GetSystemPropertyAction;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.signature.SignatureWriter;

public interface TypeDescription
extends TypeDefinition,
ByteCodeElement,
TypeVariableSource {
    public static final TypeDescription OBJECT = new ForLoadedType(Object.class);
    public static final TypeDescription STRING = new ForLoadedType(String.class);
    public static final TypeDescription CLASS = new ForLoadedType(Class.class);
    public static final TypeDescription THROWABLE = new ForLoadedType(Throwable.class);
    public static final TypeDescription VOID = new ForLoadedType(Void.TYPE);
    public static final TypeList.Generic ARRAY_INTERFACES = new TypeList.Generic.ForLoadedTypes(new Type[]{Cloneable.class, Serializable.class});
    public static final TypeDescription UNDEFINED = null;

    public FieldList<FieldDescription.InDefinedShape> getDeclaredFields();

    public MethodList<MethodDescription.InDefinedShape> getDeclaredMethods();

    public boolean isInstance(Object var1);

    public boolean isAssignableFrom(Class<?> var1);

    public boolean isAssignableFrom(TypeDescription var1);

    public boolean isAssignableTo(Class<?> var1);

    public boolean isAssignableTo(TypeDescription var1);

    @Override
    public TypeDescription getComponentType();

    @Override
    public TypeDescription getDeclaringType();

    public TypeList getDeclaredTypes();

    public MethodDescription getEnclosingMethod();

    public TypeDescription getEnclosingType();

    public int getActualModifiers(boolean var1);

    public String getSimpleName();

    public String getCanonicalName();

    public boolean isAnonymousClass();

    public boolean isLocalClass();

    public boolean isMemberClass();

    public PackageDescription getPackage();

    public AnnotationList getInheritedAnnotations();

    public boolean isSamePackage(TypeDescription var1);

    public boolean isConstantPool();

    public boolean isPrimitiveWrapper();

    public boolean isAnnotationReturnType();

    public boolean isAnnotationValue();

    public boolean isAnnotationValue(Object var1);

    public boolean isPackageType();

    public int getInnerClassCount();

    public boolean isInnerClass();

    public boolean isNestedClass();

    public TypeDescription asBoxed();

    public TypeDescription asUnboxed();

    public Object getDefaultValue();

    public static class SuperTypeLoading
    extends AbstractBase {
        private final TypeDescription delegate;
        private final ClassLoader classLoader;
        private final ClassLoadingDelegate classLoadingDelegate;

        public SuperTypeLoading(TypeDescription delegate, ClassLoader classLoader) {
            this(delegate, classLoader, ClassLoadingDelegate.Simple.INSTANCE);
        }

        public SuperTypeLoading(TypeDescription delegate, ClassLoader classLoader, ClassLoadingDelegate classLoadingDelegate) {
            this.delegate = delegate;
            this.classLoader = classLoader;
            this.classLoadingDelegate = classLoadingDelegate;
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return this.delegate.getDeclaredAnnotations();
        }

        @Override
        public int getModifiers() {
            return this.delegate.getModifiers();
        }

        @Override
        public TypeList.Generic getTypeVariables() {
            return this.delegate.getTypeVariables();
        }

        @Override
        public String getDescriptor() {
            return this.delegate.getDescriptor();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public Generic getSuperClass() {
            Generic superClass = this.delegate.getSuperClass();
            return superClass == null ? Generic.UNDEFINED : new ClassLoadingTypeProjection(superClass, this.classLoader, this.classLoadingDelegate);
        }

        @Override
        public TypeList.Generic getInterfaces() {
            return new ClassLoadingTypeList(this.delegate.getInterfaces(), this.classLoader, this.classLoadingDelegate);
        }

        @Override
        public FieldList<FieldDescription.InDefinedShape> getDeclaredFields() {
            return this.delegate.getDeclaredFields();
        }

        @Override
        public MethodList<MethodDescription.InDefinedShape> getDeclaredMethods() {
            return this.delegate.getDeclaredMethods();
        }

        @Override
        public StackSize getStackSize() {
            return this.delegate.getStackSize();
        }

        @Override
        public boolean isArray() {
            return this.delegate.isArray();
        }

        @Override
        public boolean isPrimitive() {
            return this.delegate.isPrimitive();
        }

        @Override
        public TypeDescription getComponentType() {
            return this.delegate.getComponentType();
        }

        @Override
        public TypeDescription getDeclaringType() {
            return this.delegate.getDeclaringType();
        }

        @Override
        public TypeList getDeclaredTypes() {
            return this.delegate.getDeclaredTypes();
        }

        @Override
        public MethodDescription getEnclosingMethod() {
            return this.delegate.getEnclosingMethod();
        }

        @Override
        public TypeDescription getEnclosingType() {
            return this.delegate.getEnclosingType();
        }

        @Override
        public String getSimpleName() {
            return this.delegate.getSimpleName();
        }

        @Override
        public String getCanonicalName() {
            return this.delegate.getCanonicalName();
        }

        @Override
        public boolean isAnonymousClass() {
            return this.delegate.isAnonymousClass();
        }

        @Override
        public boolean isLocalClass() {
            return this.delegate.isLocalClass();
        }

        @Override
        public boolean isMemberClass() {
            return this.delegate.isMemberClass();
        }

        @Override
        public PackageDescription getPackage() {
            return this.delegate.getPackage();
        }

        protected static class ClassLoadingTypeList
        extends TypeList.Generic.AbstractBase {
            private final TypeList.Generic delegate;
            private final ClassLoader classLoader;
            private final ClassLoadingDelegate classLoadingDelegate;

            protected ClassLoadingTypeList(TypeList.Generic delegate, ClassLoader classLoader, ClassLoadingDelegate classLoadingDelegate) {
                this.delegate = delegate;
                this.classLoader = classLoader;
                this.classLoadingDelegate = classLoadingDelegate;
            }

            @Override
            public Generic get(int index) {
                return new ClassLoadingTypeProjection((Generic)this.delegate.get(index), this.classLoader, this.classLoadingDelegate);
            }

            @Override
            public int size() {
                return this.delegate.size();
            }
        }

        protected static class ClassLoadingTypeProjection
        extends Generic.LazyProjection {
            private final Generic delegate;
            private final ClassLoader classLoader;
            private final ClassLoadingDelegate classLoadingDelegate;

            protected ClassLoadingTypeProjection(Generic delegate, ClassLoader classLoader, ClassLoadingDelegate classLoadingDelegate) {
                this.delegate = delegate;
                this.classLoader = classLoader;
                this.classLoadingDelegate = classLoadingDelegate;
            }

            @Override
            public AnnotationList getDeclaredAnnotations() {
                return this.delegate.getDeclaredAnnotations();
            }

            @Override
            public TypeDescription asErasure() {
                try {
                    return new ForLoadedType(this.classLoadingDelegate.load(this.delegate.asErasure().getName(), this.classLoader));
                }
                catch (ClassNotFoundException ignored) {
                    return this.delegate.asErasure();
                }
            }

            @Override
            protected Generic resolve() {
                return this.delegate;
            }

            @Override
            public Generic getSuperClass() {
                Generic superClass = this.delegate.getSuperClass();
                if (superClass == null) {
                    return Generic.UNDEFINED;
                }
                try {
                    return new ClassLoadingTypeProjection(superClass, this.classLoadingDelegate.load(this.delegate.asErasure().getName(), this.classLoader).getClassLoader(), this.classLoadingDelegate);
                }
                catch (ClassNotFoundException ignored) {
                    return superClass;
                }
            }

            @Override
            public TypeList.Generic getInterfaces() {
                TypeList.Generic interfaces = this.delegate.getInterfaces();
                try {
                    return new ClassLoadingTypeList(interfaces, this.classLoadingDelegate.load(this.delegate.asErasure().getName(), this.classLoader).getClassLoader(), this.classLoadingDelegate);
                }
                catch (ClassNotFoundException ignored) {
                    return interfaces;
                }
            }

            @Override
            public Iterator<TypeDefinition> iterator() {
                return new TypeDefinition.SuperClassIterator(this);
            }
        }

        public static interface ClassLoadingDelegate {
            public Class<?> load(String var1, ClassLoader var2) throws ClassNotFoundException;

            public static enum Simple implements ClassLoadingDelegate
            {
                INSTANCE;


                @Override
                public Class<?> load(String name, ClassLoader classLoader) throws ClassNotFoundException {
                    return Class.forName(name, false, classLoader);
                }
            }
        }
    }

    public static class ForPackageDescription
    extends AbstractBase.OfSimpleType {
        private final PackageDescription packageDescription;

        public ForPackageDescription(PackageDescription packageDescription) {
            this.packageDescription = packageDescription;
        }

        @Override
        public Generic getSuperClass() {
            return Generic.OBJECT;
        }

        @Override
        public TypeList.Generic getInterfaces() {
            return new TypeList.Generic.Empty();
        }

        @Override
        public MethodDescription getEnclosingMethod() {
            return MethodDescription.UNDEFINED;
        }

        @Override
        public TypeDescription getEnclosingType() {
            return UNDEFINED;
        }

        @Override
        public boolean isAnonymousClass() {
            return false;
        }

        @Override
        public boolean isLocalClass() {
            return false;
        }

        @Override
        public boolean isMemberClass() {
            return false;
        }

        @Override
        public TypeList getDeclaredTypes() {
            return new TypeList.Empty();
        }

        @Override
        public FieldList<FieldDescription.InDefinedShape> getDeclaredFields() {
            return new FieldList.Empty<FieldDescription.InDefinedShape>();
        }

        @Override
        public MethodList<MethodDescription.InDefinedShape> getDeclaredMethods() {
            return new MethodList.Empty<MethodDescription.InDefinedShape>();
        }

        @Override
        public PackageDescription getPackage() {
            return this.packageDescription;
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return this.packageDescription.getDeclaredAnnotations();
        }

        @Override
        public TypeDescription getDeclaringType() {
            return UNDEFINED;
        }

        @Override
        public TypeList.Generic getTypeVariables() {
            return new TypeList.Generic.Empty();
        }

        @Override
        public int getModifiers() {
            return 5632;
        }

        @Override
        public String getName() {
            return this.packageDescription.getName() + "." + "package-info";
        }
    }

    public static class Latent
    extends AbstractBase.OfSimpleType {
        private final String name;
        private final int modifiers;
        private final Generic superClass;
        private final List<? extends Generic> interfaces;

        public Latent(String name, int modifiers, Generic superClass, Generic ... anInterface) {
            this(name, modifiers, superClass, Arrays.asList(anInterface));
        }

        public Latent(String name, int modifiers, Generic superClass, List<? extends Generic> interfaces) {
            this.name = name;
            this.modifiers = modifiers;
            this.superClass = superClass;
            this.interfaces = interfaces;
        }

        @Override
        public Generic getSuperClass() {
            return this.superClass;
        }

        @Override
        public TypeList.Generic getInterfaces() {
            return new TypeList.Generic.Explicit(this.interfaces);
        }

        @Override
        public MethodDescription getEnclosingMethod() {
            throw new IllegalStateException("Cannot resolve enclosing method of a latent type description: " + this);
        }

        @Override
        public TypeDescription getEnclosingType() {
            throw new IllegalStateException("Cannot resolve enclosing type of a latent type description: " + this);
        }

        @Override
        public TypeList getDeclaredTypes() {
            throw new IllegalStateException("Cannot resolve inner types of a latent type description: " + this);
        }

        @Override
        public boolean isAnonymousClass() {
            throw new IllegalStateException("Cannot resolve anonymous type property of a latent type description: " + this);
        }

        @Override
        public boolean isLocalClass() {
            throw new IllegalStateException("Cannot resolve local class property of a latent type description: " + this);
        }

        @Override
        public boolean isMemberClass() {
            throw new IllegalStateException("Cannot resolve member class property of a latent type description: " + this);
        }

        @Override
        public FieldList<FieldDescription.InDefinedShape> getDeclaredFields() {
            throw new IllegalStateException("Cannot resolve declared fields of a latent type description: " + this);
        }

        @Override
        public MethodList<MethodDescription.InDefinedShape> getDeclaredMethods() {
            throw new IllegalStateException("Cannot resolve declared methods of a latent type description: " + this);
        }

        @Override
        public PackageDescription getPackage() {
            String name = this.getName();
            int index = name.lastIndexOf(46);
            return index == -1 ? PackageDescription.UNDEFINED : new PackageDescription.Simple(name.substring(0, index));
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            throw new IllegalStateException("Cannot resolve declared annotations of a latent type description: " + this);
        }

        @Override
        public TypeDescription getDeclaringType() {
            throw new IllegalStateException("Cannot resolve declared type of a latent type description: " + this);
        }

        @Override
        public int getModifiers() {
            return this.modifiers;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public TypeList.Generic getTypeVariables() {
            throw new IllegalStateException("Cannot resolve type variables of a latent type description: " + this);
        }
    }

    public static class ArrayProjection
    extends AbstractBase {
        private static final int ARRAY_IMPLIED = 1040;
        private static final int ARRAY_EXCLUDED = 8712;
        private final TypeDescription componentType;
        private final int arity;

        protected ArrayProjection(TypeDescription componentType, int arity) {
            this.componentType = componentType;
            this.arity = arity;
        }

        public static TypeDescription of(TypeDescription componentType) {
            return ArrayProjection.of(componentType, 1);
        }

        public static TypeDescription of(TypeDescription componentType, int arity) {
            if (arity < 0) {
                throw new IllegalArgumentException("Arrays cannot have a negative arity");
            }
            while (componentType.isArray()) {
                componentType = componentType.getComponentType();
                ++arity;
            }
            return arity == 0 ? componentType : new ArrayProjection(componentType, arity);
        }

        @Override
        public boolean isArray() {
            return true;
        }

        @Override
        public TypeDescription getComponentType() {
            return this.arity == 1 ? this.componentType : new ArrayProjection(this.componentType, this.arity - 1);
        }

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public Generic getSuperClass() {
            return Generic.OBJECT;
        }

        @Override
        public TypeList.Generic getInterfaces() {
            return ARRAY_INTERFACES;
        }

        @Override
        public MethodDescription getEnclosingMethod() {
            return MethodDescription.UNDEFINED;
        }

        @Override
        public TypeDescription getEnclosingType() {
            return UNDEFINED;
        }

        @Override
        public TypeList getDeclaredTypes() {
            return new TypeList.Empty();
        }

        @Override
        public String getSimpleName() {
            StringBuilder stringBuilder = new StringBuilder(this.componentType.getSimpleName());
            for (int i = 0; i < this.arity; ++i) {
                stringBuilder.append("[]");
            }
            return stringBuilder.toString();
        }

        @Override
        public String getCanonicalName() {
            String canonicalName = this.componentType.getCanonicalName();
            if (canonicalName == null) {
                return NO_NAME;
            }
            StringBuilder stringBuilder = new StringBuilder(canonicalName);
            for (int i = 0; i < this.arity; ++i) {
                stringBuilder.append("[]");
            }
            return stringBuilder.toString();
        }

        @Override
        public boolean isAnonymousClass() {
            return false;
        }

        @Override
        public boolean isLocalClass() {
            return false;
        }

        @Override
        public boolean isMemberClass() {
            return false;
        }

        @Override
        public FieldList<FieldDescription.InDefinedShape> getDeclaredFields() {
            return new FieldList.Empty<FieldDescription.InDefinedShape>();
        }

        @Override
        public MethodList<MethodDescription.InDefinedShape> getDeclaredMethods() {
            return new MethodList.Empty<MethodDescription.InDefinedShape>();
        }

        @Override
        public StackSize getStackSize() {
            return StackSize.SINGLE;
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.Empty();
        }

        @Override
        public AnnotationList getInheritedAnnotations() {
            return new AnnotationList.Empty();
        }

        @Override
        public PackageDescription getPackage() {
            return PackageDescription.UNDEFINED;
        }

        @Override
        public String getName() {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.arity; ++i) {
                stringBuilder.append('[');
            }
            return stringBuilder.append(this.componentType.getDescriptor().replace('/', '.')).toString();
        }

        @Override
        public String getDescriptor() {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.arity; ++i) {
                stringBuilder.append('[');
            }
            return stringBuilder.append(this.componentType.getDescriptor()).toString();
        }

        @Override
        public TypeDescription getDeclaringType() {
            return UNDEFINED;
        }

        @Override
        public int getModifiers() {
            return this.getComponentType().getModifiers() & 0xFFFFDDF7 | 0x410;
        }

        @Override
        public TypeList.Generic getTypeVariables() {
            return new TypeList.Generic.Empty();
        }
    }

    public static class ForLoadedType
    extends AbstractBase
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Class<?> type;

        public ForLoadedType(Class<?> type) {
            this.type = type;
        }

        public static String getName(Class<?> type) {
            String name = type.getName();
            int anonymousLoaderIndex = name.indexOf(47);
            return anonymousLoaderIndex == -1 ? name : name.substring(0, anonymousLoaderIndex);
        }

        @Override
        public boolean isAssignableFrom(Class<?> type) {
            return this.type.isAssignableFrom(type) || super.isAssignableFrom(type);
        }

        @Override
        public boolean isAssignableTo(Class<?> type) {
            return type.isAssignableFrom(this.type) || super.isAssignableTo(type);
        }

        @Override
        public boolean represents(Type type) {
            return type == this.type || super.represents(type);
        }

        @Override
        public TypeDescription getComponentType() {
            Class<?> componentType = this.type.getComponentType();
            return componentType == null ? UNDEFINED : new ForLoadedType(componentType);
        }

        @Override
        public boolean isArray() {
            return this.type.isArray();
        }

        @Override
        public boolean isPrimitive() {
            return this.type.isPrimitive();
        }

        @Override
        public boolean isAnnotation() {
            return this.type.isAnnotation();
        }

        @Override
        public Generic getSuperClass() {
            if (RAW_TYPES) {
                return this.type.getSuperclass() == null ? Generic.UNDEFINED : new Generic.OfNonGenericType.ForLoadedType(this.type.getSuperclass());
            }
            return this.type.getSuperclass() == null ? Generic.UNDEFINED : new Generic.LazyProjection.ForLoadedSuperClass(this.type);
        }

        @Override
        public TypeList.Generic getInterfaces() {
            if (RAW_TYPES) {
                return this.isArray() ? ARRAY_INTERFACES : new TypeList.Generic.ForLoadedTypes(this.type.getInterfaces());
            }
            return this.isArray() ? ARRAY_INTERFACES : new TypeList.Generic.OfLoadedInterfaceTypes(this.type);
        }

        @Override
        public TypeDescription getDeclaringType() {
            Class<?> declaringType = this.type.getDeclaringClass();
            return declaringType == null ? UNDEFINED : new ForLoadedType(declaringType);
        }

        @Override
        public MethodDescription getEnclosingMethod() {
            Method enclosingMethod = this.type.getEnclosingMethod();
            Constructor<?> enclosingConstructor = this.type.getEnclosingConstructor();
            if (enclosingMethod != null) {
                return new MethodDescription.ForLoadedMethod(enclosingMethod);
            }
            if (enclosingConstructor != null) {
                return new MethodDescription.ForLoadedConstructor(enclosingConstructor);
            }
            return MethodDescription.UNDEFINED;
        }

        @Override
        public TypeDescription getEnclosingType() {
            Class<?> enclosingType = this.type.getEnclosingClass();
            return enclosingType == null ? UNDEFINED : new ForLoadedType(enclosingType);
        }

        @Override
        public TypeList getDeclaredTypes() {
            return new TypeList.ForLoadedTypes(this.type.getDeclaredClasses());
        }

        @Override
        public String getSimpleName() {
            String simpleName = this.type.getSimpleName();
            int anonymousLoaderIndex = simpleName.indexOf(47);
            if (anonymousLoaderIndex == -1) {
                return simpleName;
            }
            StringBuilder normalized = new StringBuilder(simpleName.substring(0, anonymousLoaderIndex));
            Class<?> type = this.type;
            while (type.isArray()) {
                normalized.append("[]");
                type = type.getComponentType();
            }
            return normalized.toString();
        }

        @Override
        public boolean isAnonymousClass() {
            return this.type.isAnonymousClass();
        }

        @Override
        public boolean isLocalClass() {
            return this.type.isLocalClass();
        }

        @Override
        public boolean isMemberClass() {
            return this.type.isMemberClass();
        }

        @Override
        public FieldList<FieldDescription.InDefinedShape> getDeclaredFields() {
            return new FieldList.ForLoadedFields(this.type.getDeclaredFields());
        }

        @Override
        public MethodList<MethodDescription.InDefinedShape> getDeclaredMethods() {
            return new MethodList.ForLoadedMethods(this.type);
        }

        @Override
        public PackageDescription getPackage() {
            Package aPackage = this.type.getPackage();
            return aPackage == null ? PackageDescription.UNDEFINED : new PackageDescription.ForLoadedPackage(aPackage);
        }

        @Override
        public StackSize getStackSize() {
            return StackSize.of(this.type);
        }

        @Override
        public String getName() {
            return ForLoadedType.getName(this.type);
        }

        @Override
        public String getCanonicalName() {
            String canonicalName = this.type.getCanonicalName();
            if (canonicalName == null) {
                return NO_NAME;
            }
            int anonymousLoaderIndex = canonicalName.indexOf(47);
            if (anonymousLoaderIndex == -1) {
                return canonicalName;
            }
            StringBuilder normalized = new StringBuilder(canonicalName.substring(0, anonymousLoaderIndex));
            Class<?> type = this.type;
            while (type.isArray()) {
                normalized.append("[]");
                type = type.getComponentType();
            }
            return normalized.toString();
        }

        @Override
        public String getDescriptor() {
            String name = this.type.getName();
            int anonymousLoaderIndex = name.indexOf(47);
            return anonymousLoaderIndex == -1 ? org.objectweb.asm.Type.getDescriptor(this.type) : "L" + name.substring(0, anonymousLoaderIndex).replace('.', '/') + ";";
        }

        @Override
        public int getModifiers() {
            return this.type.getModifiers();
        }

        @Override
        public TypeList.Generic getTypeVariables() {
            if (RAW_TYPES) {
                return new TypeList.Generic.Empty();
            }
            return TypeList.Generic.ForLoadedTypes.OfTypeVariables.of(this.type);
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.ForLoadedAnnotations(this.type.getDeclaredAnnotations());
        }
    }

    public static abstract class AbstractBase
    extends TypeVariableSource.AbstractBase
    implements TypeDescription {
        public static final boolean RAW_TYPES;

        private static boolean isAssignable(TypeDescription sourceType, TypeDescription targetType) {
            if (sourceType.equals(targetType)) {
                return true;
            }
            if (targetType.isArray()) {
                return sourceType.isArray() ? AbstractBase.isAssignable(sourceType.getComponentType(), targetType.getComponentType()) : sourceType.represents((Type)((Object)Object.class)) || ARRAY_INTERFACES.contains(sourceType.asGenericType());
            }
            if (sourceType.represents((Type)((Object)Object.class))) {
                return !targetType.isPrimitive();
            }
            Generic superClass = targetType.getSuperClass();
            if (superClass != null && sourceType.isAssignableFrom(superClass.asErasure())) {
                return true;
            }
            if (sourceType.isInterface()) {
                for (TypeDescription interfaceType : targetType.getInterfaces().asErasures()) {
                    if (!sourceType.isAssignableFrom(interfaceType)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isAssignableFrom(Class<?> type) {
            return this.isAssignableFrom(new ForLoadedType(type));
        }

        @Override
        public boolean isAssignableFrom(TypeDescription typeDescription) {
            return AbstractBase.isAssignable(this, typeDescription);
        }

        @Override
        public boolean isAssignableTo(Class<?> type) {
            return this.isAssignableTo(new ForLoadedType(type));
        }

        @Override
        public boolean isAssignableTo(TypeDescription typeDescription) {
            return AbstractBase.isAssignable(typeDescription, this);
        }

        @Override
        public TypeDescription asErasure() {
            return this;
        }

        @Override
        public Generic asGenericType() {
            return new Generic.OfNonGenericType.ForErasure(this);
        }

        @Override
        public TypeDefinition.Sort getSort() {
            return TypeDefinition.Sort.NON_GENERIC;
        }

        @Override
        public boolean isInstance(Object value) {
            return this.isAssignableFrom(value.getClass());
        }

        @Override
        public boolean isAnnotationValue(Object value) {
            if (this.represents((Type)((Object)Class.class)) && value instanceof TypeDescription || value instanceof AnnotationDescription && ((AnnotationDescription)value).getAnnotationType().equals(this) || value instanceof EnumerationDescription && ((EnumerationDescription)value).getEnumerationType().equals(this) || this.represents((Type)((Object)String.class)) && value instanceof String || this.represents(Boolean.TYPE) && value instanceof Boolean || this.represents(Byte.TYPE) && value instanceof Byte || this.represents(Short.TYPE) && value instanceof Short || this.represents(Character.TYPE) && value instanceof Character || this.represents(Integer.TYPE) && value instanceof Integer || this.represents(Long.TYPE) && value instanceof Long || this.represents(Float.TYPE) && value instanceof Float || this.represents(Double.TYPE) && value instanceof Double || this.represents((Type)((Object)String[].class)) && value instanceof String[] || this.represents((Type)((Object)boolean[].class)) && value instanceof boolean[] || this.represents((Type)((Object)byte[].class)) && value instanceof byte[] || this.represents((Type)((Object)short[].class)) && value instanceof short[] || this.represents((Type)((Object)char[].class)) && value instanceof char[] || this.represents((Type)((Object)int[].class)) && value instanceof int[] || this.represents((Type)((Object)long[].class)) && value instanceof long[] || this.represents((Type)((Object)float[].class)) && value instanceof float[] || this.represents((Type)((Object)double[].class)) && value instanceof double[] || this.represents((Type)((Object)Class[].class)) && value instanceof TypeDescription[]) {
                return true;
            }
            if (this.isAssignableTo(Annotation[].class) && value instanceof AnnotationDescription[]) {
                for (AnnotationDescription annotationDescription : (AnnotationDescription[])value) {
                    if (annotationDescription.getAnnotationType().equals(this.getComponentType())) continue;
                    return false;
                }
                return true;
            }
            if (this.isAssignableTo(Enum[].class) && value instanceof EnumerationDescription[]) {
                for (EnumerationDescription enumerationDescription : (EnumerationDescription[])value) {
                    if (enumerationDescription.getEnumerationType().equals(this.getComponentType())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        public String getInternalName() {
            return this.getName().replace('.', '/');
        }

        @Override
        public int getActualModifiers(boolean superFlag) {
            int actualModifiers = this.getModifiers() | (this.getDeclaredAnnotations().isAnnotationPresent(Deprecated.class) ? 131072 : 0);
            actualModifiers = this.isPrivate() ? (actualModifiers &= 0xFFFFFFF5) : (this.isProtected() ? actualModifiers & 0xFFFFFFF3 | 1 : (actualModifiers &= 0xFFFFFFF7));
            return superFlag ? actualModifiers | 0x20 : actualModifiers;
        }

        @Override
        public String getGenericSignature() {
            try {
                SignatureWriter signatureWriter = new SignatureWriter();
                boolean generic = false;
                for (Generic typeVariable : this.getTypeVariables()) {
                    signatureWriter.visitFormalTypeParameter(typeVariable.getSymbol());
                    Iterator iterator = typeVariable.getUpperBounds().iterator();
                    while (iterator.hasNext()) {
                        Generic upperBound;
                        upperBound.accept(new Generic.Visitor.ForSignatureVisitor((upperBound = (Generic)iterator.next()).asErasure().isInterface() ? signatureWriter.visitInterfaceBound() : signatureWriter.visitClassBound()));
                    }
                    generic = true;
                }
                Generic superClass = this.getSuperClass();
                if (superClass == null) {
                    superClass = Generic.OBJECT;
                }
                superClass.accept(new Generic.Visitor.ForSignatureVisitor(signatureWriter.visitSuperclass()));
                generic = generic || !superClass.getSort().isNonGeneric();
                for (Generic interfaceType : this.getInterfaces()) {
                    interfaceType.accept(new Generic.Visitor.ForSignatureVisitor(signatureWriter.visitInterface()));
                    generic = generic || !interfaceType.getSort().isNonGeneric();
                }
                return generic ? signatureWriter.toString() : NON_GENERIC_SIGNATURE;
            }
            catch (GenericSignatureFormatError ignored) {
                return NON_GENERIC_SIGNATURE;
            }
        }

        @Override
        public boolean isSamePackage(TypeDescription typeDescription) {
            PackageDescription thisPackage = this.getPackage();
            PackageDescription otherPackage = typeDescription.getPackage();
            return thisPackage == null || otherPackage == null ? thisPackage == otherPackage : thisPackage.equals(otherPackage);
        }

        @Override
        public boolean isVisibleTo(TypeDescription typeDescription) {
            return this.isPrimitive() || (this.isArray() ? this.getComponentType().isVisibleTo(typeDescription) : this.isPublic() || this.isProtected() || this.isSamePackage(typeDescription));
        }

        @Override
        public boolean isAccessibleTo(TypeDescription typeDescription) {
            return this.isPrimitive() || (this.isArray() ? this.getComponentType().isVisibleTo(typeDescription) : this.isPublic() || this.isSamePackage(typeDescription));
        }

        @Override
        public AnnotationList getInheritedAnnotations() {
            Generic superClass = this.getSuperClass();
            AnnotationList declaredAnnotations = this.getDeclaredAnnotations();
            if (superClass == null) {
                return declaredAnnotations;
            }
            HashSet<TypeDescription> annotationTypes = new HashSet<TypeDescription>();
            for (AnnotationDescription annotationDescription : declaredAnnotations) {
                annotationTypes.add(annotationDescription.getAnnotationType());
            }
            return new AnnotationList.Explicit(CompoundList.of(declaredAnnotations, superClass.asErasure().getInheritedAnnotations().inherited(annotationTypes)));
        }

        @Override
        public String getActualName() {
            if (this.isArray()) {
                TypeDescription typeDescription = this;
                int dimensions = 0;
                do {
                    ++dimensions;
                } while ((typeDescription = typeDescription.getComponentType()).isArray());
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(typeDescription.getActualName());
                for (int i = 0; i < dimensions; ++i) {
                    stringBuilder.append("[]");
                }
                return stringBuilder.toString();
            }
            return this.getName();
        }

        @Override
        public boolean isConstantPool() {
            return this.represents(Integer.TYPE) || this.represents(Long.TYPE) || this.represents(Float.TYPE) || this.represents(Double.TYPE) || this.represents((Type)((Object)String.class)) || this.represents((Type)((Object)Class.class)) || JavaType.METHOD_HANDLE.getTypeStub().equals(this) || JavaType.METHOD_TYPE.getTypeStub().equals(this);
        }

        @Override
        public boolean isPrimitiveWrapper() {
            return this.represents((Type)((Object)Boolean.class)) || this.represents((Type)((Object)Byte.class)) || this.represents((Type)((Object)Short.class)) || this.represents((Type)((Object)Character.class)) || this.represents((Type)((Object)Integer.class)) || this.represents((Type)((Object)Long.class)) || this.represents((Type)((Object)Float.class)) || this.represents((Type)((Object)Double.class));
        }

        @Override
        public boolean isAnnotationReturnType() {
            return this.isPrimitive() || this.represents((Type)((Object)String.class)) || this.isAssignableTo(Enum.class) && !this.represents((Type)((Object)Enum.class)) || this.isAssignableTo(Annotation.class) && !this.represents((Type)((Object)Annotation.class)) || this.represents((Type)((Object)Class.class)) || this.isArray() && !this.getComponentType().isArray() && this.getComponentType().isAnnotationReturnType();
        }

        @Override
        public boolean isAnnotationValue() {
            return this.isPrimitive() || this.represents((Type)((Object)String.class)) || this.isAssignableTo(TypeDescription.class) || this.isAssignableTo(AnnotationDescription.class) || this.isAssignableTo(EnumerationDescription.class) || this.isArray() && !this.getComponentType().isArray() && this.getComponentType().isAnnotationValue();
        }

        @Override
        @SuppressFBWarnings(value={"EC_UNRELATED_CLASS_AND_INTERFACE"}, justification="Fits equality contract for type definitions")
        public boolean represents(Type type) {
            return this.equals(TypeDefinition.Sort.describe(type));
        }

        @Override
        public String getTypeName() {
            return this.getName();
        }

        @Override
        public TypeVariableSource getEnclosingSource() {
            MethodDescription enclosingMethod = this.getEnclosingMethod();
            return enclosingMethod == null ? (this.isStatic() ? TypeVariableSource.UNDEFINED : this.getEnclosingType()) : enclosingMethod;
        }

        @Override
        public <T> T accept(TypeVariableSource.Visitor<T> visitor) {
            return visitor.onType(this);
        }

        @Override
        public boolean isPackageType() {
            return this.getSimpleName().equals("package-info");
        }

        @Override
        public boolean isGenerified() {
            if (!this.getTypeVariables().isEmpty()) {
                return true;
            }
            if (this.isStatic()) {
                return false;
            }
            TypeDescription declaringType = this.getDeclaringType();
            return declaringType != null && declaringType.isGenerified();
        }

        @Override
        public int getInnerClassCount() {
            if (this.isStatic()) {
                return 0;
            }
            TypeDescription declaringType = this.getDeclaringType();
            return declaringType == null ? 0 : declaringType.getInnerClassCount() + 1;
        }

        @Override
        public boolean isInnerClass() {
            return !this.isStatic() && this.isNestedClass();
        }

        @Override
        public boolean isNestedClass() {
            return this.getDeclaringType() != null;
        }

        @Override
        public TypeDescription asBoxed() {
            if (this.represents(Boolean.TYPE)) {
                return new ForLoadedType(Boolean.class);
            }
            if (this.represents(Byte.TYPE)) {
                return new ForLoadedType(Byte.class);
            }
            if (this.represents(Short.TYPE)) {
                return new ForLoadedType(Short.class);
            }
            if (this.represents(Character.TYPE)) {
                return new ForLoadedType(Character.class);
            }
            if (this.represents(Integer.TYPE)) {
                return new ForLoadedType(Integer.class);
            }
            if (this.represents(Long.TYPE)) {
                return new ForLoadedType(Long.class);
            }
            if (this.represents(Float.TYPE)) {
                return new ForLoadedType(Float.class);
            }
            if (this.represents(Double.TYPE)) {
                return new ForLoadedType(Double.class);
            }
            return this;
        }

        @Override
        public TypeDescription asUnboxed() {
            if (this.represents((Type)((Object)Boolean.class))) {
                return new ForLoadedType(Boolean.TYPE);
            }
            if (this.represents((Type)((Object)Byte.class))) {
                return new ForLoadedType(Byte.TYPE);
            }
            if (this.represents((Type)((Object)Short.class))) {
                return new ForLoadedType(Short.TYPE);
            }
            if (this.represents((Type)((Object)Character.class))) {
                return new ForLoadedType(Character.TYPE);
            }
            if (this.represents((Type)((Object)Integer.class))) {
                return new ForLoadedType(Integer.TYPE);
            }
            if (this.represents((Type)((Object)Long.class))) {
                return new ForLoadedType(Long.TYPE);
            }
            if (this.represents((Type)((Object)Float.class))) {
                return new ForLoadedType(Float.TYPE);
            }
            if (this.represents((Type)((Object)Double.class))) {
                return new ForLoadedType(Double.TYPE);
            }
            return this;
        }

        @Override
        public Object getDefaultValue() {
            if (this.represents(Boolean.TYPE)) {
                return false;
            }
            if (this.represents(Byte.TYPE)) {
                return (byte)0;
            }
            if (this.represents(Short.TYPE)) {
                return (short)0;
            }
            if (this.represents(Character.TYPE)) {
                return Character.valueOf('\u0000');
            }
            if (this.represents(Integer.TYPE)) {
                return 0;
            }
            if (this.represents(Long.TYPE)) {
                return 0L;
            }
            if (this.represents(Float.TYPE)) {
                return Float.valueOf(0.0f);
            }
            if (this.represents(Double.TYPE)) {
                return 0.0;
            }
            return null;
        }

        @Override
        public Iterator<TypeDefinition> iterator() {
            return new TypeDefinition.SuperClassIterator(this);
        }

        public boolean equals(Object other) {
            return other == this || other instanceof TypeDefinition && ((TypeDefinition)other).getSort().isNonGeneric() && this.getName().equals(((TypeDefinition)other).asErasure().getName());
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public String toString() {
            return (this.isPrimitive() ? "" : (this.isInterface() ? "interface" : "class") + " ") + this.getName();
        }

        static {
            boolean rawTypes;
            try {
                rawTypes = Boolean.parseBoolean(AccessController.doPrivileged(new GetSystemPropertyAction("net.bytebuddy.raw")));
            }
            catch (Exception ignored) {
                rawTypes = false;
            }
            RAW_TYPES = rawTypes;
        }

        public static abstract class OfSimpleType
        extends AbstractBase {
            @Override
            public boolean isPrimitive() {
                return false;
            }

            @Override
            public boolean isArray() {
                return false;
            }

            @Override
            public TypeDescription getComponentType() {
                return UNDEFINED;
            }

            @Override
            public String getDescriptor() {
                return "L" + this.getInternalName() + ";";
            }

            @Override
            public String getCanonicalName() {
                return this.isAnonymousClass() || this.isLocalClass() ? NO_NAME : this.getName().replace('$', '.');
            }

            @Override
            public String getSimpleName() {
                String internalName = this.getInternalName();
                int simpleNameIndex = internalName.lastIndexOf(36);
                int n = simpleNameIndex = simpleNameIndex == -1 ? internalName.lastIndexOf(47) : simpleNameIndex;
                if (simpleNameIndex == -1) {
                    return internalName;
                }
                while (simpleNameIndex < internalName.length() && !Character.isLetter(internalName.charAt(simpleNameIndex))) {
                    ++simpleNameIndex;
                }
                return internalName.substring(simpleNameIndex);
            }

            @Override
            public StackSize getStackSize() {
                return StackSize.SINGLE;
            }

            public static abstract class WithDelegation
            extends OfSimpleType {
                protected abstract TypeDescription delegate();

                @Override
                public Generic getSuperClass() {
                    return this.delegate().getSuperClass();
                }

                @Override
                public TypeList.Generic getInterfaces() {
                    return this.delegate().getInterfaces();
                }

                @Override
                public FieldList<FieldDescription.InDefinedShape> getDeclaredFields() {
                    return this.delegate().getDeclaredFields();
                }

                @Override
                public MethodList<MethodDescription.InDefinedShape> getDeclaredMethods() {
                    return this.delegate().getDeclaredMethods();
                }

                @Override
                public TypeDescription getDeclaringType() {
                    return this.delegate().getDeclaringType();
                }

                @Override
                public MethodDescription getEnclosingMethod() {
                    return this.delegate().getEnclosingMethod();
                }

                @Override
                public TypeDescription getEnclosingType() {
                    return this.delegate().getEnclosingType();
                }

                @Override
                public TypeList getDeclaredTypes() {
                    return this.delegate().getDeclaredTypes();
                }

                @Override
                public boolean isAnonymousClass() {
                    return this.delegate().isAnonymousClass();
                }

                @Override
                public boolean isLocalClass() {
                    return this.delegate().isLocalClass();
                }

                @Override
                public boolean isMemberClass() {
                    return this.delegate().isMemberClass();
                }

                @Override
                public PackageDescription getPackage() {
                    return this.delegate().getPackage();
                }

                @Override
                public AnnotationList getDeclaredAnnotations() {
                    return this.delegate().getDeclaredAnnotations();
                }

                @Override
                public TypeList.Generic getTypeVariables() {
                    return this.delegate().getTypeVariables();
                }

                @Override
                public int getModifiers() {
                    return this.delegate().getModifiers();
                }

                @Override
                public String getGenericSignature() {
                    return this.delegate().getGenericSignature();
                }

                @Override
                public int getActualModifiers(boolean superFlag) {
                    return this.delegate().getActualModifiers(superFlag);
                }
            }
        }
    }

    public static interface Generic
    extends TypeDefinition,
    AnnotationSource {
        public static final Generic OBJECT = new OfNonGenericType.ForLoadedType(Object.class);
        public static final Generic VOID = new OfNonGenericType.ForLoadedType(Void.TYPE);
        public static final Generic ANNOTATION = new OfNonGenericType.ForLoadedType(Annotation.class);
        public static final Generic UNDEFINED = null;

        public Generic asRawType();

        public TypeList.Generic getUpperBounds();

        public TypeList.Generic getLowerBounds();

        public TypeList.Generic getTypeArguments();

        public Generic getOwnerType();

        public Generic findBindingOf(Generic var1);

        public TypeVariableSource getTypeVariableSource();

        public String getSymbol();

        @Override
        public Generic getComponentType();

        public FieldList<FieldDescription.InGenericShape> getDeclaredFields();

        public MethodList<MethodDescription.InGenericShape> getDeclaredMethods();

        public <T> T accept(Visitor<T> var1);

        public static abstract class Builder {
            private static final Type UNDEFINED = null;
            protected final List<? extends AnnotationDescription> annotations;

            protected Builder(List<? extends AnnotationDescription> annotations) {
                this.annotations = annotations;
            }

            public static Builder rawType(Class<?> type) {
                return Builder.rawType(new ForLoadedType(type));
            }

            public static Builder rawType(TypeDescription type) {
                return new OfNonGenericType(type);
            }

            public static Builder rawType(Class<?> type, Generic ownerType) {
                return Builder.rawType(new ForLoadedType(type), ownerType);
            }

            public static Builder rawType(TypeDescription type, Generic ownerType) {
                TypeDescription declaringType = type.getDeclaringType();
                if (declaringType == null && ownerType != null) {
                    throw new IllegalArgumentException(type + " does not have a declaring type: " + ownerType);
                }
                if (!(declaringType == null || ownerType != null && declaringType.equals(ownerType.asErasure()))) {
                    throw new IllegalArgumentException(ownerType + " is not the declaring type of " + type);
                }
                return new OfNonGenericType(type, ownerType);
            }

            public static Generic unboundWildcard() {
                return Builder.unboundWildcard(Collections.emptySet());
            }

            public static Generic unboundWildcard(Annotation ... annotation) {
                return Builder.unboundWildcard(Arrays.asList(annotation));
            }

            public static Generic unboundWildcard(List<? extends Annotation> annotations) {
                return Builder.unboundWildcard(new AnnotationList.ForLoadedAnnotations(annotations));
            }

            public static Generic unboundWildcard(AnnotationDescription ... annotation) {
                return Builder.unboundWildcard(Arrays.asList(annotation));
            }

            public static Generic unboundWildcard(Collection<? extends AnnotationDescription> annotations) {
                return OfWildcardType.Latent.unbounded(new AnnotationSource.Explicit(new ArrayList<AnnotationDescription>(annotations)));
            }

            public static Builder typeVariable(String symbol) {
                return new OfTypeVariable(symbol);
            }

            public static Builder parameterizedType(Class<?> rawType, Type ... parameter) {
                return Builder.parameterizedType(rawType, Arrays.asList(parameter));
            }

            public static Builder parameterizedType(Class<?> rawType, List<? extends Type> parameters) {
                return Builder.parameterizedType(rawType, UNDEFINED, parameters);
            }

            public static Builder parameterizedType(Class<?> rawType, Type ownerType, List<? extends Type> parameters) {
                return Builder.parameterizedType((TypeDescription)new ForLoadedType(rawType), ownerType == null ? null : TypeDefinition.Sort.describe(ownerType), new TypeList.Generic.ForLoadedTypes(parameters));
            }

            public static Builder parameterizedType(TypeDescription rawType, TypeDefinition ... parameter) {
                return Builder.parameterizedType(rawType, Arrays.asList(parameter));
            }

            public static Builder parameterizedType(TypeDescription rawType, Collection<? extends TypeDefinition> parameters) {
                return Builder.parameterizedType(rawType, UNDEFINED, parameters);
            }

            public static Builder parameterizedType(TypeDescription rawType, Generic ownerType, Collection<? extends TypeDefinition> parameters) {
                TypeDescription declaringType = rawType.getDeclaringType();
                if (ownerType == null && declaringType != null && rawType.isStatic()) {
                    ownerType = declaringType.asGenericType();
                }
                if (!rawType.isGenerified()) {
                    throw new IllegalArgumentException(rawType + " is not a parameterized type");
                }
                if (ownerType == null && declaringType != null && !rawType.isStatic()) {
                    throw new IllegalArgumentException(rawType + " requires an owner type");
                }
                if (ownerType != null && !ownerType.asErasure().equals(declaringType)) {
                    throw new IllegalArgumentException(ownerType + " does not represent required owner for " + rawType);
                }
                if (ownerType != null && rawType.isStatic() ^ ownerType.getSort().isNonGeneric()) {
                    throw new IllegalArgumentException(ownerType + " does not define the correct parameters for owning " + rawType);
                }
                if (rawType.getTypeVariables().size() != parameters.size()) {
                    throw new IllegalArgumentException(parameters + " does not contain number of required parameters for " + rawType);
                }
                return new OfParameterizedType(rawType, ownerType, new TypeList.Generic.Explicit(new ArrayList<TypeDefinition>(parameters)));
            }

            public Generic asWildcardUpperBound() {
                return this.asWildcardUpperBound(Collections.emptySet());
            }

            public Generic asWildcardUpperBound(Annotation ... annotation) {
                return this.asWildcardUpperBound(Arrays.asList(annotation));
            }

            public Generic asWildcardUpperBound(List<? extends Annotation> annotations) {
                return this.asWildcardUpperBound(new AnnotationList.ForLoadedAnnotations(annotations));
            }

            public Generic asWildcardUpperBound(AnnotationDescription ... annotation) {
                return this.asWildcardUpperBound((Collection<? extends AnnotationDescription>)Arrays.asList(annotation));
            }

            public Generic asWildcardUpperBound(Collection<? extends AnnotationDescription> annotations) {
                return OfWildcardType.Latent.boundedAbove(this.build(), new AnnotationSource.Explicit(new ArrayList<AnnotationDescription>(annotations)));
            }

            public Generic asWildcardLowerBound() {
                return this.asWildcardLowerBound(Collections.emptySet());
            }

            public Generic asWildcardLowerBound(Annotation ... annotation) {
                return this.asWildcardLowerBound(Arrays.asList(annotation));
            }

            public Generic asWildcardLowerBound(List<? extends Annotation> annotations) {
                return this.asWildcardLowerBound(new AnnotationList.ForLoadedAnnotations(annotations));
            }

            public Generic asWildcardLowerBound(AnnotationDescription ... annotation) {
                return this.asWildcardLowerBound((Collection<? extends AnnotationDescription>)Arrays.asList(annotation));
            }

            public Generic asWildcardLowerBound(Collection<? extends AnnotationDescription> annotations) {
                return OfWildcardType.Latent.boundedBelow(this.build(), new AnnotationSource.Explicit(new ArrayList<AnnotationDescription>(annotations)));
            }

            public Builder asArray() {
                return this.asArray(1);
            }

            public Builder asArray(int arity) {
                if (arity < 1) {
                    throw new IllegalArgumentException("Cannot define an array of a non-positive arity: " + arity);
                }
                Generic typeDescription = this.build();
                while (--arity > 0) {
                    typeDescription = new OfGenericArray.Latent(typeDescription, AnnotationSource.Empty.INSTANCE);
                }
                return new OfGenericArrayType(typeDescription);
            }

            public Builder annotate(Annotation ... annotation) {
                return this.annotate(Arrays.asList(annotation));
            }

            public Builder annotate(List<? extends Annotation> annotations) {
                return this.annotate(new AnnotationList.ForLoadedAnnotations(annotations));
            }

            public Builder annotate(AnnotationDescription ... annotation) {
                return this.annotate((Collection<? extends AnnotationDescription>)Arrays.asList(annotation));
            }

            public Builder annotate(Collection<? extends AnnotationDescription> annotations) {
                return this.doAnnotate(new ArrayList<AnnotationDescription>(annotations));
            }

            protected abstract Builder doAnnotate(List<? extends AnnotationDescription> var1);

            public Generic build() {
                return this.doBuild();
            }

            public Generic build(Annotation ... annotation) {
                return this.build(Arrays.asList(annotation));
            }

            public Generic build(List<? extends Annotation> annotations) {
                return this.build(new AnnotationList.ForLoadedAnnotations(annotations));
            }

            public Generic build(AnnotationDescription ... annotation) {
                return this.build((Collection<? extends AnnotationDescription>)Arrays.asList(annotation));
            }

            public Generic build(Collection<? extends AnnotationDescription> annotations) {
                return this.doAnnotate(new ArrayList<AnnotationDescription>(annotations)).doBuild();
            }

            protected abstract Generic doBuild();

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Builder)) {
                    return false;
                }
                Builder other = (Builder)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                List<? extends AnnotationDescription> this$annotations = this.annotations;
                List<? extends AnnotationDescription> other$annotations = other.annotations;
                return !(this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Builder;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<? extends AnnotationDescription> $annotations = this.annotations;
                result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
                return result;
            }

            protected static class OfTypeVariable
            extends Builder {
                private final String symbol;

                protected OfTypeVariable(String symbol) {
                    this(symbol, Collections.emptyList());
                }

                protected OfTypeVariable(String symbol, List<? extends AnnotationDescription> annotations) {
                    super(annotations);
                    this.symbol = symbol;
                }

                @Override
                protected Builder doAnnotate(List<? extends AnnotationDescription> annotations) {
                    return new OfTypeVariable(this.symbol, CompoundList.of(this.annotations, annotations));
                }

                @Override
                protected Generic doBuild() {
                    return new OfTypeVariable.Symbolic(this.symbol, new AnnotationSource.Explicit(this.annotations));
                }

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof OfTypeVariable)) {
                        return false;
                    }
                    OfTypeVariable other = (OfTypeVariable)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    if (!super.equals(o)) {
                        return false;
                    }
                    String this$symbol = this.symbol;
                    String other$symbol = other.symbol;
                    return !(this$symbol == null ? other$symbol != null : !this$symbol.equals(other$symbol));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof OfTypeVariable;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = super.hashCode();
                    String $symbol = this.symbol;
                    result = result * 59 + ($symbol == null ? 43 : $symbol.hashCode());
                    return result;
                }
            }

            protected static class OfGenericArrayType
            extends Builder {
                private final Generic componentType;

                protected OfGenericArrayType(Generic componentType) {
                    this(componentType, Collections.emptyList());
                }

                protected OfGenericArrayType(Generic componentType, List<? extends AnnotationDescription> annotations) {
                    super(annotations);
                    this.componentType = componentType;
                }

                @Override
                protected Builder doAnnotate(List<? extends AnnotationDescription> annotations) {
                    return new OfGenericArrayType(this.componentType, CompoundList.of(this.annotations, annotations));
                }

                @Override
                protected Generic doBuild() {
                    return new OfGenericArray.Latent(this.componentType, new AnnotationSource.Explicit(this.annotations));
                }

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof OfGenericArrayType)) {
                        return false;
                    }
                    OfGenericArrayType other = (OfGenericArrayType)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    if (!super.equals(o)) {
                        return false;
                    }
                    Generic this$componentType = this.componentType;
                    Generic other$componentType = other.componentType;
                    return !(this$componentType == null ? other$componentType != null : !this$componentType.equals(other$componentType));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof OfGenericArrayType;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = super.hashCode();
                    Generic $componentType = this.componentType;
                    result = result * 59 + ($componentType == null ? 43 : $componentType.hashCode());
                    return result;
                }
            }

            protected static class OfParameterizedType
            extends Builder {
                private final TypeDescription rawType;
                private final Generic ownerType;
                private final List<? extends Generic> parameterTypes;

                protected OfParameterizedType(TypeDescription rawType, Generic ownerType, List<? extends Generic> parameterTypes) {
                    this(rawType, ownerType, parameterTypes, Collections.emptyList());
                }

                protected OfParameterizedType(TypeDescription rawType, Generic ownerType, List<? extends Generic> parameterTypes, List<? extends AnnotationDescription> annotations) {
                    super(annotations);
                    this.rawType = rawType;
                    this.ownerType = ownerType;
                    this.parameterTypes = parameterTypes;
                }

                @Override
                protected Builder doAnnotate(List<? extends AnnotationDescription> annotations) {
                    return new OfParameterizedType(this.rawType, this.ownerType, this.parameterTypes, CompoundList.of(this.annotations, annotations));
                }

                @Override
                protected Generic doBuild() {
                    return new OfParameterizedType.Latent(this.rawType, this.ownerType, this.parameterTypes, new AnnotationSource.Explicit(this.annotations));
                }

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof OfParameterizedType)) {
                        return false;
                    }
                    OfParameterizedType other = (OfParameterizedType)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    if (!super.equals(o)) {
                        return false;
                    }
                    TypeDescription this$rawType = this.rawType;
                    TypeDescription other$rawType = other.rawType;
                    if (this$rawType == null ? other$rawType != null : !this$rawType.equals(other$rawType)) {
                        return false;
                    }
                    Generic this$ownerType = this.ownerType;
                    Generic other$ownerType = other.ownerType;
                    if (this$ownerType == null ? other$ownerType != null : !this$ownerType.equals(other$ownerType)) {
                        return false;
                    }
                    List<? extends Generic> this$parameterTypes = this.parameterTypes;
                    List<? extends Generic> other$parameterTypes = other.parameterTypes;
                    return !(this$parameterTypes == null ? other$parameterTypes != null : !((Object)this$parameterTypes).equals(other$parameterTypes));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof OfParameterizedType;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = super.hashCode();
                    TypeDescription $rawType = this.rawType;
                    result = result * 59 + ($rawType == null ? 43 : $rawType.hashCode());
                    Generic $ownerType = this.ownerType;
                    result = result * 59 + ($ownerType == null ? 43 : $ownerType.hashCode());
                    List<? extends Generic> $parameterTypes = this.parameterTypes;
                    result = result * 59 + ($parameterTypes == null ? 43 : ((Object)$parameterTypes).hashCode());
                    return result;
                }
            }

            protected static class OfNonGenericType
            extends Builder {
                private final TypeDescription typeDescription;
                private final Generic ownerType;

                protected OfNonGenericType(TypeDescription typeDescription) {
                    this(typeDescription, typeDescription.getDeclaringType());
                }

                private OfNonGenericType(TypeDescription typeDescription, TypeDescription ownerType) {
                    this(typeDescription, ownerType == null ? Generic.UNDEFINED : ownerType.asGenericType());
                }

                protected OfNonGenericType(TypeDescription typeDescription, Generic ownerType) {
                    this(typeDescription, ownerType, Collections.emptyList());
                }

                protected OfNonGenericType(TypeDescription typeDescription, Generic ownerType, List<? extends AnnotationDescription> annotations) {
                    super(annotations);
                    this.ownerType = ownerType;
                    this.typeDescription = typeDescription;
                }

                @Override
                protected Builder doAnnotate(List<? extends AnnotationDescription> annotations) {
                    return new OfNonGenericType(this.typeDescription, this.ownerType, CompoundList.of(this.annotations, annotations));
                }

                @Override
                protected Generic doBuild() {
                    if (this.typeDescription.represents(Void.TYPE) && !this.annotations.isEmpty()) {
                        throw new IllegalArgumentException("The void non-type cannot be annotated");
                    }
                    return new OfNonGenericType.Latent(this.typeDescription, this.ownerType, (AnnotationSource)new AnnotationSource.Explicit(this.annotations));
                }

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof OfNonGenericType)) {
                        return false;
                    }
                    OfNonGenericType other = (OfNonGenericType)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    if (!super.equals(o)) {
                        return false;
                    }
                    TypeDescription this$typeDescription = this.typeDescription;
                    TypeDescription other$typeDescription = other.typeDescription;
                    if (this$typeDescription == null ? other$typeDescription != null : !this$typeDescription.equals(other$typeDescription)) {
                        return false;
                    }
                    Generic this$ownerType = this.ownerType;
                    Generic other$ownerType = other.ownerType;
                    return !(this$ownerType == null ? other$ownerType != null : !this$ownerType.equals(other$ownerType));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof OfNonGenericType;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = super.hashCode();
                    TypeDescription $typeDescription = this.typeDescription;
                    result = result * 59 + ($typeDescription == null ? 43 : $typeDescription.hashCode());
                    Generic $ownerType = this.ownerType;
                    result = result * 59 + ($ownerType == null ? 43 : $ownerType.hashCode());
                    return result;
                }
            }
        }

        public static abstract class LazyProjection
        extends AbstractBase {
            protected abstract Generic resolve();

            @Override
            public TypeDefinition.Sort getSort() {
                return this.resolve().getSort();
            }

            @Override
            public FieldList<FieldDescription.InGenericShape> getDeclaredFields() {
                return this.resolve().getDeclaredFields();
            }

            @Override
            public MethodList<MethodDescription.InGenericShape> getDeclaredMethods() {
                return this.resolve().getDeclaredMethods();
            }

            @Override
            public TypeList.Generic getUpperBounds() {
                return this.resolve().getUpperBounds();
            }

            @Override
            public TypeList.Generic getLowerBounds() {
                return this.resolve().getLowerBounds();
            }

            @Override
            public Generic getComponentType() {
                return this.resolve().getComponentType();
            }

            @Override
            public TypeList.Generic getTypeArguments() {
                return this.resolve().getTypeArguments();
            }

            @Override
            public Generic findBindingOf(Generic typeVariable) {
                return this.resolve().findBindingOf(typeVariable);
            }

            @Override
            public TypeVariableSource getTypeVariableSource() {
                return this.resolve().getTypeVariableSource();
            }

            @Override
            public Generic getOwnerType() {
                return this.resolve().getOwnerType();
            }

            @Override
            public String getTypeName() {
                return this.resolve().getTypeName();
            }

            @Override
            public String getSymbol() {
                return this.resolve().getSymbol();
            }

            @Override
            public String getActualName() {
                return this.resolve().getActualName();
            }

            @Override
            public <T> T accept(Visitor<T> visitor) {
                return this.resolve().accept(visitor);
            }

            @Override
            public StackSize getStackSize() {
                return this.asErasure().getStackSize();
            }

            @Override
            public boolean isArray() {
                return this.asErasure().isArray();
            }

            @Override
            public boolean isPrimitive() {
                return this.asErasure().isPrimitive();
            }

            @Override
            public boolean represents(Type type) {
                return this.resolve().represents(type);
            }

            public int hashCode() {
                return this.resolve().hashCode();
            }

            public boolean equals(Object other) {
                return other instanceof TypeDefinition && this.resolve().equals(other);
            }

            public String toString() {
                return this.resolve().toString();
            }

            public static class WithResolvedErasure
            extends WithEagerNavigation {
                private final Generic delegate;
                private final Visitor<? extends Generic> visitor;
                private final AnnotationSource annotationSource;

                public WithResolvedErasure(Generic delegate, Visitor<? extends Generic> visitor) {
                    this(delegate, visitor, delegate);
                }

                public WithResolvedErasure(Generic delegate, Visitor<? extends Generic> visitor, AnnotationSource annotationSource) {
                    this.delegate = delegate;
                    this.visitor = visitor;
                    this.annotationSource = annotationSource;
                }

                @Override
                public AnnotationList getDeclaredAnnotations() {
                    return this.annotationSource.getDeclaredAnnotations();
                }

                @Override
                public TypeDescription asErasure() {
                    return this.delegate.asErasure();
                }

                @Override
                protected Generic resolve() {
                    return this.delegate.accept(this.visitor);
                }
            }

            public static class OfMethodParameter
            extends WithEagerNavigation.OfAnnotatedElement {
                private final Method method;
                private final int index;
                private final Class<?>[] erasure;

                @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="The array is never exposed outside of the class")
                public OfMethodParameter(Method method, int index, Class<?>[] erasure) {
                    this.method = method;
                    this.index = index;
                    this.erasure = erasure;
                }

                @Override
                protected Generic resolve() {
                    Type[] type = this.method.getGenericParameterTypes();
                    return this.erasure.length == type.length ? TypeDefinition.Sort.describe(type[this.index], this.getAnnotationReader()) : new OfNonGenericType.ForLoadedType(this.erasure[this.index]);
                }

                @Override
                public TypeDescription asErasure() {
                    return new ForLoadedType(this.erasure[this.index]);
                }

                @Override
                protected AnnotationReader getAnnotationReader() {
                    return AnnotationReader.DISPATCHER.resolveParameterType(this.method, this.index);
                }
            }

            public static class OfConstructorParameter
            extends WithEagerNavigation.OfAnnotatedElement {
                private final Constructor<?> constructor;
                private final int index;
                private final Class<?>[] erasure;

                @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="The array is never exposed outside of the class")
                public OfConstructorParameter(Constructor<?> constructor, int index, Class<?>[] erasure) {
                    this.constructor = constructor;
                    this.index = index;
                    this.erasure = erasure;
                }

                @Override
                protected Generic resolve() {
                    Type[] type = this.constructor.getGenericParameterTypes();
                    return this.erasure.length == type.length ? TypeDefinition.Sort.describe(type[this.index], this.getAnnotationReader()) : new OfNonGenericType.ForLoadedType(this.erasure[this.index]);
                }

                @Override
                public TypeDescription asErasure() {
                    return new ForLoadedType(this.erasure[this.index]);
                }

                @Override
                protected AnnotationReader getAnnotationReader() {
                    return AnnotationReader.DISPATCHER.resolveParameterType(this.constructor, this.index);
                }
            }

            public static class ForLoadedReturnType
            extends WithEagerNavigation.OfAnnotatedElement {
                private final Method method;

                public ForLoadedReturnType(Method method) {
                    this.method = method;
                }

                @Override
                protected Generic resolve() {
                    return TypeDefinition.Sort.describe(this.method.getGenericReturnType(), this.getAnnotationReader());
                }

                @Override
                public TypeDescription asErasure() {
                    return new ForLoadedType(this.method.getReturnType());
                }

                @Override
                protected AnnotationReader getAnnotationReader() {
                    return AnnotationReader.DISPATCHER.resolveReturnType(this.method);
                }
            }

            public static class ForLoadedFieldType
            extends WithEagerNavigation.OfAnnotatedElement {
                private final Field field;

                public ForLoadedFieldType(Field field) {
                    this.field = field;
                }

                @Override
                protected Generic resolve() {
                    return TypeDefinition.Sort.describe(this.field.getGenericType(), this.getAnnotationReader());
                }

                @Override
                public TypeDescription asErasure() {
                    return new ForLoadedType(this.field.getType());
                }

                @Override
                protected AnnotationReader getAnnotationReader() {
                    return AnnotationReader.DISPATCHER.resolveFieldType(this.field);
                }
            }

            public static class ForLoadedSuperClass
            extends WithLazyNavigation.OfAnnotatedElement {
                private final Class<?> type;

                public ForLoadedSuperClass(Class<?> type) {
                    this.type = type;
                }

                @Override
                protected Generic resolve() {
                    Type superClass = this.type.getGenericSuperclass();
                    return superClass == null ? UNDEFINED : TypeDefinition.Sort.describe(superClass, this.getAnnotationReader());
                }

                @Override
                public TypeDescription asErasure() {
                    Class<?> superClass = this.type.getSuperclass();
                    return superClass == null ? TypeDescription.UNDEFINED : new ForLoadedType(superClass);
                }

                @Override
                protected AnnotationReader getAnnotationReader() {
                    return AnnotationReader.DISPATCHER.resolveSuperClassType(this.type);
                }
            }

            public static abstract class WithEagerNavigation
            extends LazyProjection {
                @Override
                public Generic getSuperClass() {
                    return this.resolve().getSuperClass();
                }

                @Override
                public TypeList.Generic getInterfaces() {
                    return this.resolve().getInterfaces();
                }

                @Override
                public Iterator<TypeDefinition> iterator() {
                    return this.resolve().iterator();
                }

                protected static abstract class OfAnnotatedElement
                extends WithEagerNavigation {
                    protected OfAnnotatedElement() {
                    }

                    protected abstract AnnotationReader getAnnotationReader();

                    @Override
                    public AnnotationList getDeclaredAnnotations() {
                        return this.getAnnotationReader().asList();
                    }
                }
            }

            public static abstract class WithLazyNavigation
            extends LazyProjection {
                @Override
                public Generic getSuperClass() {
                    return LazySuperClass.of(this);
                }

                @Override
                public TypeList.Generic getInterfaces() {
                    return LazyInterfaceList.of(this);
                }

                @Override
                public Iterator<TypeDefinition> iterator() {
                    return new TypeDefinition.SuperClassIterator(this);
                }

                protected static abstract class OfAnnotatedElement
                extends WithLazyNavigation {
                    protected OfAnnotatedElement() {
                    }

                    protected abstract AnnotationReader getAnnotationReader();

                    @Override
                    public AnnotationList getDeclaredAnnotations() {
                        return this.getAnnotationReader().asList();
                    }
                }

                protected static class LazyInterfaceList
                extends TypeList.Generic.AbstractBase {
                    private final LazyProjection delegate;
                    private final TypeList.Generic rawInterfaces;

                    protected LazyInterfaceList(LazyProjection delegate, TypeList.Generic rawInterfaces) {
                        this.delegate = delegate;
                        this.rawInterfaces = rawInterfaces;
                    }

                    protected static TypeList.Generic of(LazyProjection delegate) {
                        return new LazyInterfaceList(delegate, delegate.asErasure().getInterfaces());
                    }

                    @Override
                    public Generic get(int index) {
                        return new LazyInterfaceType(this.delegate, index, (Generic)this.rawInterfaces.get(index));
                    }

                    @Override
                    public int size() {
                        return this.rawInterfaces.size();
                    }
                }

                protected static class LazyInterfaceType
                extends WithLazyNavigation {
                    private final LazyProjection delegate;
                    private final int index;
                    private final Generic rawInterface;

                    protected LazyInterfaceType(LazyProjection delegate, int index, Generic rawInterface) {
                        this.delegate = delegate;
                        this.index = index;
                        this.rawInterface = rawInterface;
                    }

                    @Override
                    public AnnotationList getDeclaredAnnotations() {
                        return this.resolve().getDeclaredAnnotations();
                    }

                    @Override
                    public TypeDescription asErasure() {
                        return this.rawInterface.asErasure();
                    }

                    @Override
                    protected Generic resolve() {
                        return (Generic)this.delegate.resolve().getInterfaces().get(this.index);
                    }
                }

                protected static class LazySuperClass
                extends WithLazyNavigation {
                    private final LazyProjection delegate;

                    protected LazySuperClass(LazyProjection delegate) {
                        this.delegate = delegate;
                    }

                    protected static Generic of(LazyProjection delegate) {
                        return delegate.asErasure().getSuperClass() == null ? UNDEFINED : new LazySuperClass(delegate);
                    }

                    @Override
                    public AnnotationList getDeclaredAnnotations() {
                        return this.resolve().getDeclaredAnnotations();
                    }

                    @Override
                    public TypeDescription asErasure() {
                        return this.delegate.asErasure().getSuperClass().asErasure();
                    }

                    @Override
                    protected Generic resolve() {
                        return this.delegate.resolve().getSuperClass();
                    }
                }
            }
        }

        public static abstract class OfTypeVariable
        extends AbstractBase {
            @Override
            public TypeDefinition.Sort getSort() {
                return TypeDefinition.Sort.VARIABLE;
            }

            @Override
            public TypeDescription asErasure() {
                TypeList.Generic upperBounds = this.getUpperBounds();
                return upperBounds.isEmpty() ? TypeDescription.OBJECT : ((Generic)upperBounds.get(0)).asErasure();
            }

            @Override
            public Generic getSuperClass() {
                throw new IllegalStateException("A type variable does not imply a super type definition: " + this);
            }

            @Override
            public TypeList.Generic getInterfaces() {
                throw new IllegalStateException("A type variable does not imply an interface type definition: " + this);
            }

            @Override
            public FieldList<FieldDescription.InGenericShape> getDeclaredFields() {
                throw new IllegalStateException("A type variable does not imply field definitions: " + this);
            }

            @Override
            public MethodList<MethodDescription.InGenericShape> getDeclaredMethods() {
                throw new IllegalStateException("A type variable does not imply method definitions: " + this);
            }

            @Override
            public Generic getComponentType() {
                throw new IllegalStateException("A type variable does not imply a component type: " + this);
            }

            @Override
            public TypeList.Generic getTypeArguments() {
                throw new IllegalStateException("A type variable does not imply type arguments: " + this);
            }

            @Override
            public Generic findBindingOf(Generic typeVariable) {
                throw new IllegalStateException("A type variable does not imply type arguments: " + this);
            }

            @Override
            public TypeList.Generic getLowerBounds() {
                throw new IllegalStateException("A type variable does not imply lower bounds: " + this);
            }

            @Override
            public Generic getOwnerType() {
                throw new IllegalStateException("A type variable does not imply an owner type: " + this);
            }

            @Override
            public String getTypeName() {
                return this.toString();
            }

            @Override
            public String getActualName() {
                return this.getSymbol();
            }

            @Override
            public <T> T accept(Visitor<T> visitor) {
                return visitor.onTypeVariable(this);
            }

            @Override
            public StackSize getStackSize() {
                return StackSize.SINGLE;
            }

            @Override
            public boolean isArray() {
                return false;
            }

            @Override
            public boolean isPrimitive() {
                return false;
            }

            @Override
            public boolean represents(Type type) {
                return this.equals(TypeDefinition.Sort.describe(type));
            }

            @Override
            public Iterator<TypeDefinition> iterator() {
                throw new IllegalStateException("A type variable does not imply a super type definition: " + this);
            }

            public int hashCode() {
                return this.getTypeVariableSource().hashCode() ^ this.getSymbol().hashCode();
            }

            public boolean equals(Object other) {
                if (!(other instanceof Generic)) {
                    return false;
                }
                Generic typeDescription = (Generic)other;
                return typeDescription.getSort().isTypeVariable() && this.getSymbol().equals(typeDescription.getSymbol()) && this.getTypeVariableSource().equals(typeDescription.getTypeVariableSource());
            }

            public String toString() {
                return this.getSymbol();
            }

            public static class WithAnnotationOverlay
            extends OfTypeVariable {
                private final Generic typeVariable;
                private final AnnotationSource annotationSource;

                public WithAnnotationOverlay(Generic typeVariable, AnnotationSource annotationSource) {
                    this.typeVariable = typeVariable;
                    this.annotationSource = annotationSource;
                }

                @Override
                public AnnotationList getDeclaredAnnotations() {
                    return this.annotationSource.getDeclaredAnnotations();
                }

                @Override
                public TypeList.Generic getUpperBounds() {
                    return this.typeVariable.getUpperBounds();
                }

                @Override
                public TypeVariableSource getTypeVariableSource() {
                    return this.typeVariable.getTypeVariableSource();
                }

                @Override
                public String getSymbol() {
                    return this.typeVariable.getSymbol();
                }
            }

            public static class ForLoadedType
            extends OfTypeVariable {
                private final TypeVariable<?> typeVariable;
                private final AnnotationReader annotationReader;

                public ForLoadedType(TypeVariable<?> typeVariable) {
                    this(typeVariable, AnnotationReader.NoOp.INSTANCE);
                }

                protected ForLoadedType(TypeVariable<?> typeVariable, AnnotationReader annotationReader) {
                    this.typeVariable = typeVariable;
                    this.annotationReader = annotationReader;
                }

                @Override
                public TypeVariableSource getTypeVariableSource() {
                    Object genericDeclaration = this.typeVariable.getGenericDeclaration();
                    if (genericDeclaration instanceof Class) {
                        return new net.bytebuddy.description.type.TypeDescription$ForLoadedType((Class)genericDeclaration);
                    }
                    if (genericDeclaration instanceof Method) {
                        return new MethodDescription.ForLoadedMethod((Method)genericDeclaration);
                    }
                    if (genericDeclaration instanceof Constructor) {
                        return new MethodDescription.ForLoadedConstructor((Constructor)genericDeclaration);
                    }
                    throw new IllegalStateException("Unknown declaration: " + genericDeclaration);
                }

                @Override
                public TypeList.Generic getUpperBounds() {
                    return new TypeVariableBoundList(this.typeVariable.getBounds(), this.annotationReader);
                }

                @Override
                public String getSymbol() {
                    return this.typeVariable.getName();
                }

                @Override
                public AnnotationList getDeclaredAnnotations() {
                    return this.annotationReader.asList();
                }

                protected static class TypeVariableBoundList
                extends TypeList.Generic.AbstractBase {
                    private final Type[] bound;
                    private final AnnotationReader annotationReader;

                    protected TypeVariableBoundList(Type[] bound, AnnotationReader annotationReader) {
                        this.bound = bound;
                        this.annotationReader = annotationReader;
                    }

                    @Override
                    public Generic get(int index) {
                        return TypeDefinition.Sort.describe(this.bound[index], this.annotationReader.ofTypeVariableBoundType(index));
                    }

                    @Override
                    public int size() {
                        return this.bound.length;
                    }
                }
            }

            public static class Symbolic
            extends AbstractBase {
                private final String symbol;
                private final AnnotationSource annotationSource;

                public Symbolic(String symbol, AnnotationSource annotationSource) {
                    this.symbol = symbol;
                    this.annotationSource = annotationSource;
                }

                @Override
                public TypeDefinition.Sort getSort() {
                    return TypeDefinition.Sort.VARIABLE_SYMBOLIC;
                }

                @Override
                public String getSymbol() {
                    return this.symbol;
                }

                @Override
                public AnnotationList getDeclaredAnnotations() {
                    return this.annotationSource.getDeclaredAnnotations();
                }

                @Override
                public TypeDescription asErasure() {
                    throw new IllegalStateException("A symbolic type variable does not imply an erasure: " + this);
                }

                @Override
                public TypeList.Generic getUpperBounds() {
                    throw new IllegalStateException("A symbolic type variable does not imply an upper type bound: " + this);
                }

                @Override
                public TypeVariableSource getTypeVariableSource() {
                    throw new IllegalStateException("A symbolic type variable does not imply a variable source: " + this);
                }

                @Override
                public Generic getSuperClass() {
                    throw new IllegalStateException("A symbolic type variable does not imply a super type definition: " + this);
                }

                @Override
                public TypeList.Generic getInterfaces() {
                    throw new IllegalStateException("A symbolic type variable does not imply an interface type definition: " + this);
                }

                @Override
                public FieldList<FieldDescription.InGenericShape> getDeclaredFields() {
                    throw new IllegalStateException("A symbolic type variable does not imply field definitions: " + this);
                }

                @Override
                public MethodList<MethodDescription.InGenericShape> getDeclaredMethods() {
                    throw new IllegalStateException("A symbolic type variable does not imply method definitions: " + this);
                }

                @Override
                public Generic getComponentType() {
                    throw new IllegalStateException("A symbolic type variable does not imply a component type: " + this);
                }

                @Override
                public TypeList.Generic getTypeArguments() {
                    throw new IllegalStateException("A symbolic type variable does not imply type arguments: " + this);
                }

                @Override
                public Generic findBindingOf(Generic typeVariable) {
                    throw new IllegalStateException("A symbolic type variable does not imply type arguments: " + this);
                }

                @Override
                public TypeList.Generic getLowerBounds() {
                    throw new IllegalStateException("A symbolic type variable does not imply lower bounds: " + this);
                }

                @Override
                public Generic getOwnerType() {
                    throw new IllegalStateException("A symbolic type variable does not imply an owner type: " + this);
                }

                @Override
                public String getTypeName() {
                    return this.toString();
                }

                @Override
                public String getActualName() {
                    return this.getSymbol();
                }

                @Override
                public <T> T accept(Visitor<T> visitor) {
                    return visitor.onTypeVariable(this);
                }

                @Override
                public StackSize getStackSize() {
                    return StackSize.SINGLE;
                }

                @Override
                public boolean isArray() {
                    return false;
                }

                @Override
                public boolean isPrimitive() {
                    return false;
                }

                @Override
                public boolean represents(Type type) {
                    if (type == null) {
                        throw new NullPointerException();
                    }
                    return false;
                }

                @Override
                public Iterator<TypeDefinition> iterator() {
                    throw new IllegalStateException("A symbolic type variable does not imply a super type definition: " + this);
                }

                public int hashCode() {
                    return this.symbol.hashCode();
                }

                public boolean equals(Object other) {
                    if (!(other instanceof Generic)) {
                        return false;
                    }
                    Generic typeDescription = (Generic)other;
                    return typeDescription.getSort().isTypeVariable() && this.getSymbol().equals(typeDescription.getSymbol());
                }

                public String toString() {
                    return this.getSymbol();
                }
            }
        }

        public static abstract class OfParameterizedType
        extends AbstractBase {
            @Override
            public TypeDefinition.Sort getSort() {
                return TypeDefinition.Sort.PARAMETERIZED;
            }

            @Override
            public Generic getSuperClass() {
                Generic superClass = this.asErasure().getSuperClass();
                return superClass == null ? UNDEFINED : new LazyProjection.WithResolvedErasure(superClass, new Visitor.Substitutor.ForTypeVariableBinding(this));
            }

            @Override
            public TypeList.Generic getInterfaces() {
                return new TypeList.Generic.ForDetachedTypes.WithResolvedErasure(this.asErasure().getInterfaces(), new Visitor.Substitutor.ForTypeVariableBinding(this));
            }

            @Override
            public FieldList<FieldDescription.InGenericShape> getDeclaredFields() {
                return new FieldList.TypeSubstituting(this, this.asErasure().getDeclaredFields(), new Visitor.Substitutor.ForTypeVariableBinding(this));
            }

            @Override
            public MethodList<MethodDescription.InGenericShape> getDeclaredMethods() {
                return new MethodList.TypeSubstituting(this, this.asErasure().getDeclaredMethods(), new Visitor.Substitutor.ForTypeVariableBinding(this));
            }

            @Override
            public Generic findBindingOf(Generic typeVariable) {
                Generic typeDescription = this;
                do {
                    TypeList.Generic typeArguments = typeDescription.getTypeArguments();
                    TypeList.Generic typeVariables = typeDescription.asErasure().getTypeVariables();
                    for (int index = 0; index < Math.min(typeArguments.size(), typeVariables.size()); ++index) {
                        if (!typeVariable.equals(typeVariables.get(index))) continue;
                        return (Generic)typeArguments.get(index);
                    }
                } while ((typeDescription = typeDescription.getOwnerType()) != null && typeDescription.getSort().isParameterized());
                return UNDEFINED;
            }

            @Override
            public TypeList.Generic getUpperBounds() {
                throw new IllegalStateException("A parameterized type does not imply upper bounds: " + this);
            }

            @Override
            public TypeList.Generic getLowerBounds() {
                throw new IllegalStateException("A parameterized type does not imply lower bounds: " + this);
            }

            @Override
            public Generic getComponentType() {
                throw new IllegalStateException("A parameterized type does not imply a component type: " + this);
            }

            @Override
            public TypeVariableSource getTypeVariableSource() {
                throw new IllegalStateException("A parameterized type does not imply a type variable source: " + this);
            }

            @Override
            public String getSymbol() {
                throw new IllegalStateException("A parameterized type does not imply a symbol: " + this);
            }

            @Override
            public String getTypeName() {
                return this.toString();
            }

            @Override
            public String getActualName() {
                return this.toString();
            }

            @Override
            public boolean isPrimitive() {
                return false;
            }

            @Override
            public boolean isArray() {
                return false;
            }

            @Override
            public boolean represents(Type type) {
                return this.equals(TypeDefinition.Sort.describe(type));
            }

            @Override
            public Iterator<TypeDefinition> iterator() {
                return new TypeDefinition.SuperClassIterator(this);
            }

            @Override
            public <T> T accept(Visitor<T> visitor) {
                return visitor.onParameterizedType(this);
            }

            @Override
            public StackSize getStackSize() {
                return StackSize.SINGLE;
            }

            public int hashCode() {
                int result = 1;
                for (Generic typeArgument : this.getTypeArguments()) {
                    result = 31 * result + typeArgument.hashCode();
                }
                Generic ownerType = this.getOwnerType();
                return result ^ (ownerType == null ? this.asErasure().hashCode() : ownerType.hashCode());
            }

            public boolean equals(Object other) {
                if (!(other instanceof Generic)) {
                    return false;
                }
                Generic typeDescription = (Generic)other;
                if (!typeDescription.getSort().isParameterized()) {
                    return false;
                }
                Generic ownerType = this.getOwnerType();
                Generic otherOwnerType = typeDescription.getOwnerType();
                return !(!this.asErasure().equals(typeDescription.asErasure()) || ownerType == null && otherOwnerType != null || ownerType != null && !ownerType.equals(otherOwnerType) || !this.getTypeArguments().equals(typeDescription.getTypeArguments()));
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                Generic ownerType = this.getOwnerType();
                if (ownerType != null) {
                    RenderingDelegate.CURRENT.apply(stringBuilder.append(ownerType.getTypeName()), this.asErasure(), ownerType);
                } else {
                    stringBuilder.append(this.asErasure().getName());
                }
                TypeList.Generic actualTypeArguments = this.getTypeArguments();
                if (!actualTypeArguments.isEmpty()) {
                    stringBuilder.append('<');
                    boolean multiple = false;
                    for (Generic typeArgument : actualTypeArguments) {
                        if (multiple) {
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append(typeArgument.getTypeName());
                        multiple = true;
                    }
                    stringBuilder.append('>');
                }
                return stringBuilder.toString();
            }

            public static class ForGenerifiedErasure
            extends OfParameterizedType {
                private final TypeDescription typeDescription;

                protected ForGenerifiedErasure(TypeDescription typeDescription) {
                    this.typeDescription = typeDescription;
                }

                public static Generic of(TypeDescription typeDescription) {
                    return typeDescription.isGenerified() ? new ForGenerifiedErasure(typeDescription) : new OfNonGenericType.ForErasure(typeDescription);
                }

                @Override
                public TypeDescription asErasure() {
                    return this.typeDescription;
                }

                @Override
                public TypeList.Generic getTypeArguments() {
                    return new TypeList.Generic.ForDetachedTypes(this.typeDescription.getTypeVariables(), Visitor.AnnotationStripper.INSTANCE);
                }

                @Override
                public Generic getOwnerType() {
                    TypeDescription declaringType = this.typeDescription.getDeclaringType();
                    return declaringType == null ? UNDEFINED : ForGenerifiedErasure.of(declaringType);
                }

                @Override
                public AnnotationList getDeclaredAnnotations() {
                    return new AnnotationList.Empty();
                }
            }

            public static class ForReifiedType
            extends OfParameterizedType {
                private final Generic parameterizedType;

                protected ForReifiedType(Generic parameterizedType) {
                    this.parameterizedType = parameterizedType;
                }

                @Override
                public Generic getSuperClass() {
                    Generic superClass = super.getSuperClass();
                    return superClass == null ? UNDEFINED : new LazyProjection.WithResolvedErasure(superClass, Visitor.Reifying.INHERITING);
                }

                @Override
                public TypeList.Generic getInterfaces() {
                    return new TypeList.Generic.ForDetachedTypes.WithResolvedErasure(super.getInterfaces(), Visitor.Reifying.INHERITING);
                }

                @Override
                public FieldList<FieldDescription.InGenericShape> getDeclaredFields() {
                    return new FieldList.TypeSubstituting(this, super.getDeclaredFields(), Visitor.TypeErasing.INSTANCE);
                }

                @Override
                public MethodList<MethodDescription.InGenericShape> getDeclaredMethods() {
                    return new MethodList.TypeSubstituting(this, super.getDeclaredMethods(), Visitor.TypeErasing.INSTANCE);
                }

                @Override
                public TypeList.Generic getTypeArguments() {
                    return new TypeList.Generic.ForDetachedTypes(this.parameterizedType.getTypeArguments(), Visitor.TypeErasing.INSTANCE);
                }

                @Override
                public Generic getOwnerType() {
                    Generic ownerType = this.parameterizedType.getOwnerType();
                    return ownerType == null ? UNDEFINED : ownerType.accept(Visitor.Reifying.INHERITING);
                }

                @Override
                public TypeDescription asErasure() {
                    return this.parameterizedType.asErasure();
                }

                @Override
                public AnnotationList getDeclaredAnnotations() {
                    return new AnnotationList.Empty();
                }
            }

            public static class Latent
            extends OfParameterizedType {
                private final TypeDescription rawType;
                private final Generic ownerType;
                private final List<? extends Generic> parameters;
                private final AnnotationSource annotationSource;

                public Latent(TypeDescription rawType, Generic ownerType, List<? extends Generic> parameters, AnnotationSource annotationSource) {
                    this.rawType = rawType;
                    this.ownerType = ownerType;
                    this.parameters = parameters;
                    this.annotationSource = annotationSource;
                }

                @Override
                public TypeDescription asErasure() {
                    return this.rawType;
                }

                @Override
                public Generic getOwnerType() {
                    return this.ownerType;
                }

                @Override
                public TypeList.Generic getTypeArguments() {
                    return new TypeList.Generic.Explicit(this.parameters);
                }

                @Override
                public AnnotationList getDeclaredAnnotations() {
                    return this.annotationSource.getDeclaredAnnotations();
                }
            }

            public static class ForLoadedType
            extends OfParameterizedType {
                private final ParameterizedType parameterizedType;
                private final AnnotationReader annotationReader;

                public ForLoadedType(ParameterizedType parameterizedType) {
                    this(parameterizedType, AnnotationReader.NoOp.INSTANCE);
                }

                protected ForLoadedType(ParameterizedType parameterizedType, AnnotationReader annotationReader) {
                    this.parameterizedType = parameterizedType;
                    this.annotationReader = annotationReader;
                }

                @Override
                public TypeList.Generic getTypeArguments() {
                    return new ParameterArgumentTypeList(this.parameterizedType.getActualTypeArguments(), this.annotationReader);
                }

                @Override
                public Generic getOwnerType() {
                    Type ownerType = this.parameterizedType.getOwnerType();
                    return ownerType == null ? UNDEFINED : TypeDefinition.Sort.describe(ownerType, this.annotationReader.ofOwnerType());
                }

                @Override
                public TypeDescription asErasure() {
                    return new net.bytebuddy.description.type.TypeDescription$ForLoadedType((Class)this.parameterizedType.getRawType());
                }

                @Override
                public AnnotationList getDeclaredAnnotations() {
                    return this.annotationReader.asList();
                }

                protected static class ParameterArgumentTypeList
                extends TypeList.Generic.AbstractBase {
                    private final Type[] argumentType;
                    private final AnnotationReader annotationReader;

                    protected ParameterArgumentTypeList(Type[] argumentType, AnnotationReader annotationReader) {
                        this.argumentType = argumentType;
                        this.annotationReader = annotationReader;
                    }

                    @Override
                    public Generic get(int index) {
                        return TypeDefinition.Sort.describe(this.argumentType[index], this.annotationReader.ofTypeArgument(index));
                    }

                    @Override
                    public int size() {
                        return this.argumentType.length;
                    }
                }
            }

            protected static enum RenderingDelegate {
                LEGACY_VM{

                    @Override
                    protected void apply(StringBuilder stringBuilder, TypeDescription typeDescription, Generic ownerType) {
                        stringBuilder.append('.').append(ownerType.getSort().isParameterized() ? typeDescription.getSimpleName() : typeDescription.getName());
                    }
                }
                ,
                JAVA_9_CAPABLE_VM{

                    @Override
                    protected void apply(StringBuilder stringBuilder, TypeDescription typeDescription, Generic ownerType) {
                        stringBuilder.append('$').append(typeDescription.getSimpleName());
                    }
                };

                protected static final RenderingDelegate CURRENT;

                protected abstract void apply(StringBuilder var1, TypeDescription var2, Generic var3);

                static {
                    CURRENT = ClassFileVersion.ofThisVm(ClassFileVersion.JAVA_V6).isAtLeast(ClassFileVersion.JAVA_V9) ? JAVA_9_CAPABLE_VM : LEGACY_VM;
                }
            }
        }

        public static abstract class OfWildcardType
        extends AbstractBase {
            public static final String SYMBOL = "?";

            @Override
            public TypeDefinition.Sort getSort() {
                return TypeDefinition.Sort.WILDCARD;
            }

            @Override
            public TypeDescription asErasure() {
                throw new IllegalStateException("A wildcard does not represent an erasable type: " + this);
            }

            @Override
            public Generic getSuperClass() {
                throw new IllegalStateException("A wildcard does not imply a super type definition: " + this);
            }

            @Override
            public TypeList.Generic getInterfaces() {
                throw new IllegalStateException("A wildcard does not imply an interface type definition: " + this);
            }

            @Override
            public FieldList<FieldDescription.InGenericShape> getDeclaredFields() {
                throw new IllegalStateException("A wildcard does not imply field definitions: " + this);
            }

            @Override
            public MethodList<MethodDescription.InGenericShape> getDeclaredMethods() {
                throw new IllegalStateException("A wildcard does not imply method definitions: " + this);
            }

            @Override
            public Generic getComponentType() {
                throw new IllegalStateException("A wildcard does not imply a component type: " + this);
            }

            @Override
            public TypeVariableSource getTypeVariableSource() {
                throw new IllegalStateException("A wildcard does not imply a type variable source: " + this);
            }

            @Override
            public TypeList.Generic getTypeArguments() {
                throw new IllegalStateException("A wildcard does not imply type arguments: " + this);
            }

            @Override
            public Generic findBindingOf(Generic typeVariable) {
                throw new IllegalStateException("A wildcard does not imply type arguments: " + this);
            }

            @Override
            public Generic getOwnerType() {
                throw new IllegalStateException("A wildcard does not imply an owner type: " + this);
            }

            @Override
            public String getSymbol() {
                throw new IllegalStateException("A wildcard does not imply a symbol: " + this);
            }

            @Override
            public String getTypeName() {
                return this.toString();
            }

            @Override
            public String getActualName() {
                return this.toString();
            }

            @Override
            public boolean isPrimitive() {
                return false;
            }

            @Override
            public boolean isArray() {
                return false;
            }

            @Override
            public boolean represents(Type type) {
                return this.equals(TypeDefinition.Sort.describe(type));
            }

            @Override
            public Iterator<TypeDefinition> iterator() {
                throw new IllegalStateException("A wildcard does not imply a super type definition: " + this);
            }

            @Override
            public <T> T accept(Visitor<T> visitor) {
                return visitor.onWildcard(this);
            }

            @Override
            public StackSize getStackSize() {
                throw new IllegalStateException("A wildcard does not imply an operand stack size: " + this);
            }

            public int hashCode() {
                int lowerHash = 1;
                int upperHash = 1;
                for (Generic lowerBound : this.getLowerBounds()) {
                    lowerHash = 31 * lowerHash + lowerBound.hashCode();
                }
                for (Generic upperBound : this.getUpperBounds()) {
                    upperHash = 31 * upperHash + upperBound.hashCode();
                }
                return lowerHash ^ upperHash;
            }

            public boolean equals(Object other) {
                if (!(other instanceof Generic)) {
                    return false;
                }
                Generic typeDescription = (Generic)other;
                return typeDescription.getSort().isWildcard() && this.getUpperBounds().equals(typeDescription.getUpperBounds()) && this.getLowerBounds().equals(typeDescription.getLowerBounds());
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder(SYMBOL);
                TypeList.Generic bounds = this.getLowerBounds();
                if (!bounds.isEmpty()) {
                    stringBuilder.append(" super ");
                } else {
                    bounds = this.getUpperBounds();
                    if (((Generic)bounds.getOnly()).equals(OBJECT)) {
                        return SYMBOL;
                    }
                    stringBuilder.append(" extends ");
                }
                return stringBuilder.append(((Generic)bounds.getOnly()).getTypeName()).toString();
            }

            public static class Latent
            extends OfWildcardType {
                private final List<? extends Generic> upperBounds;
                private final List<? extends Generic> lowerBounds;
                private final AnnotationSource annotationSource;

                protected Latent(List<? extends Generic> upperBounds, List<? extends Generic> lowerBounds, AnnotationSource annotationSource) {
                    this.upperBounds = upperBounds;
                    this.lowerBounds = lowerBounds;
                    this.annotationSource = annotationSource;
                }

                public static Generic unbounded(AnnotationSource annotationSource) {
                    return new Latent(Collections.singletonList(OBJECT), Collections.emptyList(), annotationSource);
                }

                public static Generic boundedAbove(Generic upperBound, AnnotationSource annotationSource) {
                    return new Latent(Collections.singletonList(upperBound), Collections.emptyList(), annotationSource);
                }

                public static Generic boundedBelow(Generic lowerBound, AnnotationSource annotationSource) {
                    return new Latent(Collections.singletonList(OBJECT), Collections.singletonList(lowerBound), annotationSource);
                }

                @Override
                public TypeList.Generic getUpperBounds() {
                    return new TypeList.Generic.Explicit(this.upperBounds);
                }

                @Override
                public TypeList.Generic getLowerBounds() {
                    return new TypeList.Generic.Explicit(this.lowerBounds);
                }

                @Override
                public AnnotationList getDeclaredAnnotations() {
                    return this.annotationSource.getDeclaredAnnotations();
                }
            }

            public static class ForLoadedType
            extends OfWildcardType {
                private final WildcardType wildcardType;
                private final AnnotationReader annotationReader;

                public ForLoadedType(WildcardType wildcardType) {
                    this(wildcardType, AnnotationReader.NoOp.INSTANCE);
                }

                protected ForLoadedType(WildcardType wildcardType, AnnotationReader annotationReader) {
                    this.wildcardType = wildcardType;
                    this.annotationReader = annotationReader;
                }

                @Override
                public TypeList.Generic getUpperBounds() {
                    return new WildcardUpperBoundTypeList(this.wildcardType.getUpperBounds(), this.annotationReader);
                }

                @Override
                public TypeList.Generic getLowerBounds() {
                    return new WildcardLowerBoundTypeList(this.wildcardType.getLowerBounds(), this.annotationReader);
                }

                @Override
                public AnnotationList getDeclaredAnnotations() {
                    return this.annotationReader.asList();
                }

                protected static class WildcardLowerBoundTypeList
                extends TypeList.Generic.AbstractBase {
                    private final Type[] lowerBound;
                    private final AnnotationReader annotationReader;

                    protected WildcardLowerBoundTypeList(Type[] lowerBound, AnnotationReader annotationReader) {
                        this.lowerBound = lowerBound;
                        this.annotationReader = annotationReader;
                    }

                    @Override
                    public Generic get(int index) {
                        return TypeDefinition.Sort.describe(this.lowerBound[index], this.annotationReader.ofWildcardLowerBoundType(index));
                    }

                    @Override
                    public int size() {
                        return this.lowerBound.length;
                    }
                }

                protected static class WildcardUpperBoundTypeList
                extends TypeList.Generic.AbstractBase {
                    private final Type[] upperBound;
                    private final AnnotationReader annotationReader;

                    protected WildcardUpperBoundTypeList(Type[] upperBound, AnnotationReader annotationReader) {
                        this.upperBound = upperBound;
                        this.annotationReader = annotationReader;
                    }

                    @Override
                    public Generic get(int index) {
                        return TypeDefinition.Sort.describe(this.upperBound[index], this.annotationReader.ofWildcardUpperBoundType(index));
                    }

                    @Override
                    public int size() {
                        return this.upperBound.length;
                    }
                }
            }
        }

        public static abstract class OfGenericArray
        extends AbstractBase {
            @Override
            public TypeDefinition.Sort getSort() {
                return this.getComponentType().getSort().isNonGeneric() ? TypeDefinition.Sort.NON_GENERIC : TypeDefinition.Sort.GENERIC_ARRAY;
            }

            @Override
            public TypeDescription asErasure() {
                return ArrayProjection.of(this.getComponentType().asErasure(), 1);
            }

            @Override
            public Generic getSuperClass() {
                return OBJECT;
            }

            @Override
            public TypeList.Generic getInterfaces() {
                return ARRAY_INTERFACES;
            }

            @Override
            public FieldList<FieldDescription.InGenericShape> getDeclaredFields() {
                return new FieldList.Empty<FieldDescription.InGenericShape>();
            }

            @Override
            public MethodList<MethodDescription.InGenericShape> getDeclaredMethods() {
                return new MethodList.Empty<MethodDescription.InGenericShape>();
            }

            @Override
            public TypeList.Generic getUpperBounds() {
                throw new IllegalStateException("A generic array type does not imply upper type bounds: " + this);
            }

            @Override
            public TypeList.Generic getLowerBounds() {
                throw new IllegalStateException("A generic array type does not imply lower type bounds: " + this);
            }

            @Override
            public TypeVariableSource getTypeVariableSource() {
                throw new IllegalStateException("A generic array type does not imply a type variable source: " + this);
            }

            @Override
            public TypeList.Generic getTypeArguments() {
                throw new IllegalStateException("A generic array type does not imply type arguments: " + this);
            }

            @Override
            public Generic findBindingOf(Generic typeVariable) {
                throw new IllegalStateException("A generic array type does not imply type arguments: " + this);
            }

            @Override
            public Generic getOwnerType() {
                return UNDEFINED;
            }

            @Override
            public String getSymbol() {
                throw new IllegalStateException("A generic array type does not imply a symbol: " + this);
            }

            @Override
            public String getTypeName() {
                return this.getSort().isNonGeneric() ? this.asErasure().getTypeName() : this.toString();
            }

            @Override
            public String getActualName() {
                return this.getSort().isNonGeneric() ? this.asErasure().getActualName() : this.toString();
            }

            @Override
            public boolean isArray() {
                return true;
            }

            @Override
            public boolean isPrimitive() {
                return false;
            }

            @Override
            public Iterator<TypeDefinition> iterator() {
                return new TypeDefinition.SuperClassIterator(this);
            }

            @Override
            public <T> T accept(Visitor<T> visitor) {
                return this.getSort().isNonGeneric() ? visitor.onNonGenericType(this) : visitor.onGenericArray(this);
            }

            @Override
            public StackSize getStackSize() {
                return StackSize.SINGLE;
            }

            @SuppressFBWarnings(value={"EQ_CHECK_FOR_OPERAND_NOT_COMPATIBLE_WITH_THIS"}, justification="Type check is performed by erasure implementation")
            public boolean equals(Object other) {
                if (this.getSort().isNonGeneric()) {
                    return this.asErasure().equals(other);
                }
                if (!(other instanceof Generic)) {
                    return false;
                }
                Generic typeDescription = (Generic)other;
                return typeDescription.getSort().isGenericArray() && this.getComponentType().equals(typeDescription.getComponentType());
            }

            public int hashCode() {
                return this.getSort().isNonGeneric() ? this.asErasure().hashCode() : this.getComponentType().hashCode();
            }

            public String toString() {
                return this.getSort().isNonGeneric() ? this.asErasure().toString() : this.getComponentType().getTypeName() + "[]";
            }

            public static class Latent
            extends OfGenericArray {
                private final Generic componentType;
                private final AnnotationSource annotationSource;

                public Latent(Generic componentType, AnnotationSource annotationSource) {
                    this.componentType = componentType;
                    this.annotationSource = annotationSource;
                }

                @Override
                public Generic getComponentType() {
                    return this.componentType;
                }

                @Override
                public AnnotationList getDeclaredAnnotations() {
                    return this.annotationSource.getDeclaredAnnotations();
                }
            }

            public static class ForLoadedType
            extends OfGenericArray {
                private final GenericArrayType genericArrayType;
                private final AnnotationReader annotationReader;

                public ForLoadedType(GenericArrayType genericArrayType) {
                    this(genericArrayType, AnnotationReader.NoOp.INSTANCE);
                }

                protected ForLoadedType(GenericArrayType genericArrayType, AnnotationReader annotationReader) {
                    this.genericArrayType = genericArrayType;
                    this.annotationReader = annotationReader;
                }

                @Override
                public Generic getComponentType() {
                    return TypeDefinition.Sort.describe(this.genericArrayType.getGenericComponentType(), this.annotationReader.ofComponentType());
                }

                @Override
                public AnnotationList getDeclaredAnnotations() {
                    return this.annotationReader.asList();
                }
            }
        }

        public static abstract class OfNonGenericType
        extends AbstractBase {
            @Override
            public TypeDefinition.Sort getSort() {
                return TypeDefinition.Sort.NON_GENERIC;
            }

            @Override
            public Generic getSuperClass() {
                TypeDescription erasure = this.asErasure();
                Generic superClass = erasure.getSuperClass();
                if (net.bytebuddy.description.type.TypeDescription$AbstractBase.RAW_TYPES) {
                    return superClass;
                }
                return superClass == null ? UNDEFINED : new LazyProjection.WithResolvedErasure(superClass, new Visitor.ForRawType(erasure), AnnotationSource.Empty.INSTANCE);
            }

            @Override
            public TypeList.Generic getInterfaces() {
                TypeDescription erasure = this.asErasure();
                if (net.bytebuddy.description.type.TypeDescription$AbstractBase.RAW_TYPES) {
                    return erasure.getInterfaces();
                }
                return new TypeList.Generic.ForDetachedTypes.WithResolvedErasure(erasure.getInterfaces(), new Visitor.ForRawType(erasure));
            }

            @Override
            public FieldList<FieldDescription.InGenericShape> getDeclaredFields() {
                TypeDescription erasure = this.asErasure();
                return new FieldList.TypeSubstituting(this, erasure.getDeclaredFields(), (Visitor<? extends Generic>)(net.bytebuddy.description.type.TypeDescription$AbstractBase.RAW_TYPES ? Visitor.NoOp.INSTANCE : new Visitor.ForRawType(erasure)));
            }

            @Override
            public MethodList<MethodDescription.InGenericShape> getDeclaredMethods() {
                TypeDescription erasure = this.asErasure();
                return new MethodList.TypeSubstituting(this, erasure.getDeclaredMethods(), (Visitor<? extends Generic>)(net.bytebuddy.description.type.TypeDescription$AbstractBase.RAW_TYPES ? Visitor.NoOp.INSTANCE : new Visitor.ForRawType(erasure)));
            }

            @Override
            public TypeList.Generic getTypeArguments() {
                throw new IllegalStateException("A non-generic type does not imply type arguments: " + this);
            }

            @Override
            public Generic findBindingOf(Generic typeVariable) {
                throw new IllegalStateException("A non-generic type does not imply type arguments: " + this);
            }

            @Override
            public <T> T accept(Visitor<T> visitor) {
                return visitor.onNonGenericType(this);
            }

            @Override
            public String getTypeName() {
                return this.asErasure().getTypeName();
            }

            @Override
            public TypeList.Generic getUpperBounds() {
                throw new IllegalStateException("A non-generic type does not imply upper type bounds: " + this);
            }

            @Override
            public TypeList.Generic getLowerBounds() {
                throw new IllegalStateException("A non-generic type does not imply lower type bounds: " + this);
            }

            @Override
            public TypeVariableSource getTypeVariableSource() {
                throw new IllegalStateException("A non-generic type does not imply a type variable source: " + this);
            }

            @Override
            public String getSymbol() {
                throw new IllegalStateException("A non-generic type does not imply a symbol: " + this);
            }

            @Override
            public StackSize getStackSize() {
                return this.asErasure().getStackSize();
            }

            @Override
            public String getActualName() {
                return this.asErasure().getActualName();
            }

            @Override
            public boolean isArray() {
                return this.asErasure().isArray();
            }

            @Override
            public boolean isPrimitive() {
                return this.asErasure().isPrimitive();
            }

            @Override
            public boolean represents(Type type) {
                return this.asErasure().represents(type);
            }

            @Override
            public Iterator<TypeDefinition> iterator() {
                return new TypeDefinition.SuperClassIterator(this);
            }

            public int hashCode() {
                return this.asErasure().hashCode();
            }

            @SuppressFBWarnings(value={"EQ_CHECK_FOR_OPERAND_NOT_COMPATIBLE_WITH_THIS"}, justification="Type check is performed by erasure implementation")
            public boolean equals(Object other) {
                return this.asErasure().equals(other);
            }

            public String toString() {
                return this.asErasure().toString();
            }

            public static class ForReifiedErasure
            extends OfNonGenericType {
                private final TypeDescription typeDescription;

                protected ForReifiedErasure(TypeDescription typeDescription) {
                    this.typeDescription = typeDescription;
                }

                protected static Generic of(TypeDescription typeDescription) {
                    return typeDescription.isGenerified() ? new ForReifiedErasure(typeDescription) : new ForErasure(typeDescription);
                }

                @Override
                public Generic getSuperClass() {
                    Generic superClass = this.typeDescription.getSuperClass();
                    return superClass == null ? UNDEFINED : new LazyProjection.WithResolvedErasure(superClass, Visitor.Reifying.INHERITING);
                }

                @Override
                public TypeList.Generic getInterfaces() {
                    return new TypeList.Generic.ForDetachedTypes.WithResolvedErasure(this.typeDescription.getInterfaces(), Visitor.Reifying.INHERITING);
                }

                @Override
                public FieldList<FieldDescription.InGenericShape> getDeclaredFields() {
                    return new FieldList.TypeSubstituting(this, this.typeDescription.getDeclaredFields(), Visitor.TypeErasing.INSTANCE);
                }

                @Override
                public MethodList<MethodDescription.InGenericShape> getDeclaredMethods() {
                    return new MethodList.TypeSubstituting(this, this.typeDescription.getDeclaredMethods(), Visitor.TypeErasing.INSTANCE);
                }

                @Override
                public TypeDescription asErasure() {
                    return this.typeDescription;
                }

                @Override
                public Generic getOwnerType() {
                    TypeDescription declaringType = this.typeDescription.getDeclaringType();
                    return declaringType == null ? UNDEFINED : ForReifiedErasure.of(declaringType);
                }

                @Override
                public Generic getComponentType() {
                    TypeDescription componentType = this.typeDescription.getComponentType();
                    return componentType == null ? UNDEFINED : ForReifiedErasure.of(componentType);
                }

                @Override
                public AnnotationList getDeclaredAnnotations() {
                    return new AnnotationList.Empty();
                }
            }

            public static class Latent
            extends OfNonGenericType {
                private final TypeDescription typeDescription;
                private final Generic declaringType;
                private final AnnotationSource annotationSource;

                public Latent(TypeDescription typeDescription, AnnotationSource annotationSource) {
                    this(typeDescription, typeDescription.getDeclaringType(), annotationSource);
                }

                private Latent(TypeDescription typeDescription, TypeDescription declaringType, AnnotationSource annotationSource) {
                    this(typeDescription, declaringType == null ? UNDEFINED : declaringType.asGenericType(), annotationSource);
                }

                protected Latent(TypeDescription typeDescription, Generic declaringType, AnnotationSource annotationSource) {
                    this.typeDescription = typeDescription;
                    this.declaringType = declaringType;
                    this.annotationSource = annotationSource;
                }

                @Override
                public Generic getOwnerType() {
                    return this.declaringType;
                }

                @Override
                public Generic getComponentType() {
                    TypeDescription componentType = this.typeDescription.getComponentType();
                    return componentType == null ? UNDEFINED : componentType.asGenericType();
                }

                @Override
                public AnnotationList getDeclaredAnnotations() {
                    return this.annotationSource.getDeclaredAnnotations();
                }

                @Override
                public TypeDescription asErasure() {
                    return this.typeDescription;
                }
            }

            public static class ForErasure
            extends OfNonGenericType {
                private final TypeDescription typeDescription;

                public ForErasure(TypeDescription typeDescription) {
                    this.typeDescription = typeDescription;
                }

                @Override
                public TypeDescription asErasure() {
                    return this.typeDescription;
                }

                @Override
                public Generic getOwnerType() {
                    TypeDescription declaringType = this.typeDescription.getDeclaringType();
                    return declaringType == null ? UNDEFINED : declaringType.asGenericType();
                }

                @Override
                public Generic getComponentType() {
                    TypeDescription componentType = this.typeDescription.getComponentType();
                    return componentType == null ? UNDEFINED : componentType.asGenericType();
                }

                @Override
                public AnnotationList getDeclaredAnnotations() {
                    return new AnnotationList.Empty();
                }
            }

            public static class ForLoadedType
            extends OfNonGenericType {
                private final Class<?> type;
                private final AnnotationReader annotationReader;

                public ForLoadedType(Class<?> type) {
                    this(type, AnnotationReader.NoOp.INSTANCE);
                }

                protected ForLoadedType(Class<?> type, AnnotationReader annotationReader) {
                    this.type = type;
                    this.annotationReader = annotationReader;
                }

                @Override
                public TypeDescription asErasure() {
                    return new net.bytebuddy.description.type.TypeDescription$ForLoadedType(this.type);
                }

                @Override
                public Generic getOwnerType() {
                    Class<?> declaringClass = this.type.getDeclaringClass();
                    return declaringClass == null ? UNDEFINED : new ForLoadedType(declaringClass, this.annotationReader.ofOuterClass());
                }

                @Override
                public Generic getComponentType() {
                    Class<?> componentType = this.type.getComponentType();
                    return componentType == null ? UNDEFINED : new ForLoadedType(componentType, this.annotationReader.ofComponentType());
                }

                @Override
                public AnnotationList getDeclaredAnnotations() {
                    return this.annotationReader.asList();
                }
            }
        }

        public static abstract class AbstractBase
        extends ModifierReviewable.AbstractBase
        implements Generic {
            @Override
            public int getModifiers() {
                return this.asErasure().getModifiers();
            }

            @Override
            public Generic asGenericType() {
                return this;
            }

            @Override
            public Generic asRawType() {
                return this.asErasure().asGenericType();
            }

            @Override
            public boolean represents(Type type) {
                return this.equals(TypeDefinition.Sort.describe(type));
            }
        }

        public static interface AnnotationReader {
            public static final Dispatcher DISPATCHER = AccessController.doPrivileged(Dispatcher.CreationAction.INSTANCE);

            public AnnotatedElement resolve();

            public AnnotationList asList();

            public AnnotationReader ofWildcardUpperBoundType(int var1);

            public AnnotationReader ofWildcardLowerBoundType(int var1);

            public AnnotationReader ofTypeVariableBoundType(int var1);

            public AnnotationReader ofTypeArgument(int var1);

            public AnnotationReader ofOwnerType();

            public AnnotationReader ofOuterClass();

            public AnnotationReader ofComponentType();

            public static class ForOwnerType
            extends Delegator.Chained {
                private static final Method GET_ANNOTATED_OWNER_TYPE = ForOwnerType.of("java.lang.reflect.AnnotatedType", "getAnnotatedOwnerType");

                private static AnnotationReader of(AnnotationReader annotationReader) {
                    return GET_ANNOTATED_OWNER_TYPE == null ? NoOp.INSTANCE : new ForOwnerType(annotationReader);
                }

                protected ForOwnerType(AnnotationReader annotationReader) {
                    super(annotationReader);
                }

                @Override
                protected AnnotatedElement resolve(AnnotatedElement annotatedElement) {
                    try {
                        AnnotatedElement annotatedOwnerType = (AnnotatedElement)GET_ANNOTATED_OWNER_TYPE.invoke((Object)annotatedElement, new Object[0]);
                        return annotatedOwnerType == null ? NoOp.INSTANCE : annotatedOwnerType;
                    }
                    catch (ClassCastException ignored) {
                        return NoOp.INSTANCE;
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.reflect.AnnotatedType#getAnnotatedOwnerType", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.reflect.AnnotatedType#getAnnotatedOwnerType", exception.getCause());
                    }
                }
            }

            public static class ForComponentType
            extends Delegator.Chained {
                private static final Method GET_ANNOTATED_GENERIC_COMPONENT_TYPE = ForComponentType.of("java.lang.reflect.AnnotatedArrayType", "getAnnotatedGenericComponentType");

                protected ForComponentType(AnnotationReader annotationReader) {
                    super(annotationReader);
                }

                @Override
                protected AnnotatedElement resolve(AnnotatedElement annotatedElement) {
                    try {
                        return (AnnotatedElement)GET_ANNOTATED_GENERIC_COMPONENT_TYPE.invoke((Object)annotatedElement, new Object[0]);
                    }
                    catch (ClassCastException ignored) {
                        return NoOp.INSTANCE;
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.reflect.AnnotatedArrayType#getAnnotatedGenericComponentType", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.reflect.AnnotatedArrayType#getAnnotatedGenericComponentType", exception.getCause());
                    }
                }
            }

            public static class ForTypeArgument
            extends Delegator.Chained {
                private static final Method GET_ANNOTATED_ACTUAL_TYPE_ARGUMENTS = ForTypeArgument.of("java.lang.reflect.AnnotatedParameterizedType", "getAnnotatedActualTypeArguments");
                private final int index;

                protected ForTypeArgument(AnnotationReader annotationReader, int index) {
                    super(annotationReader);
                    this.index = index;
                }

                @Override
                protected AnnotatedElement resolve(AnnotatedElement annotatedElement) {
                    try {
                        return (AnnotatedElement)Array.get(GET_ANNOTATED_ACTUAL_TYPE_ARGUMENTS.invoke((Object)annotatedElement, new Object[0]), this.index);
                    }
                    catch (ClassCastException ignored) {
                        return NoOp.INSTANCE;
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.reflect.AnnotatedParameterizedType#getAnnotatedActualTypeArguments", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.reflect.AnnotatedParameterizedType#getAnnotatedActualTypeArguments", exception.getCause());
                    }
                }

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForTypeArgument)) {
                        return false;
                    }
                    ForTypeArgument other = (ForTypeArgument)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    if (!super.equals(o)) {
                        return false;
                    }
                    return this.index == other.index;
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof ForTypeArgument;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = super.hashCode();
                    result = result * 59 + this.index;
                    return result;
                }
            }

            public static class ForTypeVariableBoundType
            extends Delegator.Chained {
                private static final Method GET_ANNOTATED_BOUNDS = ForTypeVariableBoundType.of("java.lang.reflect.AnnotatedTypeVariable", "getAnnotatedBounds");
                private final int index;

                protected ForTypeVariableBoundType(AnnotationReader annotationReader, int index) {
                    super(annotationReader);
                    this.index = index;
                }

                @Override
                protected AnnotatedElement resolve(AnnotatedElement annotatedElement) {
                    try {
                        return (AnnotatedElement)Array.get(GET_ANNOTATED_BOUNDS.invoke((Object)annotatedElement, new Object[0]), this.index);
                    }
                    catch (ClassCastException ignored) {
                        return NoOp.INSTANCE;
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.reflect.AnnotatedTypeVariable#getAnnotatedBounds", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.reflect.AnnotatedTypeVariable#getAnnotatedBounds", exception.getCause());
                    }
                }

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForTypeVariableBoundType)) {
                        return false;
                    }
                    ForTypeVariableBoundType other = (ForTypeVariableBoundType)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    if (!super.equals(o)) {
                        return false;
                    }
                    return this.index == other.index;
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof ForTypeVariableBoundType;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = super.hashCode();
                    result = result * 59 + this.index;
                    return result;
                }

                protected static class OfFormalTypeVariable
                extends Delegator {
                    private static final Method GET_ANNOTATED_BOUNDS = Delegator.Chained.of(TypeVariable.class.getName(), "getAnnotatedBounds");
                    private final TypeVariable<?> typeVariable;
                    private final int index;

                    protected OfFormalTypeVariable(TypeVariable<?> typeVariable, int index) {
                        this.typeVariable = typeVariable;
                        this.index = index;
                    }

                    @Override
                    public AnnotatedElement resolve() {
                        try {
                            return (AnnotatedElement)Array.get(GET_ANNOTATED_BOUNDS.invoke(this.typeVariable, new Object[0]), this.index);
                        }
                        catch (ClassCastException ignored) {
                            return NoOp.INSTANCE;
                        }
                        catch (IllegalAccessException exception) {
                            throw new IllegalStateException("Cannot access java.lang.reflect.TypeVariable#getAnnotatedBounds", exception);
                        }
                        catch (InvocationTargetException exception) {
                            throw new IllegalStateException("Error invoking java.lang.reflect.TypeVariable#getAnnotatedBounds", exception.getCause());
                        }
                    }

                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof OfFormalTypeVariable)) {
                            return false;
                        }
                        OfFormalTypeVariable other = (OfFormalTypeVariable)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        TypeVariable<?> this$typeVariable = this.typeVariable;
                        TypeVariable<?> other$typeVariable = other.typeVariable;
                        if (this$typeVariable == null ? other$typeVariable != null : !this$typeVariable.equals(other$typeVariable)) {
                            return false;
                        }
                        return this.index == other.index;
                    }

                    protected boolean canEqual(Object other) {
                        return other instanceof OfFormalTypeVariable;
                    }

                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        TypeVariable<?> $typeVariable = this.typeVariable;
                        result = result * 59 + ($typeVariable == null ? 43 : $typeVariable.hashCode());
                        result = result * 59 + this.index;
                        return result;
                    }
                }
            }

            public static class ForWildcardLowerBoundType
            extends Delegator.Chained {
                private static final Method GET_ANNOTATED_LOWER_BOUNDS = ForWildcardLowerBoundType.of("java.lang.reflect.AnnotatedWildcardType", "getAnnotatedLowerBounds");
                private final int index;

                protected ForWildcardLowerBoundType(AnnotationReader annotationReader, int index) {
                    super(annotationReader);
                    this.index = index;
                }

                @Override
                protected AnnotatedElement resolve(AnnotatedElement annotatedElement) {
                    try {
                        return (AnnotatedElement)Array.get(GET_ANNOTATED_LOWER_BOUNDS.invoke((Object)annotatedElement, new Object[0]), this.index);
                    }
                    catch (ClassCastException ignored) {
                        return NoOp.INSTANCE;
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.reflect.AnnotatedWildcardType#getAnnotatedLowerBounds", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.reflect.AnnotatedWildcardType#getAnnotatedLowerBounds", exception.getCause());
                    }
                }

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForWildcardLowerBoundType)) {
                        return false;
                    }
                    ForWildcardLowerBoundType other = (ForWildcardLowerBoundType)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    if (!super.equals(o)) {
                        return false;
                    }
                    return this.index == other.index;
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof ForWildcardLowerBoundType;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = super.hashCode();
                    result = result * 59 + this.index;
                    return result;
                }
            }

            public static class ForWildcardUpperBoundType
            extends Delegator.Chained {
                private static final Method GET_ANNOTATED_UPPER_BOUNDS = ForWildcardUpperBoundType.of("java.lang.reflect.AnnotatedWildcardType", "getAnnotatedUpperBounds");
                private final int index;

                protected ForWildcardUpperBoundType(AnnotationReader annotationReader, int index) {
                    super(annotationReader);
                    this.index = index;
                }

                @Override
                protected AnnotatedElement resolve(AnnotatedElement annotatedElement) {
                    try {
                        Object annotatedUpperBounds = GET_ANNOTATED_UPPER_BOUNDS.invoke((Object)annotatedElement, new Object[0]);
                        return Array.getLength(annotatedUpperBounds) == 0 ? NoOp.INSTANCE : (AnnotatedElement)Array.get(annotatedUpperBounds, this.index);
                    }
                    catch (ClassCastException ignored) {
                        return NoOp.INSTANCE;
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.reflect.AnnotatedWildcardType#getAnnotatedUpperBounds", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.reflect.AnnotatedWildcardType#getAnnotatedUpperBounds", exception.getCause());
                    }
                }

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForWildcardUpperBoundType)) {
                        return false;
                    }
                    ForWildcardUpperBoundType other = (ForWildcardUpperBoundType)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    if (!super.equals(o)) {
                        return false;
                    }
                    return this.index == other.index;
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof ForWildcardUpperBoundType;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = super.hashCode();
                    result = result * 59 + this.index;
                    return result;
                }
            }

            public static abstract class Delegator
            implements AnnotationReader {
                @Override
                public AnnotationReader ofWildcardUpperBoundType(int index) {
                    return new ForWildcardUpperBoundType(this, index);
                }

                @Override
                public AnnotationReader ofWildcardLowerBoundType(int index) {
                    return new ForWildcardLowerBoundType(this, index);
                }

                @Override
                public AnnotationReader ofTypeVariableBoundType(int index) {
                    return new ForTypeVariableBoundType(this, index);
                }

                @Override
                public AnnotationReader ofTypeArgument(int index) {
                    return new ForTypeArgument(this, index);
                }

                @Override
                public AnnotationReader ofOwnerType() {
                    return ForOwnerType.of(this);
                }

                @Override
                public AnnotationReader ofOuterClass() {
                    return ForOwnerType.of(this);
                }

                @Override
                public AnnotationReader ofComponentType() {
                    return new ForComponentType(this);
                }

                @Override
                public AnnotationList asList() {
                    return new AnnotationList.ForLoadedAnnotations(this.resolve().getDeclaredAnnotations());
                }

                protected static abstract class Chained
                extends Delegator {
                    protected static final Method NOT_AVAILABLE = null;
                    protected final AnnotationReader annotationReader;

                    protected Chained(AnnotationReader annotationReader) {
                        this.annotationReader = annotationReader;
                    }

                    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback")
                    protected static Method of(String typeName, String methodName) {
                        try {
                            return Class.forName(typeName).getMethod(methodName, new Class[0]);
                        }
                        catch (Exception exception) {
                            return NOT_AVAILABLE;
                        }
                    }

                    @Override
                    public AnnotatedElement resolve() {
                        return this.resolve(this.annotationReader.resolve());
                    }

                    protected abstract AnnotatedElement resolve(AnnotatedElement var1);

                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Chained)) {
                            return false;
                        }
                        Chained other = (Chained)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        AnnotationReader this$annotationReader = this.annotationReader;
                        AnnotationReader other$annotationReader = other.annotationReader;
                        return !(this$annotationReader == null ? other$annotationReader != null : !this$annotationReader.equals(other$annotationReader));
                    }

                    protected boolean canEqual(Object other) {
                        return other instanceof Chained;
                    }

                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        AnnotationReader $annotationReader = this.annotationReader;
                        result = result * 59 + ($annotationReader == null ? 43 : $annotationReader.hashCode());
                        return result;
                    }
                }
            }

            public static enum NoOp implements AnnotationReader,
            AnnotatedElement
            {
                INSTANCE;


                @Override
                public AnnotatedElement resolve() {
                    return this;
                }

                @Override
                public AnnotationList asList() {
                    return new AnnotationList.Empty();
                }

                @Override
                public AnnotationReader ofWildcardUpperBoundType(int index) {
                    return this;
                }

                @Override
                public AnnotationReader ofWildcardLowerBoundType(int index) {
                    return this;
                }

                @Override
                public AnnotationReader ofTypeVariableBoundType(int index) {
                    return this;
                }

                @Override
                public AnnotationReader ofTypeArgument(int index) {
                    return this;
                }

                @Override
                public AnnotationReader ofOwnerType() {
                    return this;
                }

                @Override
                public AnnotationReader ofOuterClass() {
                    return this;
                }

                @Override
                public AnnotationReader ofComponentType() {
                    return this;
                }

                @Override
                public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
                    throw new IllegalStateException("Cannot resolve annotations for no-op reader: " + this);
                }

                @Override
                public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                    throw new IllegalStateException("Cannot resolve annotations for no-op reader: " + this);
                }

                @Override
                public Annotation[] getAnnotations() {
                    throw new IllegalStateException("Cannot resolve annotations for no-op reader: " + this);
                }

                @Override
                public Annotation[] getDeclaredAnnotations() {
                    return new Annotation[0];
                }
            }

            public static interface Dispatcher {
                public AnnotationReader resolveTypeVariable(TypeVariable<?> var1);

                public AnnotationReader resolveSuperClassType(Class<?> var1);

                public AnnotationReader resolveInterfaceType(Class<?> var1, int var2);

                public AnnotationReader resolveFieldType(Field var1);

                public AnnotationReader resolveReturnType(Method var1);

                public AnnotationReader resolveParameterType(AccessibleObject var1, int var2);

                public AnnotationReader resolveExceptionType(AccessibleObject var1, int var2);

                public Generic resolveReceiverType(AccessibleObject var1);

                public Generic resolve(AnnotatedElement var1);

                public static class ForJava8CapableVm
                implements Dispatcher {
                    private final Method getAnnotatedSuperclass;
                    private final Method getAnnotatedInterfaces;
                    private final Method getAnnotatedType;
                    private final Method getAnnotatedReturnType;
                    private final Method getAnnotatedParameterTypes;
                    private final Method getAnnotatedExceptionTypes;
                    private final Method getAnnotatedReceiverType;
                    private final Method getType;

                    protected ForJava8CapableVm(Method getAnnotatedSuperclass, Method getAnnotatedInterfaces, Method getAnnotatedType, Method getAnnotatedReturnType, Method getAnnotatedParameterTypes, Method getAnnotatedExceptionTypes, Method getAnnotatedReceiverType, Method getType) {
                        this.getAnnotatedSuperclass = getAnnotatedSuperclass;
                        this.getAnnotatedInterfaces = getAnnotatedInterfaces;
                        this.getAnnotatedType = getAnnotatedType;
                        this.getAnnotatedReturnType = getAnnotatedReturnType;
                        this.getAnnotatedParameterTypes = getAnnotatedParameterTypes;
                        this.getAnnotatedExceptionTypes = getAnnotatedExceptionTypes;
                        this.getAnnotatedReceiverType = getAnnotatedReceiverType;
                        this.getType = getType;
                    }

                    @Override
                    public AnnotationReader resolveTypeVariable(TypeVariable<?> typeVariable) {
                        return new AnnotatedTypeVariableType(typeVariable);
                    }

                    @Override
                    public AnnotationReader resolveSuperClassType(Class<?> type) {
                        return new AnnotatedSuperClass(type);
                    }

                    @Override
                    public AnnotationReader resolveInterfaceType(Class<?> type, int index) {
                        return new AnnotatedInterfaceType(type, index);
                    }

                    @Override
                    public AnnotationReader resolveFieldType(Field field) {
                        return new AnnotatedFieldType(field);
                    }

                    @Override
                    public AnnotationReader resolveReturnType(Method method) {
                        return new AnnotatedReturnType(method);
                    }

                    @Override
                    public AnnotationReader resolveParameterType(AccessibleObject executable, int index) {
                        return new AnnotatedParameterizedType(executable, index);
                    }

                    @Override
                    public AnnotationReader resolveExceptionType(AccessibleObject executable, int index) {
                        return new AnnotatedExceptionType(executable, index);
                    }

                    @Override
                    public Generic resolveReceiverType(AccessibleObject executable) {
                        try {
                            return this.resolve((AnnotatedElement)this.getAnnotatedReceiverType.invoke((Object)executable, new Object[0]));
                        }
                        catch (IllegalAccessException exception) {
                            throw new IllegalStateException("Cannot access java.lang.reflect.Executable#getAnnotatedReceiverType", exception);
                        }
                        catch (InvocationTargetException exception) {
                            throw new IllegalStateException("Error invoking java.lang.reflect.Executable#getAnnotatedReceiverType", exception.getCause());
                        }
                    }

                    @Override
                    public Generic resolve(AnnotatedElement annotatedType) {
                        try {
                            return annotatedType == null ? UNDEFINED : TypeDefinition.Sort.describe((Type)this.getType.invoke((Object)annotatedType, new Object[0]), new Resolved(annotatedType));
                        }
                        catch (IllegalAccessException exception) {
                            throw new IllegalStateException("Cannot access java.lang.reflect.AnnotatedType#getType", exception);
                        }
                        catch (InvocationTargetException exception) {
                            throw new IllegalStateException("Error invoking java.lang.reflect.AnnotatedType#getType", exception.getCause());
                        }
                    }

                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof ForJava8CapableVm)) {
                            return false;
                        }
                        ForJava8CapableVm other = (ForJava8CapableVm)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        Method this$getAnnotatedSuperclass = this.getAnnotatedSuperclass;
                        Method other$getAnnotatedSuperclass = other.getAnnotatedSuperclass;
                        if (this$getAnnotatedSuperclass == null ? other$getAnnotatedSuperclass != null : !((Object)this$getAnnotatedSuperclass).equals(other$getAnnotatedSuperclass)) {
                            return false;
                        }
                        Method this$getAnnotatedInterfaces = this.getAnnotatedInterfaces;
                        Method other$getAnnotatedInterfaces = other.getAnnotatedInterfaces;
                        if (this$getAnnotatedInterfaces == null ? other$getAnnotatedInterfaces != null : !((Object)this$getAnnotatedInterfaces).equals(other$getAnnotatedInterfaces)) {
                            return false;
                        }
                        Method this$getAnnotatedType = this.getAnnotatedType;
                        Method other$getAnnotatedType = other.getAnnotatedType;
                        if (this$getAnnotatedType == null ? other$getAnnotatedType != null : !((Object)this$getAnnotatedType).equals(other$getAnnotatedType)) {
                            return false;
                        }
                        Method this$getAnnotatedReturnType = this.getAnnotatedReturnType;
                        Method other$getAnnotatedReturnType = other.getAnnotatedReturnType;
                        if (this$getAnnotatedReturnType == null ? other$getAnnotatedReturnType != null : !((Object)this$getAnnotatedReturnType).equals(other$getAnnotatedReturnType)) {
                            return false;
                        }
                        Method this$getAnnotatedParameterTypes = this.getAnnotatedParameterTypes;
                        Method other$getAnnotatedParameterTypes = other.getAnnotatedParameterTypes;
                        if (this$getAnnotatedParameterTypes == null ? other$getAnnotatedParameterTypes != null : !((Object)this$getAnnotatedParameterTypes).equals(other$getAnnotatedParameterTypes)) {
                            return false;
                        }
                        Method this$getAnnotatedExceptionTypes = this.getAnnotatedExceptionTypes;
                        Method other$getAnnotatedExceptionTypes = other.getAnnotatedExceptionTypes;
                        if (this$getAnnotatedExceptionTypes == null ? other$getAnnotatedExceptionTypes != null : !((Object)this$getAnnotatedExceptionTypes).equals(other$getAnnotatedExceptionTypes)) {
                            return false;
                        }
                        Method this$getAnnotatedReceiverType = this.getAnnotatedReceiverType;
                        Method other$getAnnotatedReceiverType = other.getAnnotatedReceiverType;
                        if (this$getAnnotatedReceiverType == null ? other$getAnnotatedReceiverType != null : !((Object)this$getAnnotatedReceiverType).equals(other$getAnnotatedReceiverType)) {
                            return false;
                        }
                        Method this$getType = this.getType;
                        Method other$getType = other.getType;
                        return !(this$getType == null ? other$getType != null : !((Object)this$getType).equals(other$getType));
                    }

                    protected boolean canEqual(Object other) {
                        return other instanceof ForJava8CapableVm;
                    }

                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        Method $getAnnotatedSuperclass = this.getAnnotatedSuperclass;
                        result = result * 59 + ($getAnnotatedSuperclass == null ? 43 : ((Object)$getAnnotatedSuperclass).hashCode());
                        Method $getAnnotatedInterfaces = this.getAnnotatedInterfaces;
                        result = result * 59 + ($getAnnotatedInterfaces == null ? 43 : ((Object)$getAnnotatedInterfaces).hashCode());
                        Method $getAnnotatedType = this.getAnnotatedType;
                        result = result * 59 + ($getAnnotatedType == null ? 43 : ((Object)$getAnnotatedType).hashCode());
                        Method $getAnnotatedReturnType = this.getAnnotatedReturnType;
                        result = result * 59 + ($getAnnotatedReturnType == null ? 43 : ((Object)$getAnnotatedReturnType).hashCode());
                        Method $getAnnotatedParameterTypes = this.getAnnotatedParameterTypes;
                        result = result * 59 + ($getAnnotatedParameterTypes == null ? 43 : ((Object)$getAnnotatedParameterTypes).hashCode());
                        Method $getAnnotatedExceptionTypes = this.getAnnotatedExceptionTypes;
                        result = result * 59 + ($getAnnotatedExceptionTypes == null ? 43 : ((Object)$getAnnotatedExceptionTypes).hashCode());
                        Method $getAnnotatedReceiverType = this.getAnnotatedReceiverType;
                        result = result * 59 + ($getAnnotatedReceiverType == null ? 43 : ((Object)$getAnnotatedReceiverType).hashCode());
                        Method $getType = this.getType;
                        result = result * 59 + ($getType == null ? 43 : ((Object)$getType).hashCode());
                        return result;
                    }

                    protected class AnnotatedExceptionType
                    extends Delegator {
                        private final AccessibleObject executable;
                        private final int index;

                        protected AnnotatedExceptionType(AccessibleObject executable, int index) {
                            this.executable = executable;
                            this.index = index;
                        }

                        @Override
                        public AnnotatedElement resolve() {
                            try {
                                return (AnnotatedElement)Array.get(ForJava8CapableVm.this.getAnnotatedExceptionTypes.invoke((Object)this.executable, new Object[0]), this.index);
                            }
                            catch (IllegalAccessException exception) {
                                throw new IllegalStateException("Cannot access java.lang.reflect.Executable#getAnnotatedExceptionTypes", exception);
                            }
                            catch (InvocationTargetException exception) {
                                throw new IllegalStateException("Error invoking java.lang.reflect.Executable#getAnnotatedExceptionTypes", exception.getCause());
                            }
                        }

                        private ForJava8CapableVm getOuter() {
                            return ForJava8CapableVm.this;
                        }

                        public boolean equals(Object other) {
                            return this == other || other != null && this.getClass() == other.getClass() && this.getOuter().equals(((AnnotatedExceptionType)other).getOuter()) && this.executable.equals(((AnnotatedExceptionType)other).executable) && this.index == ((AnnotatedExceptionType)other).index;
                        }

                        public int hashCode() {
                            return 31 * (this.executable.hashCode() + 31 * this.index) + this.getOuter().hashCode();
                        }
                    }

                    protected class AnnotatedParameterizedType
                    extends Delegator {
                        private final AccessibleObject executable;
                        private final int index;

                        protected AnnotatedParameterizedType(AccessibleObject executable, int index) {
                            this.executable = executable;
                            this.index = index;
                        }

                        @Override
                        public AnnotatedElement resolve() {
                            try {
                                return (AnnotatedElement)Array.get(ForJava8CapableVm.this.getAnnotatedParameterTypes.invoke((Object)this.executable, new Object[0]), this.index);
                            }
                            catch (IllegalAccessException exception) {
                                throw new IllegalStateException("Cannot access java.lang.reflect.Executable#getAnnotatedParameterTypes", exception);
                            }
                            catch (InvocationTargetException exception) {
                                throw new IllegalStateException("Error invoking java.lang.reflect.Executable#getAnnotatedParameterTypes", exception.getCause());
                            }
                        }

                        private ForJava8CapableVm getOuter() {
                            return ForJava8CapableVm.this;
                        }

                        public boolean equals(Object other) {
                            return this == other || other != null && this.getClass() == other.getClass() && this.getOuter().equals(((AnnotatedParameterizedType)other).getOuter()) && this.executable.equals(((AnnotatedParameterizedType)other).executable) && this.index == ((AnnotatedParameterizedType)other).index;
                        }

                        public int hashCode() {
                            return 31 * (this.executable.hashCode() + 31 * this.index) + this.getOuter().hashCode();
                        }
                    }

                    protected class AnnotatedReturnType
                    extends Delegator {
                        private final Method method;

                        protected AnnotatedReturnType(Method method) {
                            this.method = method;
                        }

                        @Override
                        public AnnotatedElement resolve() {
                            try {
                                return (AnnotatedElement)ForJava8CapableVm.this.getAnnotatedReturnType.invoke((Object)this.method, new Object[0]);
                            }
                            catch (IllegalAccessException exception) {
                                throw new IllegalStateException("Cannot access java.lang.reflect.Method#getAnnotatedReturnType", exception);
                            }
                            catch (InvocationTargetException exception) {
                                throw new IllegalStateException("Error invoking java.lang.reflect.Method#getAnnotatedReturnType", exception.getCause());
                            }
                        }

                        private ForJava8CapableVm getOuter() {
                            return ForJava8CapableVm.this;
                        }

                        public boolean equals(Object other) {
                            return this == other || other != null && this.getClass() == other.getClass() && this.getOuter().equals(((AnnotatedReturnType)other).getOuter()) && this.method.equals(((AnnotatedReturnType)other).method);
                        }

                        public int hashCode() {
                            return 31 * this.method.hashCode() + this.getOuter().hashCode();
                        }
                    }

                    protected class AnnotatedFieldType
                    extends Delegator {
                        private final Field field;

                        protected AnnotatedFieldType(Field field) {
                            this.field = field;
                        }

                        @Override
                        public AnnotatedElement resolve() {
                            try {
                                return (AnnotatedElement)ForJava8CapableVm.this.getAnnotatedType.invoke((Object)this.field, new Object[0]);
                            }
                            catch (IllegalAccessException exception) {
                                throw new IllegalStateException("Cannot access java.lang.reflect.Field#getAnnotatedType", exception);
                            }
                            catch (InvocationTargetException exception) {
                                throw new IllegalStateException("Error invoking java.lang.reflect.Field#getAnnotatedType", exception.getCause());
                            }
                        }

                        private ForJava8CapableVm getOuter() {
                            return ForJava8CapableVm.this;
                        }

                        public boolean equals(Object other) {
                            return this == other || other != null && this.getClass() == other.getClass() && this.getOuter().equals(((AnnotatedFieldType)other).getOuter()) && this.field.equals(((AnnotatedFieldType)other).field);
                        }

                        public int hashCode() {
                            return this.field.hashCode() + this.getOuter().hashCode() * 31;
                        }
                    }

                    protected class AnnotatedInterfaceType
                    extends Delegator {
                        private final Class<?> type;
                        private final int index;

                        protected AnnotatedInterfaceType(Class<?> type, int index) {
                            this.type = type;
                            this.index = index;
                        }

                        @Override
                        public AnnotatedElement resolve() {
                            try {
                                return (AnnotatedElement)Array.get(ForJava8CapableVm.this.getAnnotatedInterfaces.invoke(this.type, new Object[0]), this.index);
                            }
                            catch (IllegalAccessException exception) {
                                throw new IllegalStateException("Cannot access java.lang.Class#getAnnotatedInterfaces", exception);
                            }
                            catch (InvocationTargetException exception) {
                                throw new IllegalStateException("Error invoking java.lang.Class#getAnnotatedInterfaces", exception.getCause());
                            }
                        }

                        private ForJava8CapableVm getOuter() {
                            return ForJava8CapableVm.this;
                        }

                        public boolean equals(Object other) {
                            return this == other || other != null && this.getClass() == other.getClass() && this.getOuter().equals(((AnnotatedInterfaceType)other).getOuter()) && this.type.equals(((AnnotatedInterfaceType)other).type) && this.index == ((AnnotatedInterfaceType)other).index;
                        }

                        public int hashCode() {
                            return 31 * (this.type.hashCode() + 31 * this.getOuter().hashCode()) + this.index;
                        }
                    }

                    protected class AnnotatedSuperClass
                    extends Delegator {
                        private final Class<?> type;

                        protected AnnotatedSuperClass(Class<?> type) {
                            this.type = type;
                        }

                        @Override
                        public AnnotatedElement resolve() {
                            try {
                                return (AnnotatedElement)ForJava8CapableVm.this.getAnnotatedSuperclass.invoke(this.type, new Object[0]);
                            }
                            catch (IllegalAccessException exception) {
                                throw new IllegalStateException("Cannot access java.lang.Class#getAnnotatedSuperclass", exception);
                            }
                            catch (InvocationTargetException exception) {
                                throw new IllegalStateException("Error invoking java.lang.Class#getAnnotatedSuperclass", exception.getCause());
                            }
                        }

                        private ForJava8CapableVm getOuter() {
                            return ForJava8CapableVm.this;
                        }

                        public boolean equals(Object other) {
                            return this == other || other != null && this.getClass() == other.getClass() && this.getOuter().equals(((AnnotatedSuperClass)other).getOuter()) && this.type.equals(((AnnotatedSuperClass)other).type);
                        }

                        public int hashCode() {
                            return this.getOuter().hashCode() + this.type.hashCode() * 31;
                        }
                    }

                    protected static class AnnotatedTypeVariableType
                    extends Delegator {
                        private final TypeVariable<?> typeVariable;

                        protected AnnotatedTypeVariableType(TypeVariable<?> typeVariable) {
                            this.typeVariable = typeVariable;
                        }

                        @Override
                        public AnnotatedElement resolve() {
                            return this.typeVariable;
                        }

                        @Override
                        public AnnotationReader ofTypeVariableBoundType(int index) {
                            return new ForTypeVariableBoundType.OfFormalTypeVariable(this.typeVariable, index);
                        }

                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof AnnotatedTypeVariableType)) {
                                return false;
                            }
                            AnnotatedTypeVariableType other = (AnnotatedTypeVariableType)o;
                            if (!other.canEqual(this)) {
                                return false;
                            }
                            TypeVariable<?> this$typeVariable = this.typeVariable;
                            TypeVariable<?> other$typeVariable = other.typeVariable;
                            return !(this$typeVariable == null ? other$typeVariable != null : !this$typeVariable.equals(other$typeVariable));
                        }

                        protected boolean canEqual(Object other) {
                            return other instanceof AnnotatedTypeVariableType;
                        }

                        public int hashCode() {
                            int PRIME = 59;
                            int result = 1;
                            TypeVariable<?> $typeVariable = this.typeVariable;
                            result = result * 59 + ($typeVariable == null ? 43 : $typeVariable.hashCode());
                            return result;
                        }
                    }

                    protected static class Resolved
                    extends Delegator {
                        private final AnnotatedElement annotatedElement;

                        protected Resolved(AnnotatedElement annotatedElement) {
                            this.annotatedElement = annotatedElement;
                        }

                        @Override
                        public AnnotatedElement resolve() {
                            return this.annotatedElement;
                        }

                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof Resolved)) {
                                return false;
                            }
                            Resolved other = (Resolved)o;
                            if (!other.canEqual(this)) {
                                return false;
                            }
                            AnnotatedElement this$annotatedElement = this.annotatedElement;
                            AnnotatedElement other$annotatedElement = other.annotatedElement;
                            return !(this$annotatedElement == null ? other$annotatedElement != null : !this$annotatedElement.equals(other$annotatedElement));
                        }

                        protected boolean canEqual(Object other) {
                            return other instanceof Resolved;
                        }

                        public int hashCode() {
                            int PRIME = 59;
                            int result = 1;
                            AnnotatedElement $annotatedElement = this.annotatedElement;
                            result = result * 59 + ($annotatedElement == null ? 43 : $annotatedElement.hashCode());
                            return result;
                        }
                    }
                }

                public static enum ForLegacyVm implements Dispatcher
                {
                    INSTANCE;


                    @Override
                    public AnnotationReader resolveTypeVariable(TypeVariable<?> typeVariable) {
                        return NoOp.INSTANCE;
                    }

                    @Override
                    public AnnotationReader resolveSuperClassType(Class<?> type) {
                        return NoOp.INSTANCE;
                    }

                    @Override
                    public AnnotationReader resolveInterfaceType(Class<?> type, int index) {
                        return NoOp.INSTANCE;
                    }

                    @Override
                    public AnnotationReader resolveFieldType(Field field) {
                        return NoOp.INSTANCE;
                    }

                    @Override
                    public AnnotationReader resolveReturnType(Method method) {
                        return NoOp.INSTANCE;
                    }

                    @Override
                    public AnnotationReader resolveParameterType(AccessibleObject executable, int index) {
                        return NoOp.INSTANCE;
                    }

                    @Override
                    public AnnotationReader resolveExceptionType(AccessibleObject executable, int index) {
                        return NoOp.INSTANCE;
                    }

                    @Override
                    public Generic resolveReceiverType(AccessibleObject executable) {
                        return UNDEFINED;
                    }

                    @Override
                    public Generic resolve(AnnotatedElement annotatedType) {
                        throw new IllegalStateException("Loaded annotated type cannot be represented on this VM");
                    }
                }

                public static enum CreationAction implements PrivilegedAction<Dispatcher>
                {
                    INSTANCE;


                    @Override
                    public Dispatcher run() {
                        try {
                            return new ForJava8CapableVm(Class.class.getMethod("getAnnotatedSuperclass", new Class[0]), Class.class.getMethod("getAnnotatedInterfaces", new Class[0]), Field.class.getMethod("getAnnotatedType", new Class[0]), Method.class.getMethod("getAnnotatedReturnType", new Class[0]), Class.forName("java.lang.reflect.Executable").getMethod("getAnnotatedParameterTypes", new Class[0]), Class.forName("java.lang.reflect.Executable").getMethod("getAnnotatedExceptionTypes", new Class[0]), Class.forName("java.lang.reflect.Executable").getMethod("getAnnotatedReceiverType", new Class[0]), Class.forName("java.lang.reflect.AnnotatedType").getMethod("getType", new Class[0]));
                        }
                        catch (RuntimeException exception) {
                            throw exception;
                        }
                        catch (Exception ignored) {
                            return ForLegacyVm.INSTANCE;
                        }
                    }
                }
            }
        }

        public static interface Visitor<T> {
            public T onGenericArray(Generic var1);

            public T onWildcard(Generic var1);

            public T onParameterizedType(Generic var1);

            public T onTypeVariable(Generic var1);

            public T onNonGenericType(Generic var1);

            public static class Reducing
            implements Visitor<TypeDescription> {
                private final TypeDescription declaringType;
                private final List<? extends TypeVariableToken> typeVariableTokens;

                public Reducing(TypeDescription declaringType) {
                    this(declaringType, Collections.emptyList());
                }

                public Reducing(TypeDescription declaringType, List<? extends TypeVariableToken> typeVariableTokens) {
                    this.declaringType = declaringType;
                    this.typeVariableTokens = typeVariableTokens;
                }

                @Override
                public TypeDescription onGenericArray(Generic genericArray) {
                    return TargetType.resolve(genericArray.asErasure(), this.declaringType);
                }

                @Override
                public TypeDescription onWildcard(Generic wildcard) {
                    throw new IllegalStateException("A wildcard cannot be a top-level type: " + wildcard);
                }

                @Override
                public TypeDescription onParameterizedType(Generic parameterizedType) {
                    return TargetType.resolve(parameterizedType.asErasure(), this.declaringType);
                }

                @Override
                public TypeDescription onTypeVariable(Generic typeVariable) {
                    for (TypeVariableToken typeVariableToken : this.typeVariableTokens) {
                        if (!typeVariable.getSymbol().equals(typeVariableToken.getSymbol())) continue;
                        return ((Generic)typeVariableToken.getBounds().get(0)).accept(this);
                    }
                    return TargetType.resolve(this.declaringType.findVariable(typeVariable.getSymbol()).asErasure(), this.declaringType);
                }

                @Override
                public TypeDescription onNonGenericType(Generic typeDescription) {
                    return TargetType.resolve(typeDescription.asErasure(), this.declaringType);
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Reducing)) {
                        return false;
                    }
                    Reducing other = (Reducing)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    TypeDescription this$declaringType = this.declaringType;
                    TypeDescription other$declaringType = other.declaringType;
                    if (this$declaringType == null ? other$declaringType != null : !this$declaringType.equals(other$declaringType)) {
                        return false;
                    }
                    List<? extends TypeVariableToken> this$typeVariableTokens = this.typeVariableTokens;
                    List<? extends TypeVariableToken> other$typeVariableTokens = other.typeVariableTokens;
                    return !(this$typeVariableTokens == null ? other$typeVariableTokens != null : !((Object)this$typeVariableTokens).equals(other$typeVariableTokens));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof Reducing;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    TypeDescription $declaringType = this.declaringType;
                    result = result * 59 + ($declaringType == null ? 43 : $declaringType.hashCode());
                    List<? extends TypeVariableToken> $typeVariableTokens = this.typeVariableTokens;
                    result = result * 59 + ($typeVariableTokens == null ? 43 : ((Object)$typeVariableTokens).hashCode());
                    return result;
                }
            }

            public static class ForRawType
            implements Visitor<Generic> {
                private final TypeDescription declaringType;

                public ForRawType(TypeDescription declaringType) {
                    this.declaringType = declaringType;
                }

                @Override
                public Generic onGenericArray(Generic genericArray) {
                    return this.declaringType.isGenerified() ? new OfNonGenericType.Latent(genericArray.asErasure(), genericArray) : genericArray;
                }

                @Override
                public Generic onWildcard(Generic wildcard) {
                    throw new IllegalStateException("Did not expect wildcard on top-level: " + wildcard);
                }

                @Override
                public Generic onParameterizedType(Generic parameterizedType) {
                    return this.declaringType.isGenerified() ? new OfNonGenericType.Latent(parameterizedType.asErasure(), parameterizedType) : parameterizedType;
                }

                @Override
                public Generic onTypeVariable(Generic typeVariable) {
                    return this.declaringType.isGenerified() ? new OfNonGenericType.Latent(typeVariable.asErasure(), typeVariable) : typeVariable;
                }

                @Override
                public Generic onNonGenericType(Generic typeDescription) {
                    return typeDescription;
                }
            }

            public static abstract class Substitutor
            implements Visitor<Generic> {
                @Override
                public Generic onParameterizedType(Generic parameterizedType) {
                    Generic ownerType = parameterizedType.getOwnerType();
                    ArrayList<Generic> typeArguments = new ArrayList<Generic>(parameterizedType.getTypeArguments().size());
                    for (Generic typeArgument : parameterizedType.getTypeArguments()) {
                        typeArguments.add(typeArgument.accept(this));
                    }
                    return new OfParameterizedType.Latent(parameterizedType.asRawType().accept(this).asErasure(), ownerType == null ? UNDEFINED : ownerType.accept(this), typeArguments, parameterizedType);
                }

                @Override
                public Generic onGenericArray(Generic genericArray) {
                    return new OfGenericArray.Latent(genericArray.getComponentType().accept(this), genericArray);
                }

                @Override
                public Generic onWildcard(Generic wildcard) {
                    return new OfWildcardType.Latent(wildcard.getUpperBounds().accept(this), wildcard.getLowerBounds().accept(this), wildcard);
                }

                @Override
                public Generic onNonGenericType(Generic typeDescription) {
                    return typeDescription.isArray() ? new OfGenericArray.Latent(typeDescription.getComponentType().accept(this), typeDescription) : this.onSimpleType(typeDescription);
                }

                protected abstract Generic onSimpleType(Generic var1);

                public static class ForTokenNormalization
                extends Substitutor {
                    private final TypeDescription typeDescription;

                    public ForTokenNormalization(TypeDescription typeDescription) {
                        this.typeDescription = typeDescription;
                    }

                    @Override
                    protected Generic onSimpleType(Generic typeDescription) {
                        return typeDescription.represents((Type)((Object)TargetType.class)) ? new OfNonGenericType.Latent(this.typeDescription, typeDescription) : typeDescription;
                    }

                    @Override
                    public Generic onTypeVariable(Generic typeVariable) {
                        return new OfTypeVariable.Symbolic(typeVariable.getSymbol(), typeVariable);
                    }

                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof ForTokenNormalization)) {
                            return false;
                        }
                        ForTokenNormalization other = (ForTokenNormalization)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        TypeDescription this$typeDescription = this.typeDescription;
                        TypeDescription other$typeDescription = other.typeDescription;
                        return !(this$typeDescription == null ? other$typeDescription != null : !this$typeDescription.equals(other$typeDescription));
                    }

                    protected boolean canEqual(Object other) {
                        return other instanceof ForTokenNormalization;
                    }

                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        TypeDescription $typeDescription = this.typeDescription;
                        result = result * 59 + ($typeDescription == null ? 43 : $typeDescription.hashCode());
                        return result;
                    }
                }

                public static class ForTypeVariableBinding
                extends WithoutTypeSubstitution {
                    private final Generic parameterizedType;

                    protected ForTypeVariableBinding(Generic parameterizedType) {
                        this.parameterizedType = parameterizedType;
                    }

                    @Override
                    public Generic onTypeVariable(Generic typeVariable) {
                        return typeVariable.getTypeVariableSource().accept(new TypeVariableSubstitutor(typeVariable));
                    }

                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof ForTypeVariableBinding)) {
                            return false;
                        }
                        ForTypeVariableBinding other = (ForTypeVariableBinding)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        Generic this$parameterizedType = this.parameterizedType;
                        Generic other$parameterizedType = other.parameterizedType;
                        return !(this$parameterizedType == null ? other$parameterizedType != null : !this$parameterizedType.equals(other$parameterizedType));
                    }

                    protected boolean canEqual(Object other) {
                        return other instanceof ForTypeVariableBinding;
                    }

                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        Generic $parameterizedType = this.parameterizedType;
                        result = result * 59 + ($parameterizedType == null ? 43 : $parameterizedType.hashCode());
                        return result;
                    }

                    protected class RetainedMethodTypeVariable
                    extends OfTypeVariable {
                        private final Generic typeVariable;

                        protected RetainedMethodTypeVariable(Generic typeVariable) {
                            this.typeVariable = typeVariable;
                        }

                        @Override
                        public TypeList.Generic getUpperBounds() {
                            return this.typeVariable.getUpperBounds().accept(ForTypeVariableBinding.this);
                        }

                        @Override
                        public TypeVariableSource getTypeVariableSource() {
                            return this.typeVariable.getTypeVariableSource();
                        }

                        @Override
                        public String getSymbol() {
                            return this.typeVariable.getSymbol();
                        }

                        @Override
                        public AnnotationList getDeclaredAnnotations() {
                            return this.typeVariable.getDeclaredAnnotations();
                        }
                    }

                    protected class TypeVariableSubstitutor
                    implements TypeVariableSource.Visitor<Generic> {
                        private final Generic typeVariable;

                        protected TypeVariableSubstitutor(Generic typeVariable) {
                            this.typeVariable = typeVariable;
                        }

                        @Override
                        public Generic onType(TypeDescription typeDescription) {
                            Generic typeArgument = ForTypeVariableBinding.this.parameterizedType.findBindingOf(this.typeVariable);
                            return typeArgument == null ? this.typeVariable.asRawType() : typeArgument;
                        }

                        @Override
                        public Generic onMethod(MethodDescription.InDefinedShape methodDescription) {
                            return new RetainedMethodTypeVariable(this.typeVariable);
                        }

                        private ForTypeVariableBinding getOuter() {
                            return ForTypeVariableBinding.this;
                        }

                        public boolean equals(Object other) {
                            return this == other || other != null && this.getClass() == other.getClass() && this.getOuter().equals(((TypeVariableSubstitutor)other).getOuter()) && this.typeVariable.equals(((TypeVariableSubstitutor)other).typeVariable);
                        }

                        public int hashCode() {
                            return this.typeVariable.hashCode();
                        }
                    }
                }

                public static class ForDetachment
                extends Substitutor {
                    private final ElementMatcher<? super TypeDescription> typeMatcher;

                    public ForDetachment(ElementMatcher<? super TypeDescription> typeMatcher) {
                        this.typeMatcher = typeMatcher;
                    }

                    public static Visitor<Generic> of(TypeDefinition typeDefinition) {
                        return new ForDetachment(ElementMatchers.is(typeDefinition));
                    }

                    @Override
                    public Generic onTypeVariable(Generic typeVariable) {
                        return new OfTypeVariable.Symbolic(typeVariable.getSymbol(), typeVariable);
                    }

                    @Override
                    protected Generic onSimpleType(Generic typeDescription) {
                        return this.typeMatcher.matches(typeDescription.asErasure()) ? new OfNonGenericType.Latent(TargetType.DESCRIPTION, typeDescription.getOwnerType(), (AnnotationSource)typeDescription) : typeDescription;
                    }

                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof ForDetachment)) {
                            return false;
                        }
                        ForDetachment other = (ForDetachment)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        ElementMatcher<? super TypeDescription> this$typeMatcher = this.typeMatcher;
                        ElementMatcher<? super TypeDescription> other$typeMatcher = other.typeMatcher;
                        return !(this$typeMatcher == null ? other$typeMatcher != null : !this$typeMatcher.equals(other$typeMatcher));
                    }

                    protected boolean canEqual(Object other) {
                        return other instanceof ForDetachment;
                    }

                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        ElementMatcher<? super TypeDescription> $typeMatcher = this.typeMatcher;
                        result = result * 59 + ($typeMatcher == null ? 43 : $typeMatcher.hashCode());
                        return result;
                    }
                }

                public static class ForAttachment
                extends Substitutor {
                    private final TypeDescription declaringType;
                    private final TypeVariableSource typeVariableSource;

                    protected ForAttachment(TypeDefinition declaringType, TypeVariableSource typeVariableSource) {
                        this(declaringType.asErasure(), typeVariableSource);
                    }

                    protected ForAttachment(TypeDescription declaringType, TypeVariableSource typeVariableSource) {
                        this.declaringType = declaringType;
                        this.typeVariableSource = typeVariableSource;
                    }

                    public static ForAttachment of(FieldDescription fieldDescription) {
                        return new ForAttachment(fieldDescription.getDeclaringType(), (TypeVariableSource)fieldDescription.getDeclaringType().asErasure());
                    }

                    public static ForAttachment of(MethodDescription methodDescription) {
                        return new ForAttachment(methodDescription.getDeclaringType(), (TypeVariableSource)methodDescription);
                    }

                    public static ForAttachment of(ParameterDescription parameterDescription) {
                        return new ForAttachment(parameterDescription.getDeclaringMethod().getDeclaringType(), (TypeVariableSource)parameterDescription.getDeclaringMethod());
                    }

                    public static ForAttachment of(TypeDescription typeDescription) {
                        return new ForAttachment(typeDescription, (TypeVariableSource)typeDescription);
                    }

                    @Override
                    public Generic onTypeVariable(Generic typeVariable) {
                        Generic attachedVariable = this.typeVariableSource.findVariable(typeVariable.getSymbol());
                        if (attachedVariable == null) {
                            throw new IllegalArgumentException("Cannot attach undefined variable: " + typeVariable);
                        }
                        return new OfTypeVariable.WithAnnotationOverlay(attachedVariable, typeVariable);
                    }

                    @Override
                    protected Generic onSimpleType(Generic typeDescription) {
                        return typeDescription.represents((Type)((Object)TargetType.class)) ? new OfNonGenericType.Latent(this.declaringType, typeDescription) : typeDescription;
                    }

                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof ForAttachment)) {
                            return false;
                        }
                        ForAttachment other = (ForAttachment)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        TypeDescription this$declaringType = this.declaringType;
                        TypeDescription other$declaringType = other.declaringType;
                        if (this$declaringType == null ? other$declaringType != null : !this$declaringType.equals(other$declaringType)) {
                            return false;
                        }
                        TypeVariableSource this$typeVariableSource = this.typeVariableSource;
                        TypeVariableSource other$typeVariableSource = other.typeVariableSource;
                        return !(this$typeVariableSource == null ? other$typeVariableSource != null : !this$typeVariableSource.equals(other$typeVariableSource));
                    }

                    protected boolean canEqual(Object other) {
                        return other instanceof ForAttachment;
                    }

                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        TypeDescription $declaringType = this.declaringType;
                        result = result * 59 + ($declaringType == null ? 43 : $declaringType.hashCode());
                        TypeVariableSource $typeVariableSource = this.typeVariableSource;
                        result = result * 59 + ($typeVariableSource == null ? 43 : $typeVariableSource.hashCode());
                        return result;
                    }
                }

                public static abstract class WithoutTypeSubstitution
                extends Substitutor {
                    @Override
                    public Generic onNonGenericType(Generic typeDescription) {
                        return typeDescription;
                    }

                    @Override
                    protected Generic onSimpleType(Generic typeDescription) {
                        return typeDescription;
                    }
                }
            }

            public static class ForSignatureVisitor
            implements Visitor<SignatureVisitor> {
                private static final int ONLY_CHARACTER = 0;
                protected final SignatureVisitor signatureVisitor;

                public ForSignatureVisitor(SignatureVisitor signatureVisitor) {
                    this.signatureVisitor = signatureVisitor;
                }

                @Override
                public SignatureVisitor onGenericArray(Generic genericArray) {
                    genericArray.getComponentType().accept(new ForSignatureVisitor(this.signatureVisitor.visitArrayType()));
                    return this.signatureVisitor;
                }

                @Override
                public SignatureVisitor onWildcard(Generic wildcard) {
                    throw new IllegalStateException("Unexpected wildcard: " + wildcard);
                }

                @Override
                public SignatureVisitor onParameterizedType(Generic parameterizedType) {
                    this.onOwnableType(parameterizedType);
                    this.signatureVisitor.visitEnd();
                    return this.signatureVisitor;
                }

                private void onOwnableType(Generic ownableType) {
                    Generic ownerType = ownableType.getOwnerType();
                    if (ownerType != null && ownerType.getSort().isParameterized()) {
                        this.onOwnableType(ownerType);
                        this.signatureVisitor.visitInnerClassType(ownableType.asErasure().getSimpleName());
                    } else {
                        this.signatureVisitor.visitClassType(ownableType.asErasure().getInternalName());
                    }
                    for (Generic typeArgument : ownableType.getTypeArguments()) {
                        typeArgument.accept(new OfTypeArgument(this.signatureVisitor));
                    }
                }

                @Override
                public SignatureVisitor onTypeVariable(Generic typeVariable) {
                    this.signatureVisitor.visitTypeVariable(typeVariable.getSymbol());
                    return this.signatureVisitor;
                }

                @Override
                public SignatureVisitor onNonGenericType(Generic typeDescription) {
                    if (typeDescription.isArray()) {
                        typeDescription.getComponentType().accept(new ForSignatureVisitor(this.signatureVisitor.visitArrayType()));
                    } else if (typeDescription.isPrimitive()) {
                        this.signatureVisitor.visitBaseType(typeDescription.asErasure().getDescriptor().charAt(0));
                    } else {
                        this.signatureVisitor.visitClassType(typeDescription.asErasure().getInternalName());
                        this.signatureVisitor.visitEnd();
                    }
                    return this.signatureVisitor;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForSignatureVisitor)) {
                        return false;
                    }
                    ForSignatureVisitor other = (ForSignatureVisitor)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    SignatureVisitor this$signatureVisitor = this.signatureVisitor;
                    SignatureVisitor other$signatureVisitor = other.signatureVisitor;
                    return !(this$signatureVisitor == null ? other$signatureVisitor != null : !this$signatureVisitor.equals(other$signatureVisitor));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ForSignatureVisitor;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    SignatureVisitor $signatureVisitor = this.signatureVisitor;
                    result = result * 59 + ($signatureVisitor == null ? 43 : $signatureVisitor.hashCode());
                    return result;
                }

                protected static class OfTypeArgument
                extends ForSignatureVisitor {
                    protected OfTypeArgument(SignatureVisitor signatureVisitor) {
                        super(signatureVisitor);
                    }

                    @Override
                    public SignatureVisitor onWildcard(Generic wildcard) {
                        TypeList.Generic upperBounds = wildcard.getUpperBounds();
                        TypeList.Generic lowerBounds = wildcard.getLowerBounds();
                        if (lowerBounds.isEmpty() && ((Generic)upperBounds.getOnly()).represents((Type)((Object)Object.class))) {
                            this.signatureVisitor.visitTypeArgument();
                        } else if (!lowerBounds.isEmpty()) {
                            ((Generic)lowerBounds.getOnly()).accept(new ForSignatureVisitor(this.signatureVisitor.visitTypeArgument('-')));
                        } else {
                            ((Generic)upperBounds.getOnly()).accept(new ForSignatureVisitor(this.signatureVisitor.visitTypeArgument('+')));
                        }
                        return this.signatureVisitor;
                    }

                    @Override
                    public SignatureVisitor onGenericArray(Generic genericArray) {
                        genericArray.accept(new ForSignatureVisitor(this.signatureVisitor.visitTypeArgument('=')));
                        return this.signatureVisitor;
                    }

                    @Override
                    public SignatureVisitor onParameterizedType(Generic parameterizedType) {
                        parameterizedType.accept(new ForSignatureVisitor(this.signatureVisitor.visitTypeArgument('=')));
                        return this.signatureVisitor;
                    }

                    @Override
                    public SignatureVisitor onTypeVariable(Generic typeVariable) {
                        typeVariable.accept(new ForSignatureVisitor(this.signatureVisitor.visitTypeArgument('=')));
                        return this.signatureVisitor;
                    }

                    @Override
                    public SignatureVisitor onNonGenericType(Generic typeDescription) {
                        typeDescription.accept(new ForSignatureVisitor(this.signatureVisitor.visitTypeArgument('=')));
                        return this.signatureVisitor;
                    }
                }
            }

            public static enum Reifying implements Visitor<Generic>
            {
                INITIATING{

                    @Override
                    public Generic onParameterizedType(Generic parameterizedType) {
                        return parameterizedType;
                    }
                }
                ,
                INHERITING{

                    @Override
                    public Generic onParameterizedType(Generic parameterizedType) {
                        return new OfParameterizedType.ForReifiedType(parameterizedType);
                    }
                };


                @Override
                public Generic onGenericArray(Generic genericArray) {
                    throw new IllegalArgumentException("Cannot reify a generic array: " + genericArray);
                }

                @Override
                public Generic onWildcard(Generic wildcard) {
                    throw new IllegalArgumentException("Cannot reify a wildcard: " + wildcard);
                }

                @Override
                public Generic onTypeVariable(Generic typeVariable) {
                    throw new IllegalArgumentException("Cannot reify a type variable: " + typeVariable);
                }

                @Override
                public Generic onNonGenericType(Generic typeDescription) {
                    TypeDescription erasure = typeDescription.asErasure();
                    return erasure.isGenerified() ? new OfNonGenericType.ForReifiedErasure(erasure) : typeDescription;
                }
            }

            public static enum Validator implements Visitor<Boolean>
            {
                SUPER_CLASS(false, false, false, false){

                    @Override
                    public Boolean onNonGenericType(Generic typeDescription) {
                        return super.onNonGenericType(typeDescription) != false && !typeDescription.isInterface();
                    }

                    @Override
                    public Boolean onParameterizedType(Generic parameterizedType) {
                        return !parameterizedType.isInterface();
                    }
                }
                ,
                INTERFACE(false, false, false, false){

                    @Override
                    public Boolean onNonGenericType(Generic typeDescription) {
                        return super.onNonGenericType(typeDescription) != false && typeDescription.isInterface();
                    }

                    @Override
                    public Boolean onParameterizedType(Generic parameterizedType) {
                        return parameterizedType.isInterface();
                    }
                }
                ,
                TYPE_VARIABLE(false, false, true, false),
                FIELD(true, true, true, false),
                METHOD_RETURN(true, true, true, true),
                METHOD_PARAMETER(true, true, true, false),
                EXCEPTION(false, false, true, false){

                    @Override
                    public Boolean onParameterizedType(Generic parameterizedType) {
                        return false;
                    }

                    @Override
                    public Boolean onTypeVariable(Generic typeVariable) {
                        for (Generic bound : typeVariable.getUpperBounds()) {
                            if (!bound.accept(this).booleanValue()) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public Boolean onNonGenericType(Generic typeDescription) {
                        return typeDescription.asErasure().isAssignableTo(Throwable.class);
                    }
                }
                ,
                RECEIVER(false, false, false, false);

                private final boolean acceptsArray;
                private final boolean acceptsPrimitive;
                private final boolean acceptsVariable;
                private final boolean acceptsVoid;

                private Validator(boolean acceptsArray, boolean acceptsPrimitive, boolean acceptsVariable, boolean acceptsVoid) {
                    this.acceptsArray = acceptsArray;
                    this.acceptsPrimitive = acceptsPrimitive;
                    this.acceptsVariable = acceptsVariable;
                    this.acceptsVoid = acceptsVoid;
                }

                @Override
                public Boolean onGenericArray(Generic genericArray) {
                    return this.acceptsArray;
                }

                @Override
                public Boolean onWildcard(Generic wildcard) {
                    return false;
                }

                @Override
                public Boolean onParameterizedType(Generic parameterizedType) {
                    return true;
                }

                @Override
                public Boolean onTypeVariable(Generic typeVariable) {
                    return this.acceptsVariable;
                }

                @Override
                public Boolean onNonGenericType(Generic typeDescription) {
                    return !(!this.acceptsArray && typeDescription.isArray() || !this.acceptsPrimitive && typeDescription.isPrimitive() || !this.acceptsVoid && typeDescription.represents(Void.TYPE));
                }

                public static enum ForTypeAnnotations implements Visitor<Boolean>
                {
                    INSTANCE;

                    private final ElementType typeUse;
                    private final ElementType typeParameter;

                    private ForTypeAnnotations() {
                        ElementType typeParameter;
                        ElementType typeUse;
                        try {
                            typeUse = Enum.valueOf(ElementType.class, "TYPE_USE");
                            typeParameter = Enum.valueOf(ElementType.class, "TYPE_PARAMETER");
                        }
                        catch (IllegalArgumentException ignored) {
                            typeUse = null;
                            typeParameter = null;
                        }
                        this.typeUse = typeUse;
                        this.typeParameter = typeParameter;
                    }

                    public static boolean ofFormalTypeVariable(Generic typeVariable) {
                        HashSet<TypeDescription> annotationTypes = new HashSet<TypeDescription>();
                        for (AnnotationDescription annotationDescription : typeVariable.getDeclaredAnnotations()) {
                            if (annotationDescription.getElementTypes().contains((Object)ForTypeAnnotations.INSTANCE.typeParameter) && annotationTypes.add(annotationDescription.getAnnotationType())) continue;
                            return false;
                        }
                        return true;
                    }

                    @Override
                    public Boolean onGenericArray(Generic genericArray) {
                        return this.isValid(genericArray) && genericArray.getComponentType().accept(this) != false;
                    }

                    @Override
                    public Boolean onWildcard(Generic wildcard) {
                        if (!this.isValid(wildcard)) {
                            return false;
                        }
                        TypeList.Generic lowerBounds = wildcard.getLowerBounds();
                        return ((Generic)(lowerBounds.isEmpty() ? wildcard.getUpperBounds() : lowerBounds).getOnly()).accept(this);
                    }

                    @Override
                    public Boolean onParameterizedType(Generic parameterizedType) {
                        if (!this.isValid(parameterizedType)) {
                            return false;
                        }
                        Generic ownerType = parameterizedType.getOwnerType();
                        if (ownerType != null && !ownerType.accept(this).booleanValue()) {
                            return false;
                        }
                        for (Generic typeArgument : parameterizedType.getTypeArguments()) {
                            if (typeArgument.accept(this).booleanValue()) continue;
                            return false;
                        }
                        return true;
                    }

                    @Override
                    public Boolean onTypeVariable(Generic typeVariable) {
                        return this.isValid(typeVariable);
                    }

                    @Override
                    public Boolean onNonGenericType(Generic typeDescription) {
                        return this.isValid(typeDescription) && (!typeDescription.isArray() || typeDescription.getComponentType().accept(this) != false);
                    }

                    private boolean isValid(Generic typeDescription) {
                        HashSet<TypeDescription> annotationTypes = new HashSet<TypeDescription>();
                        for (AnnotationDescription annotationDescription : typeDescription.getDeclaredAnnotations()) {
                            if (annotationDescription.getElementTypes().contains((Object)this.typeUse) && annotationTypes.add(annotationDescription.getAnnotationType())) continue;
                            return false;
                        }
                        return true;
                    }
                }
            }

            public static enum Assigner implements Visitor<Dispatcher>
            {
                INSTANCE;


                @Override
                public Dispatcher onGenericArray(Generic genericArray) {
                    return new Dispatcher.ForGenericArray(genericArray);
                }

                @Override
                public Dispatcher onWildcard(Generic wildcard) {
                    throw new IllegalArgumentException("A wildcard is not a first level type: " + this);
                }

                @Override
                public Dispatcher onParameterizedType(Generic parameterizedType) {
                    return new Dispatcher.ForParameterizedType(parameterizedType);
                }

                @Override
                public Dispatcher onTypeVariable(Generic typeVariable) {
                    return new Dispatcher.ForTypeVariable(typeVariable);
                }

                @Override
                public Dispatcher onNonGenericType(Generic typeDescription) {
                    return new Dispatcher.ForNonGenericType(typeDescription.asErasure());
                }

                public static interface Dispatcher {
                    public boolean isAssignableFrom(Generic var1);

                    public static class ForGenericArray
                    extends AbstractBase {
                        private final Generic genericArray;

                        protected ForGenericArray(Generic genericArray) {
                            this.genericArray = genericArray;
                        }

                        @Override
                        public Boolean onGenericArray(Generic genericArray) {
                            return this.genericArray.getComponentType().accept(INSTANCE).isAssignableFrom(genericArray.getComponentType());
                        }

                        @Override
                        public Boolean onWildcard(Generic wildcard) {
                            throw new IllegalArgumentException("A wildcard is not a first-level type: " + wildcard);
                        }

                        @Override
                        public Boolean onParameterizedType(Generic parameterizedType) {
                            return false;
                        }

                        @Override
                        public Boolean onTypeVariable(Generic typeVariable) {
                            return false;
                        }

                        @Override
                        public Boolean onNonGenericType(Generic typeDescription) {
                            return typeDescription.isArray() && this.genericArray.getComponentType().accept(INSTANCE).isAssignableFrom(typeDescription.getComponentType());
                        }

                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof ForGenericArray)) {
                                return false;
                            }
                            ForGenericArray other = (ForGenericArray)o;
                            if (!other.canEqual(this)) {
                                return false;
                            }
                            Generic this$genericArray = this.genericArray;
                            Generic other$genericArray = other.genericArray;
                            return !(this$genericArray == null ? other$genericArray != null : !this$genericArray.equals(other$genericArray));
                        }

                        protected boolean canEqual(Object other) {
                            return other instanceof ForGenericArray;
                        }

                        public int hashCode() {
                            int PRIME = 59;
                            int result = 1;
                            Generic $genericArray = this.genericArray;
                            result = result * 59 + ($genericArray == null ? 43 : $genericArray.hashCode());
                            return result;
                        }
                    }

                    public static class ForParameterizedType
                    extends AbstractBase {
                        private final Generic parameterizedType;

                        protected ForParameterizedType(Generic parameterizedType) {
                            this.parameterizedType = parameterizedType;
                        }

                        @Override
                        public Boolean onGenericArray(Generic genericArray) {
                            return false;
                        }

                        @Override
                        public Boolean onWildcard(Generic wildcard) {
                            throw new IllegalArgumentException("A wildcard is not a first-level type: " + wildcard);
                        }

                        @Override
                        public Boolean onParameterizedType(Generic parameterizedType) {
                            if (this.parameterizedType.asErasure().equals(parameterizedType.asErasure())) {
                                Generic fromOwner = this.parameterizedType.getOwnerType();
                                Generic toOwner = parameterizedType.getOwnerType();
                                if (fromOwner != null && toOwner != null && !fromOwner.accept(INSTANCE).isAssignableFrom(toOwner)) {
                                    return false;
                                }
                                TypeList.Generic fromArguments = this.parameterizedType.getTypeArguments();
                                TypeList.Generic toArguments = parameterizedType.getTypeArguments();
                                if (fromArguments.size() == toArguments.size()) {
                                    for (int index = 0; index < fromArguments.size(); ++index) {
                                        if (((Generic)fromArguments.get(index)).accept(ParameterAssigner.INSTANCE).isAssignableFrom((Generic)toArguments.get(index))) continue;
                                        return false;
                                    }
                                    return true;
                                }
                                throw new IllegalArgumentException("Incompatible generic types: " + parameterizedType + " and " + this.parameterizedType);
                            }
                            Generic superClass = parameterizedType.getSuperClass();
                            if (superClass != null && this.isAssignableFrom(superClass)) {
                                return true;
                            }
                            for (Generic interfaceType : parameterizedType.getInterfaces()) {
                                if (!this.isAssignableFrom(interfaceType)) continue;
                                return true;
                            }
                            return false;
                        }

                        @Override
                        public Boolean onTypeVariable(Generic typeVariable) {
                            for (Generic upperBound : typeVariable.getUpperBounds()) {
                                if (!this.isAssignableFrom(upperBound)) continue;
                                return true;
                            }
                            return false;
                        }

                        @Override
                        public Boolean onNonGenericType(Generic typeDescription) {
                            if (this.parameterizedType.asErasure().equals(typeDescription.asErasure())) {
                                return true;
                            }
                            Generic superClass = typeDescription.getSuperClass();
                            if (superClass != null && this.isAssignableFrom(superClass)) {
                                return true;
                            }
                            for (Generic interfaceType : typeDescription.getInterfaces()) {
                                if (!this.isAssignableFrom(interfaceType)) continue;
                                return true;
                            }
                            return false;
                        }

                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof ForParameterizedType)) {
                                return false;
                            }
                            ForParameterizedType other = (ForParameterizedType)o;
                            if (!other.canEqual(this)) {
                                return false;
                            }
                            Generic this$parameterizedType = this.parameterizedType;
                            Generic other$parameterizedType = other.parameterizedType;
                            return !(this$parameterizedType == null ? other$parameterizedType != null : !this$parameterizedType.equals(other$parameterizedType));
                        }

                        protected boolean canEqual(Object other) {
                            return other instanceof ForParameterizedType;
                        }

                        public int hashCode() {
                            int PRIME = 59;
                            int result = 1;
                            Generic $parameterizedType = this.parameterizedType;
                            result = result * 59 + ($parameterizedType == null ? 43 : $parameterizedType.hashCode());
                            return result;
                        }

                        protected static enum ParameterAssigner implements Visitor<Dispatcher>
                        {
                            INSTANCE;


                            @Override
                            public Dispatcher onGenericArray(Generic genericArray) {
                                return new InvariantBinding(genericArray);
                            }

                            @Override
                            public Dispatcher onWildcard(Generic wildcard) {
                                TypeList.Generic lowerBounds = wildcard.getLowerBounds();
                                return lowerBounds.isEmpty() ? new CovariantBinding((Generic)wildcard.getUpperBounds().getOnly()) : new ContravariantBinding((Generic)lowerBounds.getOnly());
                            }

                            @Override
                            public Dispatcher onParameterizedType(Generic parameterizedType) {
                                return new InvariantBinding(parameterizedType);
                            }

                            @Override
                            public Dispatcher onTypeVariable(Generic typeVariable) {
                                return new InvariantBinding(typeVariable);
                            }

                            @Override
                            public Dispatcher onNonGenericType(Generic typeDescription) {
                                return new InvariantBinding(typeDescription);
                            }

                            protected static class ContravariantBinding
                            implements Dispatcher {
                                private final Generic lowerBound;

                                protected ContravariantBinding(Generic lowerBound) {
                                    this.lowerBound = lowerBound;
                                }

                                @Override
                                public boolean isAssignableFrom(Generic typeDescription) {
                                    if (typeDescription.getSort().isWildcard()) {
                                        TypeList.Generic lowerBounds = typeDescription.getLowerBounds();
                                        return !lowerBounds.isEmpty() && ((Generic)lowerBounds.getOnly()).accept(Assigner.INSTANCE).isAssignableFrom(this.lowerBound);
                                    }
                                    return typeDescription.getSort().isWildcard() || typeDescription.accept(Assigner.INSTANCE).isAssignableFrom(this.lowerBound);
                                }

                                public boolean equals(Object o) {
                                    if (o == this) {
                                        return true;
                                    }
                                    if (!(o instanceof ContravariantBinding)) {
                                        return false;
                                    }
                                    ContravariantBinding other = (ContravariantBinding)o;
                                    if (!other.canEqual(this)) {
                                        return false;
                                    }
                                    Generic this$lowerBound = this.lowerBound;
                                    Generic other$lowerBound = other.lowerBound;
                                    return !(this$lowerBound == null ? other$lowerBound != null : !this$lowerBound.equals(other$lowerBound));
                                }

                                protected boolean canEqual(Object other) {
                                    return other instanceof ContravariantBinding;
                                }

                                public int hashCode() {
                                    int PRIME = 59;
                                    int result = 1;
                                    Generic $lowerBound = this.lowerBound;
                                    result = result * 59 + ($lowerBound == null ? 43 : $lowerBound.hashCode());
                                    return result;
                                }
                            }

                            protected static class CovariantBinding
                            implements Dispatcher {
                                private final Generic upperBound;

                                protected CovariantBinding(Generic upperBound) {
                                    this.upperBound = upperBound;
                                }

                                @Override
                                public boolean isAssignableFrom(Generic typeDescription) {
                                    if (typeDescription.getSort().isWildcard()) {
                                        return typeDescription.getLowerBounds().isEmpty() && this.upperBound.accept(Assigner.INSTANCE).isAssignableFrom((Generic)typeDescription.getUpperBounds().getOnly());
                                    }
                                    return this.upperBound.accept(Assigner.INSTANCE).isAssignableFrom(typeDescription);
                                }

                                public boolean equals(Object o) {
                                    if (o == this) {
                                        return true;
                                    }
                                    if (!(o instanceof CovariantBinding)) {
                                        return false;
                                    }
                                    CovariantBinding other = (CovariantBinding)o;
                                    if (!other.canEqual(this)) {
                                        return false;
                                    }
                                    Generic this$upperBound = this.upperBound;
                                    Generic other$upperBound = other.upperBound;
                                    return !(this$upperBound == null ? other$upperBound != null : !this$upperBound.equals(other$upperBound));
                                }

                                protected boolean canEqual(Object other) {
                                    return other instanceof CovariantBinding;
                                }

                                public int hashCode() {
                                    int PRIME = 59;
                                    int result = 1;
                                    Generic $upperBound = this.upperBound;
                                    result = result * 59 + ($upperBound == null ? 43 : $upperBound.hashCode());
                                    return result;
                                }
                            }

                            protected static class InvariantBinding
                            implements Dispatcher {
                                private final Generic typeDescription;

                                protected InvariantBinding(Generic typeDescription) {
                                    this.typeDescription = typeDescription;
                                }

                                @Override
                                public boolean isAssignableFrom(Generic typeDescription) {
                                    return typeDescription.equals(this.typeDescription);
                                }

                                public boolean equals(Object o) {
                                    if (o == this) {
                                        return true;
                                    }
                                    if (!(o instanceof InvariantBinding)) {
                                        return false;
                                    }
                                    InvariantBinding other = (InvariantBinding)o;
                                    if (!other.canEqual(this)) {
                                        return false;
                                    }
                                    Generic this$typeDescription = this.typeDescription;
                                    Generic other$typeDescription = other.typeDescription;
                                    return !(this$typeDescription == null ? other$typeDescription != null : !this$typeDescription.equals(other$typeDescription));
                                }

                                protected boolean canEqual(Object other) {
                                    return other instanceof InvariantBinding;
                                }

                                public int hashCode() {
                                    int PRIME = 59;
                                    int result = 1;
                                    Generic $typeDescription = this.typeDescription;
                                    result = result * 59 + ($typeDescription == null ? 43 : $typeDescription.hashCode());
                                    return result;
                                }
                            }
                        }
                    }

                    public static class ForTypeVariable
                    extends AbstractBase {
                        private final Generic typeVariable;

                        protected ForTypeVariable(Generic typeVariable) {
                            this.typeVariable = typeVariable;
                        }

                        @Override
                        public Boolean onGenericArray(Generic genericArray) {
                            return false;
                        }

                        @Override
                        public Boolean onWildcard(Generic wildcard) {
                            throw new IllegalArgumentException("A wildcard is not a first-level type: " + wildcard);
                        }

                        @Override
                        public Boolean onParameterizedType(Generic parameterizedType) {
                            return false;
                        }

                        @Override
                        public Boolean onTypeVariable(Generic typeVariable) {
                            if (typeVariable.equals(this.typeVariable)) {
                                return true;
                            }
                            for (Generic upperBound : typeVariable.getUpperBounds()) {
                                if (!this.isAssignableFrom(upperBound)) continue;
                                return true;
                            }
                            return false;
                        }

                        @Override
                        public Boolean onNonGenericType(Generic typeDescription) {
                            return false;
                        }

                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof ForTypeVariable)) {
                                return false;
                            }
                            ForTypeVariable other = (ForTypeVariable)o;
                            if (!other.canEqual(this)) {
                                return false;
                            }
                            Generic this$typeVariable = this.typeVariable;
                            Generic other$typeVariable = other.typeVariable;
                            return !(this$typeVariable == null ? other$typeVariable != null : !this$typeVariable.equals(other$typeVariable));
                        }

                        protected boolean canEqual(Object other) {
                            return other instanceof ForTypeVariable;
                        }

                        public int hashCode() {
                            int PRIME = 59;
                            int result = 1;
                            Generic $typeVariable = this.typeVariable;
                            result = result * 59 + ($typeVariable == null ? 43 : $typeVariable.hashCode());
                            return result;
                        }
                    }

                    public static class ForNonGenericType
                    extends AbstractBase {
                        private final TypeDescription typeDescription;

                        protected ForNonGenericType(TypeDescription typeDescription) {
                            this.typeDescription = typeDescription;
                        }

                        @Override
                        public Boolean onGenericArray(Generic genericArray) {
                            return this.typeDescription.isArray() ? genericArray.getComponentType().accept(new ForNonGenericType(this.typeDescription.getComponentType())) : this.typeDescription.represents((Type)((Object)Object.class)) || ARRAY_INTERFACES.contains(this.typeDescription.asGenericType());
                        }

                        @Override
                        public Boolean onWildcard(Generic wildcard) {
                            throw new IllegalArgumentException("A wildcard is not a first-level type: " + wildcard);
                        }

                        @Override
                        public Boolean onParameterizedType(Generic parameterizedType) {
                            if (this.typeDescription.equals(parameterizedType.asErasure())) {
                                return true;
                            }
                            Generic superClass = parameterizedType.getSuperClass();
                            if (superClass != null && this.isAssignableFrom(superClass)) {
                                return true;
                            }
                            for (Generic interfaceType : parameterizedType.getInterfaces()) {
                                if (!this.isAssignableFrom(interfaceType)) continue;
                                return true;
                            }
                            return this.typeDescription.represents((Type)((Object)Object.class));
                        }

                        @Override
                        public Boolean onTypeVariable(Generic typeVariable) {
                            for (Generic upperBound : typeVariable.getUpperBounds()) {
                                if (!this.isAssignableFrom(upperBound)) continue;
                                return true;
                            }
                            return false;
                        }

                        @Override
                        public Boolean onNonGenericType(Generic typeDescription) {
                            return this.typeDescription.isAssignableFrom(typeDescription.asErasure());
                        }

                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof ForNonGenericType)) {
                                return false;
                            }
                            ForNonGenericType other = (ForNonGenericType)o;
                            if (!other.canEqual(this)) {
                                return false;
                            }
                            TypeDescription this$typeDescription = this.typeDescription;
                            TypeDescription other$typeDescription = other.typeDescription;
                            return !(this$typeDescription == null ? other$typeDescription != null : !this$typeDescription.equals(other$typeDescription));
                        }

                        protected boolean canEqual(Object other) {
                            return other instanceof ForNonGenericType;
                        }

                        public int hashCode() {
                            int PRIME = 59;
                            int result = 1;
                            TypeDescription $typeDescription = this.typeDescription;
                            result = result * 59 + ($typeDescription == null ? 43 : $typeDescription.hashCode());
                            return result;
                        }
                    }

                    public static abstract class AbstractBase
                    implements Dispatcher,
                    Visitor<Boolean> {
                        @Override
                        public boolean isAssignableFrom(Generic typeDescription) {
                            return typeDescription.accept(this);
                        }
                    }
                }
            }

            public static enum AnnotationStripper implements Visitor<Generic>
            {
                INSTANCE;


                @Override
                public Generic onGenericArray(Generic genericArray) {
                    return new OfGenericArray.Latent(genericArray.getComponentType().accept(this), AnnotationSource.Empty.INSTANCE);
                }

                @Override
                public Generic onWildcard(Generic wildcard) {
                    return new OfWildcardType.Latent(wildcard.getUpperBounds().accept(this), wildcard.getLowerBounds().accept(this), AnnotationSource.Empty.INSTANCE);
                }

                @Override
                public Generic onParameterizedType(Generic parameterizedType) {
                    Generic ownerType = parameterizedType.getOwnerType();
                    return new OfParameterizedType.Latent(parameterizedType.asErasure(), ownerType == null ? UNDEFINED : ownerType.accept(this), parameterizedType.getTypeArguments().accept(this), AnnotationSource.Empty.INSTANCE);
                }

                @Override
                public Generic onTypeVariable(Generic typeVariable) {
                    return new NonAnnotatedTypeVariable(typeVariable);
                }

                @Override
                public Generic onNonGenericType(Generic typeDescription) {
                    return typeDescription.isArray() ? new OfGenericArray.Latent(this.onNonGenericType(typeDescription.getComponentType()), AnnotationSource.Empty.INSTANCE) : new OfNonGenericType.Latent(typeDescription.asErasure(), AnnotationSource.Empty.INSTANCE);
                }

                protected static class NonAnnotatedTypeVariable
                extends OfTypeVariable {
                    private final Generic typeVariable;

                    protected NonAnnotatedTypeVariable(Generic typeVariable) {
                        this.typeVariable = typeVariable;
                    }

                    @Override
                    public TypeList.Generic getUpperBounds() {
                        return this.typeVariable.getUpperBounds();
                    }

                    @Override
                    public TypeVariableSource getTypeVariableSource() {
                        return this.typeVariable.getTypeVariableSource();
                    }

                    @Override
                    public String getSymbol() {
                        return this.typeVariable.getSymbol();
                    }

                    @Override
                    public AnnotationList getDeclaredAnnotations() {
                        return new AnnotationList.Empty();
                    }
                }
            }

            public static enum TypeErasing implements Visitor<Generic>
            {
                INSTANCE;


                @Override
                public Generic onGenericArray(Generic genericArray) {
                    return genericArray.asRawType();
                }

                @Override
                public Generic onWildcard(Generic wildcard) {
                    throw new IllegalArgumentException("Cannot erase a wildcard type: " + wildcard);
                }

                @Override
                public Generic onParameterizedType(Generic parameterizedType) {
                    return parameterizedType.asRawType();
                }

                @Override
                public Generic onTypeVariable(Generic typeVariable) {
                    return typeVariable.asRawType();
                }

                @Override
                public Generic onNonGenericType(Generic typeDescription) {
                    return typeDescription.asRawType();
                }
            }

            public static enum NoOp implements Visitor<Generic>
            {
                INSTANCE;


                @Override
                public Generic onGenericArray(Generic genericArray) {
                    return genericArray;
                }

                @Override
                public Generic onWildcard(Generic wildcard) {
                    return wildcard;
                }

                @Override
                public Generic onParameterizedType(Generic parameterizedType) {
                    return parameterizedType;
                }

                @Override
                public Generic onTypeVariable(Generic typeVariable) {
                    return typeVariable;
                }

                @Override
                public Generic onNonGenericType(Generic typeDescription) {
                    return typeDescription;
                }
            }
        }
    }
}

