/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation;

import java.lang.reflect.Field;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.scaffold.FieldLocator;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import org.objectweb.asm.MethodVisitor;

public abstract class FieldAccessor
implements Implementation {
    protected final FieldLocation fieldLocation;
    protected final Assigner assigner;
    protected final Assigner.Typing typing;

    protected FieldAccessor(FieldLocation fieldLocation, Assigner assigner, Assigner.Typing typing) {
        this.fieldLocation = fieldLocation;
        this.assigner = assigner;
        this.typing = typing;
    }

    public static OwnerTypeLocatable ofField(String name) {
        return FieldAccessor.of(new FieldNameExtractor.ForFixedValue(name));
    }

    public static OwnerTypeLocatable ofBeanProperty() {
        return FieldAccessor.of(FieldNameExtractor.ForBeanProperty.INSTANCE);
    }

    public static OwnerTypeLocatable of(FieldNameExtractor fieldNameExtractor) {
        return new ForImplicitProperty(new FieldLocation.Relative(fieldNameExtractor));
    }

    public static AssignerConfigurable of(Field field) {
        return FieldAccessor.of(new FieldDescription.ForLoadedField(field));
    }

    public static AssignerConfigurable of(FieldDescription fieldDescription) {
        return new ForImplicitProperty(new FieldLocation.Absolute(fieldDescription));
    }

    protected StackManipulation getter(FieldDescription fieldDescription, MethodDescription instrumentedMethod) {
        return this.access(fieldDescription, instrumentedMethod, new StackManipulation.Compound(FieldAccess.forField(fieldDescription).read(), this.assigner.assign(fieldDescription.getType(), instrumentedMethod.getReturnType(), this.typing)));
    }

    protected StackManipulation setter(FieldDescription fieldDescription, ParameterDescription parameterDescription) {
        if (fieldDescription.isFinal() && parameterDescription.getDeclaringMethod().isMethod()) {
            throw new IllegalArgumentException("Cannot set final field " + fieldDescription + " from " + parameterDescription.getDeclaringMethod());
        }
        return this.access(fieldDescription, parameterDescription.getDeclaringMethod(), new StackManipulation.Compound(MethodVariableAccess.load(parameterDescription), this.assigner.assign(parameterDescription.getType(), fieldDescription.getType(), this.typing), FieldAccess.forField(fieldDescription).write()));
    }

    private StackManipulation access(FieldDescription fieldDescription, MethodDescription instrumentedMethod, StackManipulation fieldAccess) {
        if (!fieldAccess.isValid()) {
            throw new IllegalStateException("Incompatible type of " + fieldDescription + " and " + instrumentedMethod);
        }
        if (instrumentedMethod.isStatic() && !fieldDescription.isStatic()) {
            throw new IllegalArgumentException("Cannot call instance field " + fieldDescription + " from static method " + instrumentedMethod);
        }
        return new StackManipulation.Compound(fieldDescription.isStatic() ? StackManipulation.Trivial.INSTANCE : MethodVariableAccess.loadThis(), fieldAccess);
    }

    @Override
    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        return instrumentedType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FieldAccessor)) {
            return false;
        }
        FieldAccessor other = (FieldAccessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FieldLocation this$fieldLocation = this.fieldLocation;
        FieldLocation other$fieldLocation = other.fieldLocation;
        if (this$fieldLocation == null ? other$fieldLocation != null : !this$fieldLocation.equals(other$fieldLocation)) {
            return false;
        }
        Assigner this$assigner = this.assigner;
        Assigner other$assigner = other.assigner;
        if (this$assigner == null ? other$assigner != null : !this$assigner.equals(other$assigner)) {
            return false;
        }
        Assigner.Typing this$typing = this.typing;
        Assigner.Typing other$typing = other.typing;
        return !(this$typing == null ? other$typing != null : !((Object)((Object)this$typing)).equals((Object)other$typing));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FieldAccessor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FieldLocation $fieldLocation = this.fieldLocation;
        result = result * 59 + ($fieldLocation == null ? 43 : $fieldLocation.hashCode());
        Assigner $assigner = this.assigner;
        result = result * 59 + ($assigner == null ? 43 : $assigner.hashCode());
        Assigner.Typing $typing = this.typing;
        result = result * 59 + ($typing == null ? 43 : ((Object)((Object)$typing)).hashCode());
        return result;
    }

    protected static class ForParameterSetter
    extends FieldAccessor
    implements Implementation.Composable {
        private final int index;
        private final TerminationHandler terminationHandler;

        protected ForParameterSetter(FieldLocation fieldLocation, Assigner assigner, Assigner.Typing typing, int index) {
            this(fieldLocation, assigner, typing, index, TerminationHandler.RETURNING);
        }

        private ForParameterSetter(FieldLocation fieldLocation, Assigner assigner, Assigner.Typing typing, int index, TerminationHandler terminationHandler) {
            super(fieldLocation, assigner, typing);
            this.index = index;
            this.terminationHandler = terminationHandler;
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return new Appender(this.fieldLocation.prepare(implementationTarget.getInstrumentedType()));
        }

        @Override
        public Implementation andThen(Implementation implementation) {
            return new Implementation.Compound(new ForParameterSetter(this.fieldLocation, this.assigner, this.typing, this.index, TerminationHandler.NON_OPERATIONAL), implementation);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForParameterSetter)) {
                return false;
            }
            ForParameterSetter other = (ForParameterSetter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            if (this.index != other.index) {
                return false;
            }
            TerminationHandler this$terminationHandler = this.terminationHandler;
            TerminationHandler other$terminationHandler = other.terminationHandler;
            return !(this$terminationHandler == null ? other$terminationHandler != null : !((Object)((Object)this$terminationHandler)).equals((Object)other$terminationHandler));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ForParameterSetter;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            result = result * 59 + this.index;
            TerminationHandler $terminationHandler = this.terminationHandler;
            result = result * 59 + ($terminationHandler == null ? 43 : ((Object)((Object)$terminationHandler)).hashCode());
            return result;
        }

        protected class Appender
        implements ByteCodeAppender {
            private final FieldLocation.Prepared fieldLocation;

            protected Appender(FieldLocation.Prepared fieldLocation) {
                this.fieldLocation = fieldLocation;
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                if (instrumentedMethod.getParameters().size() <= ForParameterSetter.this.index) {
                    throw new IllegalStateException(instrumentedMethod + " does not define a parameter with index " + ForParameterSetter.this.index);
                }
                return new ByteCodeAppender.Size(new StackManipulation.Compound(ForParameterSetter.this.setter(this.fieldLocation.resolve(instrumentedMethod), (ParameterDescription)instrumentedMethod.getParameters().get(ForParameterSetter.this.index)), ForParameterSetter.this.terminationHandler.resolve(instrumentedMethod)).apply(methodVisitor, implementationContext).getMaximalSize(), instrumentedMethod.getStackSize());
            }

            private ForParameterSetter getOuter() {
                return ForParameterSetter.this;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                Appender appender = (Appender)object;
                return this.fieldLocation.equals(appender.fieldLocation) && ForParameterSetter.this.equals(appender.getOuter());
            }

            public int hashCode() {
                return this.fieldLocation.hashCode() + 31 * ForParameterSetter.this.hashCode();
            }
        }

        protected static enum TerminationHandler {
            RETURNING{

                @Override
                protected StackManipulation resolve(MethodDescription instrumentedMethod) {
                    if (!instrumentedMethod.getReturnType().represents(Void.TYPE)) {
                        throw new IllegalStateException("Cannot implement setter with return value for " + instrumentedMethod);
                    }
                    return MethodReturn.VOID;
                }
            }
            ,
            NON_OPERATIONAL{

                @Override
                protected StackManipulation resolve(MethodDescription instrumentedMethod) {
                    return StackManipulation.Trivial.INSTANCE;
                }
            };


            protected abstract StackManipulation resolve(MethodDescription var1);
        }
    }

    protected static class ForImplicitProperty
    extends FieldAccessor
    implements OwnerTypeLocatable {
        protected ForImplicitProperty(FieldLocation fieldLocation) {
            this(fieldLocation, Assigner.DEFAULT, Assigner.Typing.STATIC);
        }

        private ForImplicitProperty(FieldLocation fieldLocation, Assigner assigner, Assigner.Typing typing) {
            super(fieldLocation, assigner, typing);
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return new Appender(this.fieldLocation.prepare(implementationTarget.getInstrumentedType()));
        }

        @Override
        public Implementation.Composable setsArgumentAt(int index) {
            if (index < 0) {
                throw new IllegalArgumentException("A parameter index cannot be negative: " + index);
            }
            return new ForParameterSetter(this.fieldLocation, this.assigner, this.typing, index);
        }

        @Override
        public PropertyConfigurable withAssigner(Assigner assigner, Assigner.Typing typing) {
            return new ForImplicitProperty(this.fieldLocation, assigner, typing);
        }

        @Override
        public AssignerConfigurable in(Class<?> type) {
            return this.in(new TypeDescription.ForLoadedType(type));
        }

        @Override
        public AssignerConfigurable in(TypeDescription typeDescription) {
            return this.in(new FieldLocator.ForExactType.Factory(typeDescription));
        }

        @Override
        public AssignerConfigurable in(FieldLocator.Factory fieldLocatorFactory) {
            return new ForImplicitProperty(this.fieldLocation.with(fieldLocatorFactory), this.assigner, this.typing);
        }

        protected class Appender
        implements ByteCodeAppender {
            private final FieldLocation.Prepared fieldLocation;

            protected Appender(FieldLocation.Prepared fieldLocation) {
                this.fieldLocation = fieldLocation;
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                StackManipulation.Compound implementation;
                if (!instrumentedMethod.isMethod()) {
                    throw new IllegalArgumentException(instrumentedMethod + " does not describe a field getter or setter");
                }
                FieldDescription fieldDescription = this.fieldLocation.resolve(instrumentedMethod);
                if (!instrumentedMethod.getReturnType().represents(Void.TYPE)) {
                    implementation = new StackManipulation.Compound(ForImplicitProperty.this.getter(fieldDescription, instrumentedMethod), MethodReturn.of(instrumentedMethod.getReturnType()));
                } else if (instrumentedMethod.getReturnType().represents(Void.TYPE) && instrumentedMethod.getParameters().size() == 1) {
                    implementation = new StackManipulation.Compound(ForImplicitProperty.this.setter(fieldDescription, (ParameterDescription)instrumentedMethod.getParameters().get(0)), MethodReturn.VOID);
                } else {
                    throw new IllegalArgumentException("Method " + implementationContext + " is no bean property");
                }
                return new ByteCodeAppender.Size(implementation.apply(methodVisitor, implementationContext).getMaximalSize(), instrumentedMethod.getStackSize());
            }

            private ForImplicitProperty getOuter() {
                return ForImplicitProperty.this;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                Appender appender = (Appender)object;
                return this.fieldLocation.equals(appender.fieldLocation) && ForImplicitProperty.this.equals(appender.getOuter());
            }

            public int hashCode() {
                return this.fieldLocation.hashCode() + 31 * ForImplicitProperty.this.hashCode();
            }
        }
    }

    public static interface OwnerTypeLocatable
    extends AssignerConfigurable {
        public AssignerConfigurable in(Class<?> var1);

        public AssignerConfigurable in(TypeDescription var1);

        public AssignerConfigurable in(FieldLocator.Factory var1);
    }

    public static interface AssignerConfigurable
    extends PropertyConfigurable {
        public PropertyConfigurable withAssigner(Assigner var1, Assigner.Typing var2);
    }

    public static interface PropertyConfigurable
    extends Implementation {
        public Implementation.Composable setsArgumentAt(int var1);
    }

    public static interface FieldNameExtractor {
        public String resolve(MethodDescription var1);

        public static class ForFixedValue
        implements FieldNameExtractor {
            private final String name;

            protected ForFixedValue(String name) {
                this.name = name;
            }

            @Override
            public String resolve(MethodDescription methodDescription) {
                return this.name;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForFixedValue)) {
                    return false;
                }
                ForFixedValue other = (ForFixedValue)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$name = this.name;
                String other$name = other.name;
                return !(this$name == null ? other$name != null : !this$name.equals(other$name));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForFixedValue;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $name = this.name;
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                return result;
            }
        }

        public static enum ForBeanProperty implements FieldNameExtractor
        {
            INSTANCE;


            @Override
            public String resolve(MethodDescription methodDescription) {
                int crop;
                String name = methodDescription.getInternalName();
                if (name.startsWith("get") || name.startsWith("set")) {
                    crop = 3;
                } else if (name.startsWith("is")) {
                    crop = 2;
                } else {
                    throw new IllegalArgumentException(methodDescription + " does not follow Java bean naming conventions");
                }
                name = name.substring(crop);
                if (name.length() == 0) {
                    throw new IllegalArgumentException(methodDescription + " does not specify a bean name");
                }
                return Character.toLowerCase(name.charAt(0)) + name.substring(1);
            }
        }
    }

    protected static interface FieldLocation {
        public FieldLocation with(FieldLocator.Factory var1);

        public Prepared prepare(TypeDescription var1);

        public static class Relative
        implements FieldLocation {
            private final FieldNameExtractor fieldNameExtractor;
            private final FieldLocator.Factory fieldLocatorFactory;

            protected Relative(FieldNameExtractor fieldNameExtractor) {
                this(fieldNameExtractor, FieldLocator.ForClassHierarchy.Factory.INSTANCE);
            }

            private Relative(FieldNameExtractor fieldNameExtractor, FieldLocator.Factory fieldLocatorFactory) {
                this.fieldNameExtractor = fieldNameExtractor;
                this.fieldLocatorFactory = fieldLocatorFactory;
            }

            @Override
            public FieldLocation with(FieldLocator.Factory fieldLocatorFactory) {
                return new Relative(this.fieldNameExtractor, fieldLocatorFactory);
            }

            @Override
            public net.bytebuddy.implementation.FieldAccessor$FieldLocation$Prepared prepare(TypeDescription instrumentedType) {
                return new Prepared(this.fieldNameExtractor, this.fieldLocatorFactory.make(instrumentedType));
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Relative)) {
                    return false;
                }
                Relative other = (Relative)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                FieldNameExtractor this$fieldNameExtractor = this.fieldNameExtractor;
                FieldNameExtractor other$fieldNameExtractor = other.fieldNameExtractor;
                if (this$fieldNameExtractor == null ? other$fieldNameExtractor != null : !this$fieldNameExtractor.equals(other$fieldNameExtractor)) {
                    return false;
                }
                FieldLocator.Factory this$fieldLocatorFactory = this.fieldLocatorFactory;
                FieldLocator.Factory other$fieldLocatorFactory = other.fieldLocatorFactory;
                return !(this$fieldLocatorFactory == null ? other$fieldLocatorFactory != null : !this$fieldLocatorFactory.equals(other$fieldLocatorFactory));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Relative;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                FieldNameExtractor $fieldNameExtractor = this.fieldNameExtractor;
                result = result * 59 + ($fieldNameExtractor == null ? 43 : $fieldNameExtractor.hashCode());
                FieldLocator.Factory $fieldLocatorFactory = this.fieldLocatorFactory;
                result = result * 59 + ($fieldLocatorFactory == null ? 43 : $fieldLocatorFactory.hashCode());
                return result;
            }

            protected static class Prepared
            implements net.bytebuddy.implementation.FieldAccessor$FieldLocation$Prepared {
                private final FieldNameExtractor fieldNameExtractor;
                private final FieldLocator fieldLocator;

                protected Prepared(FieldNameExtractor fieldNameExtractor, FieldLocator fieldLocator) {
                    this.fieldNameExtractor = fieldNameExtractor;
                    this.fieldLocator = fieldLocator;
                }

                @Override
                public FieldDescription resolve(MethodDescription instrumentedMethod) {
                    FieldLocator.Resolution resolution = this.fieldLocator.locate(this.fieldNameExtractor.resolve(instrumentedMethod));
                    if (!resolution.isResolved()) {
                        throw new IllegalStateException("Cannot resolve field for " + instrumentedMethod + " using " + this.fieldLocator);
                    }
                    return resolution.getField();
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Prepared)) {
                        return false;
                    }
                    Prepared other = (Prepared)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    FieldNameExtractor this$fieldNameExtractor = this.fieldNameExtractor;
                    FieldNameExtractor other$fieldNameExtractor = other.fieldNameExtractor;
                    if (this$fieldNameExtractor == null ? other$fieldNameExtractor != null : !this$fieldNameExtractor.equals(other$fieldNameExtractor)) {
                        return false;
                    }
                    FieldLocator this$fieldLocator = this.fieldLocator;
                    FieldLocator other$fieldLocator = other.fieldLocator;
                    return !(this$fieldLocator == null ? other$fieldLocator != null : !this$fieldLocator.equals(other$fieldLocator));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof Prepared;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    FieldNameExtractor $fieldNameExtractor = this.fieldNameExtractor;
                    result = result * 59 + ($fieldNameExtractor == null ? 43 : $fieldNameExtractor.hashCode());
                    FieldLocator $fieldLocator = this.fieldLocator;
                    result = result * 59 + ($fieldLocator == null ? 43 : $fieldLocator.hashCode());
                    return result;
                }
            }
        }

        public static class Absolute
        implements FieldLocation,
        Prepared {
            private final FieldDescription fieldDescription;

            protected Absolute(FieldDescription fieldDescription) {
                this.fieldDescription = fieldDescription;
            }

            @Override
            public FieldLocation with(FieldLocator.Factory fieldLocatorFactory) {
                throw new IllegalStateException("Cannot specify a field locator factory for an absolute field location");
            }

            @Override
            public Prepared prepare(TypeDescription instrumentedType) {
                if (!instrumentedType.isAssignableTo(this.fieldDescription.getDeclaringType().asErasure())) {
                    throw new IllegalStateException(this.fieldDescription + " is not declared by " + instrumentedType);
                }
                if (!this.fieldDescription.isVisibleTo(instrumentedType)) {
                    throw new IllegalStateException("Cannot access " + this.fieldDescription + " from " + instrumentedType);
                }
                return this;
            }

            @Override
            public FieldDescription resolve(MethodDescription instrumentedMethod) {
                return this.fieldDescription;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Absolute)) {
                    return false;
                }
                Absolute other = (Absolute)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                FieldDescription this$fieldDescription = this.fieldDescription;
                FieldDescription other$fieldDescription = other.fieldDescription;
                return !(this$fieldDescription == null ? other$fieldDescription != null : !this$fieldDescription.equals(other$fieldDescription));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Absolute;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                FieldDescription $fieldDescription = this.fieldDescription;
                result = result * 59 + ($fieldDescription == null ? 43 : $fieldDescription.hashCode());
                return result;
            }
        }

        public static interface Prepared {
            public FieldDescription resolve(MethodDescription var1);
        }
    }
}

