/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import net.bytebuddy.description.enumeration.EnumerationDescription;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.method.ParameterList;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.scaffold.FieldLocator;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.dynamic.scaffold.MethodGraph;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.LoadedTypeInitializer;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.Duplication;
import net.bytebuddy.implementation.bytecode.Removal;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.TypeCreation;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.collection.ArrayAccess;
import net.bytebuddy.implementation.bytecode.collection.ArrayFactory;
import net.bytebuddy.implementation.bytecode.constant.ClassConstant;
import net.bytebuddy.implementation.bytecode.constant.DoubleConstant;
import net.bytebuddy.implementation.bytecode.constant.FloatConstant;
import net.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import net.bytebuddy.implementation.bytecode.constant.LongConstant;
import net.bytebuddy.implementation.bytecode.constant.NullConstant;
import net.bytebuddy.implementation.bytecode.constant.TextConstant;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.CompoundList;
import net.bytebuddy.utility.JavaConstant;
import net.bytebuddy.utility.JavaType;
import net.bytebuddy.utility.RandomString;
import org.objectweb.asm.MethodVisitor;

public class MethodCall
implements Implementation.Composable {
    protected final MethodLocator methodLocator;
    protected final TargetHandler targetHandler;
    protected final List<ArgumentLoader.Factory> argumentLoaders;
    protected final MethodInvoker methodInvoker;
    protected final TerminationHandler terminationHandler;
    protected final Assigner assigner;
    protected final Assigner.Typing typing;

    protected MethodCall(MethodLocator methodLocator, TargetHandler targetHandler, List<ArgumentLoader.Factory> argumentLoaders, MethodInvoker methodInvoker, TerminationHandler terminationHandler, Assigner assigner, Assigner.Typing typing) {
        this.methodLocator = methodLocator;
        this.targetHandler = targetHandler;
        this.argumentLoaders = argumentLoaders;
        this.methodInvoker = methodInvoker;
        this.terminationHandler = terminationHandler;
        this.assigner = assigner;
        this.typing = typing;
    }

    public static WithoutSpecifiedTarget invoke(Method method) {
        return MethodCall.invoke(new MethodDescription.ForLoadedMethod(method));
    }

    public static WithoutSpecifiedTarget invoke(Constructor<?> constructor) {
        return MethodCall.invoke(new MethodDescription.ForLoadedConstructor(constructor));
    }

    public static WithoutSpecifiedTarget invoke(MethodDescription methodDescription) {
        return MethodCall.invoke(new MethodLocator.ForExplicitMethod(methodDescription));
    }

    public static WithoutSpecifiedTarget invoke(ElementMatcher<? super MethodDescription> matcher) {
        return MethodCall.invoke(matcher, MethodGraph.Compiler.DEFAULT);
    }

    public static WithoutSpecifiedTarget invoke(ElementMatcher<? super MethodDescription> matcher, MethodGraph.Compiler methodGraphCompiler) {
        return MethodCall.invoke(new MethodLocator.ForElementMatcher(matcher, methodGraphCompiler));
    }

    public static WithoutSpecifiedTarget invoke(MethodLocator methodLocator) {
        return new WithoutSpecifiedTarget(methodLocator);
    }

    public static WithoutSpecifiedTarget invokeSelf() {
        return new WithoutSpecifiedTarget(MethodLocator.ForInstrumentedMethod.INSTANCE);
    }

    public static MethodCall invokeSuper() {
        return MethodCall.invokeSelf().onSuper();
    }

    public static Implementation.Composable call(Callable<?> callable) {
        try {
            return MethodCall.invoke(Callable.class.getMethod("call", new Class[0])).on(callable, Callable.class).withAssigner(Assigner.DEFAULT, Assigner.Typing.DYNAMIC);
        }
        catch (NoSuchMethodException exception) {
            throw new IllegalStateException("Could not locate Callable::call method", exception);
        }
    }

    public static Implementation.Composable run(Runnable runnable) {
        try {
            return MethodCall.invoke(Runnable.class.getMethod("run", new Class[0])).on(runnable, Runnable.class).withAssigner(Assigner.DEFAULT, Assigner.Typing.DYNAMIC);
        }
        catch (NoSuchMethodException exception) {
            throw new IllegalStateException("Could not locate Runnable::run method", exception);
        }
    }

    public static MethodCall construct(Constructor<?> constructor) {
        return MethodCall.construct(new MethodDescription.ForLoadedConstructor(constructor));
    }

    public static MethodCall construct(MethodDescription methodDescription) {
        if (!methodDescription.isConstructor()) {
            throw new IllegalArgumentException("Not a constructor: " + methodDescription);
        }
        return new MethodCall(new MethodLocator.ForExplicitMethod(methodDescription), TargetHandler.ForConstructingInvocation.INSTANCE, Collections.<ArgumentLoader.Factory>emptyList(), MethodInvoker.ForContextualInvocation.INSTANCE, TerminationHandler.RETURNING, Assigner.DEFAULT, Assigner.Typing.STATIC);
    }

    public MethodCall with(Object ... argument) {
        ArrayList<ArgumentLoader.Factory> argumentLoaders = new ArrayList<ArgumentLoader.Factory>(argument.length);
        for (Object anArgument : argument) {
            argumentLoaders.add(ArgumentLoader.ForStackManipulation.of(anArgument));
        }
        return this.with(argumentLoaders);
    }

    public MethodCall with(TypeDescription ... typeDescription) {
        ArrayList<ArgumentLoader.ForStackManipulation> argumentLoaders = new ArrayList<ArgumentLoader.ForStackManipulation>(typeDescription.length);
        for (TypeDescription aTypeDescription : typeDescription) {
            argumentLoaders.add(new ArgumentLoader.ForStackManipulation(ClassConstant.of(aTypeDescription), (Type)((Object)Class.class)));
        }
        return this.with(argumentLoaders);
    }

    public MethodCall with(EnumerationDescription ... enumerationDescription) {
        ArrayList<ArgumentLoader.ForStackManipulation> argumentLoaders = new ArrayList<ArgumentLoader.ForStackManipulation>(enumerationDescription.length);
        for (EnumerationDescription anEnumerationDescription : enumerationDescription) {
            argumentLoaders.add(new ArgumentLoader.ForStackManipulation(FieldAccess.forEnumeration(anEnumerationDescription), anEnumerationDescription.getEnumerationType()));
        }
        return this.with(argumentLoaders);
    }

    public MethodCall with(JavaConstant ... javaConstant) {
        ArrayList<ArgumentLoader.ForStackManipulation> argumentLoaders = new ArrayList<ArgumentLoader.ForStackManipulation>(javaConstant.length);
        for (JavaConstant aJavaConstant : javaConstant) {
            argumentLoaders.add(new ArgumentLoader.ForStackManipulation(aJavaConstant.asStackManipulation(), aJavaConstant.getType()));
        }
        return this.with(argumentLoaders);
    }

    public MethodCall withReference(Object ... argument) {
        ArrayList<ArgumentLoader.ForNullConstant> argumentLoaders = new ArrayList<ArgumentLoader.ForNullConstant>(argument.length);
        for (Object anArgument : argument) {
            argumentLoaders.add((ArgumentLoader.ForNullConstant)(anArgument == null ? ArgumentLoader.ForNullConstant.INSTANCE : new ArgumentLoader.ForInstance.Factory(anArgument)));
        }
        return this.with(argumentLoaders);
    }

    public MethodCall withArgument(int ... index) {
        ArrayList<ArgumentLoader.ForMethodParameter.Factory> argumentLoaders = new ArrayList<ArgumentLoader.ForMethodParameter.Factory>(index.length);
        for (int anIndex : index) {
            if (anIndex < 0) {
                throw new IllegalArgumentException("Negative index: " + anIndex);
            }
            argumentLoaders.add(new ArgumentLoader.ForMethodParameter.Factory(anIndex));
        }
        return this.with(argumentLoaders);
    }

    public MethodCall withAllArguments() {
        return this.with(ArgumentLoader.ForMethodParameter.OfInstrumentedMethod.INSTANCE);
    }

    public MethodCall withArgumentArray() {
        return this.with(ArgumentLoader.ForMethodParameterArray.ForInstrumentedMethod.INSTANCE);
    }

    public MethodCall withArgumentArrayElements(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("A parameter index cannot be negative: " + index);
        }
        return this.with(new ArgumentLoader.ForMethodParameterArrayElement.OfInvokedMethod(index));
    }

    public MethodCall withArgumentArrayElements(int index, int size) {
        return this.withArgumentArrayElements(index, 0, size);
    }

    public MethodCall withArgumentArrayElements(int index, int start, int size) {
        if (index < 0) {
            throw new IllegalArgumentException("A parameter index cannot be negative: " + index);
        }
        if (start < 0) {
            throw new IllegalArgumentException("An array index cannot be negative: " + start);
        }
        if (size == 0) {
            return this;
        }
        if (size < 0) {
            throw new IllegalArgumentException("Size cannot be negative: " + size);
        }
        ArrayList<ArgumentLoader.ForMethodParameterArrayElement.OfParameter> argumentLoaders = new ArrayList<ArgumentLoader.ForMethodParameterArrayElement.OfParameter>(size);
        for (int position = 0; position < size; ++position) {
            argumentLoaders.add(new ArgumentLoader.ForMethodParameterArrayElement.OfParameter(index, start + position));
        }
        return this.with(argumentLoaders);
    }

    public MethodCall withThis() {
        return this.with(ArgumentLoader.ForThisReference.Factory.INSTANCE);
    }

    public MethodCall withOwnType() {
        return this.with(ArgumentLoader.ForInstrumentedType.Factory.INSTANCE);
    }

    public MethodCall withField(String ... name) {
        return this.withField(FieldLocator.ForClassHierarchy.Factory.INSTANCE, name);
    }

    public MethodCall withField(FieldLocator.Factory fieldLocatorFactory, String ... name) {
        ArrayList<ArgumentLoader.ForField.Factory> argumentLoaders = new ArrayList<ArgumentLoader.ForField.Factory>(name.length);
        for (String aName : name) {
            argumentLoaders.add(new ArgumentLoader.ForField.Factory(aName, fieldLocatorFactory));
        }
        return this.with(argumentLoaders);
    }

    public MethodCall with(StackManipulation stackManipulation, Type type) {
        return this.with(stackManipulation, TypeDefinition.Sort.describe(type));
    }

    public MethodCall with(StackManipulation stackManipulation, TypeDefinition typeDefinition) {
        return this.with(new ArgumentLoader.ForStackManipulation(stackManipulation, typeDefinition));
    }

    public MethodCall with(ArgumentLoader.Factory ... argumentLoader) {
        return this.with(Arrays.asList(argumentLoader));
    }

    public MethodCall with(List<? extends ArgumentLoader.Factory> argumentLoaders) {
        return new MethodCall(this.methodLocator, this.targetHandler, CompoundList.of(this.argumentLoaders, argumentLoaders), this.methodInvoker, this.terminationHandler, this.assigner, this.typing);
    }

    public Implementation.Composable withAssigner(Assigner assigner, Assigner.Typing typing) {
        return new MethodCall(this.methodLocator, this.targetHandler, this.argumentLoaders, this.methodInvoker, this.terminationHandler, assigner, typing);
    }

    @Override
    public Implementation andThen(Implementation implementation) {
        return new Implementation.Compound(new MethodCall(this.methodLocator, this.targetHandler, this.argumentLoaders, this.methodInvoker, TerminationHandler.DROPPING, this.assigner, this.typing), implementation);
    }

    @Override
    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        for (ArgumentLoader.Factory argumentLoader : this.argumentLoaders) {
            instrumentedType = argumentLoader.prepare(instrumentedType);
        }
        return this.targetHandler.prepare(instrumentedType);
    }

    @Override
    public ByteCodeAppender appender(Implementation.Target implementationTarget) {
        return new Appender(implementationTarget);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodCall)) {
            return false;
        }
        MethodCall other = (MethodCall)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MethodLocator this$methodLocator = this.methodLocator;
        MethodLocator other$methodLocator = other.methodLocator;
        if (this$methodLocator == null ? other$methodLocator != null : !this$methodLocator.equals(other$methodLocator)) {
            return false;
        }
        TargetHandler this$targetHandler = this.targetHandler;
        TargetHandler other$targetHandler = other.targetHandler;
        if (this$targetHandler == null ? other$targetHandler != null : !this$targetHandler.equals(other$targetHandler)) {
            return false;
        }
        List<ArgumentLoader.Factory> this$argumentLoaders = this.argumentLoaders;
        List<ArgumentLoader.Factory> other$argumentLoaders = other.argumentLoaders;
        if (this$argumentLoaders == null ? other$argumentLoaders != null : !((Object)this$argumentLoaders).equals(other$argumentLoaders)) {
            return false;
        }
        MethodInvoker this$methodInvoker = this.methodInvoker;
        MethodInvoker other$methodInvoker = other.methodInvoker;
        if (this$methodInvoker == null ? other$methodInvoker != null : !this$methodInvoker.equals(other$methodInvoker)) {
            return false;
        }
        TerminationHandler this$terminationHandler = this.terminationHandler;
        TerminationHandler other$terminationHandler = other.terminationHandler;
        if (this$terminationHandler == null ? other$terminationHandler != null : !((Object)((Object)this$terminationHandler)).equals((Object)other$terminationHandler)) {
            return false;
        }
        Assigner this$assigner = this.assigner;
        Assigner other$assigner = other.assigner;
        if (this$assigner == null ? other$assigner != null : !this$assigner.equals(other$assigner)) {
            return false;
        }
        Assigner.Typing this$typing = this.typing;
        Assigner.Typing other$typing = other.typing;
        return !(this$typing == null ? other$typing != null : !((Object)((Object)this$typing)).equals((Object)other$typing));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MethodCall;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MethodLocator $methodLocator = this.methodLocator;
        result = result * 59 + ($methodLocator == null ? 43 : $methodLocator.hashCode());
        TargetHandler $targetHandler = this.targetHandler;
        result = result * 59 + ($targetHandler == null ? 43 : $targetHandler.hashCode());
        List<ArgumentLoader.Factory> $argumentLoaders = this.argumentLoaders;
        result = result * 59 + ($argumentLoaders == null ? 43 : ((Object)$argumentLoaders).hashCode());
        MethodInvoker $methodInvoker = this.methodInvoker;
        result = result * 59 + ($methodInvoker == null ? 43 : $methodInvoker.hashCode());
        TerminationHandler $terminationHandler = this.terminationHandler;
        result = result * 59 + ($terminationHandler == null ? 43 : ((Object)((Object)$terminationHandler)).hashCode());
        Assigner $assigner = this.assigner;
        result = result * 59 + ($assigner == null ? 43 : $assigner.hashCode());
        Assigner.Typing $typing = this.typing;
        result = result * 59 + ($typing == null ? 43 : ((Object)((Object)$typing)).hashCode());
        return result;
    }

    protected class Appender
    implements ByteCodeAppender {
        private final Implementation.Target implementationTarget;

        protected Appender(Implementation.Target implementationTarget) {
            this.implementationTarget = implementationTarget;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            MethodDescription invokedMethod = MethodCall.this.methodLocator.resolve(this.implementationTarget.getInstrumentedType(), instrumentedMethod);
            if (!invokedMethod.isVisibleTo(this.implementationTarget.getInstrumentedType())) {
                throw new IllegalStateException("Cannot invoke " + invokedMethod + " from " + implementationContext.getInstrumentedType());
            }
            ArrayList<ArgumentLoader> argumentLoaders = new ArrayList<ArgumentLoader>(MethodCall.this.argumentLoaders.size());
            for (ArgumentLoader.Factory argumentLoader : MethodCall.this.argumentLoaders) {
                argumentLoaders.addAll(argumentLoader.make(this.implementationTarget.getInstrumentedType(), instrumentedMethod, invokedMethod));
            }
            ParameterList<?> parameters = invokedMethod.getParameters();
            Iterator parameterIterator = parameters.iterator();
            if (parameters.size() != argumentLoaders.size()) {
                throw new IllegalStateException(invokedMethod + " does not take " + argumentLoaders.size() + " arguments");
            }
            ArrayList<StackManipulation> argumentInstructions = new ArrayList<StackManipulation>(argumentLoaders.size());
            for (ArgumentLoader argumentLoader : argumentLoaders) {
                argumentInstructions.add(argumentLoader.resolve((ParameterDescription)parameterIterator.next(), MethodCall.this.assigner, MethodCall.this.typing));
            }
            StackManipulation.Size size = new StackManipulation.Compound(MethodCall.this.targetHandler.resolve(invokedMethod, instrumentedMethod, this.implementationTarget.getInstrumentedType(), MethodCall.this.assigner, MethodCall.this.typing), new StackManipulation.Compound(argumentInstructions), MethodCall.this.methodInvoker.invoke(invokedMethod, this.implementationTarget), MethodCall.this.terminationHandler.resolve(invokedMethod, instrumentedMethod, MethodCall.this.assigner, MethodCall.this.typing)).apply(methodVisitor, implementationContext);
            return new ByteCodeAppender.Size(size.getMaximalSize(), instrumentedMethod.getStackSize());
        }

        private MethodCall getOuter() {
            return MethodCall.this;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Appender appender = (Appender)other;
            return this.implementationTarget.equals(appender.implementationTarget) && MethodCall.this.equals(appender.getOuter());
        }

        public int hashCode() {
            return this.implementationTarget.hashCode() + 31 * MethodCall.this.hashCode();
        }
    }

    public static class WithoutSpecifiedTarget
    extends MethodCall {
        protected WithoutSpecifiedTarget(MethodLocator methodLocator) {
            super(methodLocator, TargetHandler.ForSelfOrStaticInvocation.INSTANCE, Collections.<ArgumentLoader.Factory>emptyList(), MethodInvoker.ForContextualInvocation.INSTANCE, TerminationHandler.RETURNING, Assigner.DEFAULT, Assigner.Typing.STATIC);
        }

        public MethodCall on(Object target) {
            return this.on(target, target.getClass());
        }

        public <T> MethodCall on(T target, Class<? super T> type) {
            return new MethodCall(this.methodLocator, new TargetHandler.ForValue(target, new TypeDescription.Generic.OfNonGenericType.ForLoadedType(type)), this.argumentLoaders, new MethodInvoker.ForVirtualInvocation(type), this.terminationHandler, this.assigner, this.typing);
        }

        public MethodCall onArgument(int index) {
            if (index < 0) {
                throw new IllegalArgumentException("An argument index cannot be negative: " + index);
            }
            return new MethodCall(this.methodLocator, new TargetHandler.ForMethodParameter(index), this.argumentLoaders, MethodInvoker.ForVirtualInvocation.WithImplicitType.INSTANCE, this.terminationHandler, this.assigner, this.typing);
        }

        public MethodCall onField(String name) {
            return this.onField(name, FieldLocator.ForClassHierarchy.Factory.INSTANCE);
        }

        public MethodCall onField(String name, FieldLocator.Factory fieldLocatorFactory) {
            return new MethodCall(this.methodLocator, new TargetHandler.ForField(name, fieldLocatorFactory), this.argumentLoaders, MethodInvoker.ForVirtualInvocation.WithImplicitType.INSTANCE, this.terminationHandler, this.assigner, this.typing);
        }

        public MethodCall onSuper() {
            return new MethodCall(this.methodLocator, TargetHandler.ForSelfOrStaticInvocation.INSTANCE, this.argumentLoaders, MethodInvoker.ForSuperMethodInvocation.INSTANCE, this.terminationHandler, this.assigner, this.typing);
        }

        public MethodCall onDefault() {
            return new MethodCall(this.methodLocator, TargetHandler.ForSelfOrStaticInvocation.INSTANCE, this.argumentLoaders, MethodInvoker.ForDefaultMethodInvocation.INSTANCE, this.terminationHandler, this.assigner, this.typing);
        }
    }

    protected static enum TerminationHandler {
        RETURNING{

            @Override
            public StackManipulation resolve(MethodDescription invokedMethod, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                StackManipulation stackManipulation = assigner.assign(invokedMethod.isConstructor() ? invokedMethod.getDeclaringType().asGenericType() : invokedMethod.getReturnType(), instrumentedMethod.getReturnType(), typing);
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot return " + invokedMethod.getReturnType() + " from " + instrumentedMethod);
                }
                return new StackManipulation.Compound(stackManipulation, MethodReturn.of(instrumentedMethod.getReturnType()));
            }
        }
        ,
        DROPPING{

            @Override
            protected StackManipulation resolve(MethodDescription invokedMethod, MethodDescription instrumentedMethod, Assigner assigner, Assigner.Typing typing) {
                return Removal.of(invokedMethod.isConstructor() ? invokedMethod.getDeclaringType() : invokedMethod.getReturnType());
            }
        };


        protected abstract StackManipulation resolve(MethodDescription var1, MethodDescription var2, Assigner var3, Assigner.Typing var4);
    }

    protected static interface MethodInvoker {
        public StackManipulation invoke(MethodDescription var1, Implementation.Target var2);

        public static enum ForDefaultMethodInvocation implements MethodInvoker
        {
            INSTANCE;


            @Override
            public StackManipulation invoke(MethodDescription invokedMethod, Implementation.Target implementationTarget) {
                if (!invokedMethod.isInvokableOn(implementationTarget.getInstrumentedType())) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " as default method of " + implementationTarget.getInstrumentedType());
                }
                Implementation.SpecialMethodInvocation stackManipulation = implementationTarget.invokeDefault(invokedMethod.asSignatureToken(), invokedMethod.getDeclaringType().asErasure());
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " on " + implementationTarget.getInstrumentedType());
                }
                return stackManipulation;
            }
        }

        public static enum ForSuperMethodInvocation implements MethodInvoker
        {
            INSTANCE;


            @Override
            public StackManipulation invoke(MethodDescription invokedMethod, Implementation.Target implementationTarget) {
                if (implementationTarget.getInstrumentedType().getSuperClass() == null) {
                    throw new IllegalStateException("Cannot invoke super method for " + implementationTarget.getInstrumentedType());
                }
                if (!invokedMethod.isInvokableOn(implementationTarget.getOriginType().asErasure())) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " as super method of " + implementationTarget.getInstrumentedType());
                }
                Implementation.SpecialMethodInvocation stackManipulation = implementationTarget.invokeDominant(invokedMethod.asSignatureToken());
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " as a super method");
                }
                return stackManipulation;
            }
        }

        public static class ForVirtualInvocation
        implements MethodInvoker {
            private final TypeDescription typeDescription;

            protected ForVirtualInvocation(TypeDescription typeDescription) {
                this.typeDescription = typeDescription;
            }

            protected ForVirtualInvocation(Class<?> type) {
                this(new TypeDescription.ForLoadedType(type));
            }

            @Override
            public StackManipulation invoke(MethodDescription invokedMethod, Implementation.Target implementationTarget) {
                if (!invokedMethod.isVirtual()) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " virtually");
                }
                if (!invokedMethod.isInvokableOn(this.typeDescription.asErasure())) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " on " + this.typeDescription);
                }
                if (!this.typeDescription.asErasure().isAccessibleTo(implementationTarget.getInstrumentedType())) {
                    throw new IllegalStateException(this.typeDescription + " is not accessible to " + implementationTarget.getInstrumentedType());
                }
                return MethodInvocation.invoke(invokedMethod).virtual(this.typeDescription.asErasure());
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForVirtualInvocation)) {
                    return false;
                }
                ForVirtualInvocation other = (ForVirtualInvocation)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                TypeDescription this$typeDescription = this.typeDescription;
                TypeDescription other$typeDescription = other.typeDescription;
                return !(this$typeDescription == null ? other$typeDescription != null : !this$typeDescription.equals(other$typeDescription));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForVirtualInvocation;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                TypeDescription $typeDescription = this.typeDescription;
                result = result * 59 + ($typeDescription == null ? 43 : $typeDescription.hashCode());
                return result;
            }

            public static enum WithImplicitType implements MethodInvoker
            {
                INSTANCE;


                @Override
                public StackManipulation invoke(MethodDescription invokedMethod, Implementation.Target implementationTarget) {
                    if (!invokedMethod.isVirtual()) {
                        throw new IllegalStateException("Cannot invoke " + invokedMethod + " virtually");
                    }
                    return MethodInvocation.invoke(invokedMethod);
                }
            }
        }

        public static enum ForContextualInvocation implements MethodInvoker
        {
            INSTANCE;


            @Override
            public StackManipulation invoke(MethodDescription invokedMethod, Implementation.Target implementationTarget) {
                if (invokedMethod.isVirtual() && !invokedMethod.isInvokableOn(implementationTarget.getInstrumentedType())) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " on " + implementationTarget.getInstrumentedType());
                }
                return invokedMethod.isVirtual() ? MethodInvocation.invoke(invokedMethod).virtual(implementationTarget.getInstrumentedType()) : MethodInvocation.invoke(invokedMethod);
            }
        }
    }

    protected static interface TargetHandler
    extends InstrumentedType.Prepareable {
        public StackManipulation resolve(MethodDescription var1, MethodDescription var2, TypeDescription var3, Assigner var4, Assigner.Typing var5);

        public static class ForMethodParameter
        implements TargetHandler {
            private final int index;

            protected ForMethodParameter(int index) {
                this.index = index;
            }

            @Override
            public StackManipulation resolve(MethodDescription invokedMethod, MethodDescription instrumentedMethod, TypeDescription instrumentedType, Assigner assigner, Assigner.Typing typing) {
                if (instrumentedMethod.getParameters().size() < this.index) {
                    throw new IllegalArgumentException(instrumentedMethod + " does not have a parameter with index " + this.index);
                }
                ParameterDescription parameterDescription = (ParameterDescription)instrumentedMethod.getParameters().get(this.index);
                StackManipulation stackManipulation = assigner.assign(parameterDescription.getType(), invokedMethod.getDeclaringType().asGenericType(), typing);
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " on " + parameterDescription.getType());
                }
                return new StackManipulation.Compound(MethodVariableAccess.load(parameterDescription), stackManipulation);
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForMethodParameter)) {
                    return false;
                }
                ForMethodParameter other = (ForMethodParameter)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                return this.index == other.index;
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForMethodParameter;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + this.index;
                return result;
            }
        }

        public static class ForField
        implements TargetHandler {
            private final String name;
            private final FieldLocator.Factory fieldLocatorFactory;

            protected ForField(String name, FieldLocator.Factory fieldLocatorFactory) {
                this.name = name;
                this.fieldLocatorFactory = fieldLocatorFactory;
            }

            @Override
            public StackManipulation resolve(MethodDescription invokedMethod, MethodDescription instrumentedMethod, TypeDescription instrumentedType, Assigner assigner, Assigner.Typing typing) {
                FieldLocator.Resolution resolution = this.fieldLocatorFactory.make(instrumentedType).locate(this.name);
                if (!resolution.isResolved()) {
                    throw new IllegalStateException("Could not locate field name " + this.name + " on " + instrumentedType);
                }
                if (!resolution.getField().isStatic() && !instrumentedType.isAssignableTo(resolution.getField().getDeclaringType().asErasure())) {
                    throw new IllegalStateException("Cannot access " + resolution.getField() + " from " + instrumentedType);
                }
                if (!invokedMethod.isInvokableOn(resolution.getField().getType().asErasure())) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " on " + resolution.getField());
                }
                if (!invokedMethod.isAccessibleTo(instrumentedType)) {
                    throw new IllegalStateException("Cannot access " + invokedMethod + " from " + instrumentedType);
                }
                StackManipulation stackManipulation = assigner.assign(resolution.getField().getType(), invokedMethod.getDeclaringType().asGenericType(), typing);
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " on " + resolution.getField());
                }
                return new StackManipulation.Compound(invokedMethod.isStatic() ? StackManipulation.Trivial.INSTANCE : MethodVariableAccess.loadThis(), FieldAccess.forField(resolution.getField()).read(), stackManipulation);
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForField)) {
                    return false;
                }
                ForField other = (ForField)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$name = this.name;
                String other$name = other.name;
                if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                    return false;
                }
                FieldLocator.Factory this$fieldLocatorFactory = this.fieldLocatorFactory;
                FieldLocator.Factory other$fieldLocatorFactory = other.fieldLocatorFactory;
                return !(this$fieldLocatorFactory == null ? other$fieldLocatorFactory != null : !this$fieldLocatorFactory.equals(other$fieldLocatorFactory));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForField;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $name = this.name;
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                FieldLocator.Factory $fieldLocatorFactory = this.fieldLocatorFactory;
                result = result * 59 + ($fieldLocatorFactory == null ? 43 : $fieldLocatorFactory.hashCode());
                return result;
            }
        }

        public static class ForValue
        implements TargetHandler {
            private static final String FIELD_PREFIX = "invocationTarget";
            private final Object target;
            private final TypeDescription.Generic fieldType;
            private final String name;

            protected ForValue(Object target, TypeDescription.Generic fieldType) {
                this.target = target;
                this.fieldType = fieldType;
                this.name = "invocationTarget$" + RandomString.make();
            }

            @Override
            public StackManipulation resolve(MethodDescription invokedMethod, MethodDescription instrumentedMethod, TypeDescription instrumentedType, Assigner assigner, Assigner.Typing typing) {
                StackManipulation stackManipulation = assigner.assign(this.fieldType, invokedMethod.getDeclaringType().asGenericType(), typing);
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot invoke " + invokedMethod + " on " + this.fieldType);
                }
                return new StackManipulation.Compound(FieldAccess.forField((FieldDescription.InDefinedShape)((FieldList)instrumentedType.getDeclaredFields().filter(ElementMatchers.named(this.name))).getOnly()).read(), stackManipulation);
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType.withField(new FieldDescription.Token(this.name, 4169, this.fieldType)).withInitializer(new LoadedTypeInitializer.ForStaticField(this.name, this.target));
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForValue)) {
                    return false;
                }
                ForValue other = (ForValue)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Object this$target = this.target;
                Object other$target = other.target;
                if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
                    return false;
                }
                TypeDescription.Generic this$fieldType = this.fieldType;
                TypeDescription.Generic other$fieldType = other.fieldType;
                return !(this$fieldType == null ? other$fieldType != null : !this$fieldType.equals(other$fieldType));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForValue;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Object $target = this.target;
                result = result * 59 + ($target == null ? 43 : $target.hashCode());
                TypeDescription.Generic $fieldType = this.fieldType;
                result = result * 59 + ($fieldType == null ? 43 : $fieldType.hashCode());
                return result;
            }
        }

        public static enum ForConstructingInvocation implements TargetHandler
        {
            INSTANCE;


            @Override
            public StackManipulation resolve(MethodDescription invokedMethod, MethodDescription instrumentedMethod, TypeDescription instrumentedType, Assigner assigner, Assigner.Typing typing) {
                return new StackManipulation.Compound(TypeCreation.of(invokedMethod.getDeclaringType().asErasure()), Duplication.SINGLE);
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }
        }

        public static enum ForSelfOrStaticInvocation implements TargetHandler
        {
            INSTANCE;


            @Override
            public StackManipulation resolve(MethodDescription invokedMethod, MethodDescription instrumentedMethod, TypeDescription instrumentedType, Assigner assigner, Assigner.Typing typing) {
                return new StackManipulation.Compound(invokedMethod.isStatic() ? StackManipulation.Trivial.INSTANCE : MethodVariableAccess.loadThis(), (StackManipulation)((Object)(invokedMethod.isConstructor() ? Duplication.SINGLE : StackManipulation.Trivial.INSTANCE)));
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }
        }
    }

    public static interface ArgumentLoader {
        public StackManipulation resolve(ParameterDescription var1, Assigner var2, Assigner.Typing var3);

        public static class ForStackManipulation
        implements ArgumentLoader,
        Factory {
            private final StackManipulation stackManipulation;
            private final TypeDefinition typeDefinition;

            public ForStackManipulation(StackManipulation stackManipulation, Type type) {
                this(stackManipulation, TypeDefinition.Sort.describe(type));
            }

            public ForStackManipulation(StackManipulation stackManipulation, TypeDefinition typeDefinition) {
                this.stackManipulation = stackManipulation;
                this.typeDefinition = typeDefinition;
            }

            public static Factory of(Object value) {
                if (value == null) {
                    return ForNullConstant.INSTANCE;
                }
                if (value instanceof String) {
                    return new ForStackManipulation((StackManipulation)new TextConstant((String)value), (Type)((Object)String.class));
                }
                if (value instanceof Boolean) {
                    return new ForStackManipulation(IntegerConstant.forValue((Boolean)value), Boolean.TYPE);
                }
                if (value instanceof Byte) {
                    return new ForStackManipulation(IntegerConstant.forValue(((Byte)value).byteValue()), Byte.TYPE);
                }
                if (value instanceof Short) {
                    return new ForStackManipulation(IntegerConstant.forValue(((Short)value).shortValue()), Short.TYPE);
                }
                if (value instanceof Character) {
                    return new ForStackManipulation(IntegerConstant.forValue(((Character)value).charValue()), Character.TYPE);
                }
                if (value instanceof Integer) {
                    return new ForStackManipulation(IntegerConstant.forValue((Integer)value), Integer.TYPE);
                }
                if (value instanceof Long) {
                    return new ForStackManipulation(LongConstant.forValue((Long)value), Long.TYPE);
                }
                if (value instanceof Float) {
                    return new ForStackManipulation(FloatConstant.forValue(((Float)value).floatValue()), Float.TYPE);
                }
                if (value instanceof Double) {
                    return new ForStackManipulation(DoubleConstant.forValue((Double)value), Double.TYPE);
                }
                if (value instanceof Class) {
                    return new ForStackManipulation(ClassConstant.of(new TypeDescription.ForLoadedType((Class)value)), (Type)((Object)Class.class));
                }
                if (JavaType.METHOD_HANDLE.getTypeStub().isInstance(value)) {
                    return new ForStackManipulation(JavaConstant.MethodHandle.ofLoaded(value).asStackManipulation(), JavaType.METHOD_HANDLE.getTypeStub());
                }
                if (JavaType.METHOD_TYPE.getTypeStub().isInstance(value)) {
                    return new ForStackManipulation(JavaConstant.MethodType.ofLoaded(value).asStackManipulation(), JavaType.METHOD_TYPE.getTypeStub());
                }
                if (value instanceof Enum) {
                    EnumerationDescription.ForLoadedEnumeration enumerationDescription = new EnumerationDescription.ForLoadedEnumeration((Enum)value);
                    return new ForStackManipulation(FieldAccess.forEnumeration(enumerationDescription), enumerationDescription.getEnumerationType());
                }
                return new ForInstance.Factory(value);
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                return Collections.singletonList(this);
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation assigment = assigner.assign(this.typeDefinition.asGenericType(), target.getType(), typing);
                if (!assigment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + target + " to " + this.typeDefinition);
                }
                return new StackManipulation.Compound(this.stackManipulation, assigment);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForStackManipulation)) {
                    return false;
                }
                ForStackManipulation other = (ForStackManipulation)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                StackManipulation this$stackManipulation = this.stackManipulation;
                StackManipulation other$stackManipulation = other.stackManipulation;
                if (this$stackManipulation == null ? other$stackManipulation != null : !this$stackManipulation.equals(other$stackManipulation)) {
                    return false;
                }
                TypeDefinition this$typeDefinition = this.typeDefinition;
                TypeDefinition other$typeDefinition = other.typeDefinition;
                return !(this$typeDefinition == null ? other$typeDefinition != null : !this$typeDefinition.equals(other$typeDefinition));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForStackManipulation;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                StackManipulation $stackManipulation = this.stackManipulation;
                result = result * 59 + ($stackManipulation == null ? 43 : $stackManipulation.hashCode());
                TypeDefinition $typeDefinition = this.typeDefinition;
                result = result * 59 + ($typeDefinition == null ? 43 : $typeDefinition.hashCode());
                return result;
            }
        }

        public static class ForField
        implements ArgumentLoader {
            private final FieldDescription fieldDescription;
            private final MethodDescription instrumentedMethod;

            public ForField(FieldDescription fieldDescription, MethodDescription instrumentedMethod) {
                this.fieldDescription = fieldDescription;
                this.instrumentedMethod = instrumentedMethod;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                if (!this.fieldDescription.isStatic() && this.instrumentedMethod.isStatic()) {
                    throw new IllegalStateException("Cannot access non-static " + this.fieldDescription + " from " + this.instrumentedMethod);
                }
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(this.fieldDescription.isStatic() ? StackManipulation.Trivial.INSTANCE : MethodVariableAccess.loadThis(), FieldAccess.forField(this.fieldDescription).read(), assigner.assign(this.fieldDescription.getType(), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.fieldDescription + " to " + target);
                }
                return stackManipulation;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForField)) {
                    return false;
                }
                ForField other = (ForField)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                FieldDescription this$fieldDescription = this.fieldDescription;
                FieldDescription other$fieldDescription = other.fieldDescription;
                if (this$fieldDescription == null ? other$fieldDescription != null : !this$fieldDescription.equals(other$fieldDescription)) {
                    return false;
                }
                MethodDescription this$instrumentedMethod = this.instrumentedMethod;
                MethodDescription other$instrumentedMethod = other.instrumentedMethod;
                return !(this$instrumentedMethod == null ? other$instrumentedMethod != null : !this$instrumentedMethod.equals(other$instrumentedMethod));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForField;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                FieldDescription $fieldDescription = this.fieldDescription;
                result = result * 59 + ($fieldDescription == null ? 43 : $fieldDescription.hashCode());
                MethodDescription $instrumentedMethod = this.instrumentedMethod;
                result = result * 59 + ($instrumentedMethod == null ? 43 : $instrumentedMethod.hashCode());
                return result;
            }

            protected static class Factory
            implements net.bytebuddy.implementation.MethodCall$ArgumentLoader$Factory {
                private final String name;
                private final FieldLocator.Factory fieldLocatorFactory;

                public Factory(String name, FieldLocator.Factory fieldLocatorFactory) {
                    this.name = name;
                    this.fieldLocatorFactory = fieldLocatorFactory;
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                    FieldLocator.Resolution resolution = this.fieldLocatorFactory.make(instrumentedType).locate(this.name);
                    if (!resolution.isResolved()) {
                        throw new IllegalStateException("Could not locate field '" + this.name + "' on " + instrumentedType);
                    }
                    return Collections.singletonList(new ForField(resolution.getField(), instrumentedMethod));
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Factory)) {
                        return false;
                    }
                    Factory other = (Factory)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$name = this.name;
                    String other$name = other.name;
                    if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                        return false;
                    }
                    FieldLocator.Factory this$fieldLocatorFactory = this.fieldLocatorFactory;
                    FieldLocator.Factory other$fieldLocatorFactory = other.fieldLocatorFactory;
                    return !(this$fieldLocatorFactory == null ? other$fieldLocatorFactory != null : !this$fieldLocatorFactory.equals(other$fieldLocatorFactory));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof Factory;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $name = this.name;
                    result = result * 59 + ($name == null ? 43 : $name.hashCode());
                    FieldLocator.Factory $fieldLocatorFactory = this.fieldLocatorFactory;
                    result = result * 59 + ($fieldLocatorFactory == null ? 43 : $fieldLocatorFactory.hashCode());
                    return result;
                }
            }
        }

        public static class ForInstance
        implements ArgumentLoader {
            private final FieldDescription fieldDescription;

            public ForInstance(FieldDescription fieldDescription) {
                this.fieldDescription = fieldDescription;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(FieldAccess.forField(this.fieldDescription).read(), assigner.assign(this.fieldDescription.getType(), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.fieldDescription.getType() + " to " + target);
                }
                return stackManipulation;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForInstance)) {
                    return false;
                }
                ForInstance other = (ForInstance)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                FieldDescription this$fieldDescription = this.fieldDescription;
                FieldDescription other$fieldDescription = other.fieldDescription;
                return !(this$fieldDescription == null ? other$fieldDescription != null : !this$fieldDescription.equals(other$fieldDescription));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForInstance;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                FieldDescription $fieldDescription = this.fieldDescription;
                result = result * 59 + ($fieldDescription == null ? 43 : $fieldDescription.hashCode());
                return result;
            }

            protected static class Factory
            implements net.bytebuddy.implementation.MethodCall$ArgumentLoader$Factory {
                private static final String FIELD_PREFIX = "methodCall";
                private final Object value;
                private final String name;

                public Factory(Object value) {
                    this.value = value;
                    this.name = "methodCall$" + RandomString.make();
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType.withField(new FieldDescription.Token(this.name, 4105, new TypeDescription.Generic.OfNonGenericType.ForLoadedType(this.value.getClass()))).withInitializer(new LoadedTypeInitializer.ForStaticField(this.name, this.value));
                }

                @Override
                public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                    return Collections.singletonList(new ForInstance((FieldDescription)((FieldList)instrumentedType.getDeclaredFields().filter(ElementMatchers.named(this.name))).getOnly()));
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Factory)) {
                        return false;
                    }
                    Factory other = (Factory)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Object this$value = this.value;
                    Object other$value = other.value;
                    return !(this$value == null ? other$value != null : !this$value.equals(other$value));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof Factory;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Object $value = this.value;
                    result = result * 59 + ($value == null ? 43 : $value.hashCode());
                    return result;
                }
            }
        }

        public static class ForMethodParameterArrayElement
        implements ArgumentLoader {
            private final ParameterDescription parameterDescription;
            private final int index;

            public ForMethodParameterArrayElement(ParameterDescription parameterDescription, int index) {
                this.parameterDescription = parameterDescription;
                this.index = index;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(MethodVariableAccess.load(this.parameterDescription), IntegerConstant.forValue(this.index), ArrayAccess.of(this.parameterDescription.getType().getComponentType()).load(), assigner.assign(this.parameterDescription.getType().getComponentType(), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.parameterDescription.getType().getComponentType() + " to " + target);
                }
                return stackManipulation;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForMethodParameterArrayElement)) {
                    return false;
                }
                ForMethodParameterArrayElement other = (ForMethodParameterArrayElement)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                ParameterDescription this$parameterDescription = this.parameterDescription;
                ParameterDescription other$parameterDescription = other.parameterDescription;
                if (this$parameterDescription == null ? other$parameterDescription != null : !this$parameterDescription.equals(other$parameterDescription)) {
                    return false;
                }
                return this.index == other.index;
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForMethodParameterArrayElement;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                ParameterDescription $parameterDescription = this.parameterDescription;
                result = result * 59 + ($parameterDescription == null ? 43 : $parameterDescription.hashCode());
                result = result * 59 + this.index;
                return result;
            }

            public static class OfInvokedMethod
            implements Factory {
                private final int index;

                public OfInvokedMethod(int index) {
                    this.index = index;
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                    if (instrumentedMethod.getParameters().size() <= this.index) {
                        throw new IllegalStateException(instrumentedMethod + " does not declare a parameter with index " + this.index);
                    }
                    if (!((ParameterDescription)instrumentedMethod.getParameters().get(this.index)).getType().isArray()) {
                        throw new IllegalStateException("Cannot access an item from non-array parameter " + instrumentedMethod.getParameters().get(this.index));
                    }
                    ArrayList<ArgumentLoader> argumentLoaders = new ArrayList<ArgumentLoader>(instrumentedMethod.getParameters().size());
                    for (int index = 0; index < invokedMethod.getParameters().size(); ++index) {
                        argumentLoaders.add(new ForMethodParameterArrayElement((ParameterDescription)instrumentedMethod.getParameters().get(this.index), index++));
                    }
                    return argumentLoaders;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof OfInvokedMethod)) {
                        return false;
                    }
                    OfInvokedMethod other = (OfInvokedMethod)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    return this.index == other.index;
                }

                protected boolean canEqual(Object other) {
                    return other instanceof OfInvokedMethod;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    result = result * 59 + this.index;
                    return result;
                }
            }

            protected static class OfParameter
            implements Factory {
                private final int index;
                private final int arrayIndex;

                public OfParameter(int index, int arrayIndex) {
                    this.index = index;
                    this.arrayIndex = arrayIndex;
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                    if (instrumentedMethod.getParameters().size() <= this.index) {
                        throw new IllegalStateException(instrumentedMethod + " does not declare a parameter with index " + this.index);
                    }
                    if (!((ParameterDescription)instrumentedMethod.getParameters().get(this.index)).getType().isArray()) {
                        throw new IllegalStateException("Cannot access an item from non-array parameter " + instrumentedMethod.getParameters().get(this.index));
                    }
                    return Collections.singletonList(new ForMethodParameterArrayElement((ParameterDescription)instrumentedMethod.getParameters().get(this.index), this.arrayIndex));
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof OfParameter)) {
                        return false;
                    }
                    OfParameter other = (OfParameter)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    if (this.index != other.index) {
                        return false;
                    }
                    return this.arrayIndex == other.arrayIndex;
                }

                protected boolean canEqual(Object other) {
                    return other instanceof OfParameter;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    result = result * 59 + this.index;
                    result = result * 59 + this.arrayIndex;
                    return result;
                }
            }
        }

        public static class ForMethodParameterArray
        implements ArgumentLoader {
            private final ParameterList<?> parameters;

            public ForMethodParameterArray(ParameterList<?> parameters) {
                this.parameters = parameters;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                TypeDescription.Generic componentType;
                if (target.getType().represents((Type)((Object)Object.class))) {
                    componentType = TypeDescription.Generic.OBJECT;
                } else if (target.getType().isArray()) {
                    componentType = target.getType().getComponentType();
                } else {
                    throw new IllegalStateException();
                }
                ArrayList<StackManipulation.Compound> stackManipulations = new ArrayList<StackManipulation.Compound>(this.parameters.size());
                for (ParameterDescription parameter : this.parameters) {
                    StackManipulation.Compound stackManipulation = new StackManipulation.Compound(MethodVariableAccess.load(parameter), assigner.assign(parameter.getType(), componentType, typing));
                    if (stackManipulation.isValid()) {
                        stackManipulations.add(stackManipulation);
                        continue;
                    }
                    throw new IllegalStateException("Cannot assign " + parameter + " to " + componentType);
                }
                return new StackManipulation.Compound(ArrayFactory.forType(componentType).withValues(stackManipulations));
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForMethodParameterArray)) {
                    return false;
                }
                ForMethodParameterArray other = (ForMethodParameterArray)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                ParameterList<?> this$parameters = this.parameters;
                ParameterList<?> other$parameters = other.parameters;
                return !(this$parameters == null ? other$parameters != null : !this$parameters.equals(other$parameters));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForMethodParameterArray;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                ParameterList<?> $parameters = this.parameters;
                result = result * 59 + ($parameters == null ? 43 : $parameters.hashCode());
                return result;
            }

            public static enum ForInstrumentedMethod implements Factory
            {
                INSTANCE;


                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                    return Collections.singletonList(new ForMethodParameterArray(instrumentedMethod.getParameters()));
                }
            }
        }

        public static class ForMethodParameter
        implements ArgumentLoader {
            private final int index;
            private final MethodDescription instrumentedMethod;

            public ForMethodParameter(int index, MethodDescription instrumentedMethod) {
                this.index = index;
                this.instrumentedMethod = instrumentedMethod;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                ParameterDescription parameterDescription = (ParameterDescription)this.instrumentedMethod.getParameters().get(this.index);
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(MethodVariableAccess.load(parameterDescription), assigner.assign(parameterDescription.getType(), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign " + parameterDescription + " to " + target + " for " + this.instrumentedMethod);
                }
                return stackManipulation;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForMethodParameter)) {
                    return false;
                }
                ForMethodParameter other = (ForMethodParameter)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.index != other.index) {
                    return false;
                }
                MethodDescription this$instrumentedMethod = this.instrumentedMethod;
                MethodDescription other$instrumentedMethod = other.instrumentedMethod;
                return !(this$instrumentedMethod == null ? other$instrumentedMethod != null : !this$instrumentedMethod.equals(other$instrumentedMethod));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForMethodParameter;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + this.index;
                MethodDescription $instrumentedMethod = this.instrumentedMethod;
                result = result * 59 + ($instrumentedMethod == null ? 43 : $instrumentedMethod.hashCode());
                return result;
            }

            protected static class Factory
            implements net.bytebuddy.implementation.MethodCall$ArgumentLoader$Factory {
                private final int index;

                public Factory(int index) {
                    this.index = index;
                }

                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                    if (this.index >= instrumentedMethod.getParameters().size()) {
                        throw new IllegalStateException(instrumentedMethod + " does not have a parameter with index " + this.index);
                    }
                    return Collections.singletonList(new ForMethodParameter(this.index, instrumentedMethod));
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Factory)) {
                        return false;
                    }
                    Factory other = (Factory)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    return this.index == other.index;
                }

                protected boolean canEqual(Object other) {
                    return other instanceof Factory;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    result = result * 59 + this.index;
                    return result;
                }
            }

            protected static enum OfInstrumentedMethod implements net.bytebuddy.implementation.MethodCall$ArgumentLoader$Factory
            {
                INSTANCE;


                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                    ArrayList<ArgumentLoader> argumentLoaders = new ArrayList<ArgumentLoader>(instrumentedMethod.getParameters().size());
                    for (ParameterDescription parameterDescription : instrumentedMethod.getParameters()) {
                        argumentLoaders.add(new ForMethodParameter(parameterDescription.getIndex(), instrumentedMethod));
                    }
                    return argumentLoaders;
                }
            }
        }

        public static class ForInstrumentedType
        implements ArgumentLoader {
            private final TypeDescription instrumentedType;

            public ForInstrumentedType(TypeDescription instrumentedType) {
                this.instrumentedType = instrumentedType;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(ClassConstant.of(this.instrumentedType), assigner.assign(new TypeDescription.Generic.OfNonGenericType.ForLoadedType(Class.class), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign Class value to " + target);
                }
                return stackManipulation;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForInstrumentedType)) {
                    return false;
                }
                ForInstrumentedType other = (ForInstrumentedType)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                TypeDescription this$instrumentedType = this.instrumentedType;
                TypeDescription other$instrumentedType = other.instrumentedType;
                return !(this$instrumentedType == null ? other$instrumentedType != null : !this$instrumentedType.equals(other$instrumentedType));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForInstrumentedType;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                TypeDescription $instrumentedType = this.instrumentedType;
                result = result * 59 + ($instrumentedType == null ? 43 : $instrumentedType.hashCode());
                return result;
            }

            public static enum Factory implements net.bytebuddy.implementation.MethodCall$ArgumentLoader$Factory
            {
                INSTANCE;


                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                    return Collections.singletonList(new ForInstrumentedType(instrumentedType));
                }
            }
        }

        public static class ForThisReference
        implements ArgumentLoader {
            private final TypeDescription instrumentedType;

            public ForThisReference(TypeDescription instrumentedType) {
                this.instrumentedType = instrumentedType;
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(MethodVariableAccess.loadThis(), assigner.assign(this.instrumentedType.asGenericType(), target.getType(), typing));
                if (!stackManipulation.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.instrumentedType + " to " + target);
                }
                return stackManipulation;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForThisReference)) {
                    return false;
                }
                ForThisReference other = (ForThisReference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                TypeDescription this$instrumentedType = this.instrumentedType;
                TypeDescription other$instrumentedType = other.instrumentedType;
                return !(this$instrumentedType == null ? other$instrumentedType != null : !this$instrumentedType.equals(other$instrumentedType));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForThisReference;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                TypeDescription $instrumentedType = this.instrumentedType;
                result = result * 59 + ($instrumentedType == null ? 43 : $instrumentedType.hashCode());
                return result;
            }

            public static enum Factory implements net.bytebuddy.implementation.MethodCall$ArgumentLoader$Factory
            {
                INSTANCE;


                @Override
                public InstrumentedType prepare(InstrumentedType instrumentedType) {
                    return instrumentedType;
                }

                @Override
                public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                    if (instrumentedMethod.isStatic()) {
                        throw new IllegalStateException(instrumentedMethod + " is static and cannot supply an invoker instance");
                    }
                    return Collections.singletonList(new ForThisReference(instrumentedType));
                }
            }
        }

        public static enum ForNullConstant implements ArgumentLoader,
        Factory
        {
            INSTANCE;


            @Override
            public List<ArgumentLoader> make(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription invokedMethod) {
                return Collections.singletonList(this);
            }

            @Override
            public StackManipulation resolve(ParameterDescription target, Assigner assigner, Assigner.Typing typing) {
                if (target.getType().isPrimitive()) {
                    throw new IllegalStateException("Cannot assign null to " + target);
                }
                return NullConstant.INSTANCE;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }
        }

        public static interface Factory {
            public InstrumentedType prepare(InstrumentedType var1);

            public List<ArgumentLoader> make(TypeDescription var1, MethodDescription var2, MethodDescription var3);
        }
    }

    public static interface MethodLocator {
        public MethodDescription resolve(TypeDescription var1, MethodDescription var2);

        public static class ForElementMatcher
        implements MethodLocator {
            private final ElementMatcher<? super MethodDescription> matcher;
            private final MethodGraph.Compiler methodGraphCompiler;

            protected ForElementMatcher(ElementMatcher<? super MethodDescription> matcher, MethodGraph.Compiler methodGraphCompiler) {
                this.matcher = matcher;
                this.methodGraphCompiler = methodGraphCompiler;
            }

            @Override
            public MethodDescription resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                MethodList candidates = (MethodList)this.methodGraphCompiler.compile(instrumentedType).listNodes().asMethodList().filter(this.matcher);
                if (candidates.size() == 1) {
                    return (MethodDescription)candidates.getOnly();
                }
                throw new IllegalStateException(instrumentedType + " does not define exactly one virtual method for " + this.matcher);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForElementMatcher)) {
                    return false;
                }
                ForElementMatcher other = (ForElementMatcher)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                ElementMatcher<? super MethodDescription> this$matcher = this.matcher;
                ElementMatcher<? super MethodDescription> other$matcher = other.matcher;
                if (this$matcher == null ? other$matcher != null : !this$matcher.equals(other$matcher)) {
                    return false;
                }
                MethodGraph.Compiler this$methodGraphCompiler = this.methodGraphCompiler;
                MethodGraph.Compiler other$methodGraphCompiler = other.methodGraphCompiler;
                return !(this$methodGraphCompiler == null ? other$methodGraphCompiler != null : !this$methodGraphCompiler.equals(other$methodGraphCompiler));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForElementMatcher;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                ElementMatcher<? super MethodDescription> $matcher = this.matcher;
                result = result * 59 + ($matcher == null ? 43 : $matcher.hashCode());
                MethodGraph.Compiler $methodGraphCompiler = this.methodGraphCompiler;
                result = result * 59 + ($methodGraphCompiler == null ? 43 : $methodGraphCompiler.hashCode());
                return result;
            }
        }

        public static class ForExplicitMethod
        implements MethodLocator {
            private final MethodDescription methodDescription;

            protected ForExplicitMethod(MethodDescription methodDescription) {
                this.methodDescription = methodDescription;
            }

            @Override
            public MethodDescription resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                return this.methodDescription;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForExplicitMethod)) {
                    return false;
                }
                ForExplicitMethod other = (ForExplicitMethod)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                MethodDescription this$methodDescription = this.methodDescription;
                MethodDescription other$methodDescription = other.methodDescription;
                return !(this$methodDescription == null ? other$methodDescription != null : !this$methodDescription.equals(other$methodDescription));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForExplicitMethod;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                MethodDescription $methodDescription = this.methodDescription;
                result = result * 59 + ($methodDescription == null ? 43 : $methodDescription.hashCode());
                return result;
            }
        }

        public static enum ForInstrumentedMethod implements MethodLocator
        {
            INSTANCE;


            @Override
            public MethodDescription resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                return instrumentedMethod;
            }
        }
    }
}

