/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.asm;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import net.bytebuddy.utility.CompoundList;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class ModifierAdjustment
extends AsmVisitorWrapper.AbstractBase {
    private final List<Adjustment<TypeDescription>> typeAdjustments;
    private final List<Adjustment<FieldDescription.InDefinedShape>> fieldAdjustments;
    private final List<Adjustment<MethodDescription>> methodAdjustments;

    public ModifierAdjustment() {
        this(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    protected ModifierAdjustment(List<Adjustment<TypeDescription>> typeAdjustments, List<Adjustment<FieldDescription.InDefinedShape>> fieldAdjustments, List<Adjustment<MethodDescription>> methodAdjustments) {
        this.typeAdjustments = typeAdjustments;
        this.fieldAdjustments = fieldAdjustments;
        this.methodAdjustments = methodAdjustments;
    }

    public ModifierAdjustment withTypeModifiers(ModifierContributor.ForType ... modifierContributor) {
        return this.withTypeModifiers(Arrays.asList(modifierContributor));
    }

    public ModifierAdjustment withTypeModifiers(List<? extends ModifierContributor.ForType> modifierContributors) {
        return this.withTypeModifiers(ElementMatchers.any(), modifierContributors);
    }

    public ModifierAdjustment withTypeModifiers(ElementMatcher<? super TypeDescription> matcher, ModifierContributor.ForType ... modifierContributor) {
        return this.withTypeModifiers(matcher, Arrays.asList(modifierContributor));
    }

    public ModifierAdjustment withTypeModifiers(ElementMatcher<? super TypeDescription> matcher, List<? extends ModifierContributor.ForType> modifierContributors) {
        return new ModifierAdjustment(CompoundList.of(this.typeAdjustments, new Adjustment<TypeDescription>(matcher, ModifierContributor.Resolver.of(modifierContributors))), this.fieldAdjustments, this.methodAdjustments);
    }

    public ModifierAdjustment withFieldModifiers(ModifierContributor.ForField ... modifierContributor) {
        return this.withFieldModifiers(Arrays.asList(modifierContributor));
    }

    public ModifierAdjustment withFieldModifiers(List<? extends ModifierContributor.ForField> modifierContributors) {
        return this.withFieldModifiers(ElementMatchers.any(), modifierContributors);
    }

    public ModifierAdjustment withFieldModifiers(ElementMatcher<? super FieldDescription.InDefinedShape> matcher, ModifierContributor.ForField ... modifierContributor) {
        return this.withFieldModifiers(matcher, Arrays.asList(modifierContributor));
    }

    public ModifierAdjustment withFieldModifiers(ElementMatcher<? super FieldDescription.InDefinedShape> matcher, List<? extends ModifierContributor.ForField> modifierContributors) {
        return new ModifierAdjustment(this.typeAdjustments, CompoundList.of(this.fieldAdjustments, new Adjustment<FieldDescription.InDefinedShape>(matcher, ModifierContributor.Resolver.of(modifierContributors))), this.methodAdjustments);
    }

    public ModifierAdjustment withMethodModifiers(ModifierContributor.ForMethod ... modifierContributor) {
        return this.withMethodModifiers(Arrays.asList(modifierContributor));
    }

    public ModifierAdjustment withMethodModifiers(List<? extends ModifierContributor.ForMethod> modifierContributors) {
        return this.withMethodModifiers(ElementMatchers.any(), modifierContributors);
    }

    public ModifierAdjustment withMethodModifiers(ElementMatcher<? super MethodDescription> matcher, ModifierContributor.ForMethod ... modifierContributor) {
        return this.withMethodModifiers(matcher, Arrays.asList(modifierContributor));
    }

    public ModifierAdjustment withMethodModifiers(ElementMatcher<? super MethodDescription> matcher, List<? extends ModifierContributor.ForMethod> modifierContributors) {
        return this.withInvokableModifiers(ElementMatchers.isMethod().and(matcher), modifierContributors);
    }

    public ModifierAdjustment withConstructorModifiers(ModifierContributor.ForMethod ... modifierContributor) {
        return this.withConstructorModifiers(Arrays.asList(modifierContributor));
    }

    public ModifierAdjustment withConstructorModifiers(List<? extends ModifierContributor.ForMethod> modifierContributors) {
        return this.withConstructorModifiers(ElementMatchers.any(), modifierContributors);
    }

    public ModifierAdjustment withConstructorModifiers(ElementMatcher<? super MethodDescription> matcher, ModifierContributor.ForMethod ... modifierContributor) {
        return this.withConstructorModifiers(matcher, Arrays.asList(modifierContributor));
    }

    public ModifierAdjustment withConstructorModifiers(ElementMatcher<? super MethodDescription> matcher, List<? extends ModifierContributor.ForMethod> modifierContributors) {
        return this.withInvokableModifiers(ElementMatchers.isConstructor().and(matcher), modifierContributors);
    }

    public ModifierAdjustment withInvokableModifiers(ModifierContributor.ForMethod ... modifierContributor) {
        return this.withInvokableModifiers(Arrays.asList(modifierContributor));
    }

    public ModifierAdjustment withInvokableModifiers(List<? extends ModifierContributor.ForMethod> modifierContributors) {
        return this.withInvokableModifiers(ElementMatchers.any(), modifierContributors);
    }

    public ModifierAdjustment withInvokableModifiers(ElementMatcher<? super MethodDescription> matcher, ModifierContributor.ForMethod ... modifierContributor) {
        return this.withInvokableModifiers(matcher, Arrays.asList(modifierContributor));
    }

    public ModifierAdjustment withInvokableModifiers(ElementMatcher<? super MethodDescription> matcher, List<? extends ModifierContributor.ForMethod> modifierContributors) {
        return new ModifierAdjustment(this.typeAdjustments, this.fieldAdjustments, CompoundList.of(this.methodAdjustments, new Adjustment<MethodDescription>(matcher, ModifierContributor.Resolver.of(modifierContributors))));
    }

    @Override
    public ModifierAdjustingClassVisitor wrap(TypeDescription instrumentedType, ClassVisitor classVisitor, Implementation.Context implementationContext, TypePool typePool, FieldList<FieldDescription.InDefinedShape> fields, MethodList<?> methods, int writerFlags, int readerFlags) {
        HashMap<String, FieldDescription.InDefinedShape> mappedFields = new HashMap<String, FieldDescription.InDefinedShape>();
        for (FieldDescription.InDefinedShape fieldDescription : fields) {
            mappedFields.put(fieldDescription.getInternalName() + fieldDescription.getDescriptor(), fieldDescription);
        }
        HashMap<String, MethodDescription> mappedMethods = new HashMap<String, MethodDescription>();
        for (MethodDescription methodDescription : CompoundList.of(methods, new MethodDescription.Latent.TypeInitializer(instrumentedType))) {
            mappedMethods.put(methodDescription.getInternalName() + methodDescription.getDescriptor(), methodDescription);
        }
        return new ModifierAdjustingClassVisitor(classVisitor, this.typeAdjustments, this.fieldAdjustments, this.methodAdjustments, instrumentedType, mappedFields, mappedMethods);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModifierAdjustment)) {
            return false;
        }
        ModifierAdjustment other = (ModifierAdjustment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Adjustment<TypeDescription>> this$typeAdjustments = this.typeAdjustments;
        List<Adjustment<TypeDescription>> other$typeAdjustments = other.typeAdjustments;
        if (this$typeAdjustments == null ? other$typeAdjustments != null : !((Object)this$typeAdjustments).equals(other$typeAdjustments)) {
            return false;
        }
        List<Adjustment<FieldDescription.InDefinedShape>> this$fieldAdjustments = this.fieldAdjustments;
        List<Adjustment<FieldDescription.InDefinedShape>> other$fieldAdjustments = other.fieldAdjustments;
        if (this$fieldAdjustments == null ? other$fieldAdjustments != null : !((Object)this$fieldAdjustments).equals(other$fieldAdjustments)) {
            return false;
        }
        List<Adjustment<MethodDescription>> this$methodAdjustments = this.methodAdjustments;
        List<Adjustment<MethodDescription>> other$methodAdjustments = other.methodAdjustments;
        return !(this$methodAdjustments == null ? other$methodAdjustments != null : !((Object)this$methodAdjustments).equals(other$methodAdjustments));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModifierAdjustment;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Adjustment<TypeDescription>> $typeAdjustments = this.typeAdjustments;
        result = result * 59 + ($typeAdjustments == null ? 43 : ((Object)$typeAdjustments).hashCode());
        List<Adjustment<FieldDescription.InDefinedShape>> $fieldAdjustments = this.fieldAdjustments;
        result = result * 59 + ($fieldAdjustments == null ? 43 : ((Object)$fieldAdjustments).hashCode());
        List<Adjustment<MethodDescription>> $methodAdjustments = this.methodAdjustments;
        result = result * 59 + ($methodAdjustments == null ? 43 : ((Object)$methodAdjustments).hashCode());
        return result;
    }

    protected static class ModifierAdjustingClassVisitor
    extends ClassVisitor {
        private final List<Adjustment<TypeDescription>> typeAdjustments;
        private final List<Adjustment<FieldDescription.InDefinedShape>> fieldAdjustments;
        private final List<Adjustment<MethodDescription>> methodAdjustments;
        private final TypeDescription instrumentedType;
        private final Map<String, FieldDescription.InDefinedShape> fields;
        private final Map<String, MethodDescription> methods;

        protected ModifierAdjustingClassVisitor(ClassVisitor classVisitor, List<Adjustment<TypeDescription>> typeAdjustments, List<Adjustment<FieldDescription.InDefinedShape>> fieldAdjustments, List<Adjustment<MethodDescription>> methodAdjustments, TypeDescription instrumentedType, Map<String, FieldDescription.InDefinedShape> fields, Map<String, MethodDescription> methods) {
            super(393216, classVisitor);
            this.typeAdjustments = typeAdjustments;
            this.fieldAdjustments = fieldAdjustments;
            this.methodAdjustments = methodAdjustments;
            this.instrumentedType = instrumentedType;
            this.fields = fields;
            this.methods = methods;
        }

        public void visit(int version, int modifiers, String internalName, String signature, String superClassName, String[] interfaceName) {
            for (Adjustment<TypeDescription> adjustment : this.typeAdjustments) {
                if (!adjustment.matches(this.instrumentedType)) continue;
                modifiers = adjustment.resolve(modifiers);
            }
            super.visit(version, modifiers, internalName, signature, superClassName, interfaceName);
        }

        public void visitInnerClass(String internalName, String outerName, String innerName, int modifiers) {
            if (this.instrumentedType.getInternalName().equals(internalName)) {
                for (Adjustment<TypeDescription> adjustment : this.typeAdjustments) {
                    if (!adjustment.matches(this.instrumentedType)) continue;
                    modifiers = adjustment.resolve(modifiers);
                }
            }
            super.visitInnerClass(internalName, outerName, innerName, modifiers);
        }

        public FieldVisitor visitField(int modifiers, String internalName, String descriptor, String signature, Object value) {
            FieldDescription.InDefinedShape fieldDescription = this.fields.get(internalName + descriptor);
            if (fieldDescription != null) {
                for (Adjustment<FieldDescription.InDefinedShape> adjustment : this.fieldAdjustments) {
                    if (!adjustment.matches(fieldDescription)) continue;
                    modifiers = adjustment.resolve(modifiers);
                }
            }
            return super.visitField(modifiers, internalName, descriptor, signature, value);
        }

        public MethodVisitor visitMethod(int modifiers, String internalName, String descriptor, String signature, String[] exception) {
            MethodDescription methodDescription = this.methods.get(internalName + descriptor);
            if (methodDescription != null) {
                for (Adjustment<MethodDescription> adjustment : this.methodAdjustments) {
                    if (!adjustment.matches(methodDescription)) continue;
                    modifiers = adjustment.resolve(modifiers);
                }
            }
            return super.visitMethod(modifiers, internalName, descriptor, signature, exception);
        }
    }

    protected static class Adjustment<T>
    implements ElementMatcher<T> {
        private final ElementMatcher<? super T> matcher;
        private final ModifierContributor.Resolver<?> resolver;

        protected Adjustment(ElementMatcher<? super T> matcher, ModifierContributor.Resolver<?> resolver) {
            this.matcher = matcher;
            this.resolver = resolver;
        }

        @Override
        public boolean matches(T target) {
            return this.matcher.matches(target);
        }

        protected int resolve(int modifiers) {
            return this.resolver.resolve(modifiers);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Adjustment)) {
                return false;
            }
            Adjustment other = (Adjustment)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ElementMatcher<T> this$matcher = this.matcher;
            ElementMatcher<? super T> other$matcher = other.matcher;
            if (this$matcher == null ? other$matcher != null : !this$matcher.equals(other$matcher)) {
                return false;
            }
            ModifierContributor.Resolver<?> this$resolver = this.resolver;
            ModifierContributor.Resolver<?> other$resolver = other.resolver;
            return !(this$resolver == null ? other$resolver != null : !((Object)this$resolver).equals(other$resolver));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Adjustment;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ElementMatcher<T> $matcher = this.matcher;
            result = result * 59 + ($matcher == null ? 43 : $matcher.hashCode());
            ModifierContributor.Resolver<?> $resolver = this.resolver;
            result = result * 59 + ($resolver == null ? 43 : ((Object)$resolver).hashCode());
            return result;
        }
    }
}

