/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.asm;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.enumeration.EnumerationDescription;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.method.ParameterList;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.TargetType;
import net.bytebuddy.dynamic.scaffold.FieldLocator;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.SuperMethodCall;
import net.bytebuddy.implementation.bytecode.Addition;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.Duplication;
import net.bytebuddy.implementation.bytecode.Removal;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.StackSize;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.collection.ArrayAccess;
import net.bytebuddy.implementation.bytecode.collection.ArrayFactory;
import net.bytebuddy.implementation.bytecode.constant.ClassConstant;
import net.bytebuddy.implementation.bytecode.constant.DefaultValue;
import net.bytebuddy.implementation.bytecode.constant.DoubleConstant;
import net.bytebuddy.implementation.bytecode.constant.FloatConstant;
import net.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import net.bytebuddy.implementation.bytecode.constant.LongConstant;
import net.bytebuddy.implementation.bytecode.constant.MethodConstant;
import net.bytebuddy.implementation.bytecode.constant.NullConstant;
import net.bytebuddy.implementation.bytecode.constant.SerializedConstant;
import net.bytebuddy.implementation.bytecode.constant.TextConstant;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.pool.TypePool;
import net.bytebuddy.utility.CompoundList;
import net.bytebuddy.utility.JavaType;
import net.bytebuddy.utility.visitor.ExceptionTableSensitiveMethodVisitor;
import net.bytebuddy.utility.visitor.LineNumberPrependingMethodVisitor;
import net.bytebuddy.utility.visitor.StackAwareMethodVisitor;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.TypePath;

public class Advice
implements AsmVisitorWrapper.ForDeclaredMethods.MethodVisitorWrapper,
Implementation {
    private static final ClassReader UNDEFINED = null;
    private static final MethodDescription.InDefinedShape INLINE_ENTER;
    private static final MethodDescription.InDefinedShape SUPPRESS_ENTER;
    private static final MethodDescription.InDefinedShape PREPEND_LINE_NUMBER;
    private static final MethodDescription.InDefinedShape SKIP_ON;
    private static final MethodDescription.InDefinedShape INLINE_EXIT;
    private static final MethodDescription.InDefinedShape SUPPRESS_EXIT;
    private static final MethodDescription.InDefinedShape ON_THROWABLE;
    private static final MethodDescription.InDefinedShape BACKUP_ARGUMENTS;
    private final Dispatcher.Resolved.ForMethodEnter methodEnter;
    private final Dispatcher.Resolved.ForMethodExit methodExit;
    private final Assigner assigner;
    private final StackManipulation exceptionHandler;
    private final Implementation delegate;

    protected Advice(Dispatcher.Resolved.ForMethodEnter methodEnter, Dispatcher.Resolved.ForMethodExit methodExit) {
        this(methodEnter, methodExit, Assigner.DEFAULT, Removal.of(TypeDescription.THROWABLE), SuperMethodCall.INSTANCE);
    }

    private Advice(Dispatcher.Resolved.ForMethodEnter methodEnter, Dispatcher.Resolved.ForMethodExit methodExit, Assigner assigner, StackManipulation exceptionHandler, Implementation delegate) {
        this.methodEnter = methodEnter;
        this.methodExit = methodExit;
        this.assigner = assigner;
        this.exceptionHandler = exceptionHandler;
        this.delegate = delegate;
    }

    public static Advice to(Class<?> advice) {
        return Advice.to(advice, ClassFileLocator.ForClassLoader.of(advice.getClassLoader()));
    }

    public static Advice to(Class<?> advice, ClassFileLocator classFileLocator) {
        return Advice.to((TypeDescription)new TypeDescription.ForLoadedType(advice), classFileLocator);
    }

    public static Advice to(TypeDescription advice) {
        return Advice.to(advice, (ClassFileLocator)ClassFileLocator.NoOp.INSTANCE);
    }

    public static Advice to(TypeDescription advice, ClassFileLocator classFileLocator) {
        return Advice.to(advice, classFileLocator, Collections.emptyList());
    }

    protected static Advice to(TypeDescription advice, ClassFileLocator classFileLocator, List<? extends OffsetMapping.Factory<?>> userFactories) {
        Dispatcher.Unresolved methodEnter = Dispatcher.Inactive.INSTANCE;
        Dispatcher.Unresolved methodExit = Dispatcher.Inactive.INSTANCE;
        for (MethodDescription.InDefinedShape methodDescription : advice.getDeclaredMethods()) {
            methodEnter = Advice.locate(OnMethodEnter.class, INLINE_ENTER, methodEnter, methodDescription);
            methodExit = Advice.locate(OnMethodExit.class, INLINE_EXIT, methodExit, methodDescription);
        }
        if (!methodEnter.isAlive() && !methodExit.isAlive()) {
            throw new IllegalArgumentException("No advice defined by " + advice);
        }
        try {
            ClassReader classReader = methodEnter.isBinary() || methodExit.isBinary() ? new ClassReader(classFileLocator.locate(advice.getName()).resolve()) : UNDEFINED;
            return new Advice(methodEnter.asMethodEnter(userFactories, classReader, methodExit), methodExit.asMethodExit(userFactories, classReader, methodEnter));
        }
        catch (IOException exception) {
            throw new IllegalStateException("Error reading class file of " + advice, exception);
        }
    }

    public static Advice to(Class<?> enterAdvice, Class<?> exitAdvice) {
        ClassLoader exitLoader;
        ClassLoader enterLoader = enterAdvice.getClassLoader();
        return Advice.to(enterAdvice, exitAdvice, enterLoader == (exitLoader = exitAdvice.getClassLoader()) ? ClassFileLocator.ForClassLoader.of(enterLoader) : new ClassFileLocator.Compound(ClassFileLocator.ForClassLoader.of(enterLoader), ClassFileLocator.ForClassLoader.of(exitLoader)));
    }

    public static Advice to(Class<?> enterAdvice, Class<?> exitAdvice, ClassFileLocator classFileLocator) {
        return Advice.to((TypeDescription)new TypeDescription.ForLoadedType(enterAdvice), new TypeDescription.ForLoadedType(exitAdvice), classFileLocator);
    }

    public static Advice to(TypeDescription enterAdvice, TypeDescription exitAdvice) {
        return Advice.to(enterAdvice, exitAdvice, (ClassFileLocator)ClassFileLocator.NoOp.INSTANCE);
    }

    public static Advice to(TypeDescription enterAdvice, TypeDescription exitAdvice, ClassFileLocator classFileLocator) {
        return Advice.to(enterAdvice, exitAdvice, classFileLocator, Collections.emptyList());
    }

    protected static Advice to(TypeDescription enterAdvice, TypeDescription exitAdvice, ClassFileLocator classFileLocator, List<? extends OffsetMapping.Factory<?>> userFactories) {
        Dispatcher.Unresolved methodEnter = Dispatcher.Inactive.INSTANCE;
        Dispatcher.Unresolved methodExit = Dispatcher.Inactive.INSTANCE;
        for (MethodDescription.InDefinedShape methodDescription : enterAdvice.getDeclaredMethods()) {
            methodEnter = Advice.locate(OnMethodEnter.class, INLINE_ENTER, methodEnter, methodDescription);
        }
        if (!methodEnter.isAlive()) {
            throw new IllegalArgumentException("No enter advice defined by " + enterAdvice);
        }
        for (MethodDescription.InDefinedShape methodDescription : exitAdvice.getDeclaredMethods()) {
            methodExit = Advice.locate(OnMethodExit.class, INLINE_EXIT, methodExit, methodDescription);
        }
        if (!methodExit.isAlive()) {
            throw new IllegalArgumentException("No enter advice defined by " + exitAdvice);
        }
        try {
            return new Advice(methodEnter.asMethodEnter(userFactories, methodEnter.isBinary() ? new ClassReader(classFileLocator.locate(enterAdvice.getName()).resolve()) : UNDEFINED, methodExit), methodExit.asMethodExit(userFactories, methodExit.isBinary() ? new ClassReader(classFileLocator.locate(exitAdvice.getName()).resolve()) : UNDEFINED, methodEnter));
        }
        catch (IOException exception) {
            throw new IllegalStateException("Error reading class file of " + enterAdvice + " or " + exitAdvice, exception);
        }
    }

    private static Dispatcher.Unresolved locate(Class<? extends Annotation> type, MethodDescription.InDefinedShape property, Dispatcher.Unresolved dispatcher, MethodDescription.InDefinedShape methodDescription) {
        AnnotationDescription.Loadable<? extends Annotation> annotation = methodDescription.getDeclaredAnnotations().ofType(type);
        if (annotation == null) {
            return dispatcher;
        }
        if (dispatcher.isAlive()) {
            throw new IllegalStateException("Duplicate advice for " + dispatcher + " and " + methodDescription);
        }
        if (!methodDescription.isStatic()) {
            throw new IllegalStateException("Advice for " + methodDescription + " is not static");
        }
        return annotation.getValue(property).resolve(Boolean.class) != false ? new Dispatcher.Inlining(methodDescription) : new Dispatcher.Delegating(methodDescription);
    }

    public static WithCustomMapping withCustomMapping() {
        return new WithCustomMapping();
    }

    public AsmVisitorWrapper.ForDeclaredMethods on(ElementMatcher<? super MethodDescription> matcher) {
        return new AsmVisitorWrapper.ForDeclaredMethods().method(matcher, this);
    }

    @Override
    public MethodVisitor wrap(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, TypePool typePool, int writerFlags, int readerFlags) {
        return instrumentedMethod.isAbstract() || instrumentedMethod.isNative() ? methodVisitor : this.doWrap(instrumentedType, instrumentedMethod, methodVisitor, implementationContext, writerFlags, readerFlags);
    }

    protected MethodVisitor doWrap(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, int writerFlags, int readerFlags) {
        MethodVisitor methodVisitor2 = methodVisitor = this.methodEnter.isPrependLineNumber() ? new LineNumberPrependingMethodVisitor(methodVisitor) : methodVisitor;
        if (!this.methodExit.isAlive()) {
            return new AdviceVisitor.WithoutExitAdvice(methodVisitor, implementationContext, this.assigner, this.exceptionHandler, instrumentedType, instrumentedMethod, this.methodEnter, writerFlags, readerFlags);
        }
        if (this.methodExit.getThrowable().represents((Type)((Object)NoExceptionHandler.class))) {
            return new AdviceVisitor.WithExitAdvice.WithoutExceptionHandling(methodVisitor, implementationContext, this.assigner, this.exceptionHandler, instrumentedType, instrumentedMethod, this.methodEnter, this.methodExit, writerFlags, readerFlags);
        }
        if (instrumentedMethod.isConstructor()) {
            throw new IllegalStateException("Cannot catch exception during constructor call for " + instrumentedMethod);
        }
        return new AdviceVisitor.WithExitAdvice.WithExceptionHandling(methodVisitor, implementationContext, this.assigner, this.exceptionHandler, instrumentedType, instrumentedMethod, this.methodEnter, this.methodExit, writerFlags, readerFlags, this.methodExit.getThrowable());
    }

    @Override
    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        return this.delegate.prepare(instrumentedType);
    }

    @Override
    public ByteCodeAppender appender(Implementation.Target implementationTarget) {
        return new Appender(this, implementationTarget, this.delegate.appender(implementationTarget));
    }

    public Advice withAssigner(Assigner assigner) {
        return new Advice(this.methodEnter, this.methodExit, assigner, this.exceptionHandler, this.delegate);
    }

    public Advice withExceptionPrinting() {
        try {
            return this.withExceptionHandler(MethodInvocation.invoke(new MethodDescription.ForLoadedMethod(Throwable.class.getMethod("printStackTrace", new Class[0]))));
        }
        catch (NoSuchMethodException exception) {
            throw new IllegalStateException("Cannot locate Throwable::printStackTrace");
        }
    }

    public Advice withExceptionHandler(StackManipulation exceptionHandler) {
        return new Advice(this.methodEnter, this.methodExit, this.assigner, exceptionHandler, this.delegate);
    }

    public Implementation wrap(Implementation implementation) {
        return new Advice(this.methodEnter, this.methodExit, this.assigner, this.exceptionHandler, implementation);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Advice)) {
            return false;
        }
        Advice other = (Advice)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Dispatcher.Resolved.ForMethodEnter this$methodEnter = this.methodEnter;
        Dispatcher.Resolved.ForMethodEnter other$methodEnter = other.methodEnter;
        if (this$methodEnter == null ? other$methodEnter != null : !this$methodEnter.equals(other$methodEnter)) {
            return false;
        }
        Dispatcher.Resolved.ForMethodExit this$methodExit = this.methodExit;
        Dispatcher.Resolved.ForMethodExit other$methodExit = other.methodExit;
        if (this$methodExit == null ? other$methodExit != null : !this$methodExit.equals(other$methodExit)) {
            return false;
        }
        Assigner this$assigner = this.assigner;
        Assigner other$assigner = other.assigner;
        if (this$assigner == null ? other$assigner != null : !this$assigner.equals(other$assigner)) {
            return false;
        }
        StackManipulation this$exceptionHandler = this.exceptionHandler;
        StackManipulation other$exceptionHandler = other.exceptionHandler;
        if (this$exceptionHandler == null ? other$exceptionHandler != null : !this$exceptionHandler.equals(other$exceptionHandler)) {
            return false;
        }
        Implementation this$delegate = this.delegate;
        Implementation other$delegate = other.delegate;
        return !(this$delegate == null ? other$delegate != null : !this$delegate.equals(other$delegate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Advice;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Dispatcher.Resolved.ForMethodEnter $methodEnter = this.methodEnter;
        result = result * 59 + ($methodEnter == null ? 43 : $methodEnter.hashCode());
        Dispatcher.Resolved.ForMethodExit $methodExit = this.methodExit;
        result = result * 59 + ($methodExit == null ? 43 : $methodExit.hashCode());
        Assigner $assigner = this.assigner;
        result = result * 59 + ($assigner == null ? 43 : $assigner.hashCode());
        StackManipulation $exceptionHandler = this.exceptionHandler;
        result = result * 59 + ($exceptionHandler == null ? 43 : $exceptionHandler.hashCode());
        Implementation $delegate = this.delegate;
        result = result * 59 + ($delegate == null ? 43 : $delegate.hashCode());
        return result;
    }

    static {
        MethodList<MethodDescription.InDefinedShape> enter = new TypeDescription.ForLoadedType(OnMethodEnter.class).getDeclaredMethods();
        INLINE_ENTER = (MethodDescription.InDefinedShape)((MethodList)enter.filter(ElementMatchers.named("inline"))).getOnly();
        SUPPRESS_ENTER = (MethodDescription.InDefinedShape)((MethodList)enter.filter(ElementMatchers.named("suppress"))).getOnly();
        SKIP_ON = (MethodDescription.InDefinedShape)((MethodList)enter.filter(ElementMatchers.named("skipOn"))).getOnly();
        PREPEND_LINE_NUMBER = (MethodDescription.InDefinedShape)((MethodList)enter.filter(ElementMatchers.named("prependLineNumber"))).getOnly();
        MethodList<MethodDescription.InDefinedShape> exit = new TypeDescription.ForLoadedType(OnMethodExit.class).getDeclaredMethods();
        INLINE_EXIT = (MethodDescription.InDefinedShape)((MethodList)exit.filter(ElementMatchers.named("inline"))).getOnly();
        SUPPRESS_EXIT = (MethodDescription.InDefinedShape)((MethodList)exit.filter(ElementMatchers.named("suppress"))).getOnly();
        ON_THROWABLE = (MethodDescription.InDefinedShape)((MethodList)exit.filter(ElementMatchers.named("onThrowable"))).getOnly();
        BACKUP_ARGUMENTS = (MethodDescription.InDefinedShape)((MethodList)exit.filter(ElementMatchers.named("backupArguments"))).getOnly();
    }

    public static final class OnNonDefaultValue {
        private OnNonDefaultValue() {
            throw new UnsupportedOperationException("This marker class is not supposed to be instantiated");
        }
    }

    public static final class OnDefaultValue {
        private OnDefaultValue() {
            throw new UnsupportedOperationException("This marker class is not supposed to be instantiated");
        }
    }

    private static class NoExceptionHandler
    extends Throwable {
        private static final TypeDescription DESCRIPTION = new TypeDescription.ForLoadedType(NoExceptionHandler.class);

        private NoExceptionHandler() {
            throw new UnsupportedOperationException("This marker class is not supposed to be instantiated");
        }
    }

    public static class WithCustomMapping {
        private final Map<Class<? extends Annotation>, OffsetMapping.Factory<?>> offsetMappings;

        protected WithCustomMapping() {
            this(Collections.emptyMap());
        }

        protected WithCustomMapping(Map<Class<? extends Annotation>, OffsetMapping.Factory<?>> offsetMappings) {
            this.offsetMappings = offsetMappings;
        }

        public <T extends Annotation> WithCustomMapping bind(Class<T> type, Object value) {
            return this.bind(OffsetMapping.ForStackManipulation.Factory.of(type, value));
        }

        public <T extends Annotation> WithCustomMapping bind(Class<T> type, Field field) {
            return this.bind(type, new FieldDescription.ForLoadedField(field));
        }

        public <T extends Annotation> WithCustomMapping bind(Class<T> type, FieldDescription fieldDescription) {
            return this.bind(new OffsetMapping.ForField.Resolved.Factory<T>(type, fieldDescription));
        }

        public <T extends Annotation> WithCustomMapping bind(Class<T> type, Method method, int index) {
            if (index < 0) {
                throw new IllegalArgumentException("A parameter cannot be negative: " + index);
            }
            if (method.getParameterTypes().length <= index) {
                throw new IllegalArgumentException(method + " does not declare a parameter with index " + index);
            }
            return this.bind(type, (ParameterDescription)new MethodDescription.ForLoadedMethod(method).getParameters().get(index));
        }

        public <T extends Annotation> WithCustomMapping bind(Class<T> type, Constructor<?> constructor, int index) {
            if (index < 0) {
                throw new IllegalArgumentException("A parameter cannot be negative: " + index);
            }
            if (constructor.getParameterTypes().length <= index) {
                throw new IllegalArgumentException(constructor + " does not declare a parameter with index " + index);
            }
            return this.bind(type, (ParameterDescription)new MethodDescription.ForLoadedConstructor(constructor).getParameters().get(index));
        }

        public <T extends Annotation> WithCustomMapping bind(Class<T> type, ParameterDescription parameterDescription) {
            return this.bind(new OffsetMapping.ForArgument.Resolved.Factory<T>(type, parameterDescription));
        }

        public <T extends Annotation> WithCustomMapping bind(Class<T> type, Class<?> value) {
            return this.bind(type, new TypeDescription.ForLoadedType(value));
        }

        public <T extends Annotation> WithCustomMapping bind(Class<T> type, TypeDescription value) {
            return this.bind(new OffsetMapping.ForStackManipulation.Factory<T>(type, value));
        }

        public <T extends Annotation> WithCustomMapping bind(Class<T> type, Enum<?> value) {
            return this.bind(type, new EnumerationDescription.ForLoadedEnumeration(value));
        }

        public <T extends Annotation> WithCustomMapping bind(Class<T> type, EnumerationDescription value) {
            return this.bind(new OffsetMapping.ForStackManipulation.Factory<T>(type, value));
        }

        public <T extends Annotation> WithCustomMapping bindSerialized(Class<T> type, Serializable value) {
            return this.bindSerialized(type, value, value.getClass());
        }

        public <T extends Annotation, S extends Serializable> WithCustomMapping bindSerialized(Class<T> type, S value, Class<? super S> targetType) {
            return this.bind(OffsetMapping.ForSerializedValue.Factory.of(type, value, targetType));
        }

        public <T extends Annotation> WithCustomMapping bindProperty(Class<T> type, String property) {
            return this.bind(OffsetMapping.ForStackManipulation.OfAnnotationProperty.of(type, property));
        }

        public <T extends Annotation> WithCustomMapping bind(Class<T> type, StackManipulation stackManipulation, Type targetType) {
            return this.bind(type, stackManipulation, TypeDefinition.Sort.describe(targetType));
        }

        public <T extends Annotation> WithCustomMapping bind(Class<T> type, StackManipulation stackManipulation, TypeDescription.Generic targetType) {
            return this.bind(new OffsetMapping.ForStackManipulation.Factory<T>(type, stackManipulation, targetType));
        }

        public <T extends Annotation> WithCustomMapping bind(Class<T> type, OffsetMapping offsetMapping) {
            return this.bind(new OffsetMapping.Factory.Simple<T>(type, offsetMapping));
        }

        public WithCustomMapping bind(OffsetMapping.Factory<?> offsetMapping) {
            HashMap offsetMappings = new HashMap(this.offsetMappings);
            if (!offsetMapping.getAnnotationType().isAnnotation()) {
                throw new IllegalArgumentException("Not an annotation type: " + offsetMapping.getAnnotationType());
            }
            if (offsetMappings.put(offsetMapping.getAnnotationType(), offsetMapping) != null) {
                throw new IllegalArgumentException("Annotation type already mapped: " + offsetMapping.getAnnotationType());
            }
            return new WithCustomMapping(offsetMappings);
        }

        public Advice to(Class<?> advice) {
            return this.to(advice, ClassFileLocator.ForClassLoader.of(advice.getClassLoader()));
        }

        public Advice to(Class<?> advice, ClassFileLocator classFileLocator) {
            return this.to((TypeDescription)new TypeDescription.ForLoadedType(advice), classFileLocator);
        }

        public Advice to(TypeDescription advice, ClassFileLocator classFileLocator) {
            return Advice.to(advice, classFileLocator, new ArrayList(this.offsetMappings.values()));
        }

        public Advice to(Class<?> enterAdvice, Class<?> exitAdvice) {
            ClassLoader exitLoader;
            ClassLoader enterLoader = enterAdvice.getClassLoader();
            return this.to(enterAdvice, exitAdvice, enterLoader == (exitLoader = exitAdvice.getClassLoader()) ? ClassFileLocator.ForClassLoader.of(enterLoader) : new ClassFileLocator.Compound(ClassFileLocator.ForClassLoader.of(enterLoader), ClassFileLocator.ForClassLoader.of(exitLoader)));
        }

        public Advice to(Class<?> enterAdvice, Class<?> exitAdvice, ClassFileLocator classFileLocator) {
            return this.to(new TypeDescription.ForLoadedType(enterAdvice), new TypeDescription.ForLoadedType(exitAdvice), classFileLocator);
        }

        public Advice to(TypeDescription enterAdvice, TypeDescription exitAdvice) {
            return this.to(enterAdvice, exitAdvice, (ClassFileLocator)ClassFileLocator.NoOp.INSTANCE);
        }

        public Advice to(TypeDescription enterAdvice, TypeDescription exitAdvice, ClassFileLocator classFileLocator) {
            return Advice.to(enterAdvice, exitAdvice, classFileLocator, new ArrayList(this.offsetMappings.values()));
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WithCustomMapping)) {
                return false;
            }
            WithCustomMapping other = (WithCustomMapping)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<Class<Annotation>, OffsetMapping.Factory<?>> this$offsetMappings = this.offsetMappings;
            Map<Class<? extends Annotation>, OffsetMapping.Factory<?>> other$offsetMappings = other.offsetMappings;
            return !(this$offsetMappings == null ? other$offsetMappings != null : !((Object)this$offsetMappings).equals(other$offsetMappings));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WithCustomMapping;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<Class<Annotation>, OffsetMapping.Factory<?>> $offsetMappings = this.offsetMappings;
            result = result * 59 + ($offsetMappings == null ? 43 : ((Object)$offsetMappings).hashCode());
            return result;
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Unused {
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface StubValue {
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Enter {
        public boolean readOnly() default true;

        public Assigner.Typing typing() default Assigner.Typing.STATIC;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Origin {
        public static final String DEFAULT = "";

        public String value() default "";
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface FieldValue {
        public String value();

        public Class<?> declaringType() default void.class;

        public boolean readOnly() default true;

        public Assigner.Typing typing() default Assigner.Typing.STATIC;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Thrown {
        public boolean readOnly() default true;

        public Assigner.Typing typing() default Assigner.Typing.DYNAMIC;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Return {
        public boolean readOnly() default true;

        public Assigner.Typing typing() default Assigner.Typing.STATIC;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface AllArguments {
        public boolean readOnly() default true;

        public Assigner.Typing typing() default Assigner.Typing.STATIC;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface Argument {
        public int value();

        public boolean readOnly() default true;

        public Assigner.Typing typing() default Assigner.Typing.STATIC;

        public boolean optional() default false;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface This {
        public boolean optional() default false;

        public boolean readOnly() default true;

        public Assigner.Typing typing() default Assigner.Typing.STATIC;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface OnMethodExit {
        public Class<? extends Throwable> onThrowable() default NoExceptionHandler.class;

        public boolean backupArguments() default true;

        public boolean inline() default true;

        public Class<? extends Throwable> suppress() default NoExceptionHandler.class;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface OnMethodEnter {
        public Class<?> skipOn() default void.class;

        public boolean prependLineNumber() default true;

        public boolean inline() default true;

        public Class<? extends Throwable> suppress() default NoExceptionHandler.class;
    }

    protected static class Appender
    implements ByteCodeAppender {
        private final Advice advice;
        private final Implementation.Target implementationTarget;
        private final ByteCodeAppender delegate;

        protected Appender(Advice advice, Implementation.Target implementationTarget, ByteCodeAppender delegate) {
            this.advice = advice;
            this.implementationTarget = implementationTarget;
            this.delegate = delegate;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            EmulatingMethodVisitor emulatingMethodVisitor = new EmulatingMethodVisitor(methodVisitor, this.delegate);
            methodVisitor = this.advice.doWrap(this.implementationTarget.getInstrumentedType(), instrumentedMethod, emulatingMethodVisitor, implementationContext, 0, 0);
            return emulatingMethodVisitor.resolve(methodVisitor, implementationContext, instrumentedMethod);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Appender)) {
                return false;
            }
            Appender other = (Appender)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Advice this$advice = this.advice;
            Advice other$advice = other.advice;
            if (this$advice == null ? other$advice != null : !((Object)this$advice).equals(other$advice)) {
                return false;
            }
            Implementation.Target this$implementationTarget = this.implementationTarget;
            Implementation.Target other$implementationTarget = other.implementationTarget;
            if (this$implementationTarget == null ? other$implementationTarget != null : !this$implementationTarget.equals(other$implementationTarget)) {
                return false;
            }
            ByteCodeAppender this$delegate = this.delegate;
            ByteCodeAppender other$delegate = other.delegate;
            return !(this$delegate == null ? other$delegate != null : !this$delegate.equals(other$delegate));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Appender;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Advice $advice = this.advice;
            result = result * 59 + ($advice == null ? 43 : ((Object)$advice).hashCode());
            Implementation.Target $implementationTarget = this.implementationTarget;
            result = result * 59 + ($implementationTarget == null ? 43 : $implementationTarget.hashCode());
            ByteCodeAppender $delegate = this.delegate;
            result = result * 59 + ($delegate == null ? 43 : $delegate.hashCode());
            return result;
        }

        protected static class EmulatingMethodVisitor
        extends MethodVisitor {
            private final ByteCodeAppender delegate;
            private int stackSize;
            private int localVariableLength;

            protected EmulatingMethodVisitor(MethodVisitor methodVisitor, ByteCodeAppender delegate) {
                super(393216, methodVisitor);
                this.delegate = delegate;
            }

            protected ByteCodeAppender.Size resolve(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                methodVisitor.visitCode();
                ByteCodeAppender.Size size = this.delegate.apply(methodVisitor, implementationContext, instrumentedMethod);
                methodVisitor.visitMaxs(size.getOperandStackSize(), size.getLocalVariableSize());
                methodVisitor.visitEnd();
                return new ByteCodeAppender.Size(this.stackSize, this.localVariableLength);
            }

            public void visitCode() {
            }

            public void visitMaxs(int stackSize, int localVariableLength) {
                this.stackSize = stackSize;
                this.localVariableLength = localVariableLength;
            }

            public void visitEnd() {
            }
        }
    }

    protected static abstract class AdviceVisitor
    extends ExceptionTableSensitiveMethodVisitor
    implements Dispatcher.RelocationHandler.Relocation {
        protected final MethodVisitor methodVisitor;
        protected final MethodDescription instrumentedMethod;
        private final Dispatcher.Bound methodEnter;
        protected final Dispatcher.Bound methodExit;
        protected final ArgumentHandler.ForInstrumentedMethod argumentHandler;
        protected final MethodSizeHandler.ForInstrumentedMethod methodSizeHandler;
        protected final StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler;

        protected AdviceVisitor(MethodVisitor methodVisitor, MethodVisitor delegate, Implementation.Context implementationContext, Assigner assigner, StackManipulation exceptionHandler, TypeDescription instrumentedType, MethodDescription instrumentedMethod, Dispatcher.Resolved.ForMethodEnter methodEnter, Dispatcher.Resolved.ForMethodExit methodExit, List<? extends TypeDescription> exitTypes, int writerFlags, int readerFlags) {
            super(393216, delegate);
            this.methodVisitor = methodVisitor;
            this.instrumentedMethod = instrumentedMethod;
            List enterTypes = methodEnter.getEnterType().represents(Void.TYPE) ? Collections.emptyList() : Collections.singletonList(methodEnter.getEnterType().asErasure());
            this.argumentHandler = methodExit.getArgumentHandlerFactory().resolve(instrumentedMethod, methodEnter.getEnterType());
            this.methodSizeHandler = MethodSizeHandler.Default.of(instrumentedMethod, enterTypes, exitTypes, this.argumentHandler.isCopyingArguments(), writerFlags);
            this.stackMapFrameHandler = StackMapFrameHandler.Default.of(instrumentedType, instrumentedMethod, enterTypes, exitTypes, methodExit.isAlive(), this.argumentHandler.isCopyingArguments(), implementationContext.getClassFileVersion(), writerFlags, readerFlags);
            this.methodEnter = methodEnter.bind(instrumentedType, instrumentedMethod, methodVisitor, implementationContext, assigner, this.argumentHandler, this.methodSizeHandler, this.stackMapFrameHandler, exceptionHandler, this);
            this.methodExit = methodExit.bind(instrumentedType, instrumentedMethod, methodVisitor, implementationContext, assigner, this.argumentHandler, this.methodSizeHandler, this.stackMapFrameHandler, exceptionHandler, Dispatcher.RelocationHandler.Relocation.Illegal.INSTANCE);
        }

        @Override
        protected void onAfterExceptionTable() {
            this.methodEnter.prepare();
            this.onUserPrepare();
            this.methodExit.prepare();
            this.methodEnter.apply();
            this.methodSizeHandler.requireStackSize(this.argumentHandler.prepare(this.methodVisitor));
            this.stackMapFrameHandler.injectStartFrame(this.methodVisitor);
            this.onUserStart();
        }

        protected abstract void onUserPrepare();

        protected abstract void onUserStart();

        @Override
        protected void onVisitVarInsn(int opcode, int offset) {
            this.mv.visitVarInsn(opcode, this.argumentHandler.argument(offset));
        }

        @Override
        protected void onVisitIincInsn(int offset, int increment) {
            this.mv.visitIincInsn(this.argumentHandler.argument(offset), increment);
        }

        public void visitFrame(int type, int localVariableLength, Object[] localVariable, int stackSize, Object[] stack) {
            this.stackMapFrameHandler.translateFrame(this.methodVisitor, type, localVariableLength, localVariable, stackSize, stack);
        }

        public void visitMaxs(int stackSize, int localVariableLength) {
            this.onUserEnd();
            this.methodVisitor.visitMaxs(this.methodSizeHandler.compoundStackSize(stackSize), this.methodSizeHandler.compoundLocalVariableLength(localVariableLength));
        }

        public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
            this.mv.visitLocalVariable(name, descriptor, signature, start, end, this.argumentHandler.variable(index));
        }

        public AnnotationVisitor visitLocalVariableAnnotation(int typeReference, TypePath typePath, Label[] start, Label[] end, int[] index, String descriptor, boolean visible) {
            int[] translated = new int[index.length];
            for (int anIndex = 0; anIndex < index.length; ++anIndex) {
                translated[anIndex] = this.argumentHandler.variable(index[anIndex]);
            }
            return this.mv.visitLocalVariableAnnotation(typeReference, typePath, start, end, translated, descriptor, visible);
        }

        protected abstract void onUserEnd();

        protected static abstract class WithExitAdvice
        extends AdviceVisitor {
            protected final Label returnHandler = new Label();
            protected boolean doesReturn = false;

            protected WithExitAdvice(MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, StackManipulation exceptionHandler, TypeDescription instrumentedType, MethodDescription instrumentedMethod, Dispatcher.Resolved.ForMethodEnter methodEnter, Dispatcher.Resolved.ForMethodExit methodExit, List<? extends TypeDescription> exitTypes, int writerFlags, int readerFlags) {
                super(methodVisitor, new StackAwareMethodVisitor(methodVisitor, instrumentedMethod), implementationContext, assigner, exceptionHandler, instrumentedType, instrumentedMethod, methodEnter, methodExit, exitTypes, writerFlags, readerFlags);
            }

            @Override
            public void apply(MethodVisitor methodVisitor) {
                if (this.instrumentedMethod.getReturnType().represents(Boolean.TYPE) || this.instrumentedMethod.getReturnType().represents(Byte.TYPE) || this.instrumentedMethod.getReturnType().represents(Short.TYPE) || this.instrumentedMethod.getReturnType().represents(Character.TYPE) || this.instrumentedMethod.getReturnType().represents(Integer.TYPE)) {
                    methodVisitor.visitInsn(3);
                } else if (this.instrumentedMethod.getReturnType().represents(Long.TYPE)) {
                    methodVisitor.visitInsn(9);
                } else if (this.instrumentedMethod.getReturnType().represents(Float.TYPE)) {
                    methodVisitor.visitInsn(11);
                } else if (this.instrumentedMethod.getReturnType().represents(Double.TYPE)) {
                    methodVisitor.visitInsn(14);
                } else if (!this.instrumentedMethod.getReturnType().represents(Void.TYPE)) {
                    methodVisitor.visitInsn(1);
                }
                methodVisitor.visitJumpInsn(167, this.returnHandler);
                this.doesReturn = true;
            }

            @Override
            protected void onVisitInsn(int opcode) {
                switch (opcode) {
                    case 177: {
                        ((StackAwareMethodVisitor)this.mv).drainStack();
                        break;
                    }
                    case 172: {
                        this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(54, 21, StackSize.SINGLE));
                        break;
                    }
                    case 174: {
                        this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(56, 23, StackSize.SINGLE));
                        break;
                    }
                    case 175: {
                        this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(57, 24, StackSize.DOUBLE));
                        break;
                    }
                    case 173: {
                        this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(55, 22, StackSize.DOUBLE));
                        break;
                    }
                    case 176: {
                        this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(58, 25, StackSize.SINGLE));
                        break;
                    }
                    default: {
                        this.mv.visitInsn(opcode);
                        return;
                    }
                }
                this.mv.visitJumpInsn(167, this.returnHandler);
                this.doesReturn = true;
            }

            @Override
            protected void onUserEnd() {
                org.objectweb.asm.Type returnType = org.objectweb.asm.Type.getType((String)this.instrumentedMethod.getReturnType().asErasure().getDescriptor());
                this.methodVisitor.visitLabel(this.returnHandler);
                if (this.doesReturn) {
                    this.stackMapFrameHandler.injectReturnFrame(this.methodVisitor);
                    if (!returnType.equals((Object)org.objectweb.asm.Type.VOID_TYPE)) {
                        this.methodVisitor.visitVarInsn(returnType.getOpcode(54), this.argumentHandler.returned());
                    }
                }
                this.onUserReturn();
                this.methodExit.apply();
                this.onExitAdviceReturn();
                if (returnType.equals((Object)org.objectweb.asm.Type.VOID_TYPE)) {
                    this.methodVisitor.visitInsn(177);
                } else {
                    this.methodVisitor.visitVarInsn(returnType.getOpcode(21), this.argumentHandler.returned());
                    this.methodVisitor.visitInsn(returnType.getOpcode(172));
                }
            }

            protected abstract void onUserReturn();

            protected abstract void onExitAdviceReturn();

            protected static class WithExceptionHandling
            extends WithExitAdvice {
                private final TypeDescription throwable;
                private final Label userStart;
                private final Label exceptionHandler;

                protected WithExceptionHandling(MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, StackManipulation exceptionHandler, TypeDescription instrumentedType, MethodDescription instrumentedMethod, Dispatcher.Resolved.ForMethodEnter methodEnter, Dispatcher.Resolved.ForMethodExit methodExit, int writerFlags, int readerFlags, TypeDescription throwable) {
                    super(methodVisitor, implementationContext, assigner, exceptionHandler, instrumentedType, instrumentedMethod, methodEnter, methodExit, instrumentedMethod.getReturnType().represents(Void.TYPE) ? Collections.singletonList(TypeDescription.THROWABLE) : Arrays.asList(instrumentedMethod.getReturnType().asErasure(), TypeDescription.THROWABLE), writerFlags, readerFlags);
                    this.throwable = throwable;
                    this.userStart = new Label();
                    this.exceptionHandler = new Label();
                }

                @Override
                protected void onUserPrepare() {
                    this.methodVisitor.visitTryCatchBlock(this.userStart, this.returnHandler, this.exceptionHandler, this.throwable.getInternalName());
                }

                @Override
                protected void onUserStart() {
                    this.methodVisitor.visitLabel(this.userStart);
                }

                @Override
                protected void onUserReturn() {
                    Label endOfHandler = new Label();
                    if (this.doesReturn) {
                        this.methodVisitor.visitInsn(1);
                        this.methodVisitor.visitVarInsn(58, this.argumentHandler.thrown());
                        this.methodVisitor.visitJumpInsn(167, endOfHandler);
                    }
                    this.methodVisitor.visitLabel(this.exceptionHandler);
                    this.stackMapFrameHandler.injectExceptionFrame(this.methodVisitor);
                    this.methodVisitor.visitVarInsn(58, this.argumentHandler.thrown());
                    this.storeDefaultReturn();
                    if (this.doesReturn) {
                        this.methodVisitor.visitLabel(endOfHandler);
                    }
                    this.stackMapFrameHandler.injectCompletionFrame(this.methodVisitor, false);
                }

                @Override
                protected void onExitAdviceReturn() {
                    this.methodVisitor.visitVarInsn(25, this.argumentHandler.thrown());
                    Label endOfHandler = new Label();
                    this.methodVisitor.visitJumpInsn(198, endOfHandler);
                    this.methodVisitor.visitVarInsn(25, this.argumentHandler.thrown());
                    this.methodVisitor.visitInsn(191);
                    this.methodVisitor.visitLabel(endOfHandler);
                    this.stackMapFrameHandler.injectCompletionFrame(this.methodVisitor, true);
                }

                private void storeDefaultReturn() {
                    if (this.instrumentedMethod.getReturnType().represents(Boolean.TYPE) || this.instrumentedMethod.getReturnType().represents(Byte.TYPE) || this.instrumentedMethod.getReturnType().represents(Short.TYPE) || this.instrumentedMethod.getReturnType().represents(Character.TYPE) || this.instrumentedMethod.getReturnType().represents(Integer.TYPE)) {
                        this.methodVisitor.visitInsn(3);
                        this.methodVisitor.visitVarInsn(54, this.argumentHandler.returned());
                    } else if (this.instrumentedMethod.getReturnType().represents(Long.TYPE)) {
                        this.methodVisitor.visitInsn(9);
                        this.methodVisitor.visitVarInsn(55, this.argumentHandler.returned());
                    } else if (this.instrumentedMethod.getReturnType().represents(Float.TYPE)) {
                        this.methodVisitor.visitInsn(11);
                        this.methodVisitor.visitVarInsn(56, this.argumentHandler.returned());
                    } else if (this.instrumentedMethod.getReturnType().represents(Double.TYPE)) {
                        this.methodVisitor.visitInsn(14);
                        this.methodVisitor.visitVarInsn(57, this.argumentHandler.returned());
                    } else if (!this.instrumentedMethod.getReturnType().represents(Void.TYPE)) {
                        this.methodVisitor.visitInsn(1);
                        this.methodVisitor.visitVarInsn(58, this.argumentHandler.returned());
                    }
                }
            }

            protected static class WithoutExceptionHandling
            extends WithExitAdvice {
                protected WithoutExceptionHandling(MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, StackManipulation exceptionHandler, TypeDescription instrumentedType, MethodDescription instrumentedMethod, Dispatcher.Resolved.ForMethodEnter methodEnter, Dispatcher.Resolved.ForMethodExit methodExit, int writerFlags, int readerFlags) {
                    super(methodVisitor, implementationContext, assigner, exceptionHandler, instrumentedType, instrumentedMethod, methodEnter, methodExit, instrumentedMethod.getReturnType().represents(Void.TYPE) ? Collections.emptyList() : Collections.singletonList(instrumentedMethod.getReturnType().asErasure()), writerFlags, readerFlags);
                }

                @Override
                protected void onUserPrepare() {
                }

                @Override
                protected void onUserStart() {
                }

                @Override
                protected void onUserReturn() {
                    if (!this.doesReturn || !this.instrumentedMethod.getReturnType().represents(Void.TYPE)) {
                        this.stackMapFrameHandler.injectCompletionFrame(this.methodVisitor, false);
                    }
                }

                @Override
                protected void onExitAdviceReturn() {
                }
            }
        }

        protected static class WithoutExitAdvice
        extends AdviceVisitor {
            protected WithoutExitAdvice(MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, StackManipulation exceptionHandler, TypeDescription instrumentedType, MethodDescription instrumentedMethod, Dispatcher.Resolved.ForMethodEnter methodEnter, int writerFlags, int readerFlags) {
                super(methodVisitor, methodVisitor, implementationContext, assigner, exceptionHandler, instrumentedType, instrumentedMethod, methodEnter, Dispatcher.Inactive.INSTANCE, Collections.emptyList(), writerFlags, readerFlags);
            }

            @Override
            protected void onUserPrepare() {
            }

            @Override
            protected void onUserStart() {
            }

            @Override
            protected void onUserEnd() {
            }

            @Override
            public void apply(MethodVisitor methodVisitor) {
                if (this.instrumentedMethod.getReturnType().represents(Boolean.TYPE) || this.instrumentedMethod.getReturnType().represents(Byte.TYPE) || this.instrumentedMethod.getReturnType().represents(Short.TYPE) || this.instrumentedMethod.getReturnType().represents(Character.TYPE) || this.instrumentedMethod.getReturnType().represents(Integer.TYPE)) {
                    methodVisitor.visitInsn(3);
                    methodVisitor.visitInsn(172);
                } else if (this.instrumentedMethod.getReturnType().represents(Long.TYPE)) {
                    methodVisitor.visitInsn(9);
                    methodVisitor.visitInsn(173);
                } else if (this.instrumentedMethod.getReturnType().represents(Float.TYPE)) {
                    methodVisitor.visitInsn(11);
                    methodVisitor.visitInsn(174);
                } else if (this.instrumentedMethod.getReturnType().represents(Double.TYPE)) {
                    methodVisitor.visitInsn(14);
                    methodVisitor.visitInsn(175);
                } else if (this.instrumentedMethod.getReturnType().represents(Void.TYPE)) {
                    methodVisitor.visitInsn(177);
                } else {
                    methodVisitor.visitInsn(1);
                    methodVisitor.visitInsn(176);
                }
            }
        }
    }

    protected static interface Dispatcher {
        public static final MethodVisitor IGNORE_METHOD = null;
        public static final AnnotationVisitor IGNORE_ANNOTATION = null;

        public boolean isAlive();

        public static class Delegating
        implements Unresolved {
            protected final MethodDescription.InDefinedShape adviceMethod;

            protected Delegating(MethodDescription.InDefinedShape adviceMethod) {
                this.adviceMethod = adviceMethod;
            }

            @Override
            public boolean isAlive() {
                return true;
            }

            @Override
            public boolean isBinary() {
                return false;
            }

            @Override
            public TypeDescription getAdviceType() {
                return this.adviceMethod.getReturnType().asErasure();
            }

            @Override
            public net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodEnter asMethodEnter(List<? extends OffsetMapping.Factory<?>> userFactories, ClassReader classReader, Unresolved methodExit) {
                return Resolved.ForMethodEnter.of(this.adviceMethod, userFactories, methodExit.isAlive());
            }

            @Override
            public net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodExit asMethodExit(List<? extends OffsetMapping.Factory<?>> userFactories, ClassReader classReader, Unresolved methodEnter) {
                return Resolved.ForMethodExit.of(this.adviceMethod, userFactories, methodEnter.getAdviceType());
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Delegating)) {
                    return false;
                }
                Delegating other = (Delegating)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                MethodDescription.InDefinedShape this$adviceMethod = this.adviceMethod;
                MethodDescription.InDefinedShape other$adviceMethod = other.adviceMethod;
                return !(this$adviceMethod == null ? other$adviceMethod != null : !this$adviceMethod.equals(other$adviceMethod));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Delegating;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                MethodDescription.InDefinedShape $adviceMethod = this.adviceMethod;
                result = result * 59 + ($adviceMethod == null ? 43 : $adviceMethod.hashCode());
                return result;
            }

            protected static abstract class Resolved
            extends Resolved.AbstractBase {
                protected Resolved(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory<?>> factories, TypeDescription throwableType, TypeDescription relocatableType) {
                    super(adviceMethod, factories, throwableType, relocatableType, OffsetMapping.Factory.AdviceType.DELEGATION);
                }

                @Override
                public Bound bind(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, ArgumentHandler.ForInstrumentedMethod argumentHandler, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, StackManipulation exceptionHandler, RelocationHandler.Relocation relocation) {
                    if (!this.adviceMethod.isVisibleTo(instrumentedType)) {
                        throw new IllegalStateException(this.adviceMethod + " is not visible to " + instrumentedMethod.getDeclaringType());
                    }
                    return this.resolve(instrumentedType, instrumentedMethod, methodVisitor, implementationContext, assigner, argumentHandler, methodSizeHandler, stackMapFrameHandler, exceptionHandler, relocation);
                }

                protected abstract Bound resolve(TypeDescription var1, MethodDescription var2, MethodVisitor var3, Implementation.Context var4, Assigner var5, ArgumentHandler.ForInstrumentedMethod var6, MethodSizeHandler.ForInstrumentedMethod var7, StackMapFrameHandler.ForInstrumentedMethod var8, StackManipulation var9, RelocationHandler.Relocation var10);

                protected static abstract class ForMethodExit
                extends Resolved
                implements net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodExit {
                    private final TypeDefinition enterType;
                    private final boolean backupArguments;

                    protected ForMethodExit(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory<?>> userFactories, TypeDefinition enterType) {
                        super(adviceMethod, CompoundList.of(Arrays.asList(OffsetMapping.ForArgument.Unresolved.Factory.INSTANCE, OffsetMapping.ForAllArguments.Factory.INSTANCE, OffsetMapping.ForThisReference.Factory.INSTANCE, OffsetMapping.ForField.Unresolved.Factory.INSTANCE, OffsetMapping.ForOrigin.Factory.INSTANCE, OffsetMapping.ForUnusedValue.Factory.INSTANCE, OffsetMapping.ForStubValue.INSTANCE, new OffsetMapping.ForEnterValue.Factory(enterType), OffsetMapping.ForReturnValue.Factory.INSTANCE, OffsetMapping.ForThrowable.Factory.of(adviceMethod)), userFactories), adviceMethod.getDeclaredAnnotations().ofType(OnMethodExit.class).getValue(SUPPRESS_EXIT).resolve(TypeDescription.class), TypeDescription.VOID);
                        this.enterType = enterType;
                        this.backupArguments = adviceMethod.getDeclaredAnnotations().ofType(OnMethodExit.class).getValue(BACKUP_ARGUMENTS).resolve(Boolean.class);
                    }

                    protected static net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodExit of(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory<?>> userFactories, TypeDefinition enterType) {
                        TypeDescription throwable = adviceMethod.getDeclaredAnnotations().ofType(OnMethodExit.class).getValue(ON_THROWABLE).resolve(TypeDescription.class);
                        return throwable.represents((Type)((Object)NoExceptionHandler.class)) ? new WithoutExceptionHandler(adviceMethod, userFactories, enterType) : new WithExceptionHandler(adviceMethod, userFactories, enterType, throwable);
                    }

                    @Override
                    protected Bound resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, ArgumentHandler.ForInstrumentedMethod argumentHandler, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, StackManipulation exceptionHandler, RelocationHandler.Relocation relocation) {
                        ArrayList<OffsetMapping.Target> offsetMappings = new ArrayList<OffsetMapping.Target>(this.offsetMappings.size());
                        for (OffsetMapping offsetMapping : this.offsetMappings.values()) {
                            offsetMappings.add(offsetMapping.resolve(instrumentedType, instrumentedMethod, assigner, argumentHandler.bindExit(this.adviceMethod, this.getThrowable().represents((Type)((Object)NoExceptionHandler.class))), OffsetMapping.Sort.EXIT));
                        }
                        return new AdviceMethodWriter.ForMethodExit(this.adviceMethod, offsetMappings, methodVisitor, implementationContext, argumentHandler.bindExit(this.adviceMethod, this.getThrowable().represents((Type)((Object)NoExceptionHandler.class))), methodSizeHandler.bindExit(this.adviceMethod, this.getThrowable().represents((Type)((Object)NoExceptionHandler.class))), stackMapFrameHandler.bindExit(this.adviceMethod), this.suppressionHandler.bind(exceptionHandler), this.relocationHandler.bind(instrumentedMethod, relocation));
                    }

                    @Override
                    public ArgumentHandler.Factory getArgumentHandlerFactory() {
                        return this.backupArguments ? ArgumentHandler.Factory.COPYING : ArgumentHandler.Factory.SIMPLE;
                    }

                    @Override
                    public boolean equals(Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null || this.getClass() != object.getClass()) {
                            return false;
                        }
                        if (!super.equals(object)) {
                            return false;
                        }
                        ForMethodExit that = (ForMethodExit)object;
                        return this.enterType.equals(that.enterType);
                    }

                    @Override
                    public int hashCode() {
                        int result = super.hashCode();
                        result = 31 * result + this.enterType.hashCode();
                        return result;
                    }

                    protected static class WithoutExceptionHandler
                    extends ForMethodExit {
                        protected WithoutExceptionHandler(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory<?>> userFactories, TypeDefinition enterType) {
                            super(adviceMethod, userFactories, enterType);
                        }

                        @Override
                        public TypeDescription getThrowable() {
                            return NoExceptionHandler.DESCRIPTION;
                        }
                    }

                    protected static class WithExceptionHandler
                    extends ForMethodExit {
                        private final TypeDescription throwable;

                        protected WithExceptionHandler(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory<?>> userFactories, TypeDefinition enterType, TypeDescription throwable) {
                            super(adviceMethod, userFactories, enterType);
                            this.throwable = throwable;
                        }

                        @Override
                        public TypeDescription getThrowable() {
                            return this.throwable;
                        }

                        @Override
                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof WithExceptionHandler)) {
                                return false;
                            }
                            WithExceptionHandler other = (WithExceptionHandler)o;
                            if (!other.canEqual(this)) {
                                return false;
                            }
                            if (!super.equals(o)) {
                                return false;
                            }
                            TypeDescription this$throwable = this.getThrowable();
                            TypeDescription other$throwable = other.getThrowable();
                            return !(this$throwable == null ? other$throwable != null : !this$throwable.equals(other$throwable));
                        }

                        @Override
                        protected boolean canEqual(Object other) {
                            return other instanceof WithExceptionHandler;
                        }

                        @Override
                        public int hashCode() {
                            int PRIME = 59;
                            int result = super.hashCode();
                            TypeDescription $throwable = this.getThrowable();
                            result = result * 59 + ($throwable == null ? 43 : $throwable.hashCode());
                            return result;
                        }
                    }
                }

                protected static abstract class ForMethodEnter
                extends Resolved
                implements net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodEnter {
                    private final boolean prependLineNumber;

                    protected ForMethodEnter(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory<?>> userFactories) {
                        super(adviceMethod, CompoundList.of(Arrays.asList(OffsetMapping.ForArgument.Unresolved.Factory.INSTANCE, OffsetMapping.ForAllArguments.Factory.INSTANCE, OffsetMapping.ForThisReference.Factory.INSTANCE, OffsetMapping.ForField.Unresolved.Factory.INSTANCE, OffsetMapping.ForOrigin.Factory.INSTANCE, OffsetMapping.ForUnusedValue.Factory.INSTANCE, OffsetMapping.ForStubValue.INSTANCE, new OffsetMapping.Factory.Illegal<Thrown>(Thrown.class), new OffsetMapping.Factory.Illegal<Enter>(Enter.class), new OffsetMapping.Factory.Illegal<Return>(Return.class)), userFactories), adviceMethod.getDeclaredAnnotations().ofType(OnMethodEnter.class).getValue(SUPPRESS_ENTER).resolve(TypeDescription.class), adviceMethod.getDeclaredAnnotations().ofType(OnMethodEnter.class).getValue(SKIP_ON).resolve(TypeDescription.class));
                        this.prependLineNumber = adviceMethod.getDeclaredAnnotations().ofType(OnMethodEnter.class).getValue(PREPEND_LINE_NUMBER).resolve(Boolean.class);
                    }

                    protected static net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodEnter of(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory<?>> userFactories, boolean methodExit) {
                        return methodExit ? new WithRetainedEnterType(adviceMethod, userFactories) : new WithDiscardedEnterType(adviceMethod, userFactories);
                    }

                    @Override
                    public boolean isPrependLineNumber() {
                        return this.prependLineNumber;
                    }

                    @Override
                    protected Bound resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, ArgumentHandler.ForInstrumentedMethod argumentHandler, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, StackManipulation exceptionHandler, RelocationHandler.Relocation relocation) {
                        ArrayList<OffsetMapping.Target> offsetMappings = new ArrayList<OffsetMapping.Target>(this.offsetMappings.size());
                        for (OffsetMapping offsetMapping : this.offsetMappings.values()) {
                            offsetMappings.add(offsetMapping.resolve(instrumentedType, instrumentedMethod, assigner, argumentHandler.bindEnter(this.adviceMethod), OffsetMapping.Sort.ENTER));
                        }
                        return new AdviceMethodWriter.ForMethodEnter(this.adviceMethod, offsetMappings, methodVisitor, implementationContext, argumentHandler.bindEnter(this.adviceMethod), methodSizeHandler.bindEnter(this.adviceMethod), stackMapFrameHandler.bindEnter(this.adviceMethod), this.suppressionHandler.bind(exceptionHandler), this.relocationHandler.bind(instrumentedMethod, relocation));
                    }

                    @Override
                    public boolean equals(Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null || this.getClass() != object.getClass()) {
                            return false;
                        }
                        if (!super.equals(object)) {
                            return false;
                        }
                        ForMethodEnter that = (ForMethodEnter)object;
                        return this.prependLineNumber == that.prependLineNumber && this.relocationHandler.equals(that.relocationHandler);
                    }

                    @Override
                    public int hashCode() {
                        int result = super.hashCode();
                        result = 31 * result + this.relocationHandler.hashCode();
                        result = 31 * result + (this.prependLineNumber ? 1 : 0);
                        return result;
                    }

                    protected static class WithDiscardedEnterType
                    extends ForMethodEnter {
                        protected WithDiscardedEnterType(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory<?>> userFactories) {
                            super(adviceMethod, userFactories);
                        }

                        @Override
                        public TypeDefinition getEnterType() {
                            return TypeDescription.VOID;
                        }
                    }

                    protected static class WithRetainedEnterType
                    extends ForMethodEnter {
                        protected WithRetainedEnterType(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory<?>> userFactories) {
                            super(adviceMethod, userFactories);
                        }

                        @Override
                        public TypeDefinition getEnterType() {
                            return this.adviceMethod.getReturnType();
                        }
                    }
                }

                protected static abstract class AdviceMethodWriter
                implements Bound,
                SuppressionHandler.ReturnValueProducer {
                    private static final int EMPTY = 0;
                    protected final MethodDescription.InDefinedShape adviceMethod;
                    private final List<OffsetMapping.Target> offsetMappings;
                    protected final MethodVisitor methodVisitor;
                    protected final Implementation.Context implementationContext;
                    protected final ArgumentHandler.ForAdvice argumentHandler;
                    protected final MethodSizeHandler.ForAdvice methodSizeHandler;
                    protected final StackMapFrameHandler.ForAdvice stackMapFrameHandler;
                    private final SuppressionHandler.Bound suppressionHandler;
                    private final RelocationHandler.Bound relocationHandler;

                    protected AdviceMethodWriter(MethodDescription.InDefinedShape adviceMethod, List<OffsetMapping.Target> offsetMappings, MethodVisitor methodVisitor, Implementation.Context implementationContext, ArgumentHandler.ForAdvice argumentHandler, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, SuppressionHandler.Bound suppressionHandler, RelocationHandler.Bound relocationHandler) {
                        this.adviceMethod = adviceMethod;
                        this.offsetMappings = offsetMappings;
                        this.methodVisitor = methodVisitor;
                        this.implementationContext = implementationContext;
                        this.argumentHandler = argumentHandler;
                        this.methodSizeHandler = methodSizeHandler;
                        this.stackMapFrameHandler = stackMapFrameHandler;
                        this.suppressionHandler = suppressionHandler;
                        this.relocationHandler = relocationHandler;
                    }

                    @Override
                    public void prepare() {
                        this.suppressionHandler.onPrepare(this.methodVisitor);
                    }

                    @Override
                    public void apply() {
                        this.suppressionHandler.onStart(this.methodVisitor);
                        int index = 0;
                        int currentStackSize = 0;
                        int maximumStackSize = 0;
                        for (OffsetMapping.Target offsetMapping : this.offsetMappings) {
                            maximumStackSize = Math.max(maximumStackSize, (currentStackSize += ((ParameterDescription.InDefinedShape)this.adviceMethod.getParameters().get(index++)).getType().getStackSize().getSize()) + offsetMapping.resolveRead().apply(this.methodVisitor, this.implementationContext).getMaximalSize());
                        }
                        this.methodVisitor.visitMethodInsn(184, this.adviceMethod.getDeclaringType().getInternalName(), this.adviceMethod.getInternalName(), this.adviceMethod.getDescriptor(), false);
                        this.onMethodReturn();
                        this.suppressionHandler.onEndSkipped(this.methodVisitor, this.implementationContext, this.methodSizeHandler, this.stackMapFrameHandler, this);
                        this.relocationHandler.apply(this.methodVisitor, this.argumentHandler, this.methodSizeHandler, this.stackMapFrameHandler);
                        this.stackMapFrameHandler.injectCompletionFrame(this.methodVisitor, false);
                        this.methodSizeHandler.recordMaxima(Math.max(maximumStackSize, this.adviceMethod.getReturnType().getStackSize().getSize()), 0);
                    }

                    protected abstract void onMethodReturn();

                    protected static class ForMethodExit
                    extends AdviceMethodWriter {
                        protected ForMethodExit(MethodDescription.InDefinedShape adviceMethod, List<OffsetMapping.Target> offsetMappings, MethodVisitor methodVisitor, Implementation.Context implementationContext, ArgumentHandler.ForAdvice argumentHandler, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, SuppressionHandler.Bound suppressionHandler, RelocationHandler.Bound relocationHandler) {
                            super(adviceMethod, offsetMappings, methodVisitor, implementationContext, argumentHandler, methodSizeHandler, stackMapFrameHandler, suppressionHandler, relocationHandler);
                        }

                        @Override
                        protected void onMethodReturn() {
                            switch (this.adviceMethod.getReturnType().getStackSize()) {
                                case ZERO: {
                                    return;
                                }
                                case SINGLE: {
                                    this.methodVisitor.visitInsn(87);
                                    return;
                                }
                                case DOUBLE: {
                                    this.methodVisitor.visitInsn(88);
                                    return;
                                }
                            }
                            throw new IllegalStateException("Unexpected size: " + (Object)((Object)this.adviceMethod.getReturnType().getStackSize()));
                        }

                        @Override
                        public void onDefaultValue(MethodVisitor methodVisitor) {
                        }
                    }

                    protected static class ForMethodEnter
                    extends AdviceMethodWriter {
                        protected ForMethodEnter(MethodDescription.InDefinedShape adviceMethod, List<OffsetMapping.Target> offsetMappings, MethodVisitor methodVisitor, Implementation.Context implementationContext, ArgumentHandler.ForAdvice argumentHandler, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, SuppressionHandler.Bound suppressionHandler, RelocationHandler.Bound relocationHandler) {
                            super(adviceMethod, offsetMappings, methodVisitor, implementationContext, argumentHandler, methodSizeHandler, stackMapFrameHandler, suppressionHandler, relocationHandler);
                        }

                        @Override
                        protected void onMethodReturn() {
                            if (this.adviceMethod.getReturnType().represents(Boolean.TYPE) || this.adviceMethod.getReturnType().represents(Byte.TYPE) || this.adviceMethod.getReturnType().represents(Short.TYPE) || this.adviceMethod.getReturnType().represents(Character.TYPE) || this.adviceMethod.getReturnType().represents(Integer.TYPE)) {
                                this.methodVisitor.visitVarInsn(54, this.argumentHandler.enter());
                            } else if (this.adviceMethod.getReturnType().represents(Long.TYPE)) {
                                this.methodVisitor.visitVarInsn(55, this.argumentHandler.enter());
                            } else if (this.adviceMethod.getReturnType().represents(Float.TYPE)) {
                                this.methodVisitor.visitVarInsn(56, this.argumentHandler.enter());
                            } else if (this.adviceMethod.getReturnType().represents(Double.TYPE)) {
                                this.methodVisitor.visitVarInsn(57, this.argumentHandler.enter());
                            } else if (!this.adviceMethod.getReturnType().represents(Void.TYPE)) {
                                this.methodVisitor.visitVarInsn(58, this.argumentHandler.enter());
                            }
                        }

                        @Override
                        public void onDefaultValue(MethodVisitor methodVisitor) {
                            if (this.adviceMethod.getReturnType().represents(Boolean.TYPE) || this.adviceMethod.getReturnType().represents(Byte.TYPE) || this.adviceMethod.getReturnType().represents(Short.TYPE) || this.adviceMethod.getReturnType().represents(Character.TYPE) || this.adviceMethod.getReturnType().represents(Integer.TYPE)) {
                                methodVisitor.visitInsn(3);
                                methodVisitor.visitVarInsn(54, this.argumentHandler.enter());
                            } else if (this.adviceMethod.getReturnType().represents(Long.TYPE)) {
                                methodVisitor.visitInsn(9);
                                methodVisitor.visitVarInsn(55, this.argumentHandler.enter());
                            } else if (this.adviceMethod.getReturnType().represents(Float.TYPE)) {
                                methodVisitor.visitInsn(11);
                                methodVisitor.visitVarInsn(56, this.argumentHandler.enter());
                            } else if (this.adviceMethod.getReturnType().represents(Double.TYPE)) {
                                methodVisitor.visitInsn(14);
                                methodVisitor.visitVarInsn(57, this.argumentHandler.enter());
                            } else if (!this.adviceMethod.getReturnType().represents(Void.TYPE)) {
                                methodVisitor.visitInsn(1);
                                methodVisitor.visitVarInsn(58, this.argumentHandler.enter());
                            }
                        }
                    }
                }
            }
        }

        public static class Inlining
        implements Unresolved {
            protected final MethodDescription.InDefinedShape adviceMethod;

            protected Inlining(MethodDescription.InDefinedShape adviceMethod) {
                this.adviceMethod = adviceMethod;
            }

            @Override
            public boolean isAlive() {
                return true;
            }

            @Override
            public boolean isBinary() {
                return true;
            }

            @Override
            public TypeDescription getAdviceType() {
                return this.adviceMethod.getReturnType().asErasure();
            }

            @Override
            public net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodEnter asMethodEnter(List<? extends OffsetMapping.Factory<?>> userFactories, ClassReader classReader, Unresolved methodExit) {
                return Resolved.ForMethodEnter.of(this.adviceMethod, userFactories, classReader, methodExit.isAlive());
            }

            @Override
            public net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodExit asMethodExit(List<? extends OffsetMapping.Factory<?>> userFactories, ClassReader classReader, Unresolved methodEnter) {
                return Resolved.ForMethodExit.of(this.adviceMethod, userFactories, classReader, methodEnter.getAdviceType());
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Inlining)) {
                    return false;
                }
                Inlining other = (Inlining)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                MethodDescription.InDefinedShape this$adviceMethod = this.adviceMethod;
                MethodDescription.InDefinedShape other$adviceMethod = other.adviceMethod;
                return !(this$adviceMethod == null ? other$adviceMethod != null : !this$adviceMethod.equals(other$adviceMethod));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Inlining;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                MethodDescription.InDefinedShape $adviceMethod = this.adviceMethod;
                result = result * 59 + ($adviceMethod == null ? 43 : $adviceMethod.hashCode());
                return result;
            }

            protected static abstract class CodeTranslationVisitor
            extends MethodVisitor
            implements SuppressionHandler.ReturnValueProducer {
                protected final MethodVisitor methodVisitor;
                protected final Implementation.Context implementationContext;
                protected final ArgumentHandler.ForAdvice argumentHandler;
                protected final MethodSizeHandler.ForAdvice methodSizeHandler;
                protected final StackMapFrameHandler.ForAdvice stackMapFrameHandler;
                protected final MethodDescription.InDefinedShape adviceMethod;
                private final Map<Integer, OffsetMapping.Target> offsetMappings;
                private final SuppressionHandler.Bound suppressionHandler;
                private final RelocationHandler.Bound relocationHandler;
                protected final Label endOfMethod;

                protected CodeTranslationVisitor(MethodVisitor methodVisitor, Implementation.Context implementationContext, ArgumentHandler.ForAdvice argumentHandler, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, MethodDescription instrumentedMethod, MethodDescription.InDefinedShape adviceMethod, Map<Integer, OffsetMapping.Target> offsetMappings, SuppressionHandler.Bound suppressionHandler, RelocationHandler.Bound relocationHandler) {
                    super(393216, (MethodVisitor)new StackAwareMethodVisitor(methodVisitor, instrumentedMethod));
                    this.methodVisitor = methodVisitor;
                    this.implementationContext = implementationContext;
                    this.argumentHandler = argumentHandler;
                    this.methodSizeHandler = methodSizeHandler;
                    this.stackMapFrameHandler = stackMapFrameHandler;
                    this.adviceMethod = adviceMethod;
                    this.offsetMappings = offsetMappings;
                    this.suppressionHandler = suppressionHandler;
                    this.relocationHandler = relocationHandler;
                    this.endOfMethod = new Label();
                }

                protected void propagateHandler(Label label) {
                    ((StackAwareMethodVisitor)this.mv).register(label, Collections.singletonList(StackSize.SINGLE));
                }

                public void visitParameter(String name, int modifiers) {
                }

                public void visitAnnotableParameterCount(int count, boolean visible) {
                }

                public AnnotationVisitor visitAnnotationDefault() {
                    return IGNORE_ANNOTATION;
                }

                public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                    return IGNORE_ANNOTATION;
                }

                public AnnotationVisitor visitTypeAnnotation(int typeReference, TypePath typePath, String descriptor, boolean visible) {
                    return IGNORE_ANNOTATION;
                }

                public AnnotationVisitor visitParameterAnnotation(int index, String descriptor, boolean visible) {
                    return IGNORE_ANNOTATION;
                }

                public void visitAttribute(Attribute attribute) {
                }

                public void visitCode() {
                    this.suppressionHandler.onStart(this.methodVisitor);
                }

                public void visitFrame(int type, int localVariableLength, Object[] localVariable, int stackSize, Object[] stack) {
                    this.stackMapFrameHandler.translateFrame(this.methodVisitor, type, localVariableLength, localVariable, stackSize, stack);
                }

                public void visitEnd() {
                    this.suppressionHandler.onEnd(this.methodVisitor, this.implementationContext, this.methodSizeHandler, this.stackMapFrameHandler, this);
                    this.methodVisitor.visitLabel(this.endOfMethod);
                    this.onMethodReturn();
                    this.relocationHandler.apply(this.methodVisitor, this.argumentHandler, this.methodSizeHandler, this.stackMapFrameHandler);
                    this.stackMapFrameHandler.injectCompletionFrame(this.methodVisitor, false);
                }

                public void visitMaxs(int stackSize, int localVariableLength) {
                    this.methodSizeHandler.recordMaxima(stackSize, localVariableLength);
                }

                public void visitVarInsn(int opcode, int offset) {
                    OffsetMapping.Target target = this.offsetMappings.get(offset);
                    if (target != null) {
                        StackSize expectedGrowth;
                        StackManipulation stackManipulation;
                        switch (opcode) {
                            case 21: 
                            case 23: 
                            case 25: {
                                stackManipulation = target.resolveRead();
                                expectedGrowth = StackSize.SINGLE;
                                break;
                            }
                            case 22: 
                            case 24: {
                                stackManipulation = target.resolveRead();
                                expectedGrowth = StackSize.DOUBLE;
                                break;
                            }
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: 
                            case 58: {
                                stackManipulation = target.resolveWrite();
                                expectedGrowth = StackSize.ZERO;
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected opcode: " + opcode);
                            }
                        }
                        this.methodSizeHandler.recordPadding(stackManipulation.apply(this.mv, this.implementationContext).getMaximalSize() - expectedGrowth.getSize());
                    } else {
                        this.mv.visitVarInsn(opcode, this.argumentHandler.mapped(offset));
                    }
                }

                public void visitIincInsn(int offset, int value) {
                    OffsetMapping.Target target = this.offsetMappings.get(offset);
                    if (target != null) {
                        this.methodSizeHandler.recordPadding(target.resolveIncrement(value).apply(this.mv, this.implementationContext).getMaximalSize());
                    } else {
                        this.mv.visitIincInsn(this.argumentHandler.mapped(offset), value);
                    }
                }

                public abstract void visitInsn(int var1);

                protected abstract void onMethodReturn();

                protected static class ForMethodExit
                extends CodeTranslationVisitor {
                    protected ForMethodExit(MethodVisitor methodVisitor, Implementation.Context implementationContext, ArgumentHandler.ForAdvice argumentHandler, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, MethodDescription instrumentedMethod, MethodDescription.InDefinedShape adviceMethod, Map<Integer, OffsetMapping.Target> offsetMappings, SuppressionHandler.Bound suppressionHandler, RelocationHandler.Bound relocationHandler) {
                        super(methodVisitor, implementationContext, argumentHandler, methodSizeHandler, stackMapFrameHandler, instrumentedMethod, adviceMethod, offsetMappings, suppressionHandler, relocationHandler);
                    }

                    @Override
                    public void visitInsn(int opcode) {
                        switch (opcode) {
                            case 177: {
                                break;
                            }
                            case 172: 
                            case 174: 
                            case 176: {
                                this.mv.visitInsn(87);
                                break;
                            }
                            case 173: 
                            case 175: {
                                this.mv.visitInsn(88);
                                break;
                            }
                            default: {
                                this.mv.visitInsn(opcode);
                                return;
                            }
                        }
                        ((StackAwareMethodVisitor)this.mv).drainStack();
                        this.mv.visitJumpInsn(167, this.endOfMethod);
                    }

                    @Override
                    public void onDefaultValue(MethodVisitor methodVisitor) {
                    }

                    @Override
                    protected void onMethodReturn() {
                    }
                }

                protected static class ForMethodEnter
                extends CodeTranslationVisitor {
                    private boolean doesReturn = false;

                    protected ForMethodEnter(MethodVisitor methodVisitor, Implementation.Context implementationContext, ArgumentHandler.ForAdvice argumentHandler, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, MethodDescription instrumentedMethod, MethodDescription.InDefinedShape adviceMethod, Map<Integer, OffsetMapping.Target> offsetMappings, SuppressionHandler.Bound suppressionHandler, RelocationHandler.Bound relocationHandler) {
                        super(methodVisitor, implementationContext, argumentHandler, methodSizeHandler, stackMapFrameHandler, instrumentedMethod, adviceMethod, offsetMappings, suppressionHandler, relocationHandler);
                    }

                    @Override
                    public void visitInsn(int opcode) {
                        switch (opcode) {
                            case 177: {
                                ((StackAwareMethodVisitor)this.mv).drainStack();
                                break;
                            }
                            case 172: {
                                this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(54, 21, StackSize.SINGLE));
                                break;
                            }
                            case 176: {
                                this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(58, 25, StackSize.SINGLE));
                                break;
                            }
                            case 174: {
                                this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(56, 23, StackSize.SINGLE));
                                break;
                            }
                            case 173: {
                                this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(55, 22, StackSize.DOUBLE));
                                break;
                            }
                            case 175: {
                                this.methodSizeHandler.requireLocalVariableLength(((StackAwareMethodVisitor)this.mv).drainStack(57, 24, StackSize.DOUBLE));
                                break;
                            }
                            default: {
                                this.mv.visitInsn(opcode);
                                return;
                            }
                        }
                        this.mv.visitJumpInsn(167, this.endOfMethod);
                        this.doesReturn = true;
                    }

                    @Override
                    public void onDefaultValue(MethodVisitor methodVisitor) {
                        if (this.adviceMethod.getReturnType().represents(Boolean.TYPE) || this.adviceMethod.getReturnType().represents(Byte.TYPE) || this.adviceMethod.getReturnType().represents(Short.TYPE) || this.adviceMethod.getReturnType().represents(Character.TYPE) || this.adviceMethod.getReturnType().represents(Integer.TYPE)) {
                            methodVisitor.visitInsn(3);
                        } else if (this.adviceMethod.getReturnType().represents(Long.TYPE)) {
                            methodVisitor.visitInsn(9);
                        } else if (this.adviceMethod.getReturnType().represents(Float.TYPE)) {
                            methodVisitor.visitInsn(11);
                        } else if (this.adviceMethod.getReturnType().represents(Double.TYPE)) {
                            methodVisitor.visitInsn(14);
                        } else if (!this.adviceMethod.getReturnType().represents(Void.TYPE)) {
                            methodVisitor.visitInsn(1);
                        }
                        this.doesReturn = true;
                    }

                    @Override
                    protected void onMethodReturn() {
                        if (this.doesReturn) {
                            this.stackMapFrameHandler.injectReturnFrame(this.methodVisitor);
                            if (!this.adviceMethod.getReturnType().represents(Void.TYPE)) {
                                this.methodVisitor.visitVarInsn(org.objectweb.asm.Type.getType((String)this.adviceMethod.getReturnType().asErasure().getDescriptor()).getOpcode(54), this.argumentHandler.enter());
                            }
                        }
                    }
                }
            }

            protected static abstract class Resolved
            extends Resolved.AbstractBase {
                protected final ClassReader classReader;

                protected Resolved(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory<?>> factories, TypeDescription throwableType, TypeDescription relocatableType, ClassReader classReader) {
                    super(adviceMethod, factories, throwableType, relocatableType, OffsetMapping.Factory.AdviceType.INLINING);
                    this.classReader = classReader;
                }

                protected abstract MethodVisitor apply(MethodVisitor var1, Implementation.Context var2, Assigner var3, ArgumentHandler.ForInstrumentedMethod var4, MethodSizeHandler.ForInstrumentedMethod var5, StackMapFrameHandler.ForInstrumentedMethod var6, TypeDescription var7, MethodDescription var8, SuppressionHandler.Bound var9, RelocationHandler.Bound var10);

                protected static abstract class ForMethodExit
                extends Resolved
                implements net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodExit {
                    private final TypeDefinition enterType;
                    private final boolean backupArguments;

                    protected ForMethodExit(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory<?>> userFactories, ClassReader classReader, TypeDefinition enterType) {
                        super(adviceMethod, CompoundList.of(Arrays.asList(OffsetMapping.ForArgument.Unresolved.Factory.INSTANCE, OffsetMapping.ForAllArguments.Factory.INSTANCE, OffsetMapping.ForThisReference.Factory.INSTANCE, OffsetMapping.ForField.Unresolved.Factory.INSTANCE, OffsetMapping.ForOrigin.Factory.INSTANCE, OffsetMapping.ForUnusedValue.Factory.INSTANCE, OffsetMapping.ForStubValue.INSTANCE, new OffsetMapping.ForEnterValue.Factory(enterType), OffsetMapping.ForReturnValue.Factory.INSTANCE, OffsetMapping.ForThrowable.Factory.of(adviceMethod)), userFactories), adviceMethod.getDeclaredAnnotations().ofType(OnMethodExit.class).getValue(SUPPRESS_EXIT).resolve(TypeDescription.class), TypeDescription.VOID, classReader);
                        this.enterType = enterType;
                        this.backupArguments = adviceMethod.getDeclaredAnnotations().ofType(OnMethodExit.class).getValue(BACKUP_ARGUMENTS).resolve(Boolean.class);
                    }

                    protected static net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodExit of(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory<?>> userFactories, ClassReader classReader, TypeDefinition enterType) {
                        TypeDescription throwable = adviceMethod.getDeclaredAnnotations().ofType(OnMethodExit.class).getValue(ON_THROWABLE).resolve(TypeDescription.class);
                        return throwable.represents((Type)((Object)NoExceptionHandler.class)) ? new WithoutExceptionHandler(adviceMethod, userFactories, classReader, enterType) : new WithExceptionHandler(adviceMethod, userFactories, classReader, enterType, throwable);
                    }

                    @Override
                    protected MethodVisitor apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, ArgumentHandler.ForInstrumentedMethod argumentHandler, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, TypeDescription instrumentedType, MethodDescription instrumentedMethod, SuppressionHandler.Bound suppressionHandler, RelocationHandler.Bound relocationHandler) {
                        HashMap<Integer, OffsetMapping.Target> offsetMappings = new HashMap<Integer, OffsetMapping.Target>();
                        for (Map.Entry entry : this.offsetMappings.entrySet()) {
                            offsetMappings.put((Integer)entry.getKey(), ((OffsetMapping)entry.getValue()).resolve(instrumentedType, instrumentedMethod, assigner, argumentHandler.bindExit(this.adviceMethod, this.getThrowable().represents((Type)((Object)NoExceptionHandler.class))), OffsetMapping.Sort.EXIT));
                        }
                        return new CodeTranslationVisitor.ForMethodExit(methodVisitor, implementationContext, argumentHandler.bindExit(this.adviceMethod, this.getThrowable().represents((Type)((Object)NoExceptionHandler.class))), methodSizeHandler.bindExit(this.adviceMethod, this.getThrowable().represents((Type)((Object)NoExceptionHandler.class))), stackMapFrameHandler.bindExit(this.adviceMethod), instrumentedMethod, this.adviceMethod, offsetMappings, suppressionHandler, relocationHandler);
                    }

                    @Override
                    public ArgumentHandler.Factory getArgumentHandlerFactory() {
                        return this.backupArguments ? ArgumentHandler.Factory.COPYING : ArgumentHandler.Factory.SIMPLE;
                    }

                    @Override
                    public Bound bind(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, ArgumentHandler.ForInstrumentedMethod argumentHandler, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, StackManipulation exceptionHandler, RelocationHandler.Relocation relocation) {
                        return new AdviceMethodInliner(instrumentedType, instrumentedMethod, methodVisitor, implementationContext, assigner, argumentHandler, methodSizeHandler, stackMapFrameHandler, this.suppressionHandler.bind(exceptionHandler), this.relocationHandler.bind(instrumentedMethod, relocation), this.classReader);
                    }

                    @Override
                    public boolean equals(Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null || this.getClass() != object.getClass()) {
                            return false;
                        }
                        if (!super.equals(object)) {
                            return false;
                        }
                        ForMethodExit that = (ForMethodExit)object;
                        return this.enterType.equals(that.enterType);
                    }

                    @Override
                    public int hashCode() {
                        int result = super.hashCode();
                        result = 31 * result + this.enterType.hashCode();
                        return result;
                    }

                    protected static class WithoutExceptionHandler
                    extends ForMethodExit {
                        protected WithoutExceptionHandler(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory<?>> userFactories, ClassReader classReader, TypeDefinition enterType) {
                            super(adviceMethod, userFactories, classReader, enterType);
                        }

                        @Override
                        public TypeDescription getThrowable() {
                            return NoExceptionHandler.DESCRIPTION;
                        }
                    }

                    protected static class WithExceptionHandler
                    extends ForMethodExit {
                        private final TypeDescription throwable;

                        protected WithExceptionHandler(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory<?>> userFactories, ClassReader classReader, TypeDefinition enterType, TypeDescription throwable) {
                            super(adviceMethod, userFactories, classReader, enterType);
                            this.throwable = throwable;
                        }

                        @Override
                        public TypeDescription getThrowable() {
                            return this.throwable;
                        }

                        @Override
                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof WithExceptionHandler)) {
                                return false;
                            }
                            WithExceptionHandler other = (WithExceptionHandler)o;
                            if (!other.canEqual(this)) {
                                return false;
                            }
                            if (!super.equals(o)) {
                                return false;
                            }
                            TypeDescription this$throwable = this.getThrowable();
                            TypeDescription other$throwable = other.getThrowable();
                            return !(this$throwable == null ? other$throwable != null : !this$throwable.equals(other$throwable));
                        }

                        @Override
                        protected boolean canEqual(Object other) {
                            return other instanceof WithExceptionHandler;
                        }

                        @Override
                        public int hashCode() {
                            int PRIME = 59;
                            int result = super.hashCode();
                            TypeDescription $throwable = this.getThrowable();
                            result = result * 59 + ($throwable == null ? 43 : $throwable.hashCode());
                            return result;
                        }
                    }
                }

                protected static abstract class ForMethodEnter
                extends Resolved
                implements net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodEnter {
                    private final boolean prependLineNumber;

                    protected ForMethodEnter(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory<?>> userFactories, ClassReader classReader) {
                        super(adviceMethod, CompoundList.of(Arrays.asList(OffsetMapping.ForArgument.Unresolved.Factory.INSTANCE, OffsetMapping.ForAllArguments.Factory.INSTANCE, OffsetMapping.ForThisReference.Factory.INSTANCE, OffsetMapping.ForField.Unresolved.Factory.INSTANCE, OffsetMapping.ForOrigin.Factory.INSTANCE, OffsetMapping.ForUnusedValue.Factory.INSTANCE, OffsetMapping.ForStubValue.INSTANCE, OffsetMapping.ForThrowable.Factory.INSTANCE, new OffsetMapping.Factory.Illegal<Thrown>(Thrown.class), new OffsetMapping.Factory.Illegal<Enter>(Enter.class), new OffsetMapping.Factory.Illegal<Return>(Return.class)), userFactories), adviceMethod.getDeclaredAnnotations().ofType(OnMethodEnter.class).getValue(SUPPRESS_ENTER).resolve(TypeDescription.class), adviceMethod.getDeclaredAnnotations().ofType(OnMethodEnter.class).getValue(SKIP_ON).resolve(TypeDescription.class), classReader);
                        this.prependLineNumber = adviceMethod.getDeclaredAnnotations().ofType(OnMethodEnter.class).getValue(PREPEND_LINE_NUMBER).resolve(Boolean.class);
                    }

                    protected static net.bytebuddy.asm.Advice$Dispatcher$Resolved$ForMethodEnter of(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory<?>> userFactories, ClassReader classReader, boolean methodExit) {
                        return methodExit ? new WithRetainedEnterType(adviceMethod, userFactories, classReader) : new WithDiscardedEnterType(adviceMethod, userFactories, classReader);
                    }

                    @Override
                    public Bound bind(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, ArgumentHandler.ForInstrumentedMethod argumentHandler, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, StackManipulation exceptionHandler, RelocationHandler.Relocation relocation) {
                        return new AdviceMethodInliner(instrumentedType, instrumentedMethod, methodVisitor, implementationContext, assigner, argumentHandler, methodSizeHandler, stackMapFrameHandler, this.suppressionHandler.bind(exceptionHandler), this.relocationHandler.bind(instrumentedMethod, relocation), this.classReader);
                    }

                    @Override
                    public boolean isPrependLineNumber() {
                        return this.prependLineNumber;
                    }

                    @Override
                    protected MethodVisitor apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, ArgumentHandler.ForInstrumentedMethod argumentHandler, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, TypeDescription instrumentedType, MethodDescription instrumentedMethod, SuppressionHandler.Bound suppressionHandler, RelocationHandler.Bound relocationHandler) {
                        HashMap<Integer, OffsetMapping.Target> offsetMappings = new HashMap<Integer, OffsetMapping.Target>();
                        for (Map.Entry entry : this.offsetMappings.entrySet()) {
                            offsetMappings.put((Integer)entry.getKey(), ((OffsetMapping)entry.getValue()).resolve(instrumentedType, instrumentedMethod, assigner, argumentHandler.bindEnter(this.adviceMethod), OffsetMapping.Sort.ENTER));
                        }
                        return new CodeTranslationVisitor.ForMethodEnter(methodVisitor, implementationContext, argumentHandler.bindEnter(this.adviceMethod), methodSizeHandler.bindEnter(this.adviceMethod), stackMapFrameHandler.bindEnter(this.adviceMethod), instrumentedMethod, this.adviceMethod, offsetMappings, suppressionHandler, relocationHandler);
                    }

                    @Override
                    public boolean equals(Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null || this.getClass() != object.getClass()) {
                            return false;
                        }
                        if (!super.equals(object)) {
                            return false;
                        }
                        ForMethodEnter that = (ForMethodEnter)object;
                        return this.prependLineNumber == that.prependLineNumber && this.relocationHandler.equals(that.relocationHandler);
                    }

                    @Override
                    public int hashCode() {
                        int result = super.hashCode();
                        result = 31 * result + this.relocationHandler.hashCode();
                        result = 31 * result + (this.prependLineNumber ? 1 : 0);
                        return result;
                    }

                    protected static class WithDiscardedEnterType
                    extends ForMethodEnter {
                        protected WithDiscardedEnterType(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory<?>> userFactories, ClassReader classReader) {
                            super(adviceMethod, userFactories, classReader);
                        }

                        @Override
                        public TypeDefinition getEnterType() {
                            return TypeDescription.VOID;
                        }
                    }

                    protected static class WithRetainedEnterType
                    extends ForMethodEnter {
                        protected WithRetainedEnterType(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory<?>> userFactories, ClassReader classReader) {
                            super(adviceMethod, userFactories, classReader);
                        }

                        @Override
                        public TypeDefinition getEnterType() {
                            return this.adviceMethod.getReturnType();
                        }
                    }
                }

                protected class AdviceMethodInliner
                extends ClassVisitor
                implements Bound {
                    protected final TypeDescription instrumentedType;
                    protected final MethodDescription instrumentedMethod;
                    protected final MethodVisitor methodVisitor;
                    protected final Implementation.Context implementationContext;
                    protected final Assigner assigner;
                    protected final ArgumentHandler.ForInstrumentedMethod argumentHandler;
                    protected final MethodSizeHandler.ForInstrumentedMethod methodSizeHandler;
                    protected final StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler;
                    protected final SuppressionHandler.Bound suppressionHandler;
                    protected final RelocationHandler.Bound relocationHandler;
                    protected final ClassReader classReader;
                    protected final List<Label> labels;

                    protected AdviceMethodInliner(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, ArgumentHandler.ForInstrumentedMethod argumentHandler, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, SuppressionHandler.Bound suppressionHandler, RelocationHandler.Bound relocationHandler, ClassReader classReader) {
                        super(393216);
                        this.instrumentedType = instrumentedType;
                        this.instrumentedMethod = instrumentedMethod;
                        this.methodVisitor = methodVisitor;
                        this.implementationContext = implementationContext;
                        this.assigner = assigner;
                        this.argumentHandler = argumentHandler;
                        this.methodSizeHandler = methodSizeHandler;
                        this.stackMapFrameHandler = stackMapFrameHandler;
                        this.suppressionHandler = suppressionHandler;
                        this.classReader = classReader;
                        this.relocationHandler = relocationHandler;
                        this.labels = new ArrayList<Label>();
                    }

                    @Override
                    public void prepare() {
                        this.classReader.accept((ClassVisitor)new ExceptionTableExtractor(), 6);
                        this.suppressionHandler.onPrepare(this.methodVisitor);
                    }

                    @Override
                    public void apply() {
                        this.classReader.accept((ClassVisitor)this, 2 | this.stackMapFrameHandler.getReaderHint());
                    }

                    public MethodVisitor visitMethod(int modifiers, String internalName, String descriptor, String signature, String[] exception) {
                        return Resolved.this.adviceMethod.getInternalName().equals(internalName) && Resolved.this.adviceMethod.getDescriptor().equals(descriptor) ? new ExceptionTableSubstitutor(Resolved.this.apply(this.methodVisitor, this.implementationContext, this.assigner, this.argumentHandler, this.methodSizeHandler, this.stackMapFrameHandler, this.instrumentedType, this.instrumentedMethod, this.suppressionHandler, this.relocationHandler)) : IGNORE_METHOD;
                    }

                    protected class ExceptionTableSubstitutor
                    extends MethodVisitor {
                        private final Map<Label, Label> substitutions;
                        private int index;

                        protected ExceptionTableSubstitutor(MethodVisitor methodVisitor) {
                            super(393216, methodVisitor);
                            this.substitutions = new IdentityHashMap<Label, Label>();
                        }

                        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
                            this.substitutions.put(start, AdviceMethodInliner.this.labels.get(this.index++));
                            this.substitutions.put(end, AdviceMethodInliner.this.labels.get(this.index++));
                            Label actualHandler = AdviceMethodInliner.this.labels.get(this.index++);
                            this.substitutions.put(handler, actualHandler);
                            ((CodeTranslationVisitor)this.mv).propagateHandler(actualHandler);
                        }

                        public AnnotationVisitor visitTryCatchAnnotation(int typeReference, TypePath typePath, String descriptor, boolean visible) {
                            return IGNORE_ANNOTATION;
                        }

                        public void visitLabel(Label label) {
                            super.visitLabel(this.resolve(label));
                        }

                        public void visitJumpInsn(int opcode, Label label) {
                            super.visitJumpInsn(opcode, this.resolve(label));
                        }

                        public void visitTableSwitchInsn(int minimum, int maximum, Label defaultOption, Label ... label) {
                            super.visitTableSwitchInsn(minimum, maximum, defaultOption, this.resolve(label));
                        }

                        public void visitLookupSwitchInsn(Label defaultOption, int[] keys, Label[] label) {
                            super.visitLookupSwitchInsn(this.resolve(defaultOption), keys, this.resolve(label));
                        }

                        private Label[] resolve(Label[] label) {
                            Label[] resolved = new Label[label.length];
                            int index = 0;
                            for (Label aLabel : label) {
                                resolved[index++] = this.resolve(aLabel);
                            }
                            return resolved;
                        }

                        private Label resolve(Label label) {
                            Label substitution = this.substitutions.get(label);
                            return substitution == null ? label : substitution;
                        }
                    }

                    protected class ExceptionTableCollector
                    extends MethodVisitor {
                        private final MethodVisitor methodVisitor;

                        protected ExceptionTableCollector(MethodVisitor methodVisitor) {
                            super(393216);
                            this.methodVisitor = methodVisitor;
                        }

                        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
                            this.methodVisitor.visitTryCatchBlock(start, end, handler, type);
                            AdviceMethodInliner.this.labels.addAll(Arrays.asList(start, end, handler));
                        }

                        public AnnotationVisitor visitTryCatchAnnotation(int typeReference, TypePath typePath, String descriptor, boolean visible) {
                            return this.methodVisitor.visitTryCatchAnnotation(typeReference, typePath, descriptor, visible);
                        }
                    }

                    protected class ExceptionTableExtractor
                    extends ClassVisitor {
                        protected ExceptionTableExtractor() {
                            super(393216);
                        }

                        public MethodVisitor visitMethod(int modifiers, String internalName, String descriptor, String signature, String[] exception) {
                            return Resolved.this.adviceMethod.getInternalName().equals(internalName) && Resolved.this.adviceMethod.getDescriptor().equals(descriptor) ? new ExceptionTableCollector(AdviceMethodInliner.this.methodVisitor) : IGNORE_METHOD;
                        }
                    }
                }
            }
        }

        public static enum Inactive implements Unresolved,
        Resolved.ForMethodEnter,
        Resolved.ForMethodExit,
        Bound
        {
            INSTANCE;


            @Override
            public boolean isAlive() {
                return false;
            }

            @Override
            public boolean isBinary() {
                return false;
            }

            @Override
            public TypeDescription getAdviceType() {
                return TypeDescription.VOID;
            }

            @Override
            public TypeDescription getThrowable() {
                return NoExceptionHandler.DESCRIPTION;
            }

            @Override
            public ArgumentHandler.Factory getArgumentHandlerFactory() {
                return ArgumentHandler.Factory.SIMPLE;
            }

            @Override
            public TypeDefinition getEnterType() {
                return TypeDescription.VOID;
            }

            @Override
            public boolean isPrependLineNumber() {
                return false;
            }

            @Override
            public Resolved.ForMethodEnter asMethodEnter(List<? extends OffsetMapping.Factory<?>> userFactories, ClassReader classReader, Unresolved methodExit) {
                return this;
            }

            @Override
            public Resolved.ForMethodExit asMethodExit(List<? extends OffsetMapping.Factory<?>> userFactories, ClassReader classReader, Unresolved methodEnter) {
                return this;
            }

            @Override
            public void prepare() {
            }

            @Override
            public void apply() {
            }

            @Override
            public Bound bind(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodVisitor methodVisitor, Implementation.Context implementationContext, Assigner assigner, ArgumentHandler.ForInstrumentedMethod argumentHandler, MethodSizeHandler.ForInstrumentedMethod methodSizeHandler, StackMapFrameHandler.ForInstrumentedMethod stackMapFrameHandler, StackManipulation exceptionHandler, RelocationHandler.Relocation relocation) {
                return this;
            }
        }

        public static interface Bound {
            public void prepare();

            public void apply();
        }

        public static interface Resolved
        extends Dispatcher {
            public Bound bind(TypeDescription var1, MethodDescription var2, MethodVisitor var3, Implementation.Context var4, Assigner var5, ArgumentHandler.ForInstrumentedMethod var6, MethodSizeHandler.ForInstrumentedMethod var7, StackMapFrameHandler.ForInstrumentedMethod var8, StackManipulation var9, RelocationHandler.Relocation var10);

            public static abstract class AbstractBase
            implements Resolved {
                protected final MethodDescription.InDefinedShape adviceMethod;
                protected final Map<Integer, OffsetMapping> offsetMappings;
                protected final SuppressionHandler suppressionHandler;
                protected final RelocationHandler relocationHandler;

                protected AbstractBase(MethodDescription.InDefinedShape adviceMethod, List<? extends OffsetMapping.Factory<?>> factories, TypeDescription throwableType, TypeDescription relocatableType, OffsetMapping.Factory.AdviceType adviceType) {
                    this.adviceMethod = adviceMethod;
                    HashMap offsetMappings = new HashMap();
                    for (OffsetMapping.Factory<?> factory : factories) {
                        offsetMappings.put(new TypeDescription.ForLoadedType(factory.getAnnotationType()), factory);
                    }
                    this.offsetMappings = new LinkedHashMap<Integer, OffsetMapping>();
                    for (ParameterDescription.InDefinedShape parameterDescription : adviceMethod.getParameters()) {
                        OffsetMapping offsetMapping = null;
                        for (AnnotationDescription annotationDescription : parameterDescription.getDeclaredAnnotations()) {
                            OffsetMapping.Factory factory = (OffsetMapping.Factory)offsetMappings.get(annotationDescription.getAnnotationType());
                            if (factory == null) continue;
                            OffsetMapping current = factory.make(parameterDescription, annotationDescription.prepare(factory.getAnnotationType()), adviceType);
                            if (offsetMapping == null) {
                                offsetMapping = current;
                                continue;
                            }
                            throw new IllegalStateException(parameterDescription + " is bound to both " + current + " and " + offsetMapping);
                        }
                        this.offsetMappings.put(parameterDescription.getOffset(), offsetMapping == null ? new OffsetMapping.ForArgument.Unresolved(parameterDescription) : offsetMapping);
                    }
                    this.suppressionHandler = SuppressionHandler.Suppressing.of(throwableType);
                    this.relocationHandler = RelocationHandler.ForType.of(relocatableType, adviceMethod.getReturnType());
                }

                @Override
                public boolean isAlive() {
                    return true;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof AbstractBase)) {
                        return false;
                    }
                    AbstractBase other = (AbstractBase)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    MethodDescription.InDefinedShape this$adviceMethod = this.adviceMethod;
                    MethodDescription.InDefinedShape other$adviceMethod = other.adviceMethod;
                    if (this$adviceMethod == null ? other$adviceMethod != null : !this$adviceMethod.equals(other$adviceMethod)) {
                        return false;
                    }
                    Map<Integer, OffsetMapping> this$offsetMappings = this.offsetMappings;
                    Map<Integer, OffsetMapping> other$offsetMappings = other.offsetMappings;
                    if (this$offsetMappings == null ? other$offsetMappings != null : !((Object)this$offsetMappings).equals(other$offsetMappings)) {
                        return false;
                    }
                    SuppressionHandler this$suppressionHandler = this.suppressionHandler;
                    SuppressionHandler other$suppressionHandler = other.suppressionHandler;
                    if (this$suppressionHandler == null ? other$suppressionHandler != null : !this$suppressionHandler.equals(other$suppressionHandler)) {
                        return false;
                    }
                    RelocationHandler this$relocationHandler = this.relocationHandler;
                    RelocationHandler other$relocationHandler = other.relocationHandler;
                    return !(this$relocationHandler == null ? other$relocationHandler != null : !this$relocationHandler.equals(other$relocationHandler));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof AbstractBase;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    MethodDescription.InDefinedShape $adviceMethod = this.adviceMethod;
                    result = result * 59 + ($adviceMethod == null ? 43 : $adviceMethod.hashCode());
                    Map<Integer, OffsetMapping> $offsetMappings = this.offsetMappings;
                    result = result * 59 + ($offsetMappings == null ? 43 : ((Object)$offsetMappings).hashCode());
                    SuppressionHandler $suppressionHandler = this.suppressionHandler;
                    result = result * 59 + ($suppressionHandler == null ? 43 : $suppressionHandler.hashCode());
                    RelocationHandler $relocationHandler = this.relocationHandler;
                    result = result * 59 + ($relocationHandler == null ? 43 : $relocationHandler.hashCode());
                    return result;
                }
            }

            public static interface ForMethodExit
            extends Resolved {
                public TypeDescription getThrowable();

                public ArgumentHandler.Factory getArgumentHandlerFactory();
            }

            public static interface ForMethodEnter
            extends Resolved {
                public TypeDefinition getEnterType();

                public boolean isPrependLineNumber();
            }
        }

        public static interface RelocationHandler {
            public Bound bind(MethodDescription var1, Relocation var2);

            public static class ForType
            implements RelocationHandler {
                private final TypeDescription typeDescription;

                protected ForType(TypeDescription typeDescription) {
                    this.typeDescription = typeDescription;
                }

                protected static RelocationHandler of(TypeDescription typeDescription, TypeDefinition checkedType) {
                    if (typeDescription.represents(Void.TYPE)) {
                        return Disabled.INSTANCE;
                    }
                    if (typeDescription.represents((Type)((Object)OnDefaultValue.class))) {
                        return ForValue.of(checkedType, false);
                    }
                    if (typeDescription.represents((Type)((Object)OnNonDefaultValue.class))) {
                        return ForValue.of(checkedType, true);
                    }
                    if (typeDescription.isPrimitive() || checkedType.isPrimitive()) {
                        throw new IllegalStateException("Cannot skip method by instance type for primitive return type " + checkedType);
                    }
                    return new ForType(typeDescription);
                }

                @Override
                public net.bytebuddy.asm.Advice$Dispatcher$RelocationHandler$Bound bind(MethodDescription instrumentedMethod, Relocation relocation) {
                    return new Bound(this.typeDescription, instrumentedMethod, relocation);
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForType)) {
                        return false;
                    }
                    ForType other = (ForType)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    TypeDescription this$typeDescription = this.typeDescription;
                    TypeDescription other$typeDescription = other.typeDescription;
                    return !(this$typeDescription == null ? other$typeDescription != null : !this$typeDescription.equals(other$typeDescription));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ForType;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    TypeDescription $typeDescription = this.typeDescription;
                    result = result * 59 + ($typeDescription == null ? 43 : $typeDescription.hashCode());
                    return result;
                }

                protected static class Bound
                implements net.bytebuddy.asm.Advice$Dispatcher$RelocationHandler$Bound {
                    private final TypeDescription typeDescription;
                    private final MethodDescription instrumentedMethod;
                    private final Relocation relocation;

                    protected Bound(TypeDescription typeDescription, MethodDescription instrumentedMethod, Relocation relocation) {
                        this.typeDescription = typeDescription;
                        this.instrumentedMethod = instrumentedMethod;
                        this.relocation = relocation;
                    }

                    @Override
                    public void apply(MethodVisitor methodVisitor, ArgumentHandler.ForAdvice argumentHandler, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler) {
                        if (this.instrumentedMethod.isConstructor()) {
                            throw new IllegalStateException("Cannot skip code execution from constructor: " + this.instrumentedMethod);
                        }
                        methodVisitor.visitVarInsn(25, argumentHandler.enter());
                        methodVisitor.visitTypeInsn(193, this.typeDescription.getInternalName());
                        Label noSkip = new Label();
                        methodVisitor.visitJumpInsn(153, noSkip);
                        this.relocation.apply(methodVisitor);
                        methodVisitor.visitLabel(noSkip);
                    }

                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Bound)) {
                            return false;
                        }
                        Bound other = (Bound)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        TypeDescription this$typeDescription = this.typeDescription;
                        TypeDescription other$typeDescription = other.typeDescription;
                        if (this$typeDescription == null ? other$typeDescription != null : !this$typeDescription.equals(other$typeDescription)) {
                            return false;
                        }
                        MethodDescription this$instrumentedMethod = this.instrumentedMethod;
                        MethodDescription other$instrumentedMethod = other.instrumentedMethod;
                        if (this$instrumentedMethod == null ? other$instrumentedMethod != null : !this$instrumentedMethod.equals(other$instrumentedMethod)) {
                            return false;
                        }
                        Relocation this$relocation = this.relocation;
                        Relocation other$relocation = other.relocation;
                        return !(this$relocation == null ? other$relocation != null : !this$relocation.equals(other$relocation));
                    }

                    protected boolean canEqual(Object other) {
                        return other instanceof Bound;
                    }

                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        TypeDescription $typeDescription = this.typeDescription;
                        result = result * 59 + ($typeDescription == null ? 43 : $typeDescription.hashCode());
                        MethodDescription $instrumentedMethod = this.instrumentedMethod;
                        result = result * 59 + ($instrumentedMethod == null ? 43 : $instrumentedMethod.hashCode());
                        Relocation $relocation = this.relocation;
                        result = result * 59 + ($relocation == null ? 43 : $relocation.hashCode());
                        return result;
                    }
                }
            }

            public static enum ForValue implements RelocationHandler
            {
                INTEGER(21, 154, 153){

                    @Override
                    protected void convertValue(MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler) {
                    }
                }
                ,
                LONG(22, 154, 153){

                    @Override
                    protected void convertValue(MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler) {
                        methodVisitor.visitInsn(136);
                    }
                }
                ,
                FLOAT(23, 154, 153){

                    @Override
                    protected void convertValue(MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler) {
                        methodVisitor.visitInsn(11);
                        methodVisitor.visitInsn(149);
                        methodSizeHandler.requireStackSize(2);
                    }
                }
                ,
                DOUBLE(24, 154, 153){

                    @Override
                    protected void convertValue(MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler) {
                        methodVisitor.visitInsn(14);
                        methodVisitor.visitInsn(151);
                        methodSizeHandler.requireStackSize(4);
                    }
                }
                ,
                REFERENCE(25, 199, 198){

                    @Override
                    protected void convertValue(MethodVisitor methodVisitor, MethodSizeHandler.ForAdvice methodSizeHandler) {
                    }
                };

                private final int load;
                private final int defaultJump;
                private final int nonDefaultJump;

                private ForValue(int load, int defaultJump, int nonDefaultJump) {
                    this.load = load;
                    this.defaultJump = defaultJump;
                    this.nonDefaultJump = nonDefaultJump;
                }

                protected static RelocationHandler of(TypeDefinition typeDefinition, boolean inverted) {
                    ForValue skipDispatcher;
                    if (typeDefinition.represents(Long.TYPE)) {
                        skipDispatcher = LONG;
                    } else if (typeDefinition.represents(Float.TYPE)) {
                        skipDispatcher = FLOAT;
                    } else if (typeDefinition.represents(Double.TYPE)) {
                        skipDispatcher = DOUBLE;
                    } else {
                        if (typeDefinition.represents(Void.TYPE)) {
                            throw new IllegalStateException("Cannot skip on default value for void return type");
                        }
                        skipDispatcher = typeDefinition.isPrimitive() ? INTEGER : REFERENCE;
                    }
                    return inverted ? skipDispatcher.new Inverted() : skipDispatcher;
                }

                protected abstract void convertValue(MethodVisitor var1, MethodSizeHandler.ForAdvice var2);

                @Override
                public net.bytebuddy.asm.Advice$Dispatcher$RelocationHandler$Bound bind(MethodDescription instrumentedMethod, Relocation relocation) {
                    return new Bound(instrumentedMethod, relocation, false);
                }

                protected class Bound
                implements net.bytebuddy.asm.Advice$Dispatcher$RelocationHandler$Bound {
                    private final MethodDescription instrumentedMethod;
                    private final Relocation relocation;
                    private final boolean inverted;

                    protected Bound(MethodDescription instrumentedMethod, Relocation relocation, boolean inverted) {
                        this.instrumentedMethod = instrumentedMethod;
                        this.relocation = relocation;
                        this.inverted = inverted;
                    }

                    @Override
                    public void apply(MethodVisitor methodVisitor, ArgumentHandler.ForAdvice argumentHandler, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler) {
                        if (this.instrumentedMethod.isConstructor()) {
                            throw new IllegalStateException("Cannot skip code execution from constructor: " + this.instrumentedMethod);
                        }
                        methodVisitor.visitVarInsn(ForValue.this.load, argumentHandler.enter());
                        ForValue.this.convertValue(methodVisitor, methodSizeHandler);
                        Label noSkip = new Label();
                        methodVisitor.visitJumpInsn(this.inverted ? ForValue.this.nonDefaultJump : ForValue.this.defaultJump, noSkip);
                        this.relocation.apply(methodVisitor);
                        methodVisitor.visitLabel(noSkip);
                    }

                    public int hashCode() {
                        int result = ForValue.this.hashCode();
                        result = 31 * result + (this.inverted ? 1 : 0);
                        result = 31 * result + this.instrumentedMethod.hashCode();
                        result = 31 * result + this.relocation.hashCode();
                        return result;
                    }

                    public boolean equals(Object other) {
                        if (other == this) {
                            return true;
                        }
                        if (other == null || this.getClass() != other.getClass()) {
                            return false;
                        }
                        Bound bound = (Bound)other;
                        return ForValue.this.equals(bound.getOuter()) && this.inverted == bound.inverted && this.instrumentedMethod.equals(bound.instrumentedMethod) && this.relocation.equals(bound.relocation);
                    }

                    private ForValue getOuter() {
                        return ForValue.this;
                    }
                }

                protected class Inverted
                implements RelocationHandler {
                    protected Inverted() {
                    }

                    @Override
                    public net.bytebuddy.asm.Advice$Dispatcher$RelocationHandler$Bound bind(MethodDescription instrumentedMethod, Relocation relocation) {
                        return new Bound(instrumentedMethod, relocation, true);
                    }

                    public int hashCode() {
                        return ForValue.this.hashCode();
                    }

                    public boolean equals(Object other) {
                        if (other == this) {
                            return true;
                        }
                        if (other == null || this.getClass() != other.getClass()) {
                            return false;
                        }
                        return ForValue.this.equals(((Inverted)other).getOuter());
                    }

                    private ForValue getOuter() {
                        return ForValue.this;
                    }
                }
            }

            public static enum Disabled implements RelocationHandler,
            Bound
            {
                INSTANCE;


                @Override
                public Bound bind(MethodDescription instrumentedMethod, Relocation relocation) {
                    return this;
                }

                @Override
                public void apply(MethodVisitor methodVisitor, ArgumentHandler.ForAdvice argumentHandler, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler) {
                }
            }

            public static interface Bound {
                public void apply(MethodVisitor var1, ArgumentHandler.ForAdvice var2, MethodSizeHandler.ForAdvice var3, StackMapFrameHandler.ForAdvice var4);
            }

            public static interface Relocation {
                public void apply(MethodVisitor var1);

                public static enum Illegal implements Relocation
                {
                    INSTANCE;


                    @Override
                    public void apply(MethodVisitor methodVisitor) {
                        throw new IllegalStateException("Relocation is illegal");
                    }
                }
            }
        }

        public static interface SuppressionHandler {
            public Bound bind(StackManipulation var1);

            public static class Suppressing
            implements SuppressionHandler {
                private final TypeDescription suppressedType;

                protected Suppressing(TypeDescription suppressedType) {
                    this.suppressedType = suppressedType;
                }

                protected static SuppressionHandler of(TypeDescription suppressedType) {
                    return suppressedType.represents((Type)((Object)NoExceptionHandler.class)) ? NoOp.INSTANCE : new Suppressing(suppressedType);
                }

                @Override
                public net.bytebuddy.asm.Advice$Dispatcher$SuppressionHandler$Bound bind(StackManipulation exceptionHandler) {
                    return new Bound(this.suppressedType, exceptionHandler);
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Suppressing)) {
                        return false;
                    }
                    Suppressing other = (Suppressing)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    TypeDescription this$suppressedType = this.suppressedType;
                    TypeDescription other$suppressedType = other.suppressedType;
                    return !(this$suppressedType == null ? other$suppressedType != null : !this$suppressedType.equals(other$suppressedType));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof Suppressing;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    TypeDescription $suppressedType = this.suppressedType;
                    result = result * 59 + ($suppressedType == null ? 43 : $suppressedType.hashCode());
                    return result;
                }

                protected static class Bound
                implements net.bytebuddy.asm.Advice$Dispatcher$SuppressionHandler$Bound {
                    private final TypeDescription suppressedType;
                    private final StackManipulation exceptionHandler;
                    private final Label startOfMethod;
                    private final Label endOfMethod;

                    protected Bound(TypeDescription suppressedType, StackManipulation exceptionHandler) {
                        this.suppressedType = suppressedType;
                        this.exceptionHandler = exceptionHandler;
                        this.startOfMethod = new Label();
                        this.endOfMethod = new Label();
                    }

                    @Override
                    public void onPrepare(MethodVisitor methodVisitor) {
                        methodVisitor.visitTryCatchBlock(this.startOfMethod, this.endOfMethod, this.endOfMethod, this.suppressedType.getInternalName());
                    }

                    @Override
                    public void onStart(MethodVisitor methodVisitor) {
                        methodVisitor.visitLabel(this.startOfMethod);
                    }

                    @Override
                    public void onEnd(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, ReturnValueProducer returnValueProducer) {
                        methodVisitor.visitLabel(this.endOfMethod);
                        stackMapFrameHandler.injectExceptionFrame(methodVisitor);
                        methodSizeHandler.requireStackSize(1 + this.exceptionHandler.apply(methodVisitor, implementationContext).getMaximalSize());
                        returnValueProducer.onDefaultValue(methodVisitor);
                    }

                    @Override
                    public void onEndSkipped(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, ReturnValueProducer returnValueProducer) {
                        Label endOfHandler = new Label();
                        methodVisitor.visitJumpInsn(167, endOfHandler);
                        this.onEnd(methodVisitor, implementationContext, methodSizeHandler, stackMapFrameHandler, returnValueProducer);
                        methodVisitor.visitLabel(endOfHandler);
                    }
                }
            }

            public static enum NoOp implements SuppressionHandler,
            Bound
            {
                INSTANCE;


                @Override
                public Bound bind(StackManipulation exceptionHandler) {
                    return this;
                }

                @Override
                public void onPrepare(MethodVisitor methodVisitor) {
                }

                @Override
                public void onStart(MethodVisitor methodVisitor) {
                }

                @Override
                public void onEnd(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, ReturnValueProducer returnValueProducer) {
                }

                @Override
                public void onEndSkipped(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodSizeHandler.ForAdvice methodSizeHandler, StackMapFrameHandler.ForAdvice stackMapFrameHandler, ReturnValueProducer returnValueProducer) {
                }
            }

            public static interface Bound {
                public void onPrepare(MethodVisitor var1);

                public void onStart(MethodVisitor var1);

                public void onEnd(MethodVisitor var1, Implementation.Context var2, MethodSizeHandler.ForAdvice var3, StackMapFrameHandler.ForAdvice var4, ReturnValueProducer var5);

                public void onEndSkipped(MethodVisitor var1, Implementation.Context var2, MethodSizeHandler.ForAdvice var3, StackMapFrameHandler.ForAdvice var4, ReturnValueProducer var5);
            }

            public static interface ReturnValueProducer {
                public void onDefaultValue(MethodVisitor var1);
            }
        }

        public static interface Unresolved
        extends Dispatcher {
            public boolean isBinary();

            public TypeDescription getAdviceType();

            public Resolved.ForMethodEnter asMethodEnter(List<? extends OffsetMapping.Factory<?>> var1, ClassReader var2, Unresolved var3);

            public Resolved.ForMethodExit asMethodExit(List<? extends OffsetMapping.Factory<?>> var1, ClassReader var2, Unresolved var3);
        }
    }

    protected static interface StackMapFrameHandler {
        public void translateFrame(MethodVisitor var1, int var2, int var3, Object[] var4, int var5, Object[] var6);

        public void injectReturnFrame(MethodVisitor var1);

        public void injectExceptionFrame(MethodVisitor var1);

        public void injectCompletionFrame(MethodVisitor var1, boolean var2);

        public static abstract class Default
        implements ForInstrumentedMethod {
            protected static final Object[] EMPTY = new Object[0];
            protected final TypeDescription instrumentedType;
            protected final MethodDescription instrumentedMethod;
            protected final List<? extends TypeDescription> enterTypes;
            protected final List<? extends TypeDescription> exitTypes;
            protected final boolean expandFrames;
            protected int currentFrameDivergence;

            protected Default(TypeDescription instrumentedType, MethodDescription instrumentedMethod, List<? extends TypeDescription> enterTypes, List<? extends TypeDescription> exitTypes, boolean expandFrames) {
                this.instrumentedType = instrumentedType;
                this.instrumentedMethod = instrumentedMethod;
                this.enterTypes = enterTypes;
                this.exitTypes = exitTypes;
                this.expandFrames = expandFrames;
            }

            protected static ForInstrumentedMethod of(TypeDescription instrumentedType, MethodDescription instrumentedMethod, List<? extends TypeDescription> enterTypes, List<? extends TypeDescription> exitTypes, boolean exitAdvice, boolean copyArguments, ClassFileVersion classFileVersion, int writerFlags, int readerFlags) {
                if ((writerFlags & 2) != 0 || classFileVersion.isLessThan(ClassFileVersion.JAVA_V6)) {
                    return NoOp.INSTANCE;
                }
                if (!exitAdvice) {
                    return new Trivial(instrumentedType, instrumentedMethod, (readerFlags & 8) != 0);
                }
                if (copyArguments) {
                    return new WithPreservedArguments.UsingArgumentCopy(instrumentedType, instrumentedMethod, enterTypes, exitTypes, (readerFlags & 8) != 0);
                }
                return new WithPreservedArguments.RequiringConsistentShape(instrumentedType, instrumentedMethod, enterTypes, exitTypes, (readerFlags & 8) != 0);
            }

            protected static Object toFrame(TypeDescription typeDescription) {
                if (typeDescription.represents(Boolean.TYPE) || typeDescription.represents(Byte.TYPE) || typeDescription.represents(Short.TYPE) || typeDescription.represents(Character.TYPE) || typeDescription.represents(Integer.TYPE)) {
                    return Opcodes.INTEGER;
                }
                if (typeDescription.represents(Long.TYPE)) {
                    return Opcodes.LONG;
                }
                if (typeDescription.represents(Float.TYPE)) {
                    return Opcodes.FLOAT;
                }
                if (typeDescription.represents(Double.TYPE)) {
                    return Opcodes.DOUBLE;
                }
                return typeDescription.getInternalName();
            }

            @Override
            public net.bytebuddy.asm.Advice$StackMapFrameHandler$ForAdvice bindEnter(MethodDescription.InDefinedShape adviceMethod) {
                return new ForAdvice(adviceMethod, Collections.emptyList(), this.enterTypes, TranslationMode.ENTER);
            }

            @Override
            public int getReaderHint() {
                return this.expandFrames ? 8 : 0;
            }

            protected void translateFrame(MethodVisitor methodVisitor, TranslationMode translationMode, MethodDescription methodDescription, List<? extends TypeDescription> additionalTypes, int type, int localVariableLength, Object[] localVariable, int stackSize, Object[] stack) {
                switch (type) {
                    case 3: 
                    case 4: {
                        break;
                    }
                    case 1: {
                        this.currentFrameDivergence += localVariableLength;
                        break;
                    }
                    case 2: {
                        this.currentFrameDivergence -= localVariableLength;
                        if (this.currentFrameDivergence >= 0) break;
                        throw new IllegalStateException(methodDescription + " dropped " + Math.abs(this.currentFrameDivergence) + " implicit frames");
                    }
                    case -1: 
                    case 0: {
                        int offset;
                        if (methodDescription.getParameters().size() + (methodDescription.isStatic() ? 0 : 1) > localVariableLength) {
                            throw new IllegalStateException("Inconsistent frame length for " + methodDescription + ": " + localVariableLength);
                        }
                        if (methodDescription.isStatic()) {
                            offset = 0;
                        } else {
                            if (!translationMode.isPossibleThisFrameValue(this.instrumentedType, this.instrumentedMethod, localVariable[0])) {
                                throw new IllegalStateException(methodDescription + " is inconsistent for 'this' reference: " + localVariable[0]);
                            }
                            offset = 1;
                        }
                        for (int index = 0; index < methodDescription.getParameters().size(); ++index) {
                            if (Default.toFrame(((ParameterDescription)methodDescription.getParameters().get(index)).getType().asErasure()).equals(localVariable[index + offset])) continue;
                            throw new IllegalStateException(methodDescription + " is inconsistent at " + index + ": " + localVariable[index + offset]);
                        }
                        Object[] translated = new Object[localVariableLength - (methodDescription.isStatic() ? 0 : 1) - methodDescription.getParameters().size() + (this.instrumentedMethod.isStatic() ? 0 : 1) + this.instrumentedMethod.getParameters().size() + additionalTypes.size()];
                        int index = translationMode.copy(this.instrumentedType, this.instrumentedMethod, methodDescription, localVariable, translated);
                        for (TypeDescription typeDescription : additionalTypes) {
                            translated[index++] = Default.toFrame(typeDescription);
                        }
                        System.arraycopy(localVariable, methodDescription.getParameters().size() + (methodDescription.isStatic() ? 0 : 1), translated, index, translated.length - index);
                        localVariableLength = translated.length;
                        localVariable = translated;
                        this.currentFrameDivergence = translated.length - index;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected frame type: " + type);
                    }
                }
                methodVisitor.visitFrame(type, localVariableLength, localVariable, stackSize, stack);
            }

            protected void injectFullFrame(MethodVisitor methodVisitor, List<? extends TypeDescription> typesInArray, List<? extends TypeDescription> typesOnStack) {
                Object[] localVariable = new Object[this.instrumentedMethod.getParameters().size() + (this.instrumentedMethod.isStatic() ? 0 : 1) + typesInArray.size()];
                int index = 0;
                if (!this.instrumentedMethod.isStatic()) {
                    localVariable[index++] = Default.toFrame(this.instrumentedType);
                }
                for (TypeDescription typeDescription : this.instrumentedMethod.getParameters().asTypeList().asErasures()) {
                    localVariable[index++] = Default.toFrame(typeDescription);
                }
                for (TypeDescription typeDescription : typesInArray) {
                    localVariable[index++] = Default.toFrame(typeDescription);
                }
                index = 0;
                Object[] stackType = new Object[typesOnStack.size()];
                for (TypeDescription typeDescription : typesOnStack) {
                    stackType[index++] = Default.toFrame(typeDescription);
                }
                methodVisitor.visitFrame(this.expandFrames ? -1 : 0, localVariable.length, localVariable, stackType.length, stackType);
                this.currentFrameDivergence = 0;
            }

            protected class ForAdvice
            implements net.bytebuddy.asm.Advice$StackMapFrameHandler$ForAdvice {
                protected final MethodDescription.InDefinedShape adviceMethod;
                protected final List<? extends TypeDescription> startTypes;
                protected final List<? extends TypeDescription> endTypes;
                protected final TranslationMode translationMode;

                protected ForAdvice(MethodDescription.InDefinedShape adviceMethod, List<? extends TypeDescription> startTypes, List<? extends TypeDescription> endTypes, TranslationMode translationMode) {
                    this.adviceMethod = adviceMethod;
                    this.startTypes = startTypes;
                    this.endTypes = endTypes;
                    this.translationMode = translationMode;
                }

                @Override
                public void translateFrame(MethodVisitor methodVisitor, int type, int localVariableLength, Object[] localVariable, int stackSize, Object[] stack) {
                    Default.this.translateFrame(methodVisitor, this.translationMode, this.adviceMethod, this.startTypes, type, localVariableLength, localVariable, stackSize, stack);
                }

                @Override
                public void injectReturnFrame(MethodVisitor methodVisitor) {
                    if (!Default.this.expandFrames && Default.this.currentFrameDivergence == 0) {
                        if (this.adviceMethod.getReturnType().represents(Void.TYPE)) {
                            methodVisitor.visitFrame(3, EMPTY.length, EMPTY, EMPTY.length, EMPTY);
                        } else {
                            methodVisitor.visitFrame(4, EMPTY.length, EMPTY, 1, new Object[]{Default.toFrame(this.adviceMethod.getReturnType().asErasure())});
                        }
                    } else {
                        Default.this.injectFullFrame(methodVisitor, this.startTypes, this.adviceMethod.getReturnType().represents(Void.TYPE) ? Collections.emptyList() : Collections.singletonList(this.adviceMethod.getReturnType().asErasure()));
                    }
                }

                @Override
                public void injectExceptionFrame(MethodVisitor methodVisitor) {
                    if (!Default.this.expandFrames && Default.this.currentFrameDivergence == 0) {
                        methodVisitor.visitFrame(4, EMPTY.length, EMPTY, 1, new Object[]{org.objectweb.asm.Type.getInternalName(Throwable.class)});
                    } else {
                        Default.this.injectFullFrame(methodVisitor, this.startTypes, Collections.singletonList(TypeDescription.THROWABLE));
                    }
                }

                @Override
                public void injectCompletionFrame(MethodVisitor methodVisitor, boolean secondary) {
                    if (!Default.this.expandFrames && Default.this.currentFrameDivergence == 0 && this.endTypes.size() < 4) {
                        if (secondary || this.endTypes.isEmpty()) {
                            methodVisitor.visitFrame(3, EMPTY.length, EMPTY, EMPTY.length, EMPTY);
                        } else {
                            Object[] local = new Object[this.endTypes.size()];
                            int index = 0;
                            for (TypeDescription typeDescription : this.endTypes) {
                                local[index++] = Default.toFrame(typeDescription);
                            }
                            methodVisitor.visitFrame(1, local.length, local, EMPTY.length, EMPTY);
                        }
                    } else {
                        Default.this.injectFullFrame(methodVisitor, CompoundList.of(this.startTypes, this.endTypes), Collections.emptyList());
                    }
                }
            }

            protected static abstract class WithPreservedArguments
            extends Default {
                protected WithPreservedArguments(TypeDescription instrumentedType, MethodDescription instrumentedMethod, List<? extends TypeDescription> enterTypes, List<? extends TypeDescription> exitTypes, boolean expandFrames) {
                    super(instrumentedType, instrumentedMethod, enterTypes, exitTypes, expandFrames);
                }

                @Override
                public net.bytebuddy.asm.Advice$StackMapFrameHandler$ForAdvice bindExit(MethodDescription.InDefinedShape adviceMethod) {
                    return new ForAdvice(adviceMethod, CompoundList.of(this.enterTypes, this.exitTypes), Collections.emptyList(), TranslationMode.EXIT);
                }

                @Override
                public void injectReturnFrame(MethodVisitor methodVisitor) {
                    if (!this.expandFrames && this.currentFrameDivergence == 0 && !this.instrumentedMethod.isConstructor()) {
                        if (this.instrumentedMethod.getReturnType().represents(Void.TYPE)) {
                            methodVisitor.visitFrame(3, EMPTY.length, EMPTY, EMPTY.length, EMPTY);
                        } else {
                            methodVisitor.visitFrame(4, EMPTY.length, EMPTY, 1, new Object[]{WithPreservedArguments.toFrame(this.instrumentedMethod.getReturnType().asErasure())});
                        }
                    } else {
                        this.injectFullFrame(methodVisitor, this.enterTypes, this.instrumentedMethod.getReturnType().represents(Void.TYPE) ? Collections.emptyList() : Collections.singletonList(this.instrumentedMethod.getReturnType().asErasure()));
                    }
                }

                @Override
                public void injectExceptionFrame(MethodVisitor methodVisitor) {
                    if (!this.expandFrames && this.currentFrameDivergence == 0) {
                        methodVisitor.visitFrame(4, EMPTY.length, EMPTY, 1, new Object[]{org.objectweb.asm.Type.getInternalName(Throwable.class)});
                    } else {
                        this.injectFullFrame(methodVisitor, this.enterTypes, Collections.singletonList(TypeDescription.THROWABLE));
                    }
                }

                @Override
                public void injectCompletionFrame(MethodVisitor methodVisitor, boolean secondary) {
                    if (!(this.expandFrames || this.currentFrameDivergence != 0 || !secondary && this.instrumentedMethod.isConstructor())) {
                        if (secondary) {
                            methodVisitor.visitFrame(3, EMPTY.length, EMPTY, EMPTY.length, EMPTY);
                        } else {
                            Object[] local = new Object[this.exitTypes.size()];
                            int index = 0;
                            for (TypeDescription typeDescription : this.exitTypes) {
                                local[index++] = WithPreservedArguments.toFrame(typeDescription);
                            }
                            methodVisitor.visitFrame(1, local.length, local, EMPTY.length, EMPTY);
                        }
                    } else {
                        this.injectFullFrame(methodVisitor, CompoundList.of(this.enterTypes, this.exitTypes), Collections.emptyList());
                    }
                }

                protected static class UsingArgumentCopy
                extends WithPreservedArguments {
                    protected UsingArgumentCopy(TypeDescription instrumentedType, MethodDescription instrumentedMethod, List<? extends TypeDescription> enterTypes, List<? extends TypeDescription> exitTypes, boolean expandFrames) {
                        super(instrumentedType, instrumentedMethod, enterTypes, exitTypes, expandFrames);
                    }

                    @Override
                    public void injectStartFrame(MethodVisitor methodVisitor) {
                        if (!this.instrumentedMethod.isStatic() || !this.instrumentedMethod.getParameters().isEmpty()) {
                            if (!this.expandFrames && (this.instrumentedMethod.isStatic() ? 0 : 1) + this.instrumentedMethod.getParameters().size() < 4) {
                                Object[] localVariable = new Object[(this.instrumentedMethod.isStatic() ? 0 : 1) + this.instrumentedMethod.getParameters().size()];
                                int index = 0;
                                if (this.instrumentedMethod.isConstructor()) {
                                    localVariable[index++] = Opcodes.UNINITIALIZED_THIS;
                                } else if (!this.instrumentedMethod.isStatic()) {
                                    localVariable[index++] = UsingArgumentCopy.toFrame(this.instrumentedType);
                                }
                                for (TypeDescription typeDescription : this.instrumentedMethod.getParameters().asTypeList().asErasures()) {
                                    localVariable[index++] = UsingArgumentCopy.toFrame(typeDescription);
                                }
                                methodVisitor.visitFrame(1, localVariable.length, localVariable, EMPTY.length, EMPTY);
                            } else {
                                Object[] localVariable = new Object[(this.instrumentedMethod.isStatic() ? 0 : 2) + this.instrumentedMethod.getParameters().size() * 2 + this.enterTypes.size()];
                                int index = 0;
                                if (this.instrumentedMethod.isConstructor()) {
                                    localVariable[index++] = Opcodes.UNINITIALIZED_THIS;
                                } else if (!this.instrumentedMethod.isStatic()) {
                                    localVariable[index++] = UsingArgumentCopy.toFrame(this.instrumentedType);
                                }
                                for (TypeDescription typeDescription : this.instrumentedMethod.getParameters().asTypeList().asErasures()) {
                                    localVariable[index++] = UsingArgumentCopy.toFrame(typeDescription);
                                }
                                for (TypeDescription typeDescription : this.enterTypes) {
                                    localVariable[index++] = UsingArgumentCopy.toFrame(typeDescription);
                                }
                                if (this.instrumentedMethod.isConstructor()) {
                                    localVariable[index++] = Opcodes.UNINITIALIZED_THIS;
                                } else if (!this.instrumentedMethod.isStatic()) {
                                    localVariable[index++] = UsingArgumentCopy.toFrame(this.instrumentedType);
                                }
                                for (TypeDescription typeDescription : this.instrumentedMethod.getParameters().asTypeList().asErasures()) {
                                    localVariable[index++] = UsingArgumentCopy.toFrame(typeDescription);
                                }
                                methodVisitor.visitFrame(this.expandFrames ? -1 : 0, localVariable.length, localVariable, EMPTY.length, EMPTY);
                            }
                        }
                        this.currentFrameDivergence = (this.instrumentedMethod.isStatic() ? 0 : 1) + this.instrumentedMethod.getParameters().size();
                    }

                    @Override
                    @SuppressFBWarnings(value={"RC_REF_COMPARISON_BAD_PRACTICE"}, justification="Reference equality is required by ASM")
                    public void translateFrame(MethodVisitor methodVisitor, int type, int localVariableLength, Object[] localVariable, int stackSize, Object[] stack) {
                        switch (type) {
                            case 3: 
                            case 4: {
                                break;
                            }
                            case 1: {
                                this.currentFrameDivergence += localVariableLength;
                                break;
                            }
                            case 2: {
                                this.currentFrameDivergence -= localVariableLength;
                                break;
                            }
                            case -1: 
                            case 0: {
                                Object[] translated = new Object[localVariableLength + (this.instrumentedMethod.isStatic() ? 0 : 1) + this.instrumentedMethod.getParameters().size() + this.enterTypes.size()];
                                int index = 0;
                                if (this.instrumentedMethod.isConstructor()) {
                                    boolean uninitializedThis = false;
                                    for (int variableIndex = 0; variableIndex < localVariableLength; ++variableIndex) {
                                        if (localVariable[variableIndex] != Opcodes.UNINITIALIZED_THIS) continue;
                                        uninitializedThis = true;
                                        break;
                                    }
                                    translated[index++] = uninitializedThis ? Opcodes.UNINITIALIZED_THIS : UsingArgumentCopy.toFrame(this.instrumentedType);
                                } else if (!this.instrumentedMethod.isStatic()) {
                                    translated[index++] = UsingArgumentCopy.toFrame(this.instrumentedType);
                                }
                                for (TypeDescription typeDescription : this.instrumentedMethod.getParameters().asTypeList().asErasures()) {
                                    translated[index++] = UsingArgumentCopy.toFrame(typeDescription);
                                }
                                for (TypeDescription typeDescription : this.enterTypes) {
                                    translated[index++] = UsingArgumentCopy.toFrame(typeDescription);
                                }
                                System.arraycopy(localVariable, 0, translated, index, localVariableLength);
                                localVariableLength = translated.length;
                                localVariable = translated;
                                this.currentFrameDivergence = localVariableLength;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Unexpected frame type: " + type);
                            }
                        }
                        methodVisitor.visitFrame(type, localVariableLength, localVariable, stackSize, stack);
                    }
                }

                protected static class RequiringConsistentShape
                extends WithPreservedArguments {
                    protected RequiringConsistentShape(TypeDescription instrumentedType, MethodDescription instrumentedMethod, List<? extends TypeDescription> enterTypes, List<? extends TypeDescription> exitTypes, boolean expandFrames) {
                        super(instrumentedType, instrumentedMethod, enterTypes, exitTypes, expandFrames);
                    }

                    @Override
                    public void injectStartFrame(MethodVisitor methodVisitor) {
                    }

                    @Override
                    public void translateFrame(MethodVisitor methodVisitor, int type, int localVariableLength, Object[] localVariable, int stackSize, Object[] stack) {
                        this.translateFrame(methodVisitor, TranslationMode.COPY, this.instrumentedMethod, this.enterTypes, type, localVariableLength, localVariable, stackSize, stack);
                    }
                }
            }

            protected static class Trivial
            extends Default {
                protected Trivial(TypeDescription instrumentedType, MethodDescription instrumentedMethod, boolean expandFrames) {
                    super(instrumentedType, instrumentedMethod, Collections.emptyList(), Collections.emptyList(), expandFrames);
                }

                @Override
                public void translateFrame(MethodVisitor methodVisitor, int type, int localVariableLength, Object[] localVariable, int stackSize, Object[] stack) {
                    methodVisitor.visitFrame(type, localVariableLength, localVariable, stackSize, stack);
                }

                @Override
                public net.bytebuddy.asm.Advice$StackMapFrameHandler$ForAdvice bindExit(MethodDescription.InDefinedShape adviceMethod) {
                    throw new IllegalStateException("Did not expect exit advice " + adviceMethod + " for " + this.instrumentedMethod);
                }

                @Override
                public void injectReturnFrame(MethodVisitor methodVisitor) {
                    throw new IllegalStateException("Did not expect return frame for " + this.instrumentedMethod);
                }

                @Override
                public void injectExceptionFrame(MethodVisitor methodVisitor) {
                    throw new IllegalStateException("Did not expect exception frame for " + this.instrumentedMethod);
                }

                @Override
                public void injectCompletionFrame(MethodVisitor methodVisitor, boolean secondary) {
                    throw new IllegalStateException("Did not expect completion frame for " + this.instrumentedMethod);
                }

                @Override
                public void injectStartFrame(MethodVisitor methodVisitor) {
                }
            }

            protected static enum TranslationMode {
                COPY{

                    @Override
                    protected int copy(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription methodDescription, Object[] localVariable, Object[] translated) {
                        int length = instrumentedMethod.getParameters().size() + (instrumentedMethod.isStatic() ? 0 : 1);
                        System.arraycopy(localVariable, 0, translated, 0, length);
                        return length;
                    }

                    @Override
                    protected boolean isPossibleThisFrameValue(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Object frame) {
                        return instrumentedMethod.isConstructor() && Opcodes.UNINITIALIZED_THIS.equals(frame) || Default.toFrame(instrumentedType).equals(frame);
                    }
                }
                ,
                ENTER{

                    @Override
                    protected int copy(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription methodDescription, Object[] localVariable, Object[] translated) {
                        int index = 0;
                        if (!instrumentedMethod.isStatic()) {
                            translated[index++] = instrumentedMethod.isConstructor() ? Opcodes.UNINITIALIZED_THIS : Default.toFrame(instrumentedType);
                        }
                        for (TypeDescription typeDescription : instrumentedMethod.getParameters().asTypeList().asErasures()) {
                            translated[index++] = Default.toFrame(typeDescription);
                        }
                        return index;
                    }

                    @Override
                    protected boolean isPossibleThisFrameValue(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Object frame) {
                        return instrumentedMethod.isConstructor() ? Opcodes.UNINITIALIZED_THIS.equals(frame) : Default.toFrame(instrumentedType).equals(frame);
                    }
                }
                ,
                EXIT{

                    @Override
                    protected int copy(TypeDescription instrumentedType, MethodDescription instrumentedMethod, MethodDescription methodDescription, Object[] localVariable, Object[] translated) {
                        int index = 0;
                        if (!instrumentedMethod.isStatic()) {
                            translated[index++] = Default.toFrame(instrumentedType);
                        }
                        for (TypeDescription typeDescription : instrumentedMethod.getParameters().asTypeList().asErasures()) {
                            translated[index++] = Default.toFrame(typeDescription);
                        }
                        return index;
                    }

                    @Override
                    protected boolean isPossibleThisFrameValue(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Object frame) {
                        return Default.toFrame(instrumentedType).equals(frame);
                    }
                };


                protected abstract int copy(TypeDescription var1, MethodDescription var2, MethodDescription var3, Object[] var4, Object[] var5);

                protected abstract boolean isPossibleThisFrameValue(TypeDescription var1, MethodDescription var2, Object var3);
            }
        }

        public static enum NoOp implements ForInstrumentedMethod,
        ForAdvice
        {
            INSTANCE;


            @Override
            public ForAdvice bindEnter(MethodDescription.InDefinedShape adviceMethod) {
                return this;
            }

            @Override
            public ForAdvice bindExit(MethodDescription.InDefinedShape adviceMethod) {
                return this;
            }

            @Override
            public int getReaderHint() {
                return 4;
            }

            @Override
            public void translateFrame(MethodVisitor methodVisitor, int type, int localVariableLength, Object[] localVariable, int stackSize, Object[] stack) {
            }

            @Override
            public void injectReturnFrame(MethodVisitor methodVisitor) {
            }

            @Override
            public void injectExceptionFrame(MethodVisitor methodVisitor) {
            }

            @Override
            public void injectCompletionFrame(MethodVisitor methodVisitor, boolean secondary) {
            }

            @Override
            public void injectStartFrame(MethodVisitor methodVisitor) {
            }
        }

        public static interface ForAdvice
        extends StackMapFrameHandler {
        }

        public static interface ForInstrumentedMethod
        extends StackMapFrameHandler {
            public ForAdvice bindEnter(MethodDescription.InDefinedShape var1);

            public ForAdvice bindExit(MethodDescription.InDefinedShape var1);

            public int getReaderHint();

            public void injectStartFrame(MethodVisitor var1);
        }
    }

    protected static interface MethodSizeHandler {
        public static final int UNDEFINED_SIZE = Short.MAX_VALUE;

        public void requireStackSize(int var1);

        public void requireLocalVariableLength(int var1);

        public static abstract class Default
        implements ForInstrumentedMethod {
            protected final MethodDescription instrumentedMethod;
            protected final List<? extends TypeDescription> enterTypes;
            protected final List<? extends TypeDescription> exitTypes;
            protected int stackSize;
            protected int localVariableLength;

            protected Default(MethodDescription instrumentedMethod, List<? extends TypeDescription> enterTypes, List<? extends TypeDescription> exitTypes) {
                this.instrumentedMethod = instrumentedMethod;
                this.enterTypes = enterTypes;
                this.exitTypes = exitTypes;
            }

            protected static ForInstrumentedMethod of(MethodDescription instrumentedMethod, List<? extends TypeDescription> enterTypes, List<? extends TypeDescription> exitTypes, boolean copyArguments, int writerFlags) {
                if ((writerFlags & 3) != 0) {
                    return NoOp.INSTANCE;
                }
                if (copyArguments) {
                    return new WithCopiedArguments(instrumentedMethod, enterTypes, exitTypes);
                }
                return new WithRetainedArguments(instrumentedMethod, enterTypes, exitTypes);
            }

            @Override
            public net.bytebuddy.asm.Advice$MethodSizeHandler$ForAdvice bindEnter(MethodDescription.InDefinedShape adviceMethod) {
                this.stackSize = Math.max(this.stackSize, adviceMethod.getReturnType().getStackSize().getSize());
                this.localVariableLength = Math.max(this.localVariableLength, this.instrumentedMethod.getStackSize() + adviceMethod.getReturnType().getStackSize().getSize());
                return new ForAdvice(adviceMethod, Collections.emptyList(), this.enterTypes);
            }

            @Override
            public net.bytebuddy.asm.Advice$MethodSizeHandler$ForAdvice bindExit(MethodDescription.InDefinedShape adviceMethod, boolean skipThrowable) {
                this.stackSize = Math.max(this.stackSize, adviceMethod.getReturnType().getStackSize().maximum(skipThrowable ? StackSize.ZERO : StackSize.SINGLE).getSize());
                this.stackSize = Math.max(this.stackSize, adviceMethod.getReturnType().getStackSize().getSize());
                return new ForAdvice(adviceMethod, CompoundList.of(this.enterTypes, this.exitTypes), Collections.emptyList());
            }

            @Override
            public int compoundStackSize(int stackSize) {
                return Math.max(this.stackSize, stackSize);
            }

            @Override
            public int compoundLocalVariableLength(int localVariableLength) {
                return Math.max(this.localVariableLength, localVariableLength + StackSize.of(this.enterTypes) + StackSize.of(this.exitTypes));
            }

            @Override
            public void requireStackSize(int stackSize) {
                this.stackSize = Math.max(this.stackSize, stackSize);
            }

            @Override
            public void requireLocalVariableLength(int localVariableLength) {
                this.localVariableLength = Math.max(this.localVariableLength, localVariableLength);
            }

            protected class ForAdvice
            implements net.bytebuddy.asm.Advice$MethodSizeHandler$ForAdvice {
                private final MethodDescription.InDefinedShape adviceMethod;
                private final List<? extends TypeDescription> startTypes;
                private final List<? extends TypeDescription> endTypes;
                private int padding;

                protected ForAdvice(MethodDescription.InDefinedShape adviceMethod, List<? extends TypeDescription> startTypes, List<? extends TypeDescription> endTypes) {
                    this.adviceMethod = adviceMethod;
                    this.startTypes = startTypes;
                    this.endTypes = endTypes;
                }

                @Override
                public void requireLocalVariableLength(int localVariableLength) {
                    Default.this.requireLocalVariableLength(localVariableLength);
                }

                @Override
                public void requireStackSize(int stackSize) {
                    Default.this.requireStackSize(stackSize);
                }

                @Override
                public void recordMaxima(int stackSize, int localVariableLength) {
                    Default.this.stackSize = Math.max(Default.this.stackSize, stackSize) + this.padding;
                    Default.this.localVariableLength = Math.max(Default.this.localVariableLength, localVariableLength - this.adviceMethod.getStackSize() + Default.this.instrumentedMethod.getStackSize() + StackSize.of(this.startTypes) + StackSize.of(this.endTypes));
                }

                @Override
                public void recordPadding(int padding) {
                    this.padding = Math.max(this.padding, padding);
                }
            }

            protected static class WithCopiedArguments
            extends Default {
                protected WithCopiedArguments(MethodDescription instrumentedMethod, List<? extends TypeDescription> enterTypes, List<? extends TypeDescription> exitTypes) {
                    super(instrumentedMethod, enterTypes, exitTypes);
                }

                @Override
                public int compoundLocalVariableLength(int localVariableLength) {
                    return Math.max(this.localVariableLength, localVariableLength + StackSize.of(this.enterTypes) + StackSize.of(this.exitTypes) + this.instrumentedMethod.getStackSize());
                }
            }

            protected static class WithRetainedArguments
            extends Default {
                protected WithRetainedArguments(MethodDescription instrumentedMethod, List<? extends TypeDescription> enterTypes, List<? extends TypeDescription> exitTypes) {
                    super(instrumentedMethod, enterTypes, exitTypes);
                }

                @Override
                public int compoundLocalVariableLength(int localVariableLength) {
                    return Math.max(this.localVariableLength, localVariableLength + StackSize.of(this.enterTypes) + StackSize.of(this.exitTypes));
                }
            }
        }

        public static enum NoOp implements ForInstrumentedMethod,
        ForAdvice
        {
            INSTANCE;


            @Override
            public ForAdvice bindEnter(MethodDescription.InDefinedShape adviceMethod) {
                return this;
            }

            @Override
            public ForAdvice bindExit(MethodDescription.InDefinedShape adviceMethod, boolean skipThrowable) {
                return this;
            }

            @Override
            public int compoundStackSize(int stackSize) {
                return Short.MAX_VALUE;
            }

            @Override
            public int compoundLocalVariableLength(int localVariableLength) {
                return Short.MAX_VALUE;
            }

            @Override
            public void requireLocalVariableLength(int localVariableLength) {
            }

            @Override
            public void requireStackSize(int stackSize) {
            }

            @Override
            public void recordMaxima(int stackSize, int localVariableLength) {
            }

            @Override
            public void recordPadding(int padding) {
            }
        }

        public static interface ForAdvice
        extends MethodSizeHandler {
            public void recordMaxima(int var1, int var2);

            public void recordPadding(int var1);
        }

        public static interface ForInstrumentedMethod
        extends MethodSizeHandler {
            public ForAdvice bindEnter(MethodDescription.InDefinedShape var1);

            public ForAdvice bindExit(MethodDescription.InDefinedShape var1, boolean var2);

            public int compoundStackSize(int var1);

            public int compoundLocalVariableLength(int var1);
        }
    }

    public static interface ArgumentHandler {
        public static final int THIS_REFERENCE = 0;

        public int argument(int var1);

        public int enter();

        public int returned();

        public int thrown();

        public static enum Factory {
            SIMPLE{

                @Override
                protected ForInstrumentedMethod resolve(MethodDescription instrumentedMethod, TypeDefinition enterType) {
                    return new ForInstrumentedMethod.Simple(instrumentedMethod, enterType);
                }
            }
            ,
            COPYING{

                @Override
                protected ForInstrumentedMethod resolve(MethodDescription instrumentedMethod, TypeDefinition enterType) {
                    return new ForInstrumentedMethod.Copying(instrumentedMethod, enterType);
                }
            };


            protected abstract ForInstrumentedMethod resolve(MethodDescription var1, TypeDefinition var2);
        }

        public static interface ForAdvice
        extends ArgumentHandler {
            public int mapped(int var1);

            public static class ForMethodExit
            implements ForAdvice {
                protected final MethodDescription instrumentedMethod;
                protected final MethodDescription adviceMethod;
                protected final TypeDefinition enterType;
                protected final StackSize throwableSize;

                protected ForMethodExit(MethodDescription instrumentedMethod, MethodDescription adviceMethod, TypeDefinition enterType, StackSize throwableSize) {
                    this.instrumentedMethod = instrumentedMethod;
                    this.adviceMethod = adviceMethod;
                    this.enterType = enterType;
                    this.throwableSize = throwableSize;
                }

                @Override
                public int argument(int offset) {
                    return offset;
                }

                @Override
                public int enter() {
                    return this.instrumentedMethod.getStackSize();
                }

                @Override
                public int returned() {
                    return this.instrumentedMethod.getStackSize() + this.enterType.getStackSize().getSize();
                }

                @Override
                public int thrown() {
                    return this.instrumentedMethod.getStackSize() + this.enterType.getStackSize().getSize() + this.instrumentedMethod.getReturnType().getStackSize().getSize();
                }

                @Override
                public int mapped(int offset) {
                    return this.instrumentedMethod.getStackSize() + this.enterType.getStackSize().getSize() + this.instrumentedMethod.getReturnType().getStackSize().getSize() + this.throwableSize.getSize() - this.adviceMethod.getStackSize() + offset;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForMethodExit)) {
                        return false;
                    }
                    ForMethodExit other = (ForMethodExit)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    MethodDescription this$instrumentedMethod = this.instrumentedMethod;
                    MethodDescription other$instrumentedMethod = other.instrumentedMethod;
                    if (this$instrumentedMethod == null ? other$instrumentedMethod != null : !this$instrumentedMethod.equals(other$instrumentedMethod)) {
                        return false;
                    }
                    MethodDescription this$adviceMethod = this.adviceMethod;
                    MethodDescription other$adviceMethod = other.adviceMethod;
                    if (this$adviceMethod == null ? other$adviceMethod != null : !this$adviceMethod.equals(other$adviceMethod)) {
                        return false;
                    }
                    TypeDefinition this$enterType = this.enterType;
                    TypeDefinition other$enterType = other.enterType;
                    if (this$enterType == null ? other$enterType != null : !this$enterType.equals(other$enterType)) {
                        return false;
                    }
                    StackSize this$throwableSize = this.throwableSize;
                    StackSize other$throwableSize = other.throwableSize;
                    return !(this$throwableSize == null ? other$throwableSize != null : !((Object)((Object)this$throwableSize)).equals((Object)other$throwableSize));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ForMethodExit;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    MethodDescription $instrumentedMethod = this.instrumentedMethod;
                    result = result * 59 + ($instrumentedMethod == null ? 43 : $instrumentedMethod.hashCode());
                    MethodDescription $adviceMethod = this.adviceMethod;
                    result = result * 59 + ($adviceMethod == null ? 43 : $adviceMethod.hashCode());
                    TypeDefinition $enterType = this.enterType;
                    result = result * 59 + ($enterType == null ? 43 : $enterType.hashCode());
                    StackSize $throwableSize = this.throwableSize;
                    result = result * 59 + ($throwableSize == null ? 43 : ((Object)((Object)$throwableSize)).hashCode());
                    return result;
                }
            }

            public static class ForMethodEnter
            implements ForAdvice {
                private final MethodDescription instrumentedMethod;
                private final MethodDescription adviceMethod;

                protected ForMethodEnter(MethodDescription instrumentedMethod, MethodDescription adviceMethod) {
                    this.instrumentedMethod = instrumentedMethod;
                    this.adviceMethod = adviceMethod;
                }

                @Override
                public int argument(int offset) {
                    return offset;
                }

                @Override
                public int enter() {
                    return this.instrumentedMethod.getStackSize();
                }

                @Override
                public int returned() {
                    throw new IllegalStateException("Cannot resolve the return value offset during enter advice");
                }

                @Override
                public int thrown() {
                    throw new IllegalStateException("Cannot resolve the thrown value offset during enter advice");
                }

                @Override
                public int mapped(int offset) {
                    return this.instrumentedMethod.getStackSize() - this.adviceMethod.getStackSize() + offset;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForMethodEnter)) {
                        return false;
                    }
                    ForMethodEnter other = (ForMethodEnter)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    MethodDescription this$instrumentedMethod = this.instrumentedMethod;
                    MethodDescription other$instrumentedMethod = other.instrumentedMethod;
                    if (this$instrumentedMethod == null ? other$instrumentedMethod != null : !this$instrumentedMethod.equals(other$instrumentedMethod)) {
                        return false;
                    }
                    MethodDescription this$adviceMethod = this.adviceMethod;
                    MethodDescription other$adviceMethod = other.adviceMethod;
                    return !(this$adviceMethod == null ? other$adviceMethod != null : !this$adviceMethod.equals(other$adviceMethod));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ForMethodEnter;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    MethodDescription $instrumentedMethod = this.instrumentedMethod;
                    result = result * 59 + ($instrumentedMethod == null ? 43 : $instrumentedMethod.hashCode());
                    MethodDescription $adviceMethod = this.adviceMethod;
                    result = result * 59 + ($adviceMethod == null ? 43 : $adviceMethod.hashCode());
                    return result;
                }
            }
        }

        public static interface ForInstrumentedMethod
        extends ArgumentHandler {
            public int variable(int var1);

            public int prepare(MethodVisitor var1);

            public ForAdvice bindEnter(MethodDescription var1);

            public ForAdvice bindExit(MethodDescription var1, boolean var2);

            public boolean isCopyingArguments();

            public static class Copying
            implements ForInstrumentedMethod {
                private final MethodDescription instrumentedMethod;
                private final TypeDefinition enterType;

                protected Copying(MethodDescription instrumentedMethod, TypeDefinition enterType) {
                    this.instrumentedMethod = instrumentedMethod;
                    this.enterType = enterType;
                }

                @Override
                public int argument(int offset) {
                    return this.instrumentedMethod.getStackSize() + this.enterType.getStackSize().getSize() + offset;
                }

                @Override
                public int enter() {
                    return this.instrumentedMethod.getStackSize();
                }

                @Override
                public int returned() {
                    return this.instrumentedMethod.getStackSize() + this.enterType.getStackSize().getSize();
                }

                @Override
                public int thrown() {
                    return this.instrumentedMethod.getStackSize() + this.enterType.getStackSize().getSize() + this.instrumentedMethod.getReturnType().getStackSize().getSize();
                }

                @Override
                public int variable(int index) {
                    return (this.instrumentedMethod.isStatic() ? 0 : 1) + this.instrumentedMethod.getParameters().size() + (this.enterType.represents(Void.TYPE) ? 0 : 1) + index;
                }

                @Override
                public int prepare(MethodVisitor methodVisitor) {
                    StackSize stackSize;
                    if (!this.instrumentedMethod.isStatic()) {
                        methodVisitor.visitVarInsn(25, 0);
                        methodVisitor.visitVarInsn(58, this.instrumentedMethod.getStackSize() + this.enterType.getStackSize().getSize());
                        stackSize = StackSize.SINGLE;
                    } else {
                        stackSize = StackSize.ZERO;
                    }
                    for (ParameterDescription parameterDescription : this.instrumentedMethod.getParameters()) {
                        org.objectweb.asm.Type type = org.objectweb.asm.Type.getType((String)parameterDescription.getType().asErasure().getDescriptor());
                        methodVisitor.visitVarInsn(type.getOpcode(21), parameterDescription.getOffset());
                        methodVisitor.visitVarInsn(type.getOpcode(54), this.instrumentedMethod.getStackSize() + this.enterType.getStackSize().getSize() + parameterDescription.getOffset());
                        stackSize = stackSize.maximum(parameterDescription.getType().getStackSize());
                    }
                    return stackSize.getSize();
                }

                @Override
                public ForAdvice bindEnter(MethodDescription adviceMethod) {
                    return new ForAdvice.ForMethodEnter(this.instrumentedMethod, adviceMethod);
                }

                @Override
                public ForAdvice bindExit(MethodDescription adviceMethod, boolean skipThrowable) {
                    return new ForAdvice.ForMethodExit(this.instrumentedMethod, adviceMethod, this.enterType, skipThrowable ? StackSize.ZERO : StackSize.SINGLE);
                }

                @Override
                public boolean isCopyingArguments() {
                    return true;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Copying)) {
                        return false;
                    }
                    Copying other = (Copying)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    MethodDescription this$instrumentedMethod = this.instrumentedMethod;
                    MethodDescription other$instrumentedMethod = other.instrumentedMethod;
                    if (this$instrumentedMethod == null ? other$instrumentedMethod != null : !this$instrumentedMethod.equals(other$instrumentedMethod)) {
                        return false;
                    }
                    TypeDefinition this$enterType = this.enterType;
                    TypeDefinition other$enterType = other.enterType;
                    return !(this$enterType == null ? other$enterType != null : !this$enterType.equals(other$enterType));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof Copying;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    MethodDescription $instrumentedMethod = this.instrumentedMethod;
                    result = result * 59 + ($instrumentedMethod == null ? 43 : $instrumentedMethod.hashCode());
                    TypeDefinition $enterType = this.enterType;
                    result = result * 59 + ($enterType == null ? 43 : $enterType.hashCode());
                    return result;
                }
            }

            public static class Simple
            implements ForInstrumentedMethod {
                private final MethodDescription instrumentedMethod;
                private final TypeDefinition enterType;

                protected Simple(MethodDescription instrumentedMethod, TypeDefinition enterType) {
                    this.instrumentedMethod = instrumentedMethod;
                    this.enterType = enterType;
                }

                @Override
                public int argument(int offset) {
                    return offset < this.instrumentedMethod.getStackSize() ? offset : offset + this.enterType.getStackSize().getSize();
                }

                @Override
                public int enter() {
                    return this.instrumentedMethod.getStackSize();
                }

                @Override
                public int returned() {
                    return this.instrumentedMethod.getStackSize() + this.enterType.getStackSize().getSize();
                }

                @Override
                public int thrown() {
                    return this.instrumentedMethod.getStackSize() + this.enterType.getStackSize().getSize() + this.instrumentedMethod.getReturnType().getStackSize().getSize();
                }

                @Override
                public int variable(int index) {
                    return index < (this.instrumentedMethod.isStatic() ? 0 : 1) + this.instrumentedMethod.getParameters().size() ? index : index + (this.enterType.represents(Void.TYPE) ? 0 : 1);
                }

                @Override
                public int prepare(MethodVisitor methodVisitor) {
                    return 0;
                }

                @Override
                public ForAdvice bindEnter(MethodDescription adviceMethod) {
                    return new ForAdvice.ForMethodEnter(this.instrumentedMethod, adviceMethod);
                }

                @Override
                public ForAdvice bindExit(MethodDescription adviceMethod, boolean skipThrowable) {
                    return new ForAdvice.ForMethodExit(this.instrumentedMethod, adviceMethod, this.enterType, skipThrowable ? StackSize.ZERO : StackSize.SINGLE);
                }

                @Override
                public boolean isCopyingArguments() {
                    return false;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Simple)) {
                        return false;
                    }
                    Simple other = (Simple)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    MethodDescription this$instrumentedMethod = this.instrumentedMethod;
                    MethodDescription other$instrumentedMethod = other.instrumentedMethod;
                    if (this$instrumentedMethod == null ? other$instrumentedMethod != null : !this$instrumentedMethod.equals(other$instrumentedMethod)) {
                        return false;
                    }
                    TypeDefinition this$enterType = this.enterType;
                    TypeDefinition other$enterType = other.enterType;
                    return !(this$enterType == null ? other$enterType != null : !this$enterType.equals(other$enterType));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof Simple;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    MethodDescription $instrumentedMethod = this.instrumentedMethod;
                    result = result * 59 + ($instrumentedMethod == null ? 43 : $instrumentedMethod.hashCode());
                    TypeDefinition $enterType = this.enterType;
                    result = result * 59 + ($enterType == null ? 43 : $enterType.hashCode());
                    return result;
                }
            }
        }
    }

    public static interface OffsetMapping {
        public Target resolve(TypeDescription var1, MethodDescription var2, Assigner var3, ArgumentHandler var4, Sort var5);

        public static class ForSerializedValue
        implements OffsetMapping {
            private final TypeDescription.Generic target;
            private final TypeDescription typeDescription;
            private final StackManipulation deserialization;

            public ForSerializedValue(TypeDescription.Generic target, TypeDescription typeDescription, StackManipulation deserialization) {
                this.target = target;
                this.typeDescription = typeDescription;
                this.deserialization = deserialization;
            }

            @Override
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, Sort sort) {
                StackManipulation assignment = assigner.assign(this.typeDescription.asGenericType(), this.target, Assigner.Typing.DYNAMIC);
                if (!assignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.typeDescription + " to " + this.target);
                }
                return new Target.ForStackManipulation(new StackManipulation.Compound(this.deserialization, assignment));
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForSerializedValue)) {
                    return false;
                }
                ForSerializedValue other = (ForSerializedValue)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                TypeDescription.Generic this$target = this.target;
                TypeDescription.Generic other$target = other.target;
                if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
                    return false;
                }
                TypeDescription this$typeDescription = this.typeDescription;
                TypeDescription other$typeDescription = other.typeDescription;
                if (this$typeDescription == null ? other$typeDescription != null : !this$typeDescription.equals(other$typeDescription)) {
                    return false;
                }
                StackManipulation this$deserialization = this.deserialization;
                StackManipulation other$deserialization = other.deserialization;
                return !(this$deserialization == null ? other$deserialization != null : !this$deserialization.equals(other$deserialization));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForSerializedValue;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                TypeDescription.Generic $target = this.target;
                result = result * 59 + ($target == null ? 43 : $target.hashCode());
                TypeDescription $typeDescription = this.typeDescription;
                result = result * 59 + ($typeDescription == null ? 43 : $typeDescription.hashCode());
                StackManipulation $deserialization = this.deserialization;
                result = result * 59 + ($deserialization == null ? 43 : $deserialization.hashCode());
                return result;
            }

            public static class Factory<T extends Annotation>
            implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<T> {
                private final Class<T> annotationType;
                private final TypeDescription typeDescription;
                private final StackManipulation deserialization;

                protected Factory(Class<T> annotationType, TypeDescription typeDescription, StackManipulation deserialization) {
                    this.annotationType = annotationType;
                    this.typeDescription = typeDescription;
                    this.deserialization = deserialization;
                }

                public static <S extends Annotation> net.bytebuddy.asm.Advice$OffsetMapping$Factory<S> of(Class<S> annotationType, Serializable target, Class<?> targetType) {
                    if (!targetType.isInstance(target)) {
                        throw new IllegalArgumentException(target + " is no instance of " + targetType);
                    }
                    return new Factory<S>(annotationType, new TypeDescription.ForLoadedType(targetType), SerializedConstant.of(target));
                }

                @Override
                public Class<T> getAnnotationType() {
                    return this.annotationType;
                }

                @Override
                public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<T> annotation, Factory.AdviceType adviceType) {
                    return new ForSerializedValue(target.getType(), this.typeDescription, this.deserialization);
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Factory)) {
                        return false;
                    }
                    Factory other = (Factory)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Class<T> this$annotationType = this.getAnnotationType();
                    Class<T> other$annotationType = other.getAnnotationType();
                    if (this$annotationType == null ? other$annotationType != null : !this$annotationType.equals(other$annotationType)) {
                        return false;
                    }
                    TypeDescription this$typeDescription = this.typeDescription;
                    TypeDescription other$typeDescription = other.typeDescription;
                    if (this$typeDescription == null ? other$typeDescription != null : !this$typeDescription.equals(other$typeDescription)) {
                        return false;
                    }
                    StackManipulation this$deserialization = this.deserialization;
                    StackManipulation other$deserialization = other.deserialization;
                    return !(this$deserialization == null ? other$deserialization != null : !this$deserialization.equals(other$deserialization));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof Factory;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Class<T> $annotationType = this.getAnnotationType();
                    result = result * 59 + ($annotationType == null ? 43 : $annotationType.hashCode());
                    TypeDescription $typeDescription = this.typeDescription;
                    result = result * 59 + ($typeDescription == null ? 43 : $typeDescription.hashCode());
                    StackManipulation $deserialization = this.deserialization;
                    result = result * 59 + ($deserialization == null ? 43 : $deserialization.hashCode());
                    return result;
                }
            }
        }

        public static class ForStackManipulation
        implements OffsetMapping {
            private final StackManipulation stackManipulation;
            private final TypeDescription.Generic typeDescription;
            private final TypeDescription.Generic targetType;
            private final Assigner.Typing typing;

            public ForStackManipulation(StackManipulation stackManipulation, TypeDescription.Generic typeDescription, TypeDescription.Generic targetType, Assigner.Typing typing) {
                this.stackManipulation = stackManipulation;
                this.typeDescription = typeDescription;
                this.targetType = targetType;
                this.typing = typing;
            }

            @Override
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, Sort sort) {
                StackManipulation assigment = assigner.assign(this.typeDescription, this.targetType, this.typing);
                if (!assigment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.typeDescription + " to " + this.targetType);
                }
                return new Target.ForStackManipulation(new StackManipulation.Compound(this.stackManipulation, assigment));
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForStackManipulation)) {
                    return false;
                }
                ForStackManipulation other = (ForStackManipulation)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                StackManipulation this$stackManipulation = this.stackManipulation;
                StackManipulation other$stackManipulation = other.stackManipulation;
                if (this$stackManipulation == null ? other$stackManipulation != null : !this$stackManipulation.equals(other$stackManipulation)) {
                    return false;
                }
                TypeDescription.Generic this$typeDescription = this.typeDescription;
                TypeDescription.Generic other$typeDescription = other.typeDescription;
                if (this$typeDescription == null ? other$typeDescription != null : !this$typeDescription.equals(other$typeDescription)) {
                    return false;
                }
                TypeDescription.Generic this$targetType = this.targetType;
                TypeDescription.Generic other$targetType = other.targetType;
                if (this$targetType == null ? other$targetType != null : !this$targetType.equals(other$targetType)) {
                    return false;
                }
                Assigner.Typing this$typing = this.typing;
                Assigner.Typing other$typing = other.typing;
                return !(this$typing == null ? other$typing != null : !((Object)((Object)this$typing)).equals((Object)other$typing));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForStackManipulation;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                StackManipulation $stackManipulation = this.stackManipulation;
                result = result * 59 + ($stackManipulation == null ? 43 : $stackManipulation.hashCode());
                TypeDescription.Generic $typeDescription = this.typeDescription;
                result = result * 59 + ($typeDescription == null ? 43 : $typeDescription.hashCode());
                TypeDescription.Generic $targetType = this.targetType;
                result = result * 59 + ($targetType == null ? 43 : $targetType.hashCode());
                Assigner.Typing $typing = this.typing;
                result = result * 59 + ($typing == null ? 43 : ((Object)((Object)$typing)).hashCode());
                return result;
            }

            public static class OfAnnotationProperty<T extends Annotation>
            implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<T> {
                private final Class<T> annotationType;
                private final MethodDescription.InDefinedShape property;

                protected OfAnnotationProperty(Class<T> annotationType, MethodDescription.InDefinedShape property) {
                    this.annotationType = annotationType;
                    this.property = property;
                }

                public static <S extends Annotation> net.bytebuddy.asm.Advice$OffsetMapping$Factory<S> of(Class<S> annotationType, String property) {
                    if (!annotationType.isAnnotation()) {
                        throw new IllegalArgumentException("Not an annotation type: " + annotationType);
                    }
                    try {
                        return new OfAnnotationProperty<S>(annotationType, new MethodDescription.ForLoadedMethod(annotationType.getMethod(property, new Class[0])));
                    }
                    catch (NoSuchMethodException exception) {
                        throw new IllegalArgumentException("Cannot find a property " + property + " on " + annotationType, exception);
                    }
                }

                @Override
                public Class<T> getAnnotationType() {
                    return this.annotationType;
                }

                @Override
                public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<T> annotation, Factory.AdviceType adviceType) {
                    net.bytebuddy.asm.Advice$OffsetMapping$Factory<T> factory;
                    Object value = annotation.getValue(this.property).resolve();
                    if (value instanceof TypeDescription) {
                        factory = new Factory<T>(this.annotationType, (TypeDescription)value);
                    } else if (value instanceof EnumerationDescription) {
                        factory = new Factory<T>(this.annotationType, (EnumerationDescription)value);
                    } else {
                        if (value instanceof AnnotationDescription) {
                            throw new IllegalStateException("Cannot bind annotation as fixed value for " + this.property);
                        }
                        factory = Factory.of(this.annotationType, value);
                    }
                    return factory.make(target, annotation, adviceType);
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof OfAnnotationProperty)) {
                        return false;
                    }
                    OfAnnotationProperty other = (OfAnnotationProperty)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Class<T> this$annotationType = this.getAnnotationType();
                    Class<T> other$annotationType = other.getAnnotationType();
                    if (this$annotationType == null ? other$annotationType != null : !this$annotationType.equals(other$annotationType)) {
                        return false;
                    }
                    MethodDescription.InDefinedShape this$property = this.property;
                    MethodDescription.InDefinedShape other$property = other.property;
                    return !(this$property == null ? other$property != null : !this$property.equals(other$property));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof OfAnnotationProperty;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Class<T> $annotationType = this.getAnnotationType();
                    result = result * 59 + ($annotationType == null ? 43 : $annotationType.hashCode());
                    MethodDescription.InDefinedShape $property = this.property;
                    result = result * 59 + ($property == null ? 43 : $property.hashCode());
                    return result;
                }
            }

            public static class OfDefaultValue<T extends Annotation>
            implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<T> {
                private final Class<T> annotationType;

                public OfDefaultValue(Class<T> annotationType) {
                    this.annotationType = annotationType;
                }

                @Override
                public Class<T> getAnnotationType() {
                    return this.annotationType;
                }

                @Override
                public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<T> annotation, Factory.AdviceType adviceType) {
                    return new ForStackManipulation(DefaultValue.of(target.getType()), target.getType(), target.getType(), Assigner.Typing.STATIC);
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof OfDefaultValue)) {
                        return false;
                    }
                    OfDefaultValue other = (OfDefaultValue)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Class<T> this$annotationType = this.getAnnotationType();
                    Class<T> other$annotationType = other.getAnnotationType();
                    return !(this$annotationType == null ? other$annotationType != null : !this$annotationType.equals(other$annotationType));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof OfDefaultValue;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Class<T> $annotationType = this.getAnnotationType();
                    result = result * 59 + ($annotationType == null ? 43 : $annotationType.hashCode());
                    return result;
                }
            }

            public static class Factory<T extends Annotation>
            implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<T> {
                private final Class<T> annotationType;
                private final StackManipulation stackManipulation;
                private final TypeDescription.Generic typeDescription;

                public Factory(Class<T> annotationType, TypeDescription typeDescription) {
                    this(annotationType, ClassConstant.of(typeDescription), TypeDescription.CLASS.asGenericType());
                }

                public Factory(Class<T> annotationType, EnumerationDescription enumerationDescription) {
                    this(annotationType, FieldAccess.forEnumeration(enumerationDescription), enumerationDescription.getEnumerationType().asGenericType());
                }

                public Factory(Class<T> annotationType, StackManipulation stackManipulation, TypeDescription.Generic typeDescription) {
                    this.annotationType = annotationType;
                    this.stackManipulation = stackManipulation;
                    this.typeDescription = typeDescription;
                }

                public static <S extends Annotation> net.bytebuddy.asm.Advice$OffsetMapping$Factory<S> of(Class<S> annotationType, Object value) {
                    TypeDescription typeDescription;
                    StackManipulation stackManipulation;
                    if (value == null) {
                        return new OfDefaultValue<S>(annotationType);
                    }
                    if (value instanceof Boolean) {
                        stackManipulation = IntegerConstant.forValue((Boolean)value);
                        typeDescription = new TypeDescription.ForLoadedType(Boolean.TYPE);
                    } else if (value instanceof Byte) {
                        stackManipulation = IntegerConstant.forValue(((Byte)value).byteValue());
                        typeDescription = new TypeDescription.ForLoadedType(Byte.TYPE);
                    } else if (value instanceof Short) {
                        stackManipulation = IntegerConstant.forValue(((Short)value).shortValue());
                        typeDescription = new TypeDescription.ForLoadedType(Short.TYPE);
                    } else if (value instanceof Character) {
                        stackManipulation = IntegerConstant.forValue(((Character)value).charValue());
                        typeDescription = new TypeDescription.ForLoadedType(Character.TYPE);
                    } else if (value instanceof Integer) {
                        stackManipulation = IntegerConstant.forValue((Integer)value);
                        typeDescription = new TypeDescription.ForLoadedType(Integer.TYPE);
                    } else if (value instanceof Long) {
                        stackManipulation = LongConstant.forValue((Long)value);
                        typeDescription = new TypeDescription.ForLoadedType(Long.TYPE);
                    } else if (value instanceof Float) {
                        stackManipulation = FloatConstant.forValue(((Float)value).floatValue());
                        typeDescription = new TypeDescription.ForLoadedType(Float.TYPE);
                    } else if (value instanceof Double) {
                        stackManipulation = DoubleConstant.forValue((Double)value);
                        typeDescription = new TypeDescription.ForLoadedType(Double.TYPE);
                    } else if (value instanceof String) {
                        stackManipulation = new TextConstant((String)value);
                        typeDescription = TypeDescription.STRING;
                    } else {
                        throw new IllegalStateException("Not a constant value: " + value);
                    }
                    return new Factory<S>(annotationType, stackManipulation, typeDescription.asGenericType());
                }

                @Override
                public Class<T> getAnnotationType() {
                    return this.annotationType;
                }

                @Override
                public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<T> annotation, Factory.AdviceType adviceType) {
                    return new ForStackManipulation(this.stackManipulation, this.typeDescription, target.getType(), Assigner.Typing.STATIC);
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Factory)) {
                        return false;
                    }
                    Factory other = (Factory)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Class<T> this$annotationType = this.getAnnotationType();
                    Class<T> other$annotationType = other.getAnnotationType();
                    if (this$annotationType == null ? other$annotationType != null : !this$annotationType.equals(other$annotationType)) {
                        return false;
                    }
                    StackManipulation this$stackManipulation = this.stackManipulation;
                    StackManipulation other$stackManipulation = other.stackManipulation;
                    if (this$stackManipulation == null ? other$stackManipulation != null : !this$stackManipulation.equals(other$stackManipulation)) {
                        return false;
                    }
                    TypeDescription.Generic this$typeDescription = this.typeDescription;
                    TypeDescription.Generic other$typeDescription = other.typeDescription;
                    return !(this$typeDescription == null ? other$typeDescription != null : !this$typeDescription.equals(other$typeDescription));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof Factory;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Class<T> $annotationType = this.getAnnotationType();
                    result = result * 59 + ($annotationType == null ? 43 : $annotationType.hashCode());
                    StackManipulation $stackManipulation = this.stackManipulation;
                    result = result * 59 + ($stackManipulation == null ? 43 : $stackManipulation.hashCode());
                    TypeDescription.Generic $typeDescription = this.typeDescription;
                    result = result * 59 + ($typeDescription == null ? 43 : $typeDescription.hashCode());
                    return result;
                }
            }
        }

        public static class ForThrowable
        implements OffsetMapping {
            private final TypeDescription.Generic target;
            private final boolean readOnly;
            private final Assigner.Typing typing;

            protected ForThrowable(TypeDescription.Generic target, Thrown annotation) {
                this(target, annotation.readOnly(), annotation.typing());
            }

            public ForThrowable(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing) {
                this.target = target;
                this.readOnly = readOnly;
                this.typing = typing;
            }

            @Override
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, Sort sort) {
                StackManipulation readAssignment = assigner.assign(TypeDescription.THROWABLE.asGenericType(), this.target, this.typing);
                if (!readAssignment.isValid()) {
                    throw new IllegalStateException("Cannot assign Throwable to " + this.target);
                }
                if (this.readOnly) {
                    return new Target.ForVariable.ReadOnly(TypeDescription.THROWABLE, argumentHandler.thrown(), readAssignment);
                }
                StackManipulation writeAssignment = assigner.assign(this.target, TypeDescription.THROWABLE.asGenericType(), this.typing);
                if (!writeAssignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.target + " to Throwable");
                }
                return new Target.ForVariable.ReadWrite(TypeDescription.THROWABLE, argumentHandler.thrown(), readAssignment, writeAssignment);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForThrowable)) {
                    return false;
                }
                ForThrowable other = (ForThrowable)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                TypeDescription.Generic this$target = this.target;
                TypeDescription.Generic other$target = other.target;
                if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
                    return false;
                }
                if (this.readOnly != other.readOnly) {
                    return false;
                }
                Assigner.Typing this$typing = this.typing;
                Assigner.Typing other$typing = other.typing;
                return !(this$typing == null ? other$typing != null : !((Object)((Object)this$typing)).equals((Object)other$typing));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForThrowable;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                TypeDescription.Generic $target = this.target;
                result = result * 59 + ($target == null ? 43 : $target.hashCode());
                result = result * 59 + (this.readOnly ? 79 : 97);
                Assigner.Typing $typing = this.typing;
                result = result * 59 + ($typing == null ? 43 : ((Object)((Object)$typing)).hashCode());
                return result;
            }

            protected static enum Factory implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<Thrown>
            {
                INSTANCE;


                protected static net.bytebuddy.asm.Advice$OffsetMapping$Factory<?> of(MethodDescription.InDefinedShape adviceMethod) {
                    return adviceMethod.getDeclaredAnnotations().ofType(OnMethodExit.class).getValue(ON_THROWABLE).resolve(TypeDescription.class).represents((Type)((Object)NoExceptionHandler.class)) ? new Factory.Illegal<Thrown>(Thrown.class) : INSTANCE;
                }

                @Override
                public Class<Thrown> getAnnotationType() {
                    return Thrown.class;
                }

                @Override
                public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<Thrown> annotation, Factory.AdviceType adviceType) {
                    if (adviceType.isDelegation() && !annotation.loadSilent().readOnly()) {
                        throw new IllegalStateException("Cannot use writable " + target + " on read-only parameter");
                    }
                    return new ForThrowable(target.getType(), annotation.loadSilent());
                }
            }
        }

        public static class ForReturnValue
        implements OffsetMapping {
            private final TypeDescription.Generic target;
            private final boolean readOnly;
            private final Assigner.Typing typing;

            protected ForReturnValue(TypeDescription.Generic target, Return annotation) {
                this(target, annotation.readOnly(), annotation.typing());
            }

            public ForReturnValue(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing) {
                this.target = target;
                this.readOnly = readOnly;
                this.typing = typing;
            }

            @Override
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, Sort sort) {
                StackManipulation readAssignment = assigner.assign(instrumentedMethod.getReturnType(), this.target, this.typing);
                if (!readAssignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + instrumentedMethod.getReturnType() + " to " + this.target);
                }
                if (this.readOnly) {
                    return instrumentedMethod.getReturnType().represents(Void.TYPE) ? new Target.ForDefaultValue.ReadOnly(this.target) : new Target.ForVariable.ReadOnly(instrumentedMethod.getReturnType(), argumentHandler.returned(), readAssignment);
                }
                StackManipulation writeAssignment = assigner.assign(this.target, instrumentedMethod.getReturnType(), this.typing);
                if (!writeAssignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.target + " to " + instrumentedMethod.getReturnType());
                }
                return instrumentedMethod.getReturnType().represents(Void.TYPE) ? new Target.ForDefaultValue.ReadWrite(this.target) : new Target.ForVariable.ReadWrite(instrumentedMethod.getReturnType(), argumentHandler.returned(), readAssignment, writeAssignment);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForReturnValue)) {
                    return false;
                }
                ForReturnValue other = (ForReturnValue)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                TypeDescription.Generic this$target = this.target;
                TypeDescription.Generic other$target = other.target;
                if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
                    return false;
                }
                if (this.readOnly != other.readOnly) {
                    return false;
                }
                Assigner.Typing this$typing = this.typing;
                Assigner.Typing other$typing = other.typing;
                return !(this$typing == null ? other$typing != null : !((Object)((Object)this$typing)).equals((Object)other$typing));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForReturnValue;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                TypeDescription.Generic $target = this.target;
                result = result * 59 + ($target == null ? 43 : $target.hashCode());
                result = result * 59 + (this.readOnly ? 79 : 97);
                Assigner.Typing $typing = this.typing;
                result = result * 59 + ($typing == null ? 43 : ((Object)((Object)$typing)).hashCode());
                return result;
            }

            protected static enum Factory implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<Return>
            {
                INSTANCE;


                @Override
                public Class<Return> getAnnotationType() {
                    return Return.class;
                }

                @Override
                public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<Return> annotation, Factory.AdviceType adviceType) {
                    if (adviceType.isDelegation() && !annotation.loadSilent().readOnly()) {
                        throw new IllegalStateException("Cannot write return value for " + target + " in read-only context");
                    }
                    return new ForReturnValue(target.getType(), annotation.loadSilent());
                }
            }
        }

        public static class ForEnterValue
        implements OffsetMapping {
            private final TypeDescription.Generic target;
            private final TypeDescription.Generic enterType;
            private final boolean readOnly;
            private final Assigner.Typing typing;

            protected ForEnterValue(TypeDescription.Generic target, TypeDescription.Generic enterType, Enter enter) {
                this(target, enterType, enter.readOnly(), enter.typing());
            }

            public ForEnterValue(TypeDescription.Generic target, TypeDescription.Generic enterType, boolean readOnly, Assigner.Typing typing) {
                this.target = target;
                this.enterType = enterType;
                this.readOnly = readOnly;
                this.typing = typing;
            }

            @Override
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, Sort sort) {
                StackManipulation readAssignment = assigner.assign(this.enterType, this.target, this.typing);
                if (!readAssignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.enterType + " to " + this.target);
                }
                if (this.readOnly) {
                    return new Target.ForVariable.ReadOnly(this.target, argumentHandler.enter(), readAssignment);
                }
                StackManipulation writeAssignment = assigner.assign(this.target, this.enterType, this.typing);
                if (!writeAssignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.target + " to " + this.enterType);
                }
                return new Target.ForVariable.ReadWrite(this.target, argumentHandler.enter(), readAssignment, writeAssignment);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForEnterValue)) {
                    return false;
                }
                ForEnterValue other = (ForEnterValue)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                TypeDescription.Generic this$target = this.target;
                TypeDescription.Generic other$target = other.target;
                if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
                    return false;
                }
                TypeDescription.Generic this$enterType = this.enterType;
                TypeDescription.Generic other$enterType = other.enterType;
                if (this$enterType == null ? other$enterType != null : !this$enterType.equals(other$enterType)) {
                    return false;
                }
                if (this.readOnly != other.readOnly) {
                    return false;
                }
                Assigner.Typing this$typing = this.typing;
                Assigner.Typing other$typing = other.typing;
                return !(this$typing == null ? other$typing != null : !((Object)((Object)this$typing)).equals((Object)other$typing));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForEnterValue;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                TypeDescription.Generic $target = this.target;
                result = result * 59 + ($target == null ? 43 : $target.hashCode());
                TypeDescription.Generic $enterType = this.enterType;
                result = result * 59 + ($enterType == null ? 43 : $enterType.hashCode());
                result = result * 59 + (this.readOnly ? 79 : 97);
                Assigner.Typing $typing = this.typing;
                result = result * 59 + ($typing == null ? 43 : ((Object)((Object)$typing)).hashCode());
                return result;
            }

            protected static class Factory
            implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<Enter> {
                private final TypeDefinition enterType;

                protected Factory(TypeDefinition enterType) {
                    this.enterType = enterType;
                }

                @Override
                public Class<Enter> getAnnotationType() {
                    return Enter.class;
                }

                @Override
                public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<Enter> annotation, Factory.AdviceType adviceType) {
                    if (adviceType.isDelegation() && !annotation.loadSilent().readOnly()) {
                        throw new IllegalStateException("Cannot use writable " + target + " on read-only parameter");
                    }
                    return new ForEnterValue(target.getType(), this.enterType.asGenericType(), annotation.loadSilent());
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Factory)) {
                        return false;
                    }
                    Factory other = (Factory)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    TypeDefinition this$enterType = this.enterType;
                    TypeDefinition other$enterType = other.enterType;
                    return !(this$enterType == null ? other$enterType != null : !this$enterType.equals(other$enterType));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof Factory;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    TypeDefinition $enterType = this.enterType;
                    result = result * 59 + ($enterType == null ? 43 : $enterType.hashCode());
                    return result;
                }
            }
        }

        public static enum ForStubValue implements OffsetMapping,
        Factory<StubValue>
        {
            INSTANCE;


            @Override
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, Sort sort) {
                return new Target.ForDefaultValue.ReadOnly(instrumentedMethod.getReturnType(), assigner.assign(instrumentedMethod.getReturnType(), TypeDescription.Generic.OBJECT, Assigner.Typing.DYNAMIC));
            }

            @Override
            public Class<StubValue> getAnnotationType() {
                return StubValue.class;
            }

            @Override
            public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<StubValue> annotation, Factory.AdviceType adviceType) {
                if (!target.getType().represents((Type)((Object)Object.class))) {
                    throw new IllegalStateException("Cannot use StubValue on non-Object parameter type " + target);
                }
                return this;
            }
        }

        public static class ForUnusedValue
        implements OffsetMapping {
            private final TypeDefinition target;

            public ForUnusedValue(TypeDefinition target) {
                this.target = target;
            }

            @Override
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, Sort sort) {
                return new Target.ForDefaultValue.ReadWrite(this.target);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForUnusedValue)) {
                    return false;
                }
                ForUnusedValue other = (ForUnusedValue)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                TypeDefinition this$target = this.target;
                TypeDefinition other$target = other.target;
                return !(this$target == null ? other$target != null : !this$target.equals(other$target));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForUnusedValue;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                TypeDefinition $target = this.target;
                result = result * 59 + ($target == null ? 43 : $target.hashCode());
                return result;
            }

            protected static enum Factory implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<Unused>
            {
                INSTANCE;


                @Override
                public Class<Unused> getAnnotationType() {
                    return Unused.class;
                }

                @Override
                public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<Unused> annotation, Factory.AdviceType adviceType) {
                    return new ForUnusedValue(target.getType());
                }
            }
        }

        public static class ForOrigin
        implements OffsetMapping {
            private static final char DELIMITER = '#';
            private static final char ESCAPE = '\\';
            private final List<Renderer> renderers;

            public ForOrigin(List<Renderer> renderers) {
                this.renderers = renderers;
            }

            public static OffsetMapping parse(String pattern) {
                if (pattern.equals("")) {
                    return new ForOrigin(Collections.singletonList(Renderer.ForStringRepresentation.INSTANCE));
                }
                ArrayList<Renderer> renderers = new ArrayList<Renderer>(pattern.length());
                int from = 0;
                int to = pattern.indexOf(35);
                while (to != -1) {
                    if (to != 0 && pattern.charAt(to - 1) == '\\' && (to == 1 || pattern.charAt(to - 2) != '\\')) {
                        renderers.add(new Renderer.ForConstantValue(pattern.substring(from, Math.max(0, to - 1)) + '#'));
                        from = to + 1;
                    } else {
                        if (pattern.length() == to + 1) {
                            throw new IllegalStateException("Missing sort descriptor for " + pattern + " at index " + to);
                        }
                        renderers.add(new Renderer.ForConstantValue(pattern.substring(from, to).replace("\\\\", "\\")));
                        switch (pattern.charAt(to + 1)) {
                            case 'm': {
                                renderers.add(Renderer.ForMethodName.INSTANCE);
                                break;
                            }
                            case 't': {
                                renderers.add(Renderer.ForTypeName.INSTANCE);
                                break;
                            }
                            case 'd': {
                                renderers.add(Renderer.ForDescriptor.INSTANCE);
                                break;
                            }
                            case 'r': {
                                renderers.add(Renderer.ForReturnTypeName.INSTANCE);
                                break;
                            }
                            case 's': {
                                renderers.add(Renderer.ForJavaSignature.INSTANCE);
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Illegal sort descriptor " + pattern.charAt(to + 1) + " for " + pattern);
                            }
                        }
                        from = to + 2;
                    }
                    to = pattern.indexOf(35, from);
                }
                renderers.add(new Renderer.ForConstantValue(pattern.substring(from)));
                return new ForOrigin(renderers);
            }

            @Override
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, Sort sort) {
                StringBuilder stringBuilder = new StringBuilder();
                for (Renderer renderer : this.renderers) {
                    stringBuilder.append(renderer.apply(instrumentedType, instrumentedMethod));
                }
                return Target.ForStackManipulation.of(stringBuilder.toString());
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForOrigin)) {
                    return false;
                }
                ForOrigin other = (ForOrigin)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                List<Renderer> this$renderers = this.renderers;
                List<Renderer> other$renderers = other.renderers;
                return !(this$renderers == null ? other$renderers != null : !((Object)this$renderers).equals(other$renderers));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForOrigin;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<Renderer> $renderers = this.renderers;
                result = result * 59 + ($renderers == null ? 43 : ((Object)$renderers).hashCode());
                return result;
            }

            protected static enum Factory implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<Origin>
            {
                INSTANCE;


                @Override
                public Class<Origin> getAnnotationType() {
                    return Origin.class;
                }

                @Override
                public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<Origin> annotation, Factory.AdviceType adviceType) {
                    if (target.getType().asErasure().represents((Type)((Object)Class.class))) {
                        return ForInstrumentedType.INSTANCE;
                    }
                    if (target.getType().asErasure().represents((Type)((Object)Method.class))) {
                        return ForInstrumentedMethod.METHOD;
                    }
                    if (target.getType().asErasure().represents((Type)((Object)Constructor.class))) {
                        return ForInstrumentedMethod.CONSTRUCTOR;
                    }
                    if (JavaType.EXECUTABLE.getTypeStub().equals(target.getType().asErasure())) {
                        return ForInstrumentedMethod.EXECUTABLE;
                    }
                    if (target.getType().asErasure().isAssignableFrom(String.class)) {
                        return ForOrigin.parse(annotation.loadSilent().value());
                    }
                    throw new IllegalStateException("Non-supported type " + target.getType() + " for @Origin annotation");
                }
            }

            public static interface Renderer {
                public String apply(TypeDescription var1, MethodDescription var2);

                public static class ForConstantValue
                implements Renderer {
                    private final String value;

                    public ForConstantValue(String value) {
                        this.value = value;
                    }

                    @Override
                    public String apply(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                        return this.value;
                    }

                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof ForConstantValue)) {
                            return false;
                        }
                        ForConstantValue other = (ForConstantValue)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$value = this.value;
                        String other$value = other.value;
                        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
                    }

                    protected boolean canEqual(Object other) {
                        return other instanceof ForConstantValue;
                    }

                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $value = this.value;
                        result = result * 59 + ($value == null ? 43 : $value.hashCode());
                        return result;
                    }
                }

                public static enum ForStringRepresentation implements Renderer
                {
                    INSTANCE;


                    @Override
                    public String apply(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                        return instrumentedMethod.toString();
                    }
                }

                public static enum ForReturnTypeName implements Renderer
                {
                    INSTANCE;

                    public static final char SYMBOL = 'r';

                    @Override
                    public String apply(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                        return instrumentedMethod.getReturnType().asErasure().getName();
                    }
                }

                public static enum ForJavaSignature implements Renderer
                {
                    INSTANCE;

                    public static final char SYMBOL = 's';

                    @Override
                    public String apply(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                        StringBuilder stringBuilder = new StringBuilder("(");
                        boolean comma = false;
                        for (TypeDescription typeDescription : instrumentedMethod.getParameters().asTypeList().asErasures()) {
                            if (comma) {
                                stringBuilder.append(',');
                            } else {
                                comma = true;
                            }
                            stringBuilder.append(typeDescription.getName());
                        }
                        return stringBuilder.append(')').toString();
                    }
                }

                public static enum ForDescriptor implements Renderer
                {
                    INSTANCE;

                    public static final char SYMBOL = 'd';

                    @Override
                    public String apply(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                        return instrumentedMethod.getDescriptor();
                    }
                }

                public static enum ForTypeName implements Renderer
                {
                    INSTANCE;

                    public static final char SYMBOL = 't';

                    @Override
                    public String apply(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                        return instrumentedType.getName();
                    }
                }

                public static enum ForMethodName implements Renderer
                {
                    INSTANCE;

                    public static final char SYMBOL = 'm';

                    @Override
                    public String apply(TypeDescription instrumentedType, MethodDescription instrumentedMethod) {
                        return instrumentedMethod.getInternalName();
                    }
                }
            }
        }

        public static abstract class ForField
        implements OffsetMapping {
            private static final MethodDescription.InDefinedShape VALUE;
            private static final MethodDescription.InDefinedShape DECLARING_TYPE;
            private static final MethodDescription.InDefinedShape READ_ONLY;
            private static final MethodDescription.InDefinedShape TYPING;
            private final TypeDescription.Generic target;
            private final boolean readOnly;
            private final Assigner.Typing typing;

            public ForField(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing) {
                this.target = target;
                this.readOnly = readOnly;
                this.typing = typing;
            }

            @Override
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, Sort sort) {
                FieldDescription fieldDescription = this.resolve(instrumentedType);
                if (!fieldDescription.isStatic() && instrumentedMethod.isStatic()) {
                    throw new IllegalStateException("Cannot read non-static field " + fieldDescription + " from static method " + instrumentedMethod);
                }
                if (sort.isPremature(instrumentedMethod) && !fieldDescription.isStatic()) {
                    throw new IllegalStateException("Cannot access non-static field before calling constructor: " + instrumentedMethod);
                }
                StackManipulation readAssignment = assigner.assign(fieldDescription.getType(), this.target, this.typing);
                if (!readAssignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + fieldDescription + " to " + this.target);
                }
                if (this.readOnly) {
                    return new Target.ForField.ReadOnly(fieldDescription, readAssignment);
                }
                StackManipulation writeAssignment = assigner.assign(this.target, fieldDescription.getType(), this.typing);
                if (!writeAssignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.target + " to " + fieldDescription);
                }
                return new Target.ForField.ReadWrite((FieldDescription)fieldDescription.asDefined(), readAssignment, writeAssignment);
            }

            protected abstract FieldDescription resolve(TypeDescription var1);

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForField)) {
                    return false;
                }
                ForField other = (ForField)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                TypeDescription.Generic this$target = this.target;
                TypeDescription.Generic other$target = other.target;
                if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
                    return false;
                }
                if (this.readOnly != other.readOnly) {
                    return false;
                }
                Assigner.Typing this$typing = this.typing;
                Assigner.Typing other$typing = other.typing;
                return !(this$typing == null ? other$typing != null : !((Object)((Object)this$typing)).equals((Object)other$typing));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForField;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                TypeDescription.Generic $target = this.target;
                result = result * 59 + ($target == null ? 43 : $target.hashCode());
                result = result * 59 + (this.readOnly ? 79 : 97);
                Assigner.Typing $typing = this.typing;
                result = result * 59 + ($typing == null ? 43 : ((Object)((Object)$typing)).hashCode());
                return result;
            }

            static {
                MethodList<MethodDescription.InDefinedShape> methods = new TypeDescription.ForLoadedType(FieldValue.class).getDeclaredMethods();
                VALUE = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("value"))).getOnly();
                DECLARING_TYPE = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("declaringType"))).getOnly();
                READ_ONLY = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("readOnly"))).getOnly();
                TYPING = (MethodDescription.InDefinedShape)((MethodList)methods.filter(ElementMatchers.named("typing"))).getOnly();
            }

            public static class Resolved
            extends ForField {
                private final FieldDescription fieldDescription;

                public Resolved(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing, FieldDescription fieldDescription) {
                    super(target, readOnly, typing);
                    this.fieldDescription = fieldDescription;
                }

                @Override
                protected FieldDescription resolve(TypeDescription instrumentedType) {
                    if (!this.fieldDescription.isStatic() && !this.fieldDescription.getDeclaringType().asErasure().isAssignableFrom(instrumentedType)) {
                        throw new IllegalStateException(this.fieldDescription + " is no member of " + instrumentedType);
                    }
                    if (!this.fieldDescription.isAccessibleTo(instrumentedType)) {
                        throw new IllegalStateException("Cannot access " + this.fieldDescription + " from " + instrumentedType);
                    }
                    return this.fieldDescription;
                }

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Resolved)) {
                        return false;
                    }
                    Resolved other = (Resolved)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    if (!super.equals(o)) {
                        return false;
                    }
                    FieldDescription this$fieldDescription = this.fieldDescription;
                    FieldDescription other$fieldDescription = other.fieldDescription;
                    return !(this$fieldDescription == null ? other$fieldDescription != null : !this$fieldDescription.equals(other$fieldDescription));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Resolved;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = super.hashCode();
                    FieldDescription $fieldDescription = this.fieldDescription;
                    result = result * 59 + ($fieldDescription == null ? 43 : $fieldDescription.hashCode());
                    return result;
                }

                public static class Factory<T extends Annotation>
                implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<T> {
                    private final Class<T> annotationType;
                    private final FieldDescription fieldDescription;
                    private final boolean readOnly;
                    private final Assigner.Typing typing;

                    public Factory(Class<T> annotationType, FieldDescription fieldDescription) {
                        this(annotationType, fieldDescription, true, Assigner.Typing.STATIC);
                    }

                    public Factory(Class<T> annotationType, FieldDescription fieldDescription, boolean readOnly, Assigner.Typing typing) {
                        this.annotationType = annotationType;
                        this.fieldDescription = fieldDescription;
                        this.readOnly = readOnly;
                        this.typing = typing;
                    }

                    @Override
                    public Class<T> getAnnotationType() {
                        return this.annotationType;
                    }

                    @Override
                    public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<T> annotation, Factory.AdviceType adviceType) {
                        return new Resolved(target.getType(), this.readOnly, this.typing, this.fieldDescription);
                    }

                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Factory)) {
                            return false;
                        }
                        Factory other = (Factory)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        Class<T> this$annotationType = this.getAnnotationType();
                        Class<T> other$annotationType = other.getAnnotationType();
                        if (this$annotationType == null ? other$annotationType != null : !this$annotationType.equals(other$annotationType)) {
                            return false;
                        }
                        FieldDescription this$fieldDescription = this.fieldDescription;
                        FieldDescription other$fieldDescription = other.fieldDescription;
                        if (this$fieldDescription == null ? other$fieldDescription != null : !this$fieldDescription.equals(other$fieldDescription)) {
                            return false;
                        }
                        if (this.readOnly != other.readOnly) {
                            return false;
                        }
                        Assigner.Typing this$typing = this.typing;
                        Assigner.Typing other$typing = other.typing;
                        return !(this$typing == null ? other$typing != null : !((Object)((Object)this$typing)).equals((Object)other$typing));
                    }

                    protected boolean canEqual(Object other) {
                        return other instanceof Factory;
                    }

                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        Class<T> $annotationType = this.getAnnotationType();
                        result = result * 59 + ($annotationType == null ? 43 : $annotationType.hashCode());
                        FieldDescription $fieldDescription = this.fieldDescription;
                        result = result * 59 + ($fieldDescription == null ? 43 : $fieldDescription.hashCode());
                        result = result * 59 + (this.readOnly ? 79 : 97);
                        Assigner.Typing $typing = this.typing;
                        result = result * 59 + ($typing == null ? 43 : ((Object)((Object)$typing)).hashCode());
                        return result;
                    }
                }
            }

            public static abstract class Unresolved
            extends ForField {
                private final String name;

                public Unresolved(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing, String name) {
                    super(target, readOnly, typing);
                    this.name = name;
                }

                @Override
                protected FieldDescription resolve(TypeDescription instrumentedType) {
                    FieldLocator.Resolution resolution = this.fieldLocator(instrumentedType).locate(this.name);
                    if (!resolution.isResolved()) {
                        throw new IllegalStateException("Cannot locate field named " + this.name + " for " + instrumentedType);
                    }
                    return resolution.getField();
                }

                protected abstract FieldLocator fieldLocator(TypeDescription var1);

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Unresolved)) {
                        return false;
                    }
                    Unresolved other = (Unresolved)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    if (!super.equals(o)) {
                        return false;
                    }
                    String this$name = this.name;
                    String other$name = other.name;
                    return !(this$name == null ? other$name != null : !this$name.equals(other$name));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Unresolved;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = super.hashCode();
                    String $name = this.name;
                    result = result * 59 + ($name == null ? 43 : $name.hashCode());
                    return result;
                }

                protected static enum Factory implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<FieldValue>
                {
                    INSTANCE;


                    @Override
                    public Class<FieldValue> getAnnotationType() {
                        return FieldValue.class;
                    }

                    @Override
                    public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<FieldValue> annotation, Factory.AdviceType adviceType) {
                        if (adviceType.isDelegation() && !annotation.getValue(READ_ONLY).resolve(Boolean.class).booleanValue()) {
                            throw new IllegalStateException("Cannot write to field for " + target + " in read-only context");
                        }
                        TypeDescription declaringType = annotation.getValue(DECLARING_TYPE).resolve(TypeDescription.class);
                        return declaringType.represents(Void.TYPE) ? new WithImplicitType(target.getType(), annotation) : new WithExplicitType(target.getType(), annotation, declaringType);
                    }
                }

                public static class WithExplicitType
                extends Unresolved {
                    private final TypeDescription declaringType;

                    protected WithExplicitType(TypeDescription.Generic target, AnnotationDescription.Loadable<FieldValue> annotation, TypeDescription declaringType) {
                        this(target, annotation.getValue(READ_ONLY).resolve(Boolean.class), annotation.getValue(TYPING).loadSilent(Assigner.Typing.class.getClassLoader()).resolve(Assigner.Typing.class), annotation.getValue(VALUE).resolve(String.class), declaringType);
                    }

                    public WithExplicitType(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing, String name, TypeDescription declaringType) {
                        super(target, readOnly, typing, name);
                        this.declaringType = declaringType;
                    }

                    @Override
                    protected FieldLocator fieldLocator(TypeDescription instrumentedType) {
                        if (!this.declaringType.represents((Type)((Object)TargetType.class)) && !instrumentedType.isAssignableTo(this.declaringType)) {
                            throw new IllegalStateException(this.declaringType + " is no super type of " + instrumentedType);
                        }
                        return new FieldLocator.ForExactType(TargetType.resolve(this.declaringType, instrumentedType));
                    }

                    @Override
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof WithExplicitType)) {
                            return false;
                        }
                        WithExplicitType other = (WithExplicitType)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        if (!super.equals(o)) {
                            return false;
                        }
                        TypeDescription this$declaringType = this.declaringType;
                        TypeDescription other$declaringType = other.declaringType;
                        return !(this$declaringType == null ? other$declaringType != null : !this$declaringType.equals(other$declaringType));
                    }

                    @Override
                    protected boolean canEqual(Object other) {
                        return other instanceof WithExplicitType;
                    }

                    @Override
                    public int hashCode() {
                        int PRIME = 59;
                        int result = super.hashCode();
                        TypeDescription $declaringType = this.declaringType;
                        result = result * 59 + ($declaringType == null ? 43 : $declaringType.hashCode());
                        return result;
                    }
                }

                public static class WithImplicitType
                extends Unresolved {
                    protected WithImplicitType(TypeDescription.Generic target, AnnotationDescription.Loadable<FieldValue> annotation) {
                        this(target, annotation.getValue(READ_ONLY).resolve(Boolean.class), annotation.getValue(TYPING).loadSilent(Assigner.Typing.class.getClassLoader()).resolve(Assigner.Typing.class), annotation.getValue(VALUE).resolve(String.class));
                    }

                    public WithImplicitType(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing, String name) {
                        super(target, readOnly, typing, name);
                    }

                    @Override
                    protected FieldLocator fieldLocator(TypeDescription instrumentedType) {
                        return new FieldLocator.ForClassHierarchy(instrumentedType);
                    }
                }
            }
        }

        public static enum ForInstrumentedMethod implements OffsetMapping
        {
            METHOD{

                @Override
                protected boolean isRepresentable(MethodDescription instrumentedMethod) {
                    return instrumentedMethod.isMethod();
                }
            }
            ,
            CONSTRUCTOR{

                @Override
                protected boolean isRepresentable(MethodDescription instrumentedMethod) {
                    return instrumentedMethod.isConstructor();
                }
            }
            ,
            EXECUTABLE{

                @Override
                protected boolean isRepresentable(MethodDescription instrumentedMethod) {
                    return true;
                }
            };


            @Override
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, Sort sort) {
                if (!this.isRepresentable(instrumentedMethod)) {
                    throw new IllegalStateException("Cannot represent " + instrumentedMethod + " as given method constant");
                }
                return Target.ForStackManipulation.of((MethodDescription.InDefinedShape)instrumentedMethod.asDefined());
            }

            protected abstract boolean isRepresentable(MethodDescription var1);
        }

        public static enum ForInstrumentedType implements OffsetMapping
        {
            INSTANCE;


            @Override
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, Sort sort) {
                return Target.ForStackManipulation.of(instrumentedType);
            }
        }

        public static class ForAllArguments
        implements OffsetMapping {
            private final TypeDescription.Generic target;
            private final boolean readOnly;
            private final Assigner.Typing typing;

            protected ForAllArguments(TypeDescription.Generic target, AllArguments annotation) {
                this(target, annotation.readOnly(), annotation.typing());
            }

            public ForAllArguments(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing) {
                this.target = target;
                this.readOnly = readOnly;
                this.typing = typing;
            }

            @Override
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, Sort sort) {
                ArrayList<StackManipulation.Compound> valueReads = new ArrayList<StackManipulation.Compound>(instrumentedMethod.getParameters().size());
                for (ParameterDescription parameterDescription : instrumentedMethod.getParameters()) {
                    StackManipulation readAssignment = assigner.assign(parameterDescription.getType(), this.target, this.typing);
                    if (!readAssignment.isValid()) {
                        throw new IllegalStateException("Cannot assign " + parameterDescription + " to " + this.target);
                    }
                    valueReads.add(new StackManipulation.Compound(MethodVariableAccess.of(parameterDescription.getType()).loadFrom(argumentHandler.argument(parameterDescription.getOffset())), readAssignment));
                }
                if (this.readOnly) {
                    return new Target.ForArray.ReadOnly(this.target, valueReads);
                }
                ArrayList<StackManipulation.Compound> valueWrites = new ArrayList<StackManipulation.Compound>(instrumentedMethod.getParameters().size());
                for (ParameterDescription parameterDescription : instrumentedMethod.getParameters()) {
                    StackManipulation writeAssignment = assigner.assign(this.target, parameterDescription.getType(), this.typing);
                    if (!writeAssignment.isValid()) {
                        throw new IllegalStateException("Cannot assign " + this.target + " to " + parameterDescription);
                    }
                    valueWrites.add(new StackManipulation.Compound(writeAssignment, MethodVariableAccess.of(parameterDescription.getType()).storeAt(argumentHandler.argument(parameterDescription.getOffset()))));
                }
                return new Target.ForArray.ReadWrite(this.target, valueReads, valueWrites);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForAllArguments)) {
                    return false;
                }
                ForAllArguments other = (ForAllArguments)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                TypeDescription.Generic this$target = this.target;
                TypeDescription.Generic other$target = other.target;
                if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
                    return false;
                }
                if (this.readOnly != other.readOnly) {
                    return false;
                }
                Assigner.Typing this$typing = this.typing;
                Assigner.Typing other$typing = other.typing;
                return !(this$typing == null ? other$typing != null : !((Object)((Object)this$typing)).equals((Object)other$typing));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForAllArguments;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                TypeDescription.Generic $target = this.target;
                result = result * 59 + ($target == null ? 43 : $target.hashCode());
                result = result * 59 + (this.readOnly ? 79 : 97);
                Assigner.Typing $typing = this.typing;
                result = result * 59 + ($typing == null ? 43 : ((Object)((Object)$typing)).hashCode());
                return result;
            }

            protected static enum Factory implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<AllArguments>
            {
                INSTANCE;


                @Override
                public Class<AllArguments> getAnnotationType() {
                    return AllArguments.class;
                }

                @Override
                public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<AllArguments> annotation, Factory.AdviceType adviceType) {
                    if (!target.getType().represents((Type)((Object)Object.class)) && !target.getType().isArray()) {
                        throw new IllegalStateException("Cannot use AllArguments annotation on a non-array type");
                    }
                    if (adviceType.isDelegation() && !annotation.loadSilent().readOnly()) {
                        throw new IllegalStateException("Cannot define writable field access for " + target);
                    }
                    return new ForAllArguments(target.getType().represents((Type)((Object)Object.class)) ? TypeDescription.Generic.OBJECT : target.getType().getComponentType(), annotation.loadSilent());
                }
            }
        }

        public static class ForThisReference
        implements OffsetMapping {
            private final TypeDescription.Generic target;
            private final boolean readOnly;
            private final Assigner.Typing typing;
            private final boolean optional;

            protected ForThisReference(TypeDescription.Generic target, This annotation) {
                this(target, annotation.readOnly(), annotation.typing(), annotation.optional());
            }

            public ForThisReference(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing, boolean optional) {
                this.target = target;
                this.readOnly = readOnly;
                this.typing = typing;
                this.optional = optional;
            }

            @Override
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, Sort sort) {
                if (instrumentedMethod.isStatic() || sort.isPremature(instrumentedMethod)) {
                    if (this.optional) {
                        return this.readOnly ? new Target.ForDefaultValue.ReadOnly(instrumentedType) : new Target.ForDefaultValue.ReadWrite(instrumentedType);
                    }
                    throw new IllegalStateException("Cannot map this reference for static method or constructor start: " + instrumentedMethod);
                }
                StackManipulation readAssignment = assigner.assign(instrumentedType.asGenericType(), this.target, this.typing);
                if (!readAssignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + instrumentedType + " to " + this.target);
                }
                if (this.readOnly) {
                    return new Target.ForVariable.ReadOnly(instrumentedType.asGenericType(), argumentHandler.argument(0), readAssignment);
                }
                StackManipulation writeAssignment = assigner.assign(this.target, instrumentedType.asGenericType(), this.typing);
                if (!writeAssignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + this.target + " to " + instrumentedType);
                }
                return new Target.ForVariable.ReadWrite(instrumentedType.asGenericType(), argumentHandler.argument(0), readAssignment, writeAssignment);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForThisReference)) {
                    return false;
                }
                ForThisReference other = (ForThisReference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                TypeDescription.Generic this$target = this.target;
                TypeDescription.Generic other$target = other.target;
                if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
                    return false;
                }
                if (this.readOnly != other.readOnly) {
                    return false;
                }
                Assigner.Typing this$typing = this.typing;
                Assigner.Typing other$typing = other.typing;
                if (this$typing == null ? other$typing != null : !((Object)((Object)this$typing)).equals((Object)other$typing)) {
                    return false;
                }
                return this.optional == other.optional;
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForThisReference;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                TypeDescription.Generic $target = this.target;
                result = result * 59 + ($target == null ? 43 : $target.hashCode());
                result = result * 59 + (this.readOnly ? 79 : 97);
                Assigner.Typing $typing = this.typing;
                result = result * 59 + ($typing == null ? 43 : ((Object)((Object)$typing)).hashCode());
                result = result * 59 + (this.optional ? 79 : 97);
                return result;
            }

            protected static enum Factory implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<This>
            {
                INSTANCE;


                @Override
                public Class<This> getAnnotationType() {
                    return This.class;
                }

                @Override
                public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<This> annotation, Factory.AdviceType adviceType) {
                    if (adviceType.isDelegation() && !annotation.loadSilent().readOnly()) {
                        throw new IllegalStateException("Cannot write to this reference for " + target + " in read-only context");
                    }
                    return new ForThisReference(target.getType(), annotation.loadSilent());
                }
            }
        }

        public static abstract class ForArgument
        implements OffsetMapping {
            protected final TypeDescription.Generic target;
            protected final boolean readOnly;
            private final Assigner.Typing typing;

            protected ForArgument(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing) {
                this.target = target;
                this.readOnly = readOnly;
                this.typing = typing;
            }

            @Override
            public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, Sort sort) {
                ParameterDescription parameterDescription = this.resolve(instrumentedMethod);
                StackManipulation readAssignment = assigner.assign(parameterDescription.getType(), this.target, this.typing);
                if (!readAssignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + parameterDescription + " to " + this.target);
                }
                if (this.readOnly) {
                    return new Target.ForVariable.ReadOnly(parameterDescription.getType(), argumentHandler.argument(parameterDescription.getOffset()), readAssignment);
                }
                StackManipulation writeAssignment = assigner.assign(this.target, parameterDescription.getType(), this.typing);
                if (!writeAssignment.isValid()) {
                    throw new IllegalStateException("Cannot assign " + parameterDescription + " to " + this.target);
                }
                return new Target.ForVariable.ReadWrite(parameterDescription.getType(), argumentHandler.argument(parameterDescription.getOffset()), readAssignment, writeAssignment);
            }

            protected abstract ParameterDescription resolve(MethodDescription var1);

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ForArgument)) {
                    return false;
                }
                ForArgument other = (ForArgument)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                TypeDescription.Generic this$target = this.target;
                TypeDescription.Generic other$target = other.target;
                if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
                    return false;
                }
                if (this.readOnly != other.readOnly) {
                    return false;
                }
                Assigner.Typing this$typing = this.typing;
                Assigner.Typing other$typing = other.typing;
                return !(this$typing == null ? other$typing != null : !((Object)((Object)this$typing)).equals((Object)other$typing));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ForArgument;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                TypeDescription.Generic $target = this.target;
                result = result * 59 + ($target == null ? 43 : $target.hashCode());
                result = result * 59 + (this.readOnly ? 79 : 97);
                Assigner.Typing $typing = this.typing;
                result = result * 59 + ($typing == null ? 43 : ((Object)((Object)$typing)).hashCode());
                return result;
            }

            public static class Resolved
            extends ForArgument {
                private final ParameterDescription parameterDescription;

                public Resolved(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing, ParameterDescription parameterDescription) {
                    super(target, readOnly, typing);
                    this.parameterDescription = parameterDescription;
                }

                @Override
                protected ParameterDescription resolve(MethodDescription instrumentedMethod) {
                    if (!this.parameterDescription.getDeclaringMethod().equals(instrumentedMethod)) {
                        throw new IllegalStateException(this.parameterDescription + " is not a parameter of " + instrumentedMethod);
                    }
                    return this.parameterDescription;
                }

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Resolved)) {
                        return false;
                    }
                    Resolved other = (Resolved)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    if (!super.equals(o)) {
                        return false;
                    }
                    ParameterDescription this$parameterDescription = this.parameterDescription;
                    ParameterDescription other$parameterDescription = other.parameterDescription;
                    return !(this$parameterDescription == null ? other$parameterDescription != null : !this$parameterDescription.equals(other$parameterDescription));
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Resolved;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = super.hashCode();
                    ParameterDescription $parameterDescription = this.parameterDescription;
                    result = result * 59 + ($parameterDescription == null ? 43 : $parameterDescription.hashCode());
                    return result;
                }

                public static class Factory<T extends Annotation>
                implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<T> {
                    private final Class<T> annotationType;
                    private final ParameterDescription parameterDescription;
                    private final boolean readOnly;
                    private final Assigner.Typing typing;

                    public Factory(Class<T> annotationType, ParameterDescription parameterDescription) {
                        this(annotationType, parameterDescription, true, Assigner.Typing.STATIC);
                    }

                    public Factory(Class<T> annotationType, ParameterDescription parameterDescription, boolean readOnly, Assigner.Typing typing) {
                        this.annotationType = annotationType;
                        this.parameterDescription = parameterDescription;
                        this.readOnly = readOnly;
                        this.typing = typing;
                    }

                    @Override
                    public Class<T> getAnnotationType() {
                        return this.annotationType;
                    }

                    @Override
                    public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<T> annotation, Factory.AdviceType adviceType) {
                        return new Resolved(target.getType(), this.readOnly, this.typing, this.parameterDescription);
                    }

                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Factory)) {
                            return false;
                        }
                        Factory other = (Factory)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        Class<T> this$annotationType = this.getAnnotationType();
                        Class<T> other$annotationType = other.getAnnotationType();
                        if (this$annotationType == null ? other$annotationType != null : !this$annotationType.equals(other$annotationType)) {
                            return false;
                        }
                        ParameterDescription this$parameterDescription = this.parameterDescription;
                        ParameterDescription other$parameterDescription = other.parameterDescription;
                        if (this$parameterDescription == null ? other$parameterDescription != null : !this$parameterDescription.equals(other$parameterDescription)) {
                            return false;
                        }
                        if (this.readOnly != other.readOnly) {
                            return false;
                        }
                        Assigner.Typing this$typing = this.typing;
                        Assigner.Typing other$typing = other.typing;
                        return !(this$typing == null ? other$typing != null : !((Object)((Object)this$typing)).equals((Object)other$typing));
                    }

                    protected boolean canEqual(Object other) {
                        return other instanceof Factory;
                    }

                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        Class<T> $annotationType = this.getAnnotationType();
                        result = result * 59 + ($annotationType == null ? 43 : $annotationType.hashCode());
                        ParameterDescription $parameterDescription = this.parameterDescription;
                        result = result * 59 + ($parameterDescription == null ? 43 : $parameterDescription.hashCode());
                        result = result * 59 + (this.readOnly ? 79 : 97);
                        Assigner.Typing $typing = this.typing;
                        result = result * 59 + ($typing == null ? 43 : ((Object)((Object)$typing)).hashCode());
                        return result;
                    }
                }
            }

            public static class Unresolved
            extends ForArgument {
                private final int index;
                private final boolean optional;

                protected Unresolved(TypeDescription.Generic target, Argument argument) {
                    this(target, argument.readOnly(), argument.typing(), argument.value(), argument.optional());
                }

                protected Unresolved(ParameterDescription parameterDescription) {
                    this(parameterDescription.getType(), true, Assigner.Typing.STATIC, parameterDescription.getIndex());
                }

                public Unresolved(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing, int index) {
                    this(target, readOnly, typing, index, false);
                }

                public Unresolved(TypeDescription.Generic target, boolean readOnly, Assigner.Typing typing, int index, boolean optional) {
                    super(target, readOnly, typing);
                    this.index = index;
                    this.optional = optional;
                }

                @Override
                protected ParameterDescription resolve(MethodDescription instrumentedMethod) {
                    ParameterList<?> parameters = instrumentedMethod.getParameters();
                    if (parameters.size() <= this.index) {
                        throw new IllegalStateException(instrumentedMethod + " does not define an index " + this.index);
                    }
                    return (ParameterDescription)parameters.get(this.index);
                }

                @Override
                public Target resolve(TypeDescription instrumentedType, MethodDescription instrumentedMethod, Assigner assigner, ArgumentHandler argumentHandler, Sort sort) {
                    if (this.optional && instrumentedMethod.getParameters().size() <= this.index) {
                        return this.readOnly ? new Target.ForDefaultValue.ReadOnly(this.target) : new Target.ForDefaultValue.ReadWrite(this.target);
                    }
                    return super.resolve(instrumentedType, instrumentedMethod, assigner, argumentHandler, sort);
                }

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Unresolved)) {
                        return false;
                    }
                    Unresolved other = (Unresolved)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    if (!super.equals(o)) {
                        return false;
                    }
                    if (this.index != other.index) {
                        return false;
                    }
                    return this.optional == other.optional;
                }

                @Override
                protected boolean canEqual(Object other) {
                    return other instanceof Unresolved;
                }

                @Override
                public int hashCode() {
                    int PRIME = 59;
                    int result = super.hashCode();
                    result = result * 59 + this.index;
                    result = result * 59 + (this.optional ? 79 : 97);
                    return result;
                }

                protected static enum Factory implements net.bytebuddy.asm.Advice$OffsetMapping$Factory<Argument>
                {
                    INSTANCE;


                    @Override
                    public Class<Argument> getAnnotationType() {
                        return Argument.class;
                    }

                    @Override
                    public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<Argument> annotation, Factory.AdviceType adviceType) {
                        if (adviceType.isDelegation() && !annotation.loadSilent().readOnly()) {
                            throw new IllegalStateException("Cannot define writable field access for " + target + " when using delegation");
                        }
                        return new Unresolved(target.getType(), annotation.loadSilent());
                    }
                }
            }
        }

        public static enum Sort {
            ENTER{

                @Override
                public boolean isPremature(MethodDescription methodDescription) {
                    return methodDescription.isConstructor();
                }
            }
            ,
            EXIT{

                @Override
                public boolean isPremature(MethodDescription methodDescription) {
                    return false;
                }
            };


            public abstract boolean isPremature(MethodDescription var1);
        }

        public static interface Factory<T extends Annotation> {
            public Class<T> getAnnotationType();

            public OffsetMapping make(ParameterDescription.InDefinedShape var1, AnnotationDescription.Loadable<T> var2, AdviceType var3);

            public static class Illegal<T extends Annotation>
            implements Factory<T> {
                private final Class<T> annotationType;

                public Illegal(Class<T> annotationType) {
                    this.annotationType = annotationType;
                }

                @Override
                public Class<T> getAnnotationType() {
                    return this.annotationType;
                }

                @Override
                public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<T> annotation, AdviceType adviceType) {
                    throw new IllegalStateException("Usage of " + this.annotationType + " is not allowed on " + target);
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Illegal)) {
                        return false;
                    }
                    Illegal other = (Illegal)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Class<T> this$annotationType = this.getAnnotationType();
                    Class<T> other$annotationType = other.getAnnotationType();
                    return !(this$annotationType == null ? other$annotationType != null : !this$annotationType.equals(other$annotationType));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof Illegal;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Class<T> $annotationType = this.getAnnotationType();
                    result = result * 59 + ($annotationType == null ? 43 : $annotationType.hashCode());
                    return result;
                }
            }

            public static class Simple<T extends Annotation>
            implements Factory<T> {
                private final Class<T> annotationType;
                private final OffsetMapping offsetMapping;

                public Simple(Class<T> annotationType, OffsetMapping offsetMapping) {
                    this.annotationType = annotationType;
                    this.offsetMapping = offsetMapping;
                }

                @Override
                public Class<T> getAnnotationType() {
                    return this.annotationType;
                }

                @Override
                public OffsetMapping make(ParameterDescription.InDefinedShape target, AnnotationDescription.Loadable<T> annotation, AdviceType adviceType) {
                    return this.offsetMapping;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Simple)) {
                        return false;
                    }
                    Simple other = (Simple)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Class<T> this$annotationType = this.getAnnotationType();
                    Class<T> other$annotationType = other.getAnnotationType();
                    if (this$annotationType == null ? other$annotationType != null : !this$annotationType.equals(other$annotationType)) {
                        return false;
                    }
                    OffsetMapping this$offsetMapping = this.offsetMapping;
                    OffsetMapping other$offsetMapping = other.offsetMapping;
                    return !(this$offsetMapping == null ? other$offsetMapping != null : !this$offsetMapping.equals(other$offsetMapping));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof Simple;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Class<T> $annotationType = this.getAnnotationType();
                    result = result * 59 + ($annotationType == null ? 43 : $annotationType.hashCode());
                    OffsetMapping $offsetMapping = this.offsetMapping;
                    result = result * 59 + ($offsetMapping == null ? 43 : $offsetMapping.hashCode());
                    return result;
                }
            }

            public static enum AdviceType {
                DELEGATION(true),
                INLINING(false);

                private final boolean delegation;

                private AdviceType(boolean delegation) {
                    this.delegation = delegation;
                }

                public boolean isDelegation() {
                    return this.delegation;
                }
            }
        }

        public static interface Target {
            public StackManipulation resolveRead();

            public StackManipulation resolveWrite();

            public StackManipulation resolveIncrement(int var1);

            public static class ForStackManipulation
            implements Target {
                private final StackManipulation stackManipulation;

                public ForStackManipulation(StackManipulation stackManipulation) {
                    this.stackManipulation = stackManipulation;
                }

                public static Target of(MethodDescription.InDefinedShape methodDescription) {
                    return new ForStackManipulation(MethodConstant.forMethod(methodDescription));
                }

                public static Target of(TypeDescription typeDescription) {
                    return new ForStackManipulation(ClassConstant.of(typeDescription));
                }

                public static Target of(Object value) {
                    if (value == null) {
                        return new ForStackManipulation(NullConstant.INSTANCE);
                    }
                    if (value instanceof Boolean) {
                        return new ForStackManipulation(IntegerConstant.forValue((Boolean)value));
                    }
                    if (value instanceof Byte) {
                        return new ForStackManipulation(IntegerConstant.forValue(((Byte)value).byteValue()));
                    }
                    if (value instanceof Short) {
                        return new ForStackManipulation(IntegerConstant.forValue(((Short)value).shortValue()));
                    }
                    if (value instanceof Character) {
                        return new ForStackManipulation(IntegerConstant.forValue(((Character)value).charValue()));
                    }
                    if (value instanceof Integer) {
                        return new ForStackManipulation(IntegerConstant.forValue((Integer)value));
                    }
                    if (value instanceof Long) {
                        return new ForStackManipulation(LongConstant.forValue((Long)value));
                    }
                    if (value instanceof Float) {
                        return new ForStackManipulation(FloatConstant.forValue(((Float)value).floatValue()));
                    }
                    if (value instanceof Double) {
                        return new ForStackManipulation(DoubleConstant.forValue((Double)value));
                    }
                    if (value instanceof String) {
                        return new ForStackManipulation(new TextConstant((String)value));
                    }
                    throw new IllegalArgumentException("Not a constant value: " + value);
                }

                @Override
                public StackManipulation resolveRead() {
                    return this.stackManipulation;
                }

                @Override
                public StackManipulation resolveWrite() {
                    throw new IllegalStateException("Cannot write to constant value: " + this.stackManipulation);
                }

                @Override
                public StackManipulation resolveIncrement(int value) {
                    throw new IllegalStateException("Cannot write to constant value: " + this.stackManipulation);
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForStackManipulation)) {
                        return false;
                    }
                    ForStackManipulation other = (ForStackManipulation)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    StackManipulation this$stackManipulation = this.stackManipulation;
                    StackManipulation other$stackManipulation = other.stackManipulation;
                    return !(this$stackManipulation == null ? other$stackManipulation != null : !this$stackManipulation.equals(other$stackManipulation));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ForStackManipulation;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    StackManipulation $stackManipulation = this.stackManipulation;
                    result = result * 59 + ($stackManipulation == null ? 43 : $stackManipulation.hashCode());
                    return result;
                }
            }

            public static abstract class ForField
            implements Target {
                protected final FieldDescription fieldDescription;
                protected final StackManipulation readAssignment;

                protected ForField(FieldDescription fieldDescription, StackManipulation readAssignment) {
                    this.fieldDescription = fieldDescription;
                    this.readAssignment = readAssignment;
                }

                @Override
                public StackManipulation resolveRead() {
                    return new StackManipulation.Compound(this.fieldDescription.isStatic() ? StackManipulation.Trivial.INSTANCE : MethodVariableAccess.loadThis(), FieldAccess.forField(this.fieldDescription).read(), this.readAssignment);
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForField)) {
                        return false;
                    }
                    ForField other = (ForField)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    FieldDescription this$fieldDescription = this.fieldDescription;
                    FieldDescription other$fieldDescription = other.fieldDescription;
                    if (this$fieldDescription == null ? other$fieldDescription != null : !this$fieldDescription.equals(other$fieldDescription)) {
                        return false;
                    }
                    StackManipulation this$readAssignment = this.readAssignment;
                    StackManipulation other$readAssignment = other.readAssignment;
                    return !(this$readAssignment == null ? other$readAssignment != null : !this$readAssignment.equals(other$readAssignment));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ForField;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    FieldDescription $fieldDescription = this.fieldDescription;
                    result = result * 59 + ($fieldDescription == null ? 43 : $fieldDescription.hashCode());
                    StackManipulation $readAssignment = this.readAssignment;
                    result = result * 59 + ($readAssignment == null ? 43 : $readAssignment.hashCode());
                    return result;
                }

                public static class ReadWrite
                extends ForField {
                    private final StackManipulation writeAssignment;

                    public ReadWrite(FieldDescription fieldDescription) {
                        this(fieldDescription, StackManipulation.Trivial.INSTANCE, StackManipulation.Trivial.INSTANCE);
                    }

                    public ReadWrite(FieldDescription fieldDescription, StackManipulation readAssignment, StackManipulation writeAssignment) {
                        super(fieldDescription, readAssignment);
                        this.writeAssignment = writeAssignment;
                    }

                    @Override
                    public StackManipulation resolveWrite() {
                        StackManipulation preparation = this.fieldDescription.isStatic() ? StackManipulation.Trivial.INSTANCE : new StackManipulation.Compound(MethodVariableAccess.loadThis(), Duplication.SINGLE.flipOver(this.fieldDescription.getType()), Removal.SINGLE);
                        return new StackManipulation.Compound(this.writeAssignment, preparation, FieldAccess.forField(this.fieldDescription).write());
                    }

                    @Override
                    public StackManipulation resolveIncrement(int value) {
                        return new StackManipulation.Compound(this.resolveRead(), IntegerConstant.forValue(value), Addition.INTEGER, this.resolveWrite());
                    }

                    @Override
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof ReadWrite)) {
                            return false;
                        }
                        ReadWrite other = (ReadWrite)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        if (!super.equals(o)) {
                            return false;
                        }
                        StackManipulation this$writeAssignment = this.writeAssignment;
                        StackManipulation other$writeAssignment = other.writeAssignment;
                        return !(this$writeAssignment == null ? other$writeAssignment != null : !this$writeAssignment.equals(other$writeAssignment));
                    }

                    @Override
                    protected boolean canEqual(Object other) {
                        return other instanceof ReadWrite;
                    }

                    @Override
                    public int hashCode() {
                        int PRIME = 59;
                        int result = super.hashCode();
                        StackManipulation $writeAssignment = this.writeAssignment;
                        result = result * 59 + ($writeAssignment == null ? 43 : $writeAssignment.hashCode());
                        return result;
                    }
                }

                public static class ReadOnly
                extends ForField {
                    public ReadOnly(FieldDescription fieldDescription) {
                        this(fieldDescription, StackManipulation.Trivial.INSTANCE);
                    }

                    public ReadOnly(FieldDescription fieldDescription, StackManipulation readAssignment) {
                        super(fieldDescription, readAssignment);
                    }

                    @Override
                    public StackManipulation resolveWrite() {
                        throw new IllegalStateException("Cannot write to read-only field value");
                    }

                    @Override
                    public StackManipulation resolveIncrement(int value) {
                        throw new IllegalStateException("Cannot write to read-only field value");
                    }
                }
            }

            public static abstract class ForArray
            implements Target {
                protected final TypeDescription.Generic target;
                protected final List<? extends StackManipulation> valueReads;

                protected ForArray(TypeDescription.Generic target, List<? extends StackManipulation> valueReads) {
                    this.target = target;
                    this.valueReads = valueReads;
                }

                @Override
                public StackManipulation resolveRead() {
                    return ArrayFactory.forType(this.target).withValues(this.valueReads);
                }

                @Override
                public StackManipulation resolveIncrement(int value) {
                    throw new IllegalStateException("Cannot increment read-only array value");
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForArray)) {
                        return false;
                    }
                    ForArray other = (ForArray)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    TypeDescription.Generic this$target = this.target;
                    TypeDescription.Generic other$target = other.target;
                    if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
                        return false;
                    }
                    List<? extends StackManipulation> this$valueReads = this.valueReads;
                    List<? extends StackManipulation> other$valueReads = other.valueReads;
                    return !(this$valueReads == null ? other$valueReads != null : !((Object)this$valueReads).equals(other$valueReads));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ForArray;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    TypeDescription.Generic $target = this.target;
                    result = result * 59 + ($target == null ? 43 : $target.hashCode());
                    List<? extends StackManipulation> $valueReads = this.valueReads;
                    result = result * 59 + ($valueReads == null ? 43 : ((Object)$valueReads).hashCode());
                    return result;
                }

                public static class ReadWrite
                extends ForArray {
                    private final List<? extends StackManipulation> valueWrites;

                    public ReadWrite(TypeDescription.Generic target, List<? extends StackManipulation> valueReads, List<? extends StackManipulation> valueWrites) {
                        super(target, valueReads);
                        this.valueWrites = valueWrites;
                    }

                    @Override
                    public StackManipulation resolveWrite() {
                        return ArrayAccess.of(this.target).forEach(this.valueWrites);
                    }

                    @Override
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof ReadWrite)) {
                            return false;
                        }
                        ReadWrite other = (ReadWrite)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        if (!super.equals(o)) {
                            return false;
                        }
                        List<? extends StackManipulation> this$valueWrites = this.valueWrites;
                        List<? extends StackManipulation> other$valueWrites = other.valueWrites;
                        return !(this$valueWrites == null ? other$valueWrites != null : !((Object)this$valueWrites).equals(other$valueWrites));
                    }

                    @Override
                    protected boolean canEqual(Object other) {
                        return other instanceof ReadWrite;
                    }

                    @Override
                    public int hashCode() {
                        int PRIME = 59;
                        int result = super.hashCode();
                        List<? extends StackManipulation> $valueWrites = this.valueWrites;
                        result = result * 59 + ($valueWrites == null ? 43 : ((Object)$valueWrites).hashCode());
                        return result;
                    }
                }

                public static class ReadOnly
                extends ForArray {
                    public ReadOnly(TypeDescription.Generic target, List<? extends StackManipulation> valueReads) {
                        super(target, valueReads);
                    }

                    @Override
                    public StackManipulation resolveWrite() {
                        throw new IllegalStateException("Cannot write to read-only array value");
                    }
                }
            }

            public static abstract class ForVariable
            implements Target {
                protected final TypeDefinition typeDefinition;
                protected final int offset;
                protected final StackManipulation readAssignment;

                protected ForVariable(TypeDefinition typeDefinition, int offset, StackManipulation readAssignment) {
                    this.typeDefinition = typeDefinition;
                    this.offset = offset;
                    this.readAssignment = readAssignment;
                }

                @Override
                public StackManipulation resolveRead() {
                    return new StackManipulation.Compound(MethodVariableAccess.of(this.typeDefinition).loadFrom(this.offset), this.readAssignment);
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForVariable)) {
                        return false;
                    }
                    ForVariable other = (ForVariable)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    TypeDefinition this$typeDefinition = this.typeDefinition;
                    TypeDefinition other$typeDefinition = other.typeDefinition;
                    if (this$typeDefinition == null ? other$typeDefinition != null : !this$typeDefinition.equals(other$typeDefinition)) {
                        return false;
                    }
                    if (this.offset != other.offset) {
                        return false;
                    }
                    StackManipulation this$readAssignment = this.readAssignment;
                    StackManipulation other$readAssignment = other.readAssignment;
                    return !(this$readAssignment == null ? other$readAssignment != null : !this$readAssignment.equals(other$readAssignment));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ForVariable;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    TypeDefinition $typeDefinition = this.typeDefinition;
                    result = result * 59 + ($typeDefinition == null ? 43 : $typeDefinition.hashCode());
                    result = result * 59 + this.offset;
                    StackManipulation $readAssignment = this.readAssignment;
                    result = result * 59 + ($readAssignment == null ? 43 : $readAssignment.hashCode());
                    return result;
                }

                public static class ReadWrite
                extends ForVariable {
                    private final StackManipulation writeAssignment;

                    public ReadWrite(TypeDefinition typeDefinition, int offset) {
                        this(typeDefinition, offset, StackManipulation.Trivial.INSTANCE, StackManipulation.Trivial.INSTANCE);
                    }

                    public ReadWrite(TypeDefinition typeDefinition, int offset, StackManipulation readAssignment, StackManipulation writeAssignment) {
                        super(typeDefinition, offset, readAssignment);
                        this.writeAssignment = writeAssignment;
                    }

                    @Override
                    public StackManipulation resolveWrite() {
                        return new StackManipulation.Compound(this.writeAssignment, MethodVariableAccess.of(this.typeDefinition).storeAt(this.offset));
                    }

                    @Override
                    public StackManipulation resolveIncrement(int value) {
                        return this.typeDefinition.represents(Integer.TYPE) ? MethodVariableAccess.of(this.typeDefinition).increment(this.offset, value) : new StackManipulation.Compound(this.resolveRead(), IntegerConstant.forValue(1), Addition.INTEGER, this.resolveWrite());
                    }

                    @Override
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof ReadWrite)) {
                            return false;
                        }
                        ReadWrite other = (ReadWrite)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        if (!super.equals(o)) {
                            return false;
                        }
                        StackManipulation this$writeAssignment = this.writeAssignment;
                        StackManipulation other$writeAssignment = other.writeAssignment;
                        return !(this$writeAssignment == null ? other$writeAssignment != null : !this$writeAssignment.equals(other$writeAssignment));
                    }

                    @Override
                    protected boolean canEqual(Object other) {
                        return other instanceof ReadWrite;
                    }

                    @Override
                    public int hashCode() {
                        int PRIME = 59;
                        int result = super.hashCode();
                        StackManipulation $writeAssignment = this.writeAssignment;
                        result = result * 59 + ($writeAssignment == null ? 43 : $writeAssignment.hashCode());
                        return result;
                    }
                }

                public static class ReadOnly
                extends ForVariable {
                    public ReadOnly(TypeDefinition typeDefinition, int offset) {
                        this(typeDefinition, offset, StackManipulation.Trivial.INSTANCE);
                    }

                    public ReadOnly(TypeDefinition typeDefinition, int offset, StackManipulation readAssignment) {
                        super(typeDefinition, offset, readAssignment);
                    }

                    @Override
                    public StackManipulation resolveWrite() {
                        throw new IllegalStateException("Cannot write to read-only parameter " + this.typeDefinition + " at " + this.offset);
                    }

                    @Override
                    public StackManipulation resolveIncrement(int value) {
                        throw new IllegalStateException("Cannot write to read-only variable " + this.typeDefinition + " at " + this.offset);
                    }
                }
            }

            public static abstract class ForDefaultValue
            implements Target {
                protected final TypeDefinition typeDefinition;
                protected final StackManipulation readAssignment;

                protected ForDefaultValue(TypeDefinition typeDefinition, StackManipulation readAssignment) {
                    this.typeDefinition = typeDefinition;
                    this.readAssignment = readAssignment;
                }

                @Override
                public StackManipulation resolveRead() {
                    return new StackManipulation.Compound(DefaultValue.of(this.typeDefinition), this.readAssignment);
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ForDefaultValue)) {
                        return false;
                    }
                    ForDefaultValue other = (ForDefaultValue)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    TypeDefinition this$typeDefinition = this.typeDefinition;
                    TypeDefinition other$typeDefinition = other.typeDefinition;
                    if (this$typeDefinition == null ? other$typeDefinition != null : !this$typeDefinition.equals(other$typeDefinition)) {
                        return false;
                    }
                    StackManipulation this$readAssignment = this.readAssignment;
                    StackManipulation other$readAssignment = other.readAssignment;
                    return !(this$readAssignment == null ? other$readAssignment != null : !this$readAssignment.equals(other$readAssignment));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof ForDefaultValue;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    TypeDefinition $typeDefinition = this.typeDefinition;
                    result = result * 59 + ($typeDefinition == null ? 43 : $typeDefinition.hashCode());
                    StackManipulation $readAssignment = this.readAssignment;
                    result = result * 59 + ($readAssignment == null ? 43 : $readAssignment.hashCode());
                    return result;
                }

                public static class ReadWrite
                extends ForDefaultValue {
                    public ReadWrite(TypeDefinition typeDefinition) {
                        this(typeDefinition, StackManipulation.Trivial.INSTANCE);
                    }

                    public ReadWrite(TypeDefinition typeDefinition, StackManipulation readAssignment) {
                        super(typeDefinition, readAssignment);
                    }

                    @Override
                    public StackManipulation resolveWrite() {
                        return Removal.of(this.typeDefinition);
                    }

                    @Override
                    public StackManipulation resolveIncrement(int value) {
                        return StackManipulation.Trivial.INSTANCE;
                    }
                }

                public static class ReadOnly
                extends ForDefaultValue {
                    public ReadOnly(TypeDefinition typeDefinition) {
                        this(typeDefinition, StackManipulation.Trivial.INSTANCE);
                    }

                    public ReadOnly(TypeDefinition typeDefinition, StackManipulation readAssignment) {
                        super(typeDefinition, readAssignment);
                    }

                    @Override
                    public StackManipulation resolveWrite() {
                        throw new IllegalStateException("Cannot write to read-only default value");
                    }

                    @Override
                    public StackManipulation resolveIncrement(int value) {
                        throw new IllegalStateException("Cannot write to read-only default value");
                    }
                }
            }

            public static abstract class AbstractReadOnlyAdapter
            implements Target {
                @Override
                public StackManipulation resolveWrite() {
                    throw new IllegalStateException("Cannot write to read-only value");
                }

                @Override
                public StackManipulation resolveIncrement(int value) {
                    throw new IllegalStateException("Cannot write to read-only value");
                }
            }
        }
    }
}

