/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.build.gradle;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.build.BuildLogger;
import net.bytebuddy.build.EntryPoint;
import net.bytebuddy.build.Plugin;
import net.bytebuddy.build.gradle.ByteBuddyExtension;
import net.bytebuddy.build.gradle.ClassLoaderResolver;
import net.bytebuddy.build.gradle.Transformation;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.scaffold.inline.MethodNameTransformer;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.compile.AbstractCompile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationAction
implements Action<Task> {
    private final Project project;
    private final ByteBuddyExtension byteBuddyExtension;
    private final AbstractCompile task;

    public TransformationAction(Project project, ByteBuddyExtension extension, AbstractCompile task) {
        this.project = project;
        this.byteBuddyExtension = extension;
        this.task = task;
    }

    public void execute(Task task) {
        try {
            this.apply(this.task.getDestinationDir(), (Iterable<? extends File>)this.task.getClasspath());
        }
        catch (IOException exception) {
            throw new GradleException("Error accessing file system", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void apply(File root, Iterable<? extends File> classPath) throws IOException {
        if (!root.isDirectory()) {
            throw new GradleException("Not a directory: " + root);
        }
        ClassLoaderResolver classLoaderResolver = new ClassLoaderResolver();
        try {
            Plugin.Engine.Summary summary;
            ArrayList<Plugin.Factory.UsingReflection> factories = new ArrayList<Plugin.Factory.UsingReflection>(this.byteBuddyExtension.getTransformations().size());
            for (Transformation transformation : this.byteBuddyExtension.getTransformations()) {
                String plugin = transformation.getPlugin();
                try {
                    factories.add(new Plugin.Factory.UsingReflection(Class.forName(plugin, false, classLoaderResolver.resolve(transformation.getClassPath(root, classPath)))).with(transformation.makeArgumentResolvers()).with(new Plugin.Factory.UsingReflection.ArgumentResolver[]{Plugin.Factory.UsingReflection.ArgumentResolver.ForType.of(File.class, (Object)root), Plugin.Factory.UsingReflection.ArgumentResolver.ForType.of(Logger.class, (Object)this.project.getLogger()), Plugin.Factory.UsingReflection.ArgumentResolver.ForType.of(BuildLogger.class, (Object)new GradleBuildLogger(this.project.getLogger()))}));
                    this.project.getLogger().info("Resolved plugin: {}", (Object)transformation.getRawPlugin());
                }
                catch (Throwable throwable) {
                    throw new GradleException("Cannot resolve plugin: " + transformation.getRawPlugin(), throwable);
                }
            }
            EntryPoint entryPoint = this.byteBuddyExtension.getInitialization().getEntryPoint(classLoaderResolver, root, classPath);
            this.project.getLogger().info("Resolved entry point: {}", (Object)entryPoint);
            ArrayList<ClassFileLocator> classFileLocators = new ArrayList<ClassFileLocator>();
            for (File file : classPath) {
                classFileLocators.add((ClassFileLocator)(file.isFile() ? ClassFileLocator.ForJarFile.of((File)file) : new ClassFileLocator.ForFolder(file)));
            }
            ClassFileLocator.Compound classFileLocator = new ClassFileLocator.Compound(classFileLocators);
            try {
                Plugin.Engine pluginEngine;
                this.project.getLogger().info("Processing class files located in in: {}", (Object)root);
                try {
                    ClassFileVersion classFileVersion;
                    JavaPluginConvention convention = (JavaPluginConvention)this.project.getConvention().getPlugins().get("java");
                    if (convention == null) {
                        classFileVersion = ClassFileVersion.ofThisVm();
                        this.project.getLogger().warn("Could not locate Java target version, build is JDK dependant: {}", (Object)classFileVersion.getMajorVersion());
                    } else {
                        classFileVersion = ClassFileVersion.ofJavaVersion((int)Integer.parseInt(convention.getTargetCompatibility().getMajorVersion()));
                        this.project.getLogger().debug("Java version detected: {}", (Object)convention.getTargetCompatibility().getMajorVersion());
                    }
                    pluginEngine = Plugin.Engine.Default.of((EntryPoint)entryPoint, (ClassFileVersion)classFileVersion, (MethodNameTransformer)this.byteBuddyExtension.getMethodNameTransformer());
                }
                catch (Throwable throwable) {
                    throw new GradleException("Cannot create plugin engine", throwable);
                }
                try {
                    summary = pluginEngine.with((Plugin.Engine.PoolStrategy)(this.byteBuddyExtension.isExtendedParsing() ? Plugin.Engine.PoolStrategy.Default.EXTENDED : Plugin.Engine.PoolStrategy.Default.FAST)).with((ClassFileLocator)classFileLocator).with((Plugin.Engine.Listener)new TransformationLogger(this.project.getLogger())).withErrorHandlers(new Plugin.Engine.ErrorHandler[]{Plugin.Engine.ErrorHandler.Enforcing.ALL_TYPES_RESOLVED, (Plugin.Engine.ErrorHandler)(this.byteBuddyExtension.isFailOnLiveInitializer() ? Plugin.Engine.ErrorHandler.Enforcing.NO_LIVE_INITIALIZERS : Plugin.Engine.Listener.NoOp.INSTANCE), (Plugin.Engine.ErrorHandler)(this.byteBuddyExtension.isFailFast() ? Plugin.Engine.ErrorHandler.Failing.FAIL_FAST : Plugin.Engine.Listener.NoOp.INSTANCE)}).with((Plugin.Engine.Dispatcher.Factory)(this.byteBuddyExtension.getThreads() == 0 ? Plugin.Engine.Dispatcher.ForSerialTransformation.Factory.INSTANCE : new Plugin.Engine.Dispatcher.ForParallelTransformation.WithThrowawayExecutorService.Factory(this.byteBuddyExtension.getThreads()))).apply((Plugin.Engine.Source)new Plugin.Engine.Source.ForFolder(root), (Plugin.Engine.Target)new Plugin.Engine.Target.ForFolder(root), factories);
                }
                catch (Throwable throwable) {
                    throw new GradleException("Failed to transform class files in " + root, throwable);
                }
            }
            finally {
                classFileLocator.close();
            }
            if (!summary.getFailed().isEmpty()) {
                throw new GradleException(summary.getFailed() + " type transformations have failed");
            }
            if (this.byteBuddyExtension.isWarnOnEmptyTypeSet() && summary.getTransformed().isEmpty()) {
                this.project.getLogger().warn("No types were transformed during plugin execution");
            } else {
                this.project.getLogger().info("Transformed {} types", (Object)summary.getTransformed().size());
            }
        }
        finally {
            classLoaderResolver.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TransformationLogger
    extends Plugin.Engine.Listener.Adapter {
        private final Logger logger;

        protected TransformationLogger(Logger logger) {
            this.logger = logger;
        }

        public void onTransformation(TypeDescription typeDescription, List<Plugin> plugins) {
            this.logger.debug("Transformed {} using {}", (Object)typeDescription, plugins);
        }

        public void onError(TypeDescription typeDescription, Plugin plugin, Throwable throwable) {
            this.logger.warn("Failed to transform {} using {}", new Object[]{typeDescription, plugin, throwable});
        }

        public void onError(Map<TypeDescription, List<Throwable>> throwables) {
            this.logger.warn("Failed to transform {} types", (Object)throwables.size());
        }

        public void onError(Plugin plugin, Throwable throwable) {
            this.logger.error("Failed to close {}", (Object)plugin, (Object)throwable);
        }

        public void onLiveInitializer(TypeDescription typeDescription, TypeDescription definingType) {
            this.logger.debug("Discovered live initializer for {} as a result of transforming {}", (Object)definingType, (Object)typeDescription);
        }
    }

    protected static class GradleBuildLogger
    implements BuildLogger {
        private final Logger logger;

        protected GradleBuildLogger(Logger logger) {
            this.logger = logger;
        }

        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        public void debug(String message) {
            this.logger.debug(message);
        }

        public void debug(String message, Throwable throwable) {
            this.logger.debug(message, throwable);
        }

        public boolean isInfoEnabled() {
            return this.logger.isInfoEnabled();
        }

        public void info(String message) {
            this.logger.info(message);
        }

        public void info(String message, Throwable throwable) {
            this.logger.info(message, throwable);
        }

        public boolean isWarnEnabled() {
            return this.logger.isWarnEnabled();
        }

        public void warn(String message) {
            this.logger.warn(message);
        }

        public void warn(String message, Throwable throwable) {
            this.logger.warn(message, throwable);
        }

        public boolean isErrorEnabled() {
            return this.logger.isErrorEnabled();
        }

        public void error(String message) {
            this.logger.error(message);
        }

        public void error(String message, Throwable throwable) {
            this.logger.error(message, throwable);
        }
    }
}

