/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.build.gradle;

import java.lang.reflect.Method;
import net.bytebuddy.build.gradle.AbstractByteBuddyTask;
import net.bytebuddy.build.gradle.AbstractByteBuddyTaskConfiguration;
import net.bytebuddy.build.gradle.AbstractByteBuddyTaskExtension;
import net.bytebuddy.build.gradle.ByteBuddySimpleTask;
import net.bytebuddy.build.gradle.ByteBuddySimpleTaskConfiguration;
import net.bytebuddy.build.gradle.ByteBuddySimpleTaskExtension;
import net.bytebuddy.build.gradle.ByteBuddyTask;
import net.bytebuddy.build.gradle.ByteBuddyTaskConfiguration;
import net.bytebuddy.build.gradle.ByteBuddyTaskExtension;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.AbstractCompile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteBuddyPlugin
implements Plugin<Project> {
    public static final String LEGACY = "net.bytebuddy.build.gradle.legacy";
    private static final Dispatcher<?, ?> DISPATCHER;

    public void apply(Project project) {
        JavaPluginConvention convention = (JavaPluginConvention)project.getConvention().getPlugins().get("java");
        if (convention == null) {
            project.getLogger().debug("Not setting up explicit Byte Buddy configurations since Java plugin was not registered");
        } else {
            for (SourceSet sourceSet : convention.getSourceSets()) {
                String name = sourceSet.getName().equals("main") ? "byteBuddy" : sourceSet.getName() + "ByteBuddy";
                project.getExtensions().add(name, DISPATCHER.toExtension());
                project.afterEvaluate(DISPATCHER.toAction(name, sourceSet));
            }
        }
    }

    static {
        Dispatcher<ByteBuddySimpleTask, ByteBuddySimpleTaskExtension> dispatcher;
        if (Boolean.getBoolean(LEGACY)) {
            dispatcher = Dispatcher.ForLegacyGradle.INSTANCE;
        } else {
            try {
                Class.forName("org.gradle.work.InputChanges");
                dispatcher = new Dispatcher.ForApi6CapableGradle(SourceDirectorySet.class.getMethod("getDestinationDirectory", new Class[0]), AbstractCompile.class.getMethod("setDestinationDir", Class.forName("org.gradle.api.provider.Provider")));
            }
            catch (Exception ignored) {
                dispatcher = Dispatcher.ForLegacyGradle.INSTANCE;
            }
        }
        DISPATCHER = dispatcher;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface Dispatcher<T extends AbstractByteBuddyTask, S extends AbstractByteBuddyTaskExtension<T>> {
        public S toExtension();

        public AbstractByteBuddyTaskConfiguration<T, S> toAction(String var1, SourceSet var2);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class ForApi6CapableGradle
        implements Dispatcher<ByteBuddyTask, ByteBuddyTaskExtension> {
            private final Method getDestinationDirectory;
            private final Method setDestinationDir;

            protected ForApi6CapableGradle(Method getDestinationDirectory, Method setDestinationDir) {
                this.getDestinationDirectory = getDestinationDirectory;
                this.setDestinationDir = setDestinationDir;
            }

            @Override
            public ByteBuddyTaskExtension toExtension() {
                return new ByteBuddyTaskExtension();
            }

            public ByteBuddyTaskConfiguration toAction(String name, SourceSet sourceSet) {
                return new ByteBuddyTaskConfiguration(name, sourceSet, this.getDestinationDirectory, this.setDestinationDir);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ForLegacyGradle implements Dispatcher<ByteBuddySimpleTask, ByteBuddySimpleTaskExtension>
        {
            INSTANCE;


            @Override
            public ByteBuddySimpleTaskExtension toExtension() {
                return new ByteBuddySimpleTaskExtension();
            }

            public ByteBuddySimpleTaskConfiguration toAction(String name, SourceSet sourceSet) {
                return new ByteBuddySimpleTaskConfiguration(name, sourceSet);
            }
        }
    }
}

