/*
 * Copyright 2014 - 2020 Rafael Winterhalter
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.bytebuddy.build.gradle.api;

import org.gradle.api.file.FileTree;

import java.io.File;

/**
 * A placeholder representation of Gradle's {@code org.gradle.api.file.DirectoryProperty} type.
 */
@GradleType("org.gradle.api.file.DirectoryProperty")
public interface DirectoryProperty extends Provider<Directory> {

    /**
     * A placeholder representation of Gradle's {@code org.gradle.api.file.DirectoryProperty#getAsFile} method.
     *
     * @return The method's return value.
     */
    Provider<File> getAsFile();

    /**
     * A placeholder representation of Gradle's {@code org.gradle.api.file.DirectoryProperty#getAsFileTree} method.
     *
     * @return The method's return value.
     */
    FileTree getAsFileTree();

    /**
     * A placeholder representation of Gradle's {@code org.gradle.api.file.DirectoryProperty#dir} method.
     *
     * @param path The method's argument.
     * @return The method's return value.
     */
    Provider<Directory> dir(String path);

    /**
     * A placeholder representation of Gradle's {@code org.gradle.api.file.DirectoryProperty#set} method.
     *
     * @param directory The method's argument.
     */
    void set(Provider<Directory> directory);
}
