/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.build.gradle;

import java.util.Map;
import java.util.Set;
import net.bytebuddy.build.gradle.AbstractByteBuddyTask;
import net.bytebuddy.build.gradle.AbstractByteBuddyTaskExtension;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.JavaCompile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractByteBuddyTaskConfiguration<T extends AbstractByteBuddyTask, S extends AbstractByteBuddyTaskExtension<T>>
implements Action<Project> {
    protected static final String RAW_FOLDER = "../raw";
    private final String name;
    private final SourceSet sourceSet;
    private final Class<T> type;

    protected AbstractByteBuddyTaskConfiguration(String name, SourceSet sourceSet, Class<T> type) {
        this.name = name;
        this.sourceSet = sourceSet;
        this.type = type;
    }

    public void execute(Project project) {
        AbstractByteBuddyTaskExtension extension = (AbstractByteBuddyTaskExtension)project.getExtensions().getByName(this.name);
        if (extension.getTransformations().isEmpty()) {
            project.getLogger().debug("Not configuring task for source set '{}' as no transformations are defined", (Object)this.sourceSet.getName());
        } else {
            project.getLogger().debug("Configuring Byte Buddy task for source set '{}' as '{}'", (Object)this.sourceSet.getName(), (Object)this.name);
            JavaCompile compileTask = (JavaCompile)project.getTasks().getByName(this.sourceSet.getCompileJavaTaskName());
            AbstractByteBuddyTask byteBuddyTask = (AbstractByteBuddyTask)project.getTasks().create(this.name, this.type);
            byteBuddyTask.setGroup("Byte Buddy");
            byteBuddyTask.setDescription("Transforms the classes compiled by " + compileTask.getName());
            byteBuddyTask.dependsOn(new Object[]{compileTask});
            extension.configure(byteBuddyTask);
            this.configureDirectories(this.sourceSet.getJava(), compileTask, byteBuddyTask);
            for (Map.Entry entry : project.getRootProject().getAllTasks(true).entrySet()) {
                for (Task task : (Set)entry.getValue()) {
                    if (task.getName().equals(this.name) && task.getProject().equals(project) || !task.getTaskDependencies().getDependencies(task).contains(compileTask)) continue;
                    task.dependsOn(new Object[]{byteBuddyTask});
                    project.getLogger().debug("Altered task '{}' of project '{}' to depend on '{}' of project '{}'", new Object[]{task.getName(), ((Project)entry.getKey()).getName(), this.name, project.getName()});
                }
            }
        }
    }

    protected abstract void configureDirectories(SourceDirectorySet var1, JavaCompile var2, T var3);
}

