/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.build.gradle;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import net.bytebuddy.build.Plugin;
import net.bytebuddy.build.gradle.AbstractByteBuddyTask;
import net.bytebuddy.build.gradle.ByteBuddyTaskExtension;
import net.bytebuddy.build.gradle.IncrementalResolver;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ByteBuddyTask
extends AbstractByteBuddyTask {
    private IncrementalResolver incrementalResolver;

    @Inject
    public ByteBuddyTask() {
        new ByteBuddyTaskExtension().configure(this);
    }

    @Incremental
    @InputDirectory
    public abstract DirectoryProperty getSource();

    @OutputDirectory
    public abstract DirectoryProperty getTarget();

    @InputFiles
    @CompileClasspath
    public abstract ConfigurableFileCollection getClassPath();

    @Internal
    public IncrementalResolver getIncrementalResolver() {
        return this.incrementalResolver;
    }

    public void setIncrementalResolver(IncrementalResolver incrementalResolver) {
        this.incrementalResolver = incrementalResolver;
    }

    @Override
    protected File source() {
        return (File)this.getSource().getAsFile().get();
    }

    @Override
    protected File target() {
        return (File)this.getTarget().getAsFile().get();
    }

    @Override
    protected Iterable<File> classPath() {
        return this.getClassPath();
    }

    @TaskAction
    public void apply(InputChanges inputChanges) throws IOException {
        Plugin.Engine.Source.ForFolder source;
        if (inputChanges.isIncremental() && this.getIncrementalResolver() != null) {
            this.getLogger().debug("Applying incremental build");
            source = new IncrementalSource(this.source(), this.getIncrementalResolver().apply(this.getProject(), inputChanges.getFileChanges((Provider)this.getSource()), this.source(), this.target(), this.classPath()));
        } else {
            this.getLogger().debug("Applying non-incremental build");
            if (this.getProject().delete(new Object[]{this.getTarget().getAsFileTree()})) {
                this.getLogger().debug("Deleted all target files in {}", (Object)this.getTarget());
            }
            source = new Plugin.Engine.Source.ForFolder((File)this.getSource().getAsFile().get());
        }
        this.doApply((Plugin.Engine.Source)source, (Plugin.Engine.Target)new Plugin.Engine.Target.ForFolder((File)this.getTarget().getAsFile().get()));
    }

    public static abstract class WithIncrementalClassPath
    extends ByteBuddyTask {
        @Incremental
        @CompileClasspath
        public abstract ConfigurableFileCollection getClassPath();

        @Inject
        public WithIncrementalClassPath() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class IncrementalSource
    extends Plugin.Engine.Source.ForFolder {
        private final File root;
        private final List<File> files;

        protected IncrementalSource(File root, List<File> files) {
            super(root);
            this.root = root;
            this.files = files;
        }

        public Iterator<Plugin.Engine.Source.Element> iterator() {
            return new DelegationIterator(this.root, this.files.iterator());
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class DelegationIterator
        implements Iterator<Plugin.Engine.Source.Element> {
            private final File root;
            private final Iterator<File> delegate;

            public DelegationIterator(File root, Iterator<File> delegate) {
                this.root = root;
                this.delegate = delegate;
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public Plugin.Engine.Source.Element next() {
                return new Plugin.Engine.Source.Element.ForFile(this.root, this.delegate.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        }
    }
}

