/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.build.gradle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Adjustment {
    FULL{

        @Override
        protected Iterable<Task> resolve(Project project, TaskExecutionGraph graph) {
            return new CompoundIterable(project.getRootProject().getAllTasks(true).values());
        }
    }
    ,
    SUB{

        @Override
        protected Iterable<Task> resolve(Project project, TaskExecutionGraph graph) {
            return new CompoundIterable(project.getAllTasks(true).values());
        }
    }
    ,
    SELF{

        @Override
        protected Iterable<Task> resolve(Project project, TaskExecutionGraph graph) {
            return new CompoundIterable(project.getAllTasks(false).values());
        }
    }
    ,
    ACTIVE{

        @Override
        protected Iterable<Task> resolve(Project project, TaskExecutionGraph graph) {
            return graph.getAllTasks();
        }
    }
    ,
    NONE{

        @Override
        protected Iterable<Task> resolve(Project project, TaskExecutionGraph graph) {
            return Collections.emptySet();
        }
    };


    protected abstract Iterable<Task> resolve(Project var1, TaskExecutionGraph var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum NoOpPostProcessor implements Action<Task>
    {
        INSTANCE;


        public void execute(Task task) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CompoundIterable
    implements Iterable<Task> {
        private final Collection<? extends Iterable<? extends Task>> iterables;

        protected CompoundIterable(Collection<? extends Iterable<? extends Task>> iterables) {
            this.iterables = iterables;
        }

        @Override
        public Iterator<Task> iterator() {
            return new CompoundIterator(new ArrayList<Iterable<? extends Task>>(this.iterables));
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class CompoundIterator
        implements Iterator<Task> {
            private Iterator<? extends Task> current;
            private final List<Iterable<? extends Task>> backlog;

            protected CompoundIterator(List<Iterable<? extends Task>> iterables) {
                this.backlog = iterables;
                this.forward();
            }

            @Override
            public boolean hasNext() {
                return this.current != null && this.current.hasNext();
            }

            @Override
            public Task next() {
                try {
                    if (this.current != null) {
                        Task task = this.current.next();
                        return task;
                    }
                    throw new NoSuchElementException();
                }
                finally {
                    this.forward();
                }
            }

            private void forward() {
                while (!(this.current != null && this.current.hasNext() || this.backlog.isEmpty())) {
                    this.current = this.backlog.remove(0).iterator();
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ErrorHandler {
        FAIL{

            protected void apply(Project project, String name, Task task, RuntimeException exception) {
                throw exception;
            }
        }
        ,
        WARN{

            protected void apply(Project project, String name, Task task, RuntimeException exception) {
                project.getLogger().warn("Failed to resolve potential dependency for task '{}' of project '{}' on '{}' of project '{}' - dependency must be declared manually if appropriate", new Object[]{task.getName(), task.getProject().getName(), name, project.getName(), exception});
            }
        }
        ,
        IGNORE{

            protected void apply(Project project, String name, Task task, RuntimeException exception) {
            }
        };


        protected abstract void apply(Project var1, String var2, Task var3, RuntimeException var4);
    }
}

