/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.build.gradle;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.work.ChangeType;
import org.gradle.work.FileChange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IncrementalResolver {
    public List<File> apply(Project var1, Iterable<FileChange> var2, File var3, File var4, Iterable<File> var5);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ForChangedFiles implements IncrementalResolver
    {
        INSTANCE;


        @Override
        public List<File> apply(Project project, Iterable<FileChange> changes, File sourceRoot, File targetRoot, Iterable<File> classPath) {
            ArrayList<File> files = new ArrayList<File>();
            for (FileChange change : changes) {
                if (change.getChangeType() == ChangeType.REMOVED) {
                    File target = new File(targetRoot, sourceRoot.toURI().relativize(change.getFile().toURI()).getPath());
                    if (!project.delete(new Object[]{target})) continue;
                    project.getLogger().debug("Deleted removed file {} to prepare incremental build", (Object)target);
                    continue;
                }
                files.add(change.getFile());
            }
            return files;
        }
    }
}

