/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.build.gradle;

import groovy.lang.Closure;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.build.BuildLogger;
import net.bytebuddy.build.EntryPoint;
import net.bytebuddy.build.Plugin;
import net.bytebuddy.build.gradle.Discovery;
import net.bytebuddy.build.gradle.ObjectFactory;
import net.bytebuddy.build.gradle.Transformation;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.scaffold.inline.MethodNameTransformer;
import net.bytebuddy.utility.nullability.MaybeNull;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractByteBuddyTask
extends DefaultTask {
    private final List<Transformation> transformations = new ArrayList<Transformation>();
    private EntryPoint entryPoint;
    private String suffix;
    private boolean failOnLiveInitializer;
    private boolean warnOnEmptyTypeSet;
    private boolean failFast;
    private boolean extendedParsing;
    private Discovery discovery;
    private int threads;
    @MaybeNull
    private ClassFileVersion classFileVersion;

    protected AbstractByteBuddyTask() {
    }

    @Nested
    public List<Transformation> getTransformations() {
        return this.transformations;
    }

    public void transformation(Closure<Transformation> closure) {
        Transformation transformation = ObjectFactory.newInstance(this.getProject(), Transformation.class, this.getProject());
        this.transformations.add((Transformation)this.getProject().configure((Object)(transformation == null ? new Transformation(this.getProject()) : transformation), closure));
    }

    public void transformation(Action<Transformation> action) {
        Transformation transformation = ObjectFactory.newInstance(this.getProject(), Transformation.class, this.getProject());
        if (transformation == null) {
            transformation = new Transformation(this.getProject());
        }
        action.execute((Object)transformation);
        this.transformations.add(transformation);
    }

    @Input
    public EntryPoint getEntryPoint() {
        return this.entryPoint;
    }

    public void setEntryPoint(EntryPoint entryPoint) {
        this.entryPoint = entryPoint;
    }

    @Input
    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    @Internal
    public boolean isFailOnLiveInitializer() {
        return this.failOnLiveInitializer;
    }

    public void setFailOnLiveInitializer(boolean failOnLiveInitializer) {
        this.failOnLiveInitializer = failOnLiveInitializer;
    }

    @Internal
    public boolean isWarnOnEmptyTypeSet() {
        return this.warnOnEmptyTypeSet;
    }

    public void setWarnOnEmptyTypeSet(boolean warnOnEmptyTypeSet) {
        this.warnOnEmptyTypeSet = warnOnEmptyTypeSet;
    }

    @Internal
    public boolean isFailFast() {
        return this.failFast;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    @Input
    public boolean isExtendedParsing() {
        return this.extendedParsing;
    }

    public void setExtendedParsing(boolean extendedParsing) {
        this.extendedParsing = extendedParsing;
    }

    @Input
    public Discovery getDiscovery() {
        return this.discovery;
    }

    public void setDiscovery(Discovery discovery) {
        this.discovery = discovery;
    }

    @Internal
    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    @MaybeNull
    @Input
    @Optional
    public ClassFileVersion getClassFileVersion() {
        return this.classFileVersion;
    }

    public void setClassFileVersion(@MaybeNull ClassFileVersion classFileVersion) {
        this.classFileVersion = classFileVersion;
    }

    protected abstract File source();

    protected abstract File target();

    protected abstract Iterable<File> classPath();

    @MaybeNull
    protected abstract Iterable<File> discoverySet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doApply(Plugin.Engine.Source source, Plugin.Engine.Target target) throws IOException {
        Plugin.Engine.Summary summary;
        if (this.source().equals(this.target())) {
            throw new IllegalStateException("Source and target cannot be equal: " + this.source());
        }
        ArrayList<Transformation> transformations = new ArrayList<Transformation>(this.getTransformations());
        ClassLoader classLoader = ByteBuddySkippingUrlClassLoader.of(((Object)((Object)this)).getClass().getClassLoader(), this.discoverySet(), this.classPath());
        if (this.discovery.isDiscover(transformations)) {
            HashSet<String> undiscoverable = new HashSet<String>();
            if (this.discovery.isRecordConfiguration()) {
                for (Transformation transformation : transformations) {
                    undiscoverable.add(transformation.toPluginName());
                }
            }
            Enumeration<URL> plugins = classLoader.getResources("META-INF/net.bytebuddy/build.plugins");
            while (plugins.hasMoreElements()) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(((URL)plugins.nextElement()).openStream(), "UTF-8"));
                try {
                    String line;
                    while ((line = bufferedReader.readLine()) != null) {
                        if (undiscoverable.add(line)) {
                            try {
                                Class<?> plugin = Class.forName(line);
                                Transformation transformation = ObjectFactory.newInstance(this.getProject(), Transformation.class, this.getProject());
                                if (transformation == null) {
                                    transformation = new Transformation(this.getProject());
                                }
                                transformation.setPlugin(plugin);
                                transformations.add(transformation);
                            }
                            catch (ClassNotFoundException exception) {
                                throw new IllegalStateException("Discovered plugin is not available: " + line, exception);
                            }
                            this.getLogger().debug("Registered discovered plugin: {}", (Object)line);
                            continue;
                        }
                        this.getLogger().info("Skipping discovered plugin {} which was previously discovered or registered", (Object)line);
                    }
                }
                finally {
                    bufferedReader.close();
                }
            }
        }
        if (transformations.isEmpty()) {
            this.getLogger().warn("No transformations are specified or discovered. Skipping plugin application.");
        } else {
            this.getLogger().debug("{} plugins are being applied via configuration and discovery", (Object)transformations.size());
        }
        ArrayList<Plugin.Factory.UsingReflection> factories = new ArrayList<Plugin.Factory.UsingReflection>(transformations.size());
        for (Transformation transformation : transformations) {
            try {
                factories.add(new Plugin.Factory.UsingReflection(transformation.toPlugin(classLoader)).with(transformation.makeArgumentResolvers()).with(new Plugin.Factory.UsingReflection.ArgumentResolver[]{Plugin.Factory.UsingReflection.ArgumentResolver.ForType.of(File.class, (Object)this.source()), Plugin.Factory.UsingReflection.ArgumentResolver.ForType.of(Logger.class, (Object)this.getLogger()), Plugin.Factory.UsingReflection.ArgumentResolver.ForType.of(BuildLogger.class, (Object)new GradleBuildLogger(this.getLogger()))}));
                this.getLogger().info("Resolved plugin: {}", (Object)transformation.toPluginName());
            }
            catch (Throwable throwable) {
                throw new IllegalStateException("Cannot resolve plugin: " + transformation.toPluginName(), throwable);
            }
        }
        ArrayList<ClassFileLocator> classFileLocators = new ArrayList<ClassFileLocator>();
        for (File artifact : this.classPath()) {
            classFileLocators.add((ClassFileLocator)(artifact.isFile() ? ClassFileLocator.ForJarFile.of((File)artifact) : new ClassFileLocator.ForFolder(artifact)));
        }
        ClassFileLocator.Compound compound = new ClassFileLocator.Compound(classFileLocators);
        try {
            Plugin.Engine pluginEngine;
            this.getLogger().info("Processing class files located in in: {}", (Object)this.source());
            try {
                ClassFileVersion classFileVersion;
                if (this.classFileVersion == null) {
                    classFileVersion = ClassFileVersion.ofThisVm();
                    this.getLogger().warn("Could not locate Java target version, build is JDK dependant: {}", (Object)classFileVersion.getJavaVersion());
                } else {
                    classFileVersion = this.classFileVersion;
                    this.getLogger().debug("Java version was configured: {}", (Object)classFileVersion.getJavaVersion());
                }
                pluginEngine = Plugin.Engine.Default.of((EntryPoint)this.getEntryPoint(), (ClassFileVersion)classFileVersion, (MethodNameTransformer)(this.getSuffix().length() == 0 ? MethodNameTransformer.Suffixing.withRandomSuffix() : new MethodNameTransformer.Suffixing(this.getSuffix())));
            }
            catch (Throwable throwable) {
                throw new IllegalStateException("Cannot create plugin engine", throwable);
            }
            try {
                summary = pluginEngine.with((Plugin.Engine.PoolStrategy)(this.isExtendedParsing() ? Plugin.Engine.PoolStrategy.Default.EXTENDED : Plugin.Engine.PoolStrategy.Default.FAST)).with((ClassFileLocator)compound).with((Plugin.Engine.Listener)new TransformationLogger(this.getLogger())).withErrorHandlers(new Plugin.Engine.ErrorHandler[]{Plugin.Engine.ErrorHandler.Enforcing.ALL_TYPES_RESOLVED, (Plugin.Engine.ErrorHandler)(this.isFailOnLiveInitializer() ? Plugin.Engine.ErrorHandler.Enforcing.NO_LIVE_INITIALIZERS : Plugin.Engine.Listener.NoOp.INSTANCE), this.isFailFast() ? Plugin.Engine.ErrorHandler.Failing.FAIL_FAST : Plugin.Engine.ErrorHandler.Failing.FAIL_LAST}).with((Plugin.Engine.Dispatcher.Factory)(this.getThreads() == 0 ? Plugin.Engine.Dispatcher.ForSerialTransformation.Factory.INSTANCE : new Plugin.Engine.Dispatcher.ForParallelTransformation.WithThrowawayExecutorService.Factory(this.getThreads()))).apply(source, target, factories);
            }
            catch (Throwable throwable) {
                throw new IllegalStateException("Failed to transform class files in " + this.source(), throwable);
            }
        }
        finally {
            compound.close();
        }
        if (!summary.getFailed().isEmpty()) {
            throw new IllegalStateException(summary.getFailed() + " type transformations have failed");
        }
        if (this.isWarnOnEmptyTypeSet() && summary.getTransformed().isEmpty()) {
            this.getLogger().warn("No types were transformed during plugin execution");
        } else {
            this.getLogger().info("Transformed {} types", (Object)summary.getTransformed().size());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ByteBuddySkippingUrlClassLoader
    extends URLClassLoader {
        protected ByteBuddySkippingUrlClassLoader(ClassLoader parent, URL[] url) {
            super(url, parent);
        }

        protected static ClassLoader of(ClassLoader classLoader, @MaybeNull Iterable<File> discoverySet, Iterable<File> classPath) {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (File file : discoverySet == null ? classPath : discoverySet) {
                try {
                    urls.add(file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new IllegalStateException(e);
                }
            }
            return new ByteBuddySkippingUrlClassLoader(classLoader, urls.toArray(new URL[0]));
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (name.startsWith("net.bytebuddy.")) {
                Class<?> type = this.getParent().loadClass(name);
                if (resolve) {
                    this.resolveClass(type);
                }
                return type;
            }
            return super.loadClass(name, resolve);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TransformationLogger
    extends Plugin.Engine.Listener.Adapter {
        private final Logger logger;

        protected TransformationLogger(Logger logger) {
            this.logger = logger;
        }

        public void onTransformation(TypeDescription typeDescription, List<Plugin> plugins) {
            this.logger.debug("Transformed {} using {}", (Object)typeDescription, plugins);
        }

        public void onError(TypeDescription typeDescription, Plugin plugin, Throwable throwable) {
            this.logger.warn("Failed to transform {} using {}", new Object[]{typeDescription, plugin, throwable});
        }

        public void onError(Map<TypeDescription, List<Throwable>> throwables) {
            this.logger.warn("Failed to transform {} types", (Object)throwables.size());
        }

        public void onError(Plugin plugin, Throwable throwable) {
            this.logger.error("Failed to close {}", (Object)plugin, (Object)throwable);
        }

        public void onLiveInitializer(TypeDescription typeDescription, TypeDescription definingType) {
            this.logger.debug("Discovered live initializer for {} as a result of transforming {}", (Object)definingType, (Object)typeDescription);
        }
    }

    protected static class GradleBuildLogger
    implements BuildLogger {
        private final Logger logger;

        protected GradleBuildLogger(Logger logger) {
            this.logger = logger;
        }

        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        public void debug(String message) {
            this.logger.debug(message);
        }

        public void debug(String message, Throwable throwable) {
            this.logger.debug(message, throwable);
        }

        public boolean isInfoEnabled() {
            return this.logger.isInfoEnabled();
        }

        public void info(String message) {
            this.logger.info(message);
        }

        public void info(String message, Throwable throwable) {
            this.logger.info(message, throwable);
        }

        public boolean isWarnEnabled() {
            return this.logger.isWarnEnabled();
        }

        public void warn(String message) {
            this.logger.warn(message);
        }

        public void warn(String message, Throwable throwable) {
            this.logger.warn(message, throwable);
        }

        public boolean isErrorEnabled() {
            return this.logger.isErrorEnabled();
        }

        public void error(String message) {
            this.logger.error(message);
        }

        public void error(String message, Throwable throwable) {
            this.logger.error(message, throwable);
        }
    }
}

