/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.build.gradle.android;

import com.android.build.api.artifact.MultipleArtifact;
import com.android.build.api.variant.Variant;
import java.io.File;
import java.io.IOException;
import net.bytebuddy.utility.FileSystem;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileType;
import org.gradle.api.file.RegularFile;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.FileChange;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;

public abstract class ByteBuddyCopyOutputTask
extends DefaultTask {
    @Incremental
    @Classpath
    public abstract ConfigurableFileCollection getLocalClasspath();

    @OutputDirectory
    public abstract DirectoryProperty getOutputDir();

    @TaskAction
    public void execute(InputChanges inputChanges) {
        block6: for (FileChange fileChange : inputChanges.getFileChanges((FileCollection)this.getLocalClasspath())) {
            if (fileChange.getFileType() == FileType.DIRECTORY) {
                return;
            }
            File target = ((RegularFile)this.getOutputDir().file(fileChange.getNormalizedPath()).get()).getAsFile();
            switch (fileChange.getChangeType()) {
                case REMOVED: {
                    if (!target.delete()) continue block6;
                    this.getLogger().debug("Deleted file {}", (Object)target);
                    continue block6;
                }
                case ADDED: 
                case MODIFIED: {
                    try {
                        if (!target.getParentFile().isDirectory() && !target.getParentFile().mkdirs()) {
                            throw new IllegalStateException("Failed to create target directory: " + target.getParentFile());
                        }
                        FileSystem.getInstance().copy(fileChange.getFile(), target);
                        continue block6;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Failed to copy " + fileChange.getFile() + " to " + target, e);
                    }
                }
            }
            throw new IllegalStateException();
        }
    }

    protected static class ConfigurationAction
    implements Action<ByteBuddyCopyOutputTask> {
        private final Project project;
        private final Variant variant;

        protected ConfigurationAction(Project project, Variant variant) {
            this.project = project;
            this.variant = variant;
        }

        public void execute(ByteBuddyCopyOutputTask task) {
            task.getLocalClasspath().from(new Object[]{this.variant.getArtifacts().getAll((MultipleArtifact)MultipleArtifact.ALL_CLASSES_DIRS.INSTANCE)});
            task.getOutputDir().set(this.project.getLayout().getBuildDirectory().dir("intermediates/incremental/" + task.getName()));
        }
    }
}

