/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.build.gradle.android;

import com.android.build.api.AndroidPluginVersion;
import com.android.build.api.artifact.Artifact;
import com.android.build.api.artifact.MultipleArtifact;
import com.android.build.api.attributes.BuildTypeAttr;
import com.android.build.api.component.impl.ComponentImpl;
import com.android.build.api.instrumentation.InstrumentationScope;
import com.android.build.api.variant.AndroidComponentsExtension;
import com.android.build.api.variant.Variant;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import net.bytebuddy.build.gradle.android.AarGradleTransformAction;
import net.bytebuddy.build.gradle.android.ByteBuddyAndroidService;
import net.bytebuddy.build.gradle.android.ByteBuddyAsmClassVisitorFactory;
import net.bytebuddy.build.gradle.android.ByteBuddyInstrumentationParameters;
import net.bytebuddy.build.gradle.android.ByteBuddyLocalClassesEnhancerTask;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeCompatibilityRule;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.AttributeMatchingStrategy;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.CompatibilityCheckDetails;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;

public class ByteBuddyAndroidPlugin
implements Plugin<Project> {
    protected static final Attribute<String> ARTIFACT_TYPE_ATTRIBUTE = Attribute.of((String)"artifactType", String.class);
    private static final String BYTE_BUDDY_JAR_TYPE = "bytebuddy-jar";

    public void apply(Project project) {
        AndroidComponentsExtension extension = (AndroidComponentsExtension)project.getExtensions().getByType(AndroidComponentsExtension.class);
        if (extension.getPluginVersion().compareTo(new AndroidPluginVersion(7, 2)) < 0) {
            throw new IllegalStateException("Byte Buddy requires at least Gradle Plugin version 7.2+, but found " + extension.getPluginVersion());
        }
        project.getDependencies().registerTransform(AarGradleTransformAction.class, (Action)new AarGradleTransformAction.ConfigurationAction());
        project.getDependencies().getAttributesSchema().attribute(ARTIFACT_TYPE_ATTRIBUTE, (Action)new AttributeMatchingStrategyConfigurationAction());
        extension.onVariants(extension.selector().all(), (Action)new VariantAction(project, (Configuration)project.getConfigurations().create("byteBuddy", (Action)new ConfigurationConfigurationAction())));
    }

    public static abstract class ByteBuddyJarRule
    implements AttributeCompatibilityRule<String> {
        public void execute(CompatibilityCheckDetails<String> details) {
            if (ByteBuddyAndroidPlugin.BYTE_BUDDY_JAR_TYPE.equals(details.getConsumerValue()) && "jar".equals(details.getProducerValue())) {
                details.compatible();
            }
        }
    }

    protected static class ConfigurationConfigurationAction
    implements Action<Configuration> {
        protected ConfigurationConfigurationAction() {
        }

        public void execute(Configuration configuration) {
            configuration.setCanBeConsumed(false);
            configuration.setCanBeResolved(false);
        }
    }

    protected static class AttributeMatchingStrategyConfigurationAction
    implements Action<AttributeMatchingStrategy<String>> {
        protected AttributeMatchingStrategyConfigurationAction() {
        }

        public void execute(AttributeMatchingStrategy<String> stringAttributeMatchingStrategy) {
            stringAttributeMatchingStrategy.getCompatibilityRules().add(ByteBuddyJarRule.class);
        }
    }

    protected static class AttributeContainerConfigurationAction
    implements Action<AttributeContainer> {
        private final Project project;
        private final String buildType;

        protected AttributeContainerConfigurationAction(Project project, String buildType) {
            this.project = project;
            this.buildType = buildType;
        }

        public void execute(AttributeContainer attributes) {
            attributes.attribute(ARTIFACT_TYPE_ATTRIBUTE, (Object)ByteBuddyAndroidPlugin.BYTE_BUDDY_JAR_TYPE);
            attributes.attribute(Category.CATEGORY_ATTRIBUTE, (Object)this.project.getObjects().named(Category.class, "library"));
            attributes.attribute(BuildTypeAttr.ATTRIBUTE, (Object)this.project.getObjects().named(BuildTypeAttr.class, this.buildType));
            attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)this.project.getObjects().named(Usage.class, "java-runtime"));
        }
    }

    protected static class VariantConfigurationConfigurationAction
    implements Action<Configuration> {
        private final Project project;
        private final Configuration configuration;
        private final String buildType;

        protected VariantConfigurationConfigurationAction(Project project, Configuration configuration, String buildType) {
            this.project = project;
            this.configuration = configuration;
            this.buildType = buildType;
        }

        public void execute(Configuration configuration) {
            configuration.setCanBeResolved(true);
            configuration.setCanBeConsumed(false);
            configuration.extendsFrom(new Configuration[]{this.configuration});
            configuration.attributes((Action)new AttributeContainerConfigurationAction(this.project, this.buildType));
        }
    }

    protected static class ByteBuddyTransformationConfiguration
    implements Function1<ByteBuddyInstrumentationParameters, Unit> {
        private final Project project;
        private final Configuration configuration;
        private final Provider<ByteBuddyAndroidService> byteBuddyAndroidServiceProvider;
        private final FileCollection classPath;

        protected ByteBuddyTransformationConfiguration(Project project, Configuration configuration, Provider<ByteBuddyAndroidService> byteBuddyAndroidServiceProvider, FileCollection classPath) {
            this.project = project;
            this.configuration = configuration;
            this.byteBuddyAndroidServiceProvider = byteBuddyAndroidServiceProvider;
            this.classPath = classPath;
        }

        public Unit invoke(ByteBuddyInstrumentationParameters parameters) {
            parameters.getByteBuddyClasspath().from(new Object[]{this.configuration});
            parameters.getAndroidBootClasspath().from(new Object[]{((BaseExtension)this.project.getExtensions().getByType(BaseExtension.class)).getBootClasspath()});
            parameters.getRuntimeClasspath().from(new Object[]{this.classPath});
            parameters.getByteBuddyService().set(this.byteBuddyAndroidServiceProvider);
            return Unit.INSTANCE;
        }
    }

    protected static class VariantAction
    implements Action<Variant> {
        private final Project project;
        private final Configuration configuration;
        private final ConcurrentMap<String, Configuration> configurations;

        protected VariantAction(Project project, Configuration configuration) {
            this.project = project;
            this.configuration = configuration;
            this.configurations = new ConcurrentHashMap<String, Configuration>();
        }

        public void execute(Variant variant) {
            Provider byteBuddyAndroidServiceProvider = this.project.getGradle().getSharedServices().registerIfAbsent(variant.getName() + "ByteBuddyAndroidService", ByteBuddyAndroidService.class, (Action)new ByteBuddyAndroidService.ConfigurationAction((BaseExtension)this.project.getExtensions().getByType(BaseExtension.class)));
            if (variant.getBuildType() == null) {
                throw new GradleException("Build type for " + variant + " was null");
            }
            Configuration configuration = (Configuration)this.configurations.get(variant.getBuildType());
            if (configuration == null) {
                configuration = (Configuration)this.project.getConfigurations().create(variant.getBuildType() + "ByteBuddy", (Action)new VariantConfigurationConfigurationAction(this.project, this.configuration, variant.getBuildType()));
                Configuration previous = this.configurations.putIfAbsent(variant.getBuildType(), configuration);
                if (previous != null) {
                    configuration = previous;
                }
            }
            if (!(variant instanceof ComponentImpl)) {
                throw new GradleException("Expected " + variant + " to be of type " + ComponentImpl.class.getName());
            }
            FileCollection classPath = ((ComponentImpl)variant).getVariantDependencies().getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.CLASSES_JAR);
            variant.getInstrumentation().transformClassesWith(ByteBuddyAsmClassVisitorFactory.class, InstrumentationScope.ALL, (Function1)new ByteBuddyTransformationConfiguration(this.project, configuration, (Provider<ByteBuddyAndroidService>)byteBuddyAndroidServiceProvider, classPath));
            TaskProvider localClassesTransformation = this.project.getTasks().register(variant.getName() + "BytebuddyLocalTransform", ByteBuddyLocalClassesEnhancerTask.class, (Action)new ByteBuddyLocalClassesEnhancerTask.ConfigurationAction(configuration, (BaseExtension)this.project.getExtensions().getByType(BaseExtension.class), classPath));
            variant.getArtifacts().use(localClassesTransformation).wiredWith(ByteBuddyLocalClassesEnhancerTask::getLocalClassesDirs, ByteBuddyLocalClassesEnhancerTask::getOutputDir).toTransform((Artifact.Multiple)MultipleArtifact.ALL_CLASSES_DIRS.INSTANCE);
        }
    }
}

