/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.build.gradle.android;

import com.android.build.gradle.BaseExtension;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.build.AndroidDescriptor;
import net.bytebuddy.build.BuildLogger;
import net.bytebuddy.build.EntryPoint;
import net.bytebuddy.build.Plugin;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.scaffold.inline.MethodNameTransformer;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.slf4j.Logger;

public abstract class ByteBuddyLocalClassesEnhancerTask
extends DefaultTask {
    @InputFiles
    public abstract ConfigurableFileCollection getAndroidBootClasspath();

    @InputFiles
    public abstract ConfigurableFileCollection getByteBuddyClasspath();

    @InputFiles
    public abstract ConfigurableFileCollection getRuntimeClasspath();

    @Input
    public abstract Property<JavaVersion> getJavaTargetCompatibilityVersion();

    @InputFiles
    public abstract ListProperty<Directory> getLocalClassesDirs();

    @OutputDirectory
    public abstract DirectoryProperty getOutputDir();

    private static URL[] toUrls(Collection<File> files) {
        URL[] url = new URL[files.size()];
        int index = 0;
        for (File file : files) {
            try {
                url[index++] = file.toURI().toURL();
            }
            catch (MalformedURLException exception) {
                throw new IllegalStateException("Failed to convert file " + file.getAbsolutePath(), exception);
            }
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public void execute() {
        try {
            ClassFileVersion classFileVersion = ClassFileVersion.ofJavaVersionString((String)((JavaVersion)this.getJavaTargetCompatibilityVersion().get()).toString());
            ArrayList<ClassFileLocator> classFileLocators = new ArrayList<ClassFileLocator>();
            for (File file : this.getRuntimeClasspath().plus((FileCollection)this.getAndroidBootClasspath()).plus((FileCollection)this.getByteBuddyClasspath()).getFiles()) {
                classFileLocators.add((ClassFileLocator)(file.isFile() ? ClassFileLocator.ForJarFile.of((File)file) : new ClassFileLocator.ForFolder(file)));
            }
            classFileLocators.add(ClassFileLocator.ForClassLoader.of((ClassLoader)ByteBuddy.class.getClassLoader()));
            try (ClassFileLocator.Compound classFileLocator = new ClassFileLocator.Compound(classFileLocators);){
                LinkedHashSet<Plugin.Engine.Source.ForFolder> sources = new LinkedHashSet<Plugin.Engine.Source.ForFolder>();
                for (Directory directory : (List)this.getLocalClassesDirs().get()) {
                    sources.add(new Plugin.Engine.Source.ForFolder(directory.getAsFile()));
                }
                URLClassLoader classLoader = new URLClassLoader(ByteBuddyLocalClassesEnhancerTask.toUrls(this.getByteBuddyClasspath().getFiles()), (ClassLoader)new URLClassLoader(ByteBuddyLocalClassesEnhancerTask.toUrls(this.getAndroidBootClasspath().getFiles()), ByteBuddy.class.getClassLoader()));
                try {
                    BuildLogger buildLogger;
                    ArrayList<Plugin.Factory.UsingReflection> factories = new ArrayList<Plugin.Factory.UsingReflection>();
                    try {
                        buildLogger = (BuildLogger)Class.forName("net.bytebuddy.build.gradle.GradleBuildLogger").getConstructor(org.gradle.api.logging.Logger.class).newInstance(this.getProject().getLogger());
                    }
                    catch (Exception exception) {
                        throw new GradleException("Failed to resolve Gradle build logger", (Throwable)exception);
                    }
                    for (String name : Plugin.Engine.Default.scan((ClassLoader)classLoader)) {
                        try {
                            Class<?> type = Class.forName(name, false, classLoader);
                            if (!Plugin.class.isAssignableFrom(type)) {
                                throw new GradleException(type.getName() + " does not implement " + Plugin.class.getName());
                            }
                            factories.add(new Plugin.Factory.UsingReflection(type).with(new Plugin.Factory.UsingReflection.ArgumentResolver[]{Plugin.Factory.UsingReflection.ArgumentResolver.ForType.of(AndroidDescriptor.class, (Object)AndroidDescriptor.Trivial.LOCAL)}).with(new Plugin.Factory.UsingReflection.ArgumentResolver[]{Plugin.Factory.UsingReflection.ArgumentResolver.ForType.of(org.gradle.api.logging.Logger.class, (Object)this.getProject().getLogger())}).with(new Plugin.Factory.UsingReflection.ArgumentResolver[]{Plugin.Factory.UsingReflection.ArgumentResolver.ForType.of(Logger.class, (Object)this.getProject().getLogger())}).with(new Plugin.Factory.UsingReflection.ArgumentResolver[]{Plugin.Factory.UsingReflection.ArgumentResolver.ForType.of(BuildLogger.class, (Object)buildLogger)}));
                        }
                        catch (Throwable throwable) {
                            throw new IllegalStateException("Cannot resolve plugin: " + name, throwable);
                        }
                    }
                    Plugin.Engine.Summary summary = Plugin.Engine.Default.of((EntryPoint)new EntryPoint.Unvalidated((EntryPoint)EntryPoint.Default.DECORATE), (ClassFileVersion)classFileVersion, (MethodNameTransformer)MethodNameTransformer.Suffixing.withRandomSuffix()).with((ClassFileLocator)classFileLocator).apply((Plugin.Engine.Source)new Plugin.Engine.Source.Compound(sources), (Plugin.Engine.Target)new Plugin.Engine.Target.ForFolder(((Directory)this.getOutputDir().get()).getAsFile()), factories);
                    if (!summary.getFailed().isEmpty()) {
                        throw new IllegalStateException(summary.getFailed() + " local type transformations have failed");
                    }
                    if (summary.getTransformed().isEmpty()) {
                        this.getLogger().info("No local types were transformed during plugin execution");
                    } else {
                        this.getLogger().info("Transformed {} local type(s)", (Object)summary.getTransformed().size());
                    }
                }
                finally {
                    if (classLoader instanceof Closeable) {
                        ((Closeable)classLoader).close();
                    }
                    if (classLoader.getParent() instanceof Closeable) {
                        ((Closeable)((Object)classLoader.getParent())).close();
                    }
                }
            }
        }
        catch (IOException exception) {
            throw new GradleException("Failed to transform local classes", (Throwable)exception);
        }
    }

    protected static class ConfigurationAction
    implements Action<ByteBuddyLocalClassesEnhancerTask> {
        private final Configuration byteBuddyConfiguration;
        private final BaseExtension androidExtension;
        private final FileCollection runtimeClasspath;

        public ConfigurationAction(Configuration byteBuddyConfiguration, BaseExtension androidExtension, FileCollection runtimeClasspath) {
            this.byteBuddyConfiguration = byteBuddyConfiguration;
            this.androidExtension = androidExtension;
            this.runtimeClasspath = runtimeClasspath;
        }

        public void execute(ByteBuddyLocalClassesEnhancerTask task) {
            task.getByteBuddyClasspath().from(new Object[]{this.byteBuddyConfiguration});
            task.getAndroidBootClasspath().from(new Object[]{this.androidExtension.getBootClasspath()});
            task.getRuntimeClasspath().from(new Object[]{this.runtimeClasspath});
            task.getJavaTargetCompatibilityVersion().set((Object)this.androidExtension.getCompileOptions().getTargetCompatibility());
        }
    }
}

