/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.build.gradle;

import groovy.lang.Closure;
import javax.annotation.Nonnull;
import javax.annotation.meta.When;
import net.bytebuddy.build.gradle.AbstractByteBuddyTask;
import net.bytebuddy.build.gradle.AbstractByteBuddyTaskExtension;
import net.bytebuddy.build.gradle.Adjustment;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.JavaCompile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractByteBuddyTaskConfiguration<T extends AbstractByteBuddyTask, S extends AbstractByteBuddyTaskExtension<T>>
implements Action<Project> {
    protected static final String RAW_FOLDER = "../raw";
    private final String name;
    private final SourceSet sourceSet;

    protected AbstractByteBuddyTaskConfiguration(String name, SourceSet sourceSet) {
        this.name = name;
        this.sourceSet = sourceSet;
    }

    public void execute(Project project) {
        AbstractByteBuddyTaskExtension extension = (AbstractByteBuddyTaskExtension)project.getExtensions().getByName(this.name);
        if (extension.getTransformations().isEmpty()) {
            project.getLogger().debug("Not configuring task for source set '{}' as no transformations are defined", (Object)this.sourceSet.getName());
        } else {
            project.getLogger().debug("Configuring Byte Buddy task for source set '{}' as '{}'", (Object)this.sourceSet.getName(), (Object)this.name);
            JavaCompile compileTask = (JavaCompile)project.getTasks().getByName(this.sourceSet.getCompileJavaTaskName());
            AbstractByteBuddyTask byteBuddyTask = (AbstractByteBuddyTask)project.getTasks().create(this.name, extension.toType());
            byteBuddyTask.setGroup("Byte Buddy");
            byteBuddyTask.setDescription("Transforms the classes compiled by " + compileTask.getName());
            byteBuddyTask.dependsOn(new Object[]{compileTask});
            extension.configure(byteBuddyTask);
            this.configureDirectories(this.sourceSet.getJava(), compileTask, byteBuddyTask);
            TaskExecutionGraphAdjustmentAction action = new TaskExecutionGraphAdjustmentAction(project, this.name, extension.getAdjustment(), extension.getAdjustmentErrorHandler(), extension.getAdjustmentPostProcessor(), (Task)byteBuddyTask, (Task)compileTask);
            if (extension.isLazy()) {
                project.getGradle().getTaskGraph().whenReady((Closure)new TaskExecutionGraphClosure(action, project.getGradle().getTaskGraph()));
            } else {
                action.execute(project.getGradle().getTaskGraph());
            }
        }
    }

    protected abstract void configureDirectories(SourceDirectorySet var1, JavaCompile var2, T var3);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TaskExecutionGraphClosure
    extends Closure<Void> {
        private static final long serialVersionUID = 1L;
        private final Action<TaskExecutionGraph> action;
        private final TaskExecutionGraph taskExecutionGraph;

        protected TaskExecutionGraphClosure(Action<TaskExecutionGraph> action, TaskExecutionGraph taskExecutionGraph) {
            super(null);
            this.action = action;
            this.taskExecutionGraph = taskExecutionGraph;
        }

        @Nonnull(when=When.MAYBE)
        public Void call(Object ... argument) {
            this.action.execute((Object)this.taskExecutionGraph);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TaskExecutionGraphAdjustmentAction
    implements Action<TaskExecutionGraph> {
        private final Project project;
        private final String name;
        private final Adjustment adjustment;
        private final Adjustment.ErrorHandler adjustmentErrorHandler;
        private final Action<Task> adjustmentPostProcessor;
        private final Task byteBuddyTask;
        private final Task compileTask;

        protected TaskExecutionGraphAdjustmentAction(Project project, String name, Adjustment adjustment, Adjustment.ErrorHandler adjustmentErrorHandler, Action<Task> adjustmentPostProcessor, Task byteBuddyTask, Task compileTask) {
            this.project = project;
            this.name = name;
            this.adjustment = adjustment;
            this.adjustmentErrorHandler = adjustmentErrorHandler;
            this.adjustmentPostProcessor = adjustmentPostProcessor;
            this.byteBuddyTask = byteBuddyTask;
            this.compileTask = compileTask;
        }

        public void execute(TaskExecutionGraph graph) {
            for (Task task : this.adjustment.resolve(this.project, graph)) {
                try {
                    if (task.getName().equals(this.name) && task.getProject().equals(this.project) || !task.getTaskDependencies().getDependencies(task).contains(this.compileTask)) continue;
                    task.dependsOn(new Object[]{this.byteBuddyTask});
                    this.project.getLogger().debug("Altered task '{}' of project '{}' to depend on '{}' of project '{}'", new Object[]{task.getName(), task.getProject().getName(), this.name, this.project.getName()});
                }
                catch (RuntimeException exception) {
                    this.adjustmentErrorHandler.apply(this.project, this.name, task, exception);
                }
            }
            this.adjustmentPostProcessor.execute((Object)this.byteBuddyTask);
        }
    }
}

