/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.build.gradle;

import java.lang.reflect.Method;
import net.bytebuddy.build.gradle.AbstractByteBuddyTask;
import net.bytebuddy.build.gradle.AbstractByteBuddyTaskConfiguration;
import net.bytebuddy.build.gradle.AbstractByteBuddyTaskExtension;
import net.bytebuddy.build.gradle.ByteBuddySimpleTask;
import net.bytebuddy.build.gradle.ByteBuddySimpleTaskConfiguration;
import net.bytebuddy.build.gradle.ByteBuddySimpleTaskExtension;
import net.bytebuddy.build.gradle.ByteBuddyTask;
import net.bytebuddy.build.gradle.ByteBuddyTaskConfiguration;
import net.bytebuddy.build.gradle.ByteBuddyTaskExtension;
import net.bytebuddy.build.gradle.ObjectFactory;
import net.bytebuddy.utility.nullability.MaybeNull;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.compile.AbstractCompile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteBuddyPlugin
implements Plugin<Project> {
    private static final Dispatcher<?, ?> DISPATCHER;

    public void apply(Project project) {
        if (project.getExtensions().findByName("android") != null) {
            project.getLogger().debug("Applying Byte Buddy Android plugin");
            try {
                Class<?> plugin = Class.forName("net.bytebuddy.build.gradle.android.ByteBuddyAndroidPlugin");
                project.getPlugins().apply(plugin);
            }
            catch (ClassNotFoundException exception) {
                project.getLogger().error("Failed to load Byte Buddy Android plugin", (Throwable)exception);
            }
        } else {
            project.getLogger().debug("Applying Byte Buddy plugin (legacy mode: {})", (Object)(DISPATCHER instanceof Dispatcher.ForLegacyGradle));
            project.getPlugins().withType(JavaPlugin.class, (Action)new JavaPluginConfigurationAction(project));
        }
    }

    static {
        Dispatcher<ByteBuddySimpleTask, ByteBuddySimpleTaskExtension> dispatcher;
        try {
            Class.forName("org.gradle.work.InputChanges");
            dispatcher = new Dispatcher.ForApi6CapableGradle(SourceDirectorySet.class.getMethod("getDestinationDirectory", new Class[0]), AbstractCompile.class.getMethod("setDestinationDir", Class.forName("org.gradle.api.provider.Provider")));
        }
        catch (Throwable ignored) {
            dispatcher = Dispatcher.ForLegacyGradle.INSTANCE;
        }
        DISPATCHER = dispatcher;
    }

    protected static class JavaConventionConfiguration {
        @MaybeNull
        private static final Class<?> JAVA_PLUGIN_CONVENTION;
        @MaybeNull
        private static final Class<?> JAVA_PLUGIN_EXTENSION;
        @MaybeNull
        private static final Method GET_CONVENTION;
        @MaybeNull
        private static final Method GET_EXTENSIONS;
        @MaybeNull
        private static final Method FIND_BY_TYPE;
        @MaybeNull
        private static final Method GET_SOURCE_SETS_CONVENTION;
        @MaybeNull
        private static final Method GET_SOURCE_SETS_EXTENSION;
        @MaybeNull
        private static final Method GET_TARGET_COMPATIBILITY_CONVENTION;
        @MaybeNull
        private static final Method GET_TARGET_COMPATIBILITY_EXTENSION;
        @MaybeNull
        private static final Method FIND_PLUGIN;
        private final SourceSetContainer sourceSets;
        private final JavaVersion targetCompatibility;

        protected JavaConventionConfiguration(SourceSetContainer sourceSets, JavaVersion targetCompatibility) {
            this.sourceSets = sourceSets;
            this.targetCompatibility = targetCompatibility;
        }

        @MaybeNull
        protected static JavaConventionConfiguration of(Project project) {
            if (JAVA_PLUGIN_EXTENSION != null && GET_EXTENSIONS != null && FIND_BY_TYPE != null && GET_SOURCE_SETS_EXTENSION != null && GET_TARGET_COMPATIBILITY_EXTENSION != null) {
                try {
                    Object extension = FIND_BY_TYPE.invoke(GET_EXTENSIONS.invoke((Object)project, new Object[0]), JAVA_PLUGIN_EXTENSION);
                    if (extension != null) {
                        return new JavaConventionConfiguration((SourceSetContainer)GET_SOURCE_SETS_EXTENSION.invoke(extension, new Object[0]), (JavaVersion)GET_TARGET_COMPATIBILITY_EXTENSION.invoke(extension, new Object[0]));
                    }
                }
                catch (Throwable extension) {
                    // empty catch block
                }
            }
            if (JAVA_PLUGIN_CONVENTION != null && GET_CONVENTION != null && FIND_PLUGIN != null && GET_SOURCE_SETS_CONVENTION != null && GET_TARGET_COMPATIBILITY_CONVENTION != null) {
                try {
                    Object convention = FIND_PLUGIN.invoke(GET_CONVENTION.invoke((Object)project, new Object[0]), JAVA_PLUGIN_CONVENTION);
                    if (convention != null) {
                        return new JavaConventionConfiguration((SourceSetContainer)GET_SOURCE_SETS_CONVENTION.invoke(convention, new Object[0]), (JavaVersion)GET_TARGET_COMPATIBILITY_CONVENTION.invoke(convention, new Object[0]));
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return null;
        }

        protected SourceSetContainer getSourceSets() {
            return this.sourceSets;
        }

        protected JavaVersion getTargetCompatibility() {
            return this.targetCompatibility;
        }

        static {
            Method getTargetCompatibilityExtension;
            Method getSourceSetsExtension;
            Method findByType;
            Method getExtensions;
            Class<?> javaPluginExtension;
            Method getTargetCompatibilityConvention;
            Method getSourceSetsConvention;
            Method findPlugin;
            Method getConvention;
            Class<?> javaPluginConvention;
            try {
                javaPluginConvention = Class.forName("org.gradle.api.plugins.JavaPluginConvention");
                getConvention = Project.class.getMethod("getConvention", new Class[0]);
                findPlugin = Class.forName("org.gradle.api.plugins.Convention").getMethod("findPlugin", Class.class);
                getSourceSetsConvention = javaPluginConvention.getMethod("getSourceSets", new Class[0]);
                getTargetCompatibilityConvention = javaPluginConvention.getMethod("getTargetCompatibility", new Class[0]);
            }
            catch (Throwable ignored) {
                javaPluginConvention = null;
                getConvention = null;
                findPlugin = null;
                getSourceSetsConvention = null;
                getTargetCompatibilityConvention = null;
            }
            try {
                javaPluginExtension = Class.forName("org.gradle.api.plugins.JavaPluginExtension");
                getExtensions = Project.class.getMethod("getExtensions", new Class[0]);
                findByType = Class.forName("org.gradle.api.plugins.ExtensionContainer").getMethod("findByType", Class.class);
                getSourceSetsExtension = javaPluginExtension.getMethod("getSourceSets", new Class[0]);
                getTargetCompatibilityExtension = javaPluginExtension.getMethod("getTargetCompatibility", new Class[0]);
            }
            catch (Throwable ignored) {
                javaPluginExtension = null;
                getExtensions = null;
                findByType = null;
                getSourceSetsExtension = null;
                getTargetCompatibilityExtension = null;
            }
            JAVA_PLUGIN_CONVENTION = javaPluginConvention;
            JAVA_PLUGIN_EXTENSION = javaPluginExtension;
            GET_CONVENTION = getConvention;
            GET_EXTENSIONS = getExtensions;
            FIND_PLUGIN = findPlugin;
            FIND_BY_TYPE = findByType;
            GET_SOURCE_SETS_CONVENTION = getSourceSetsConvention;
            GET_SOURCE_SETS_EXTENSION = getSourceSetsExtension;
            GET_TARGET_COMPATIBILITY_CONVENTION = getTargetCompatibilityConvention;
            GET_TARGET_COMPATIBILITY_EXTENSION = getTargetCompatibilityExtension;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface Dispatcher<T extends AbstractByteBuddyTask, S extends AbstractByteBuddyTaskExtension<T>> {
        public Class<S> getExtensionType();

        public S toExtension(Project var1);

        public AbstractByteBuddyTaskConfiguration<T, S> toAction(String var1, SourceSet var2);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class ForApi6CapableGradle
        implements Dispatcher<ByteBuddyTask, ByteBuddyTaskExtension> {
            private final Method getDestinationDirectory;
            private final Method setDestinationDir;

            protected ForApi6CapableGradle(Method getDestinationDirectory, Method setDestinationDir) {
                this.getDestinationDirectory = getDestinationDirectory;
                this.setDestinationDir = setDestinationDir;
            }

            @Override
            public Class<ByteBuddyTaskExtension> getExtensionType() {
                return ByteBuddyTaskExtension.class;
            }

            @Override
            public ByteBuddyTaskExtension toExtension(Project project) {
                return new ByteBuddyTaskExtension(project);
            }

            public ByteBuddyTaskConfiguration toAction(String name, SourceSet sourceSet) {
                return new ByteBuddyTaskConfiguration(name, sourceSet, this.getDestinationDirectory, this.setDestinationDir);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ForLegacyGradle implements Dispatcher<ByteBuddySimpleTask, ByteBuddySimpleTaskExtension>
        {
            INSTANCE;


            @Override
            public Class<ByteBuddySimpleTaskExtension> getExtensionType() {
                return ByteBuddySimpleTaskExtension.class;
            }

            @Override
            public ByteBuddySimpleTaskExtension toExtension(Project project) {
                return new ByteBuddySimpleTaskExtension(project);
            }

            public ByteBuddySimpleTaskConfiguration toAction(String name, SourceSet sourceSet) {
                return new ByteBuddySimpleTaskConfiguration(name, sourceSet);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class JavaPluginConfigurationAction
    implements Action<JavaPlugin> {
        private final Project project;

        protected JavaPluginConfigurationAction(Project project) {
            this.project = project;
        }

        public void execute(JavaPlugin plugin) {
            this.project.getLogger().debug("Java plugin was discovered for modification: {}", (Object)plugin);
            JavaConventionConfiguration configuration = JavaConventionConfiguration.of(this.project);
            if (configuration == null) {
                this.project.getLogger().warn("Skipping implicit Byte Buddy task configuration since Java plugin did not register Java plugin convention or extension");
            } else {
                for (SourceSet sourceSet : configuration.getSourceSets()) {
                    String name = sourceSet.getName().equals("main") ? "byteBuddy" : sourceSet.getName() + "ByteBuddy";
                    AbstractByteBuddyTaskExtension<Object> extension = (AbstractByteBuddyTaskExtension)ObjectFactory.newInstance(this.project, DISPATCHER.getExtensionType(), this.project);
                    if (extension == null) {
                        extension = DISPATCHER.toExtension(this.project);
                    }
                    extension.resolve(configuration.getTargetCompatibility());
                    extension.discoverySet((FileCollection)this.project.getConfigurations().maybeCreate(name));
                    this.project.getExtensions().add(name, extension);
                    this.project.afterEvaluate(DISPATCHER.toAction(name, sourceSet));
                }
            }
        }
    }
}

