/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.build.gradle.android;

import com.android.build.gradle.BaseExtension;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipException;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.build.AndroidDescriptor;
import net.bytebuddy.build.BuildLogger;
import net.bytebuddy.build.EntryPoint;
import net.bytebuddy.build.Plugin;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.scaffold.inline.MethodNameTransformer;
import net.bytebuddy.utility.QueueFactory;
import net.bytebuddy.utility.nullability.MaybeNull;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.slf4j.Logger;

public abstract class ByteBuddyLocalClassesEnhancerTask
extends DefaultTask {
    @InputFiles
    public abstract ConfigurableFileCollection getAndroidBootClasspath();

    @InputFiles
    public abstract ConfigurableFileCollection getByteBuddyClasspath();

    @Input
    public abstract Property<JavaVersion> getJavaTargetCompatibilityVersion();

    @Input
    public abstract Property<EntryPoint> getEntryPoint();

    @InputFiles
    public abstract ListProperty<RegularFile> getInputJars();

    @InputFiles
    public abstract ListProperty<Directory> getLocalClassesDirs();

    @OutputFile
    public abstract RegularFileProperty getOutputFile();

    private static URL[] toUrls(Collection<File> files) {
        URL[] url = new URL[files.size()];
        int index = 0;
        for (File file : files) {
            try {
                url[index++] = file.toURI().toURL();
            }
            catch (MalformedURLException exception) {
                throw new IllegalStateException("Failed to convert file " + file.getAbsolutePath(), exception);
            }
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public void execute() {
        try {
            ClassFileVersion classFileVersion = ClassFileVersion.ofJavaVersionString((String)((JavaVersion)this.getJavaTargetCompatibilityVersion().get()).toString());
            ArrayList<ClassFileLocator> classFileLocators = new ArrayList<ClassFileLocator>();
            for (File file : this.getAndroidBootClasspath().plus((FileCollection)this.getByteBuddyClasspath()).getFiles()) {
                classFileLocators.add((ClassFileLocator)(file.isFile() ? ClassFileLocator.ForJarFile.of((File)file) : new ClassFileLocator.ForFolder(file)));
            }
            classFileLocators.add(ClassFileLocator.ForClassLoader.of((ClassLoader)ByteBuddy.class.getClassLoader()));
            try (ClassFileLocator.Compound classFileLocator = new ClassFileLocator.Compound(classFileLocators);){
                LinkedHashSet<Object> sources = new LinkedHashSet<Object>();
                HashSet<File> localClasspath = new HashSet<File>();
                for (Object directory : (List)this.getLocalClassesDirs().get()) {
                    File file = directory.getAsFile();
                    localClasspath.add(file);
                    sources.add(new Plugin.Engine.Source.ForFolder(file));
                }
                AndroidDescriptor androidDescriptor = DefaultAndroidDescriptor.ofClassPath(localClasspath);
                for (RegularFile jarFile : (List)this.getInputJars().get()) {
                    sources.add(new Plugin.Engine.Source.ForJarFile(jarFile.getAsFile()));
                }
                URLClassLoader classLoader = new URLClassLoader(ByteBuddyLocalClassesEnhancerTask.toUrls(this.getByteBuddyClasspath().getFiles()), (ClassLoader)new URLClassLoader(ByteBuddyLocalClassesEnhancerTask.toUrls(this.getAndroidBootClasspath().getFiles()), ByteBuddy.class.getClassLoader()));
                try {
                    BuildLogger buildLogger;
                    ArrayList<Plugin.Factory.UsingReflection> factories = new ArrayList<Plugin.Factory.UsingReflection>();
                    try {
                        buildLogger = (BuildLogger)Class.forName("net.bytebuddy.build.gradle.GradleBuildLogger").getConstructor(org.gradle.api.logging.Logger.class).newInstance(this.getLogger());
                    }
                    catch (Exception exception) {
                        throw new GradleException("Failed to resolve Gradle build logger", (Throwable)exception);
                    }
                    for (String name : Plugin.Engine.Default.scan((ClassLoader)classLoader)) {
                        try {
                            Class<?> type = Class.forName(name, false, classLoader);
                            if (!Plugin.class.isAssignableFrom(type)) {
                                throw new GradleException(type.getName() + " does not implement " + Plugin.class.getName());
                            }
                            factories.add(new Plugin.Factory.UsingReflection(type).with(new Plugin.Factory.UsingReflection.ArgumentResolver[]{Plugin.Factory.UsingReflection.ArgumentResolver.ForType.of(AndroidDescriptor.class, (Object)androidDescriptor)}).with(new Plugin.Factory.UsingReflection.ArgumentResolver[]{Plugin.Factory.UsingReflection.ArgumentResolver.ForType.of(org.gradle.api.logging.Logger.class, (Object)this.getLogger())}).with(new Plugin.Factory.UsingReflection.ArgumentResolver[]{Plugin.Factory.UsingReflection.ArgumentResolver.ForType.of(Logger.class, (Object)this.getLogger())}).with(new Plugin.Factory.UsingReflection.ArgumentResolver[]{Plugin.Factory.UsingReflection.ArgumentResolver.ForType.of(BuildLogger.class, (Object)buildLogger)}));
                        }
                        catch (Throwable throwable) {
                            throw new IllegalStateException("Cannot resolve plugin: " + name, throwable);
                        }
                    }
                    Plugin.Engine.Summary summary = Plugin.Engine.Default.of((EntryPoint)((EntryPoint)this.getEntryPoint().getOrElse((Object)new EntryPoint.Unvalidated((EntryPoint)EntryPoint.Default.REBASE))), (ClassFileVersion)classFileVersion, (MethodNameTransformer)MethodNameTransformer.Suffixing.withRandomSuffix()).with((ClassFileLocator)classFileLocator).apply((Plugin.Engine.Source)new Plugin.Engine.Source.Compound(sources), (Plugin.Engine.Target)new TargetForAndroidAppJarFile(((RegularFile)this.getOutputFile().get()).getAsFile()), factories);
                    if (!summary.getFailed().isEmpty()) {
                        throw new IllegalStateException(summary.getFailed() + " type transformations have failed");
                    }
                    if (summary.getTransformed().isEmpty()) {
                        this.getLogger().info("No types were transformed during plugin execution");
                    } else {
                        this.getLogger().info("Transformed {} type(s)", (Object)summary.getTransformed().size());
                    }
                }
                finally {
                    if (classLoader instanceof Closeable) {
                        ((Closeable)classLoader).close();
                    }
                    if (classLoader.getParent() instanceof Closeable) {
                        ((Closeable)((Object)classLoader.getParent())).close();
                    }
                }
            }
        }
        catch (IOException exception) {
            throw new GradleException("Failed to transform classes", (Throwable)exception);
        }
    }

    protected static class TargetForAndroidAppJarFile
    extends Plugin.Engine.Target.ForJarFile {
        private final File file;

        protected TargetForAndroidAppJarFile(File file) {
            super(file);
            this.file = file;
        }

        public Plugin.Engine.Target.Sink write(@MaybeNull Manifest manifest) throws IOException {
            return manifest == null ? new ForAndroidAppOutputStream(new JarOutputStream(new FileOutputStream(this.file))) : new ForAndroidAppOutputStream(new JarOutputStream((OutputStream)new FileOutputStream(this.file), manifest));
        }

        protected static class ForAndroidAppOutputStream
        extends Plugin.Engine.Target.Sink.ForJarOutputStream {
            private final JarOutputStream outputStream;

            protected ForAndroidAppOutputStream(JarOutputStream outputStream) {
                super(outputStream);
                this.outputStream = outputStream;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void retain(Plugin.Engine.Source.Element element) throws IOException {
                block8: {
                    JarEntry entry = (JarEntry)element.resolveAs(JarEntry.class);
                    if (entry != null && entry.isDirectory()) {
                        return;
                    }
                    try {
                        this.outputStream.putNextEntry(new JarEntry(element.getName()));
                        try (InputStream inputStream = element.getInputStream();){
                            int length;
                            byte[] buffer = new byte[1024];
                            while ((length = inputStream.read(buffer)) != -1) {
                                this.outputStream.write(buffer, 0, length);
                            }
                        }
                        this.outputStream.closeEntry();
                    }
                    catch (ZipException exception) {
                        String name = element.getName();
                        if (name.startsWith("META-INF") || name.endsWith("-info.class") || !name.endsWith(".class")) break block8;
                        throw exception;
                    }
                }
            }
        }
    }

    protected static class DefaultAndroidDescriptor
    implements AndroidDescriptor {
        private static final String CLASS_FILE_EXTENSION = ".class";
        private final Set<String> names;

        protected DefaultAndroidDescriptor(Set<String> names) {
            this.names = names;
        }

        protected static AndroidDescriptor ofClassPath(Set<File> roots) {
            HashSet<String> names = new HashSet<String>();
            for (File root : roots) {
                Queue queue = QueueFactory.make(Collections.singleton(root));
                while (!queue.isEmpty()) {
                    File file = (File)queue.remove();
                    if (file.isDirectory()) {
                        File[] value = file.listFiles();
                        if (value == null) continue;
                        queue.addAll(Arrays.asList(value));
                        continue;
                    }
                    if (!file.getName().endsWith(CLASS_FILE_EXTENSION)) continue;
                    String path = root.getAbsoluteFile().toURI().relativize(file.getAbsoluteFile().toURI()).getPath();
                    names.add(path.substring(0, path.length() - CLASS_FILE_EXTENSION.length()).replace('/', '.'));
                }
            }
            return new DefaultAndroidDescriptor(names);
        }

        public AndroidDescriptor.TypeScope getTypeScope(TypeDescription typeDescription) {
            return this.names.contains(typeDescription.getName()) ? AndroidDescriptor.TypeScope.LOCAL : AndroidDescriptor.TypeScope.EXTERNAL;
        }
    }

    public static class ConfigurationAction
    implements Action<ByteBuddyLocalClassesEnhancerTask> {
        private final FileCollection byteBuddyConfiguration;
        private final BaseExtension androidExtension;

        public ConfigurationAction(FileCollection byteBuddyConfiguration, BaseExtension androidExtension) {
            this.byteBuddyConfiguration = byteBuddyConfiguration;
            this.androidExtension = androidExtension;
        }

        public void execute(ByteBuddyLocalClassesEnhancerTask task) {
            task.getByteBuddyClasspath().from(new Object[]{this.byteBuddyConfiguration});
            task.getAndroidBootClasspath().from(new Object[]{this.androidExtension.getBootClasspath()});
            task.getJavaTargetCompatibilityVersion().set((Object)this.androidExtension.getCompileOptions().getTargetCompatibility());
        }
    }
}

