/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.build.gradle;

import groovy.lang.Closure;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.build.BuildLogger;
import net.bytebuddy.build.EntryPoint;
import net.bytebuddy.build.Plugin;
import net.bytebuddy.build.gradle.Discovery;
import net.bytebuddy.build.gradle.GradleBuildLogger;
import net.bytebuddy.build.gradle.ObjectFactory;
import net.bytebuddy.build.gradle.Transformation;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.scaffold.inline.MethodNameTransformer;
import net.bytebuddy.utility.nullability.MaybeNull;
import net.bytebuddy.utility.nullability.UnknownNull;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractByteBuddyTask
extends DefaultTask {
    private final List<Transformation> transformations = new ArrayList<Transformation>();
    @UnknownNull
    private EntryPoint entryPoint;
    @UnknownNull
    private String suffix;
    private boolean failOnLiveInitializer;
    private boolean warnOnEmptyTypeSet;
    private boolean failFast;
    private boolean extendedParsing;
    @UnknownNull
    private Discovery discovery;
    private int threads;
    @MaybeNull
    private ClassFileVersion classFileVersion;
    @MaybeNull
    private ClassFileVersion multiReleaseClassFileVersion;

    protected AbstractByteBuddyTask() {
    }

    @Nested
    public List<Transformation> getTransformations() {
        return this.transformations;
    }

    public void transformation(Closure<Transformation> closure) {
        Transformation transformation = ObjectFactory.newInstance(this.getProject(), Transformation.class, this.getProject());
        this.transformations.add((Transformation)this.getProject().configure((Object)(transformation == null ? new Transformation(this.getProject()) : transformation), closure));
    }

    public void transformation(Action<Transformation> action) {
        Transformation transformation = ObjectFactory.newInstance(this.getProject(), Transformation.class, this.getProject());
        if (transformation == null) {
            transformation = new Transformation(this.getProject());
        }
        action.execute((Object)transformation);
        this.transformations.add(transformation);
    }

    @Input
    public EntryPoint getEntryPoint() {
        return this.entryPoint;
    }

    public void setEntryPoint(EntryPoint entryPoint) {
        this.entryPoint = entryPoint;
    }

    @Input
    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    @Internal
    public boolean isFailOnLiveInitializer() {
        return this.failOnLiveInitializer;
    }

    public void setFailOnLiveInitializer(boolean failOnLiveInitializer) {
        this.failOnLiveInitializer = failOnLiveInitializer;
    }

    @Internal
    public boolean isWarnOnEmptyTypeSet() {
        return this.warnOnEmptyTypeSet;
    }

    public void setWarnOnEmptyTypeSet(boolean warnOnEmptyTypeSet) {
        this.warnOnEmptyTypeSet = warnOnEmptyTypeSet;
    }

    @Internal
    public boolean isFailFast() {
        return this.failFast;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    @Input
    public boolean isExtendedParsing() {
        return this.extendedParsing;
    }

    public void setExtendedParsing(boolean extendedParsing) {
        this.extendedParsing = extendedParsing;
    }

    @Input
    public Discovery getDiscovery() {
        return this.discovery;
    }

    public void setDiscovery(Discovery discovery) {
        this.discovery = discovery;
    }

    @Internal
    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    @MaybeNull
    @Input
    @Optional
    public ClassFileVersion getClassFileVersion() {
        return this.classFileVersion;
    }

    public void setClassFileVersion(@MaybeNull ClassFileVersion classFileVersion) {
        this.classFileVersion = classFileVersion;
    }

    @MaybeNull
    @Input
    @Optional
    public ClassFileVersion getMultiReleaseClassFileVersion() {
        return this.multiReleaseClassFileVersion;
    }

    public void setMultiReleaseClassFileVersion(@MaybeNull ClassFileVersion multiReleaseClassFileVersion) {
        this.multiReleaseClassFileVersion = multiReleaseClassFileVersion;
    }

    protected abstract File source();

    protected abstract File target();

    protected abstract Iterable<File> classPath();

    @MaybeNull
    protected abstract Iterable<File> discoverySet();

    protected void doApply(Plugin.Engine.Source source, Plugin.Engine.Target target) throws IOException {
        ClassFileVersion classFileVersion;
        if (this.source().equals(this.target())) {
            throw new IllegalStateException("Source and target cannot be equal: " + this.source());
        }
        if (this.classFileVersion == null) {
            classFileVersion = ClassFileVersion.ofThisVm();
            this.getLogger().warn("Could not locate Java target version, build is JDK dependant: {}", (Object)classFileVersion.getJavaVersion());
        } else {
            classFileVersion = this.classFileVersion;
            this.getLogger().debug("Java version was configured: {}", (Object)classFileVersion.getJavaVersion());
        }
        AbstractByteBuddyTask.apply(this.getLogger(), ((Object)((Object)this)).getClass().getClassLoader(), new ArrayList<Transformation>(this.getTransformations()), this.getDiscovery(), ClassFileLocator.ForClassLoader.ofPlatformLoader(), this.classPath(), this.discoverySet(), this.getEntryPoint(), classFileVersion, this.multiReleaseClassFileVersion == null ? classFileVersion : this.multiReleaseClassFileVersion, Plugin.Factory.UsingReflection.ArgumentResolver.ForType.of(File.class, (Object)this.source()), this.getSuffix(), this.getThreads(), this.isExtendedParsing(), this.isFailFast(), this.isFailOnLiveInitializer(), this.isWarnOnEmptyTypeSet(), source, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void apply(org.gradle.api.logging.Logger logger, ClassLoader rootLoader, List<Transformation> transformations, Discovery discovery, ClassFileLocator rootLocator, Iterable<File> artifacts, @MaybeNull Iterable<File> discoverySet, EntryPoint entryPoint, ClassFileVersion classFileVersion, ClassFileVersion multiReleaseClassFileVersion, Plugin.Factory.UsingReflection.ArgumentResolver rootLocationResolver, String suffix, int threads, boolean extendedParsing, boolean failFast, boolean failOnLiveInitializer, boolean warnOnEmptyTypeSet, Plugin.Engine.Source source, Plugin.Engine.Target target) throws IOException {
        Plugin.Engine.Summary summary;
        ClassLoader classLoader = ByteBuddySkippingUrlClassLoader.of(rootLoader, discoverySet);
        try {
            if (discovery.isDiscover(transformations)) {
                HashSet<String> undiscoverable = new HashSet<String>();
                if (discovery.isRecordConfiguration()) {
                    for (Transformation transformation : transformations) {
                        undiscoverable.add(transformation.toPluginName());
                    }
                }
                for (String string : Plugin.Engine.Default.scan((ClassLoader)classLoader)) {
                    if (undiscoverable.add(string)) {
                        try {
                            Class<?> plugin = Class.forName(string, false, classLoader);
                            Transformation transformation = new Transformation();
                            transformation.setPlugin(plugin);
                            transformations.add(transformation);
                        }
                        catch (ClassNotFoundException exception) {
                            throw new IllegalStateException("Discovered plugin is not available: " + string, exception);
                        }
                        logger.debug("Registered discovered plugin: {}", (Object)string);
                        continue;
                    }
                    logger.info("Skipping discovered plugin {} which was previously discovered or registered", (Object)string);
                }
            }
            if (transformations.isEmpty()) {
                logger.warn("No transformations are specified or discovered. Application will be non-operational.");
            } else {
                logger.debug("{} plugins are being applied via configuration and discovery", (Object)transformations.size());
            }
            ArrayList<Plugin.Factory.UsingReflection> factories = new ArrayList<Plugin.Factory.UsingReflection>(transformations.size());
            for (Transformation transformation : transformations) {
                try {
                    factories.add(new Plugin.Factory.UsingReflection(transformation.toPlugin(classLoader)).with(transformation.makeArgumentResolvers()).with(new Plugin.Factory.UsingReflection.ArgumentResolver[]{rootLocationResolver, Plugin.Factory.UsingReflection.ArgumentResolver.ForType.of(org.gradle.api.logging.Logger.class, (Object)logger), Plugin.Factory.UsingReflection.ArgumentResolver.ForType.of(Logger.class, (Object)logger), Plugin.Factory.UsingReflection.ArgumentResolver.ForType.of(BuildLogger.class, (Object)new GradleBuildLogger(logger))}));
                    logger.info("Resolved plugin: {}", (Object)transformation.toPluginName());
                }
                catch (Throwable throwable) {
                    throw new IllegalStateException("Cannot resolve plugin: " + transformation.toPluginName(), throwable);
                }
            }
            ArrayList<ClassFileLocator> classFileLocators = new ArrayList<ClassFileLocator>();
            classFileLocators.add(rootLocator);
            for (File artifact : artifacts) {
                classFileLocators.add(artifact.isFile() ? ClassFileLocator.ForJarFile.of((File)artifact, (ClassFileVersion)multiReleaseClassFileVersion) : ClassFileLocator.ForFolder.of((File)artifact, (ClassFileVersion)multiReleaseClassFileVersion));
            }
            ClassFileLocator.Compound compound = new ClassFileLocator.Compound(classFileLocators);
            try {
                summary = Plugin.Engine.Default.of((EntryPoint)entryPoint, (ClassFileVersion)classFileVersion, (MethodNameTransformer)(suffix.length() == 0 ? MethodNameTransformer.Suffixing.withRandomSuffix() : new MethodNameTransformer.Suffixing(suffix))).with((Plugin.Engine.PoolStrategy)(extendedParsing ? Plugin.Engine.PoolStrategy.Default.EXTENDED : Plugin.Engine.PoolStrategy.Default.FAST)).with((ClassFileLocator)compound).with(multiReleaseClassFileVersion).with((Plugin.Engine.Listener)new TransformationLogger(logger)).withErrorHandlers(new Plugin.Engine.ErrorHandler[]{Plugin.Engine.ErrorHandler.Enforcing.ALL_TYPES_RESOLVED, (Plugin.Engine.ErrorHandler)(failOnLiveInitializer ? Plugin.Engine.ErrorHandler.Enforcing.NO_LIVE_INITIALIZERS : Plugin.Engine.Listener.NoOp.INSTANCE), failFast ? Plugin.Engine.ErrorHandler.Failing.FAIL_FAST : Plugin.Engine.ErrorHandler.Failing.FAIL_LAST}).with((Plugin.Engine.Dispatcher.Factory)(threads == 0 ? Plugin.Engine.Dispatcher.ForSerialTransformation.Factory.INSTANCE : new Plugin.Engine.Dispatcher.ForParallelTransformation.WithThrowawayExecutorService.Factory(threads))).apply(source, target, factories);
            }
            finally {
                compound.close();
            }
        }
        finally {
            if (classLoader instanceof Closeable && classLoader instanceof ByteBuddySkippingUrlClassLoader) {
                ((Closeable)((Object)classLoader)).close();
            }
        }
        if (!summary.getFailed().isEmpty()) {
            throw new IllegalStateException(summary.getFailed() + " type transformation(s) have failed");
        }
        if (warnOnEmptyTypeSet && summary.getTransformed().isEmpty()) {
            logger.warn("No types were transformed during plugin execution");
        } else {
            logger.info("Transformed {} type(s)", (Object)summary.getTransformed().size());
        }
    }

    protected static boolean deleteRecursively(Iterable<File> files) {
        boolean deleted = false;
        for (File file : files) {
            deleted = AbstractByteBuddyTask.deleteRecursively(file) || deleted;
        }
        return deleted;
    }

    protected static boolean deleteRecursively(File file) {
        boolean deleted = false;
        LinkedList<File> queue = new LinkedList<File>();
        queue.add(file);
        while (!queue.isEmpty()) {
            File current = (File)queue.remove();
            File[] child = current.listFiles();
            if (child == null || child.length == 0) {
                deleted = current.delete() || deleted;
                continue;
            }
            queue.addAll(Arrays.asList(child));
            queue.add(current);
        }
        return deleted;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ByteBuddySkippingUrlClassLoader
    extends URLClassLoader {
        protected ByteBuddySkippingUrlClassLoader(ClassLoader parent, URL[] url) {
            super(url, parent);
        }

        protected static ClassLoader of(ClassLoader classLoader, @MaybeNull Iterable<File> discoverySet) {
            if (discoverySet == null) {
                return classLoader;
            }
            ArrayList<URL> urls = new ArrayList<URL>();
            for (File file : discoverySet) {
                try {
                    urls.add(file.toURI().toURL());
                }
                catch (MalformedURLException exception) {
                    throw new IllegalStateException(exception);
                }
            }
            return urls.isEmpty() ? classLoader : new ByteBuddySkippingUrlClassLoader(classLoader, urls.toArray(new URL[0]));
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (name.startsWith("net.bytebuddy.")) {
                Class<?> type = this.getParent().loadClass(name);
                if (resolve) {
                    this.resolveClass(type);
                }
                return type;
            }
            return super.loadClass(name, resolve);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TransformationLogger
    extends Plugin.Engine.Listener.Adapter {
        private final org.gradle.api.logging.Logger logger;

        protected TransformationLogger(org.gradle.api.logging.Logger logger) {
            this.logger = logger;
        }

        public void onTransformation(TypeDescription typeDescription, List<Plugin> plugins) {
            this.logger.debug("Transformed {} using {}", (Object)typeDescription, plugins);
        }

        public void onError(TypeDescription typeDescription, Plugin plugin, Throwable throwable) {
            this.logger.warn("Failed to transform {} using {}", new Object[]{typeDescription, plugin, throwable});
        }

        public void onError(Map<TypeDescription, List<Throwable>> throwables) {
            this.logger.warn("Failed to transform {} types", (Object)throwables.size());
        }

        public void onError(Plugin plugin, Throwable throwable) {
            this.logger.error("Failed to close {}", (Object)plugin, (Object)throwable);
        }

        public void onLiveInitializer(TypeDescription typeDescription, TypeDescription definingType) {
            this.logger.debug("Discovered live initializer for {} as a result of transforming {}", (Object)definingType, (Object)typeDescription);
        }
    }
}

