/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.build.gradle;

import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import net.bytebuddy.build.Plugin;
import net.bytebuddy.build.gradle.AbstractByteBuddyTask;
import net.bytebuddy.build.gradle.ByteBuddyJarTaskExtension;
import net.bytebuddy.utility.nullability.MaybeNull;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteBuddyJarTask
extends AbstractByteBuddyTask {
    private File source;
    private File target;
    private Iterable<File> classPath;
    @MaybeNull
    private Iterable<File> discoverySet;

    @Inject
    public ByteBuddyJarTask() {
        new ByteBuddyJarTaskExtension(null).configure(this);
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getSource() {
        return this.source;
    }

    public void setSource(File source) {
        this.source = source;
    }

    @OutputFile
    public File getTarget() {
        return this.target;
    }

    public void setTarget(File target) {
        this.target = target;
    }

    @InputFiles
    @CompileClasspath
    public Iterable<File> getClassPath() {
        return this.classPath;
    }

    public void setClassPath(Iterable<File> classPath) {
        this.classPath = classPath;
    }

    @MaybeNull
    @InputFiles
    @Optional
    public Iterable<File> getDiscoverySet() {
        return this.discoverySet;
    }

    public void setDiscoverySet(@MaybeNull Iterable<File> discoverySet) {
        this.discoverySet = discoverySet;
    }

    @Override
    protected File source() {
        return this.getSource();
    }

    @Override
    protected File target() {
        return this.getTarget();
    }

    @Override
    protected Iterable<File> classPath() {
        return this.getClassPath();
    }

    @Override
    @MaybeNull
    protected Iterable<File> discoverySet() {
        return this.discoverySet;
    }

    @TaskAction
    public void apply() throws IOException {
        if (!this.getSource().equals(this.getTarget()) && ByteBuddyJarTask.deleteRecursively(this.getTarget())) {
            this.getLogger().debug("Deleted target jar {}", (Object)this.getTarget());
        }
        this.doApply((Plugin.Engine.Source)new Plugin.Engine.Source.ForJarFile(this.getSource()), (Plugin.Engine.Target)new Plugin.Engine.Target.ForJarFile(this.getTarget()));
    }
}

