/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.build.gradle;

import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.gradle.api.Project;

public class ByteBuddyLogHandler
extends Handler {
    private final Project project;
    private final Logger logger;
    private final boolean useParentHandlers;

    protected ByteBuddyLogHandler(Project project, Logger logger, boolean useParentHandlers) {
        this.project = project;
        this.logger = logger;
        this.useParentHandlers = useParentHandlers;
        this.setFormatter(new SimpleFormatter());
    }

    public static ByteBuddyLogHandler initialize(Project project) {
        Logger logger = Logger.getLogger("net.bytebuddy");
        ByteBuddyLogHandler handler = new ByteBuddyLogHandler(project, logger, logger.getUseParentHandlers());
        try {
            logger.setUseParentHandlers(false);
            logger.addHandler(handler);
        }
        catch (SecurityException exception) {
            project.getLogger().warn("Cannot configure Byte Buddy logging", (Throwable)exception);
        }
        return handler;
    }

    public void reset() {
        try {
            this.logger.setUseParentHandlers(this.useParentHandlers);
            this.logger.removeHandler(this);
        }
        catch (SecurityException exception) {
            this.project.getLogger().warn("Cannot configure Byte Buddy logging", (Throwable)exception);
        }
    }

    @Override
    public void publish(LogRecord record) {
        if (this.project.getLogger().isDebugEnabled()) {
            this.project.getLogger().debug(this.getFormatter().format(record));
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ByteBuddyLogHandler that = (ByteBuddyLogHandler)object;
        return this.useParentHandlers == that.useParentHandlers && this.logger.equals(that.logger) && this.project.equals(that.project);
    }

    public int hashCode() {
        int result = this.project.hashCode();
        result = 31 * result + this.logger.hashCode();
        result = 31 * result + (this.useParentHandlers ? 1 : 0);
        return result;
    }

    public String toString() {
        return "ByteBuddyLogHandler{project=" + this.project + " ,logger=" + this.logger + " ,useParentHandlers=" + this.useParentHandlers + '}';
    }
}

