/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.build.gradle;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.build.EntryPoint;
import net.bytebuddy.build.Plugin;
import net.bytebuddy.build.gradle.ByteBuddyExtension;
import net.bytebuddy.build.gradle.ClassLoaderResolver;
import net.bytebuddy.build.gradle.Transformation;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.inline.MethodNameTransformer;
import net.bytebuddy.implementation.LoadedTypeInitializer;
import net.bytebuddy.pool.TypePool;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.compile.AbstractCompile;

public class TransformationAction
implements Action<Task> {
    private static final String CLASS_FILE_EXTENSION = ".class";
    private final Project project;
    private final ByteBuddyExtension byteBuddyExtension;
    private final AbstractCompile task;

    public TransformationAction(Project project, ByteBuddyExtension extension, AbstractCompile task) {
        this.project = project;
        this.byteBuddyExtension = extension;
        this.task = task;
    }

    public void execute(Task task) {
        try {
            this.processOutputDirectory(this.task.getDestinationDir(), (Iterable<? extends File>)this.task.getClasspath());
        }
        catch (IOException exception) {
            throw new GradleException("Error accessing file system", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processOutputDirectory(File root, Iterable<? extends File> classPath) throws IOException {
        if (!root.isDirectory()) {
            throw new GradleException("Target location does not exist or is no directory: " + root);
        }
        ClassLoaderResolver classLoaderResolver = new ClassLoaderResolver();
        try {
            ArrayList<Plugin> plugins = new ArrayList<Plugin>(this.byteBuddyExtension.getTransformations().size());
            for (Transformation transformation : this.byteBuddyExtension.getTransformations()) {
                String plugin = transformation.getPlugin();
                try {
                    plugins.add((Plugin)Class.forName(plugin, false, classLoaderResolver.resolve(transformation.getClassPath(root, classPath))).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    this.project.getLogger().info("Created plugin: {}", (Object)plugin);
                }
                catch (Exception exception) {
                    if (exception instanceof GradleException) {
                        throw (GradleException)exception;
                    }
                    throw new GradleException("Cannot create plugin: " + transformation.getRawPlugin(), (Throwable)exception);
                }
            }
            EntryPoint entryPoint = this.byteBuddyExtension.getInitialization().getEntryPoint(classLoaderResolver, root, classPath);
            this.project.getLogger().info("Resolved entry point: {}", (Object)entryPoint);
            this.transform(root, classPath, entryPoint, plugins);
        }
        finally {
            classLoaderResolver.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transform(File root, Iterable<? extends File> classPath, EntryPoint entryPoint, List<Plugin> plugins) throws IOException {
        ArrayList<Object> classFileLocators = new ArrayList<Object>();
        classFileLocators.add(new ClassFileLocator.ForFolder(root));
        for (File file : classPath) {
            classFileLocators.add(file.isFile() ? ClassFileLocator.ForJarFile.of((File)file) : new ClassFileLocator.ForFolder(file));
        }
        ClassFileLocator.Compound classFileLocator = new ClassFileLocator.Compound(classFileLocators);
        try {
            ByteBuddy byteBuddy;
            TypePool.Default.WithLazyResolution withLazyResolution = new TypePool.Default.WithLazyResolution((TypePool.CacheProvider)new TypePool.CacheProvider.Simple(), (ClassFileLocator)classFileLocator, TypePool.Default.ReaderMode.FAST, TypePool.ClassLoading.ofBootPath());
            this.project.getLogger().info("Processing class files located in in: {}", (Object)root);
            JavaPluginConvention convention = (JavaPluginConvention)this.project.getConvention().getPlugins().get("java");
            try {
                if (convention == null) {
                    ClassFileVersion classFileVersion = ClassFileVersion.ofThisVm();
                    this.project.getLogger().warn("Could not locate Java target version, build is JDK dependant: {}", (Object)classFileVersion.getMajorVersion());
                    byteBuddy = entryPoint.byteBuddy(classFileVersion);
                } else {
                    this.project.getLogger().debug("Java version detected: {}", (Object)convention.getTargetCompatibility().getMajorVersion());
                    byteBuddy = entryPoint.byteBuddy(ClassFileVersion.ofJavaVersion((int)Integer.parseInt(convention.getTargetCompatibility().getMajorVersion())));
                }
            }
            catch (Throwable throwable) {
                throw new GradleException("Cannot create Byte Buddy instance", throwable);
            }
            this.processDirectory(root, root, byteBuddy, entryPoint, this.byteBuddyExtension.getMethodNameTransformer(), (ClassFileLocator)classFileLocator, (TypePool)withLazyResolution, plugins);
        }
        finally {
            classFileLocator.close();
        }
    }

    private void processDirectory(File root, File folder, ByteBuddy byteBuddy, EntryPoint entryPoint, MethodNameTransformer methodNameTransformer, ClassFileLocator classFileLocator, TypePool typePool, List<Plugin> plugins) {
        File[] file = folder.listFiles();
        if (file != null) {
            for (File aFile : file) {
                if (aFile.isDirectory()) {
                    this.processDirectory(root, aFile, byteBuddy, entryPoint, methodNameTransformer, classFileLocator, typePool, plugins);
                    continue;
                }
                if (aFile.isFile() && aFile.getName().endsWith(CLASS_FILE_EXTENSION)) {
                    this.processClassFile(root, root.toURI().relativize(aFile.toURI()).toString(), byteBuddy, entryPoint, methodNameTransformer, classFileLocator, typePool, plugins);
                    continue;
                }
                this.project.getLogger().debug("Skipping ignored file: {}", (Object)aFile);
            }
        }
    }

    private void processClassFile(File root, String file, ByteBuddy byteBuddy, EntryPoint entryPoint, MethodNameTransformer methodNameTransformer, ClassFileLocator classFileLocator, TypePool typePool, List<Plugin> plugins) {
        DynamicType.Builder builder;
        String typeName = file.replace('/', '.').substring(0, file.length() - CLASS_FILE_EXTENSION.length());
        this.project.getLogger().debug("Processing class file: {}", (Object)typeName);
        TypeDescription typeDescription = typePool.describe(typeName).resolve();
        try {
            builder = entryPoint.transform(typeDescription, byteBuddy, classFileLocator, methodNameTransformer);
        }
        catch (Throwable throwable) {
            throw new GradleException("Cannot transform type: " + typeName, throwable);
        }
        boolean transformed = false;
        boolean failed = false;
        for (Plugin plugin : plugins) {
            try {
                if (!plugin.matches((Object)typeDescription)) continue;
                try {
                    builder = plugin.apply(builder, typeDescription);
                    transformed = true;
                }
                catch (RuntimeException runtimeException) {
                    if (this.byteBuddyExtension.isFailFast()) {
                        throw runtimeException;
                    }
                    this.project.getLogger().error("Failure during the application of {}", (Object)plugin, (Object)runtimeException);
                    failed = true;
                }
            }
            catch (Throwable throwable) {
                throw new GradleException("Cannot apply " + plugin + " on " + typeName, throwable);
            }
        }
        if (failed) {
            throw new GradleException("At least one plugin failed its execution");
        }
        if (transformed) {
            this.project.getLogger().info("Transformed type: {}", (Object)typeName);
            DynamicType.Unloaded dynamicType = builder.make();
            for (Map.Entry entry : dynamicType.getLoadedTypeInitializers().entrySet()) {
                if (!this.byteBuddyExtension.isFailOnLiveInitializer() || !((LoadedTypeInitializer)entry.getValue()).isAlive()) continue;
                throw new GradleException("Cannot apply live initializer for " + entry.getKey());
            }
            try {
                dynamicType.saveIn(root);
            }
            catch (IOException iOException) {
                throw new GradleException("Cannot save " + typeName + " in " + root, (Throwable)iOException);
            }
        } else {
            this.project.getLogger().debug("Skipping non-transformed type: {}", (Object)typeName);
        }
    }
}

