/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.build.gradle;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.bytebuddy.build.gradle.Initialization;
import net.bytebuddy.build.gradle.Transformation;
import net.bytebuddy.dynamic.scaffold.inline.MethodNameTransformer;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;

public class ByteBuddyExtension {
    private final Project project;
    private final List<Transformation> transformations;
    private Initialization initialization;
    private String suffix;
    private boolean failOnLiveInitializer;
    private boolean continueOnFailedPlugin;
    private Set<String> tasks;

    public ByteBuddyExtension(Project project) {
        this.project = project;
        this.transformations = new ArrayList<Transformation>();
        this.failOnLiveInitializer = true;
    }

    public void transformation(Closure<?> closure) {
        Transformation transformation = (Transformation)this.project.configure((Object)new Transformation(), closure);
        this.transformations.add(transformation);
    }

    public void initialization(Closure<?> closure) {
        if (this.initialization != null) {
            throw new GradleException("Initialization is already set");
        }
        this.initialization = (Initialization)this.project.configure((Object)new Initialization(), closure);
    }

    public List<Transformation> getTransformations() {
        return this.transformations;
    }

    public Initialization getInitialization() {
        return this.initialization == null ? Initialization.makeDefault() : this.initialization;
    }

    public MethodNameTransformer getMethodNameTransformer() {
        return this.suffix == null || this.suffix.isEmpty() ? MethodNameTransformer.Suffixing.withRandomSuffix() : new MethodNameTransformer.Suffixing(this.suffix);
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public boolean isFailOnLiveInitializer() {
        return this.failOnLiveInitializer;
    }

    public void setFailOnLiveInitializer(boolean failOnLiveInitializer) {
        this.failOnLiveInitializer = failOnLiveInitializer;
    }

    public boolean isContinueOnFailedPlugin() {
        return this.continueOnFailedPlugin;
    }

    public void setContinueOnFailedPlugin(boolean continueOnFailedPlugin) {
        this.continueOnFailedPlugin = continueOnFailedPlugin;
    }

    public void setInitialization(Initialization initialization) {
        this.initialization = initialization;
    }

    public boolean implies(Task task) {
        return this.tasks == null || this.tasks.contains(task.getName());
    }

    public void setTasks(Set<String> tasks) {
        this.tasks = tasks;
    }
}

