/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.build.maven;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.build.BuildLogger;
import net.bytebuddy.build.EntryPoint;
import net.bytebuddy.build.Plugin;
import net.bytebuddy.build.maven.ClassLoaderResolver;
import net.bytebuddy.build.maven.Discovery;
import net.bytebuddy.build.maven.Initialization;
import net.bytebuddy.build.maven.Transformation;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.scaffold.inline.MethodNameTransformer;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.utility.CompoundList;
import net.bytebuddy.utility.nullability.MaybeNull;
import net.bytebuddy.utility.nullability.UnknownNull;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.codehaus.plexus.util.Scanner;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.sonatype.plexus.build.incremental.BuildContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ByteBuddyMojo
extends AbstractMojo {
    private static final String JAVA_FILE_EXTENSION = ".java";
    private static final String JAVA_CLASS_EXTENSION = ".class";
    @MaybeNull
    @Component
    public BuildContext context;
    @UnknownNull
    @Parameter(defaultValue="${project}", readonly=true)
    public MavenProject project;
    @UnknownNull
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    public MojoExecution execution;
    @UnknownNull
    @Component
    public RepositorySystem repositorySystem;
    @MaybeNull
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    public RepositorySystemSession repositorySystemSession;
    @MaybeNull
    @Parameter
    public List<Transformation> transformations;
    @MaybeNull
    @Parameter
    public Initialization initialization;
    @MaybeNull
    @Parameter
    public String suffix;
    @Parameter(defaultValue="true", required=true)
    public boolean failOnLiveInitializer;
    @Parameter(defaultValue="false", required=true)
    public boolean skip;
    @Parameter(defaultValue="true", required=true)
    public boolean warnOnMissingOutputDirectory;
    @Parameter(defaultValue="true", required=true)
    public boolean warnOnEmptyTypeSet;
    @Parameter(defaultValue="true", required=true)
    public boolean failFast;
    @Parameter(defaultValue="false", required=true)
    public boolean extendedParsing;
    @MaybeNull
    @Parameter(defaultValue="EMPTY", required=true)
    public Discovery discovery;
    @Parameter(defaultValue="false", required=true)
    public boolean classPathDiscovery;
    @Parameter(defaultValue="0", required=true)
    public int threads;
    @Parameter(defaultValue="false", required=true)
    public boolean incremental;
    @Parameter(defaultValue="0", required=true)
    public int staleMilliseconds;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.project == null || this.repositorySystem == null || this.discovery == null) {
            throw new MojoExecutionException("Plugin is not initialized correctly");
        }
        if (this.skip) {
            this.getLog().info((CharSequence)"Not applying instrumentation as a result of plugin configuration.");
            return;
        }
        ArrayList<Transformer> transformers = new ArrayList<Transformer>();
        HashSet<String> undiscoverable = new HashSet<String>();
        if (this.transformations != null) {
            for (Transformation transformation : this.transformations) {
                transformers.add(new Transformer.ForConfiguredPlugin(transformation));
                if (!this.discovery.isRecordConfiguration()) continue;
                undiscoverable.add(transformation.getPlugin());
            }
        }
        if (this.discovery.isDiscover(transformers)) {
            try {
                Enumeration<URL> plugins = ByteBuddyMojo.class.getClassLoader().getResources("META-INF/net.bytebuddy/build.plugins");
                while (plugins.hasMoreElements()) {
                    this.discover(plugins.nextElement().openStream(), undiscoverable, transformers, null);
                }
                if (this.classPathDiscovery) {
                    List<String> elements = this.getClassPathElements();
                    for (String element : elements) {
                        Object file;
                        String[] artifact = new File(element);
                        if (artifact.isFile()) {
                            file = new JarFile((File)artifact);
                            try {
                                JarEntry entry = ((JarFile)file).getJarEntry("META-INF/net.bytebuddy/build.plugins");
                                if (entry == null) continue;
                                this.discover(((JarFile)file).getInputStream(entry), undiscoverable, transformers, elements);
                                continue;
                            }
                            finally {
                                ((ZipFile)file).close();
                                continue;
                            }
                        }
                        file = new File((File)artifact, "META-INF/net.bytebuddy/build.plugins");
                        if (!((File)file).exists()) continue;
                        this.discover(new FileInputStream((File)file), undiscoverable, transformers, elements);
                    }
                }
            }
            catch (IOException exception) {
                throw new MojoExecutionException("Failed plugin discovery", (Exception)exception);
            }
        }
        if (transformers.isEmpty()) {
            this.getLog().warn((CharSequence)"No transformations are specified or discovered. Skipping plugin application.");
            return;
        }
        this.getLog().debug((CharSequence)(transformers.size() + " plugins are being applied via configuration and discovery"));
        try {
            String sourceDirectory = this.getSourceDirectory();
            if (this.incremental && this.context != null && sourceDirectory != null) {
                Plugin.Engine.Source.ForFolder source;
                this.getLog().debug((CharSequence)("Considering incremental build with context: " + this.context));
                if (this.context.isIncremental()) {
                    Scanner scanner = this.context.newScanner(new File(sourceDirectory));
                    scanner.scan();
                    ArrayList<String> names = new ArrayList<String>();
                    for (String file : scanner.getIncludedFiles()) {
                        if (!file.endsWith(JAVA_FILE_EXTENSION)) continue;
                        names.add(file.substring(0, file.length() - JAVA_FILE_EXTENSION.length()));
                    }
                    source = new Plugin.Engine.Source.Filtering((Plugin.Engine.Source)new Plugin.Engine.Source.ForFolder(new File(this.getOutputDirectory())), (ElementMatcher)new FilePrefixMatcher(names));
                    this.getLog().debug((CharSequence)("Incrementally processing: " + names));
                } else {
                    source = new Plugin.Engine.Source.ForFolder(new File(this.getOutputDirectory()));
                    this.getLog().debug((CharSequence)"Cannot build incrementally - all class files are processed");
                }
                Plugin.Engine.Summary summary = this.apply(new File(this.getOutputDirectory()), this.getClassPathElements(), transformers, (Plugin.Engine.Source)source, true);
                for (TypeDescription typeDescription : summary.getTransformed()) {
                    this.context.refresh(new File(this.getOutputDirectory(), typeDescription.getName() + JAVA_CLASS_EXTENSION));
                }
            } else {
                this.getLog().debug((CharSequence)("Not applying incremental build with context: " + this.context));
                this.apply(new File(this.getOutputDirectory()), this.getClassPathElements(), transformers, (Plugin.Engine.Source)new Plugin.Engine.Source.ForFolder(new File(this.getOutputDirectory())), false);
            }
        }
        catch (IOException exception) {
            throw new MojoFailureException("Error during writing process", (Throwable)exception);
        }
    }

    protected abstract String getOutputDirectory();

    @MaybeNull
    protected abstract String getSourceDirectory();

    protected abstract List<String> getClassPathElements() throws MojoFailureException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Plugin.Engine.Summary apply(File root, List<? extends String> classPath, List<Transformer> transformers, Plugin.Engine.Source source, boolean filtered) throws MojoExecutionException, IOException {
        StalenessFilter stalenessFilter;
        if (!root.exists()) {
            if (this.warnOnMissingOutputDirectory) {
                this.getLog().warn((CharSequence)("Skipping instrumentation due to missing directory: " + root));
            } else {
                this.getLog().info((CharSequence)("Skipping instrumentation due to missing directory: " + root));
            }
            return new Plugin.Engine.Summary(Collections.emptyList(), Collections.emptyMap(), Collections.emptyList());
        }
        if (!root.isDirectory()) {
            throw new MojoExecutionException("Not a directory: " + root);
        }
        File staleness = new File(this.project.getBuild().getDirectory(), "maven-status" + File.separator + this.execution.getArtifactId() + File.separator + this.execution.getGoal() + File.separator + this.execution.getExecutionId() + File.separator + "staleness");
        if (filtered || this.staleMilliseconds < 0) {
            stalenessFilter = null;
            this.getLog().debug((CharSequence)"Stale file detection is disabled");
        } else if (staleness.exists()) {
            stalenessFilter = new StalenessFilter(this.getLog(), staleness.lastModified() + (long)this.staleMilliseconds);
            source = new Plugin.Engine.Source.Filtering(source, (ElementMatcher)stalenessFilter);
            this.getLog().debug((CharSequence)("Using stale file detection with a margin of " + this.staleMilliseconds + " milliseconds"));
        } else {
            stalenessFilter = null;
            this.getLog().debug((CharSequence)"Did not discover previous staleness file");
        }
        HashMap<Coordinate, String> coordinates = new HashMap<Coordinate, String>();
        if (this.project.getDependencyManagement() != null) {
            for (Dependency dependency : this.project.getDependencyManagement().getDependencies()) {
                coordinates.put(new Coordinate(dependency.getGroupId(), dependency.getArtifactId()), dependency.getVersion());
            }
        }
        ClassLoaderResolver classLoaderResolver = new ClassLoaderResolver(this.getLog(), this.repositorySystem, (RepositorySystemSession)(this.repositorySystemSession == null ? MavenRepositorySystemUtils.newSession() : this.repositorySystemSession), this.project.getRemotePluginRepositories());
        try {
            Plugin.Engine.Summary summary;
            ArrayList<Plugin.Factory.UsingReflection> factories = new ArrayList<Plugin.Factory.UsingReflection>(transformers.size());
            for (Transformer transformer : transformers) {
                String plugin = transformer.getPlugin();
                try {
                    factories.add(new Plugin.Factory.UsingReflection(Class.forName(plugin, false, transformer.toClassLoader(classLoaderResolver, coordinates, this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), this.project.getPackaging()))).with(transformer.toArgumentResolvers()).with(new Plugin.Factory.UsingReflection.ArgumentResolver[]{Plugin.Factory.UsingReflection.ArgumentResolver.ForType.of(File.class, (Object)root), Plugin.Factory.UsingReflection.ArgumentResolver.ForType.of(Log.class, (Object)this.getLog()), Plugin.Factory.UsingReflection.ArgumentResolver.ForType.of(BuildLogger.class, (Object)new MavenBuildLogger(this.getLog()))}));
                    this.getLog().info((CharSequence)("Resolved plugin: " + plugin));
                }
                catch (Throwable throwable) {
                    throw new MojoExecutionException("Cannot resolve plugin: " + plugin, throwable);
                }
            }
            String managed = (String)coordinates.get(new Coordinate(this.project.getGroupId(), this.project.getArtifactId()));
            EntryPoint entryPoint = (this.initialization == null ? new Initialization() : this.initialization).getEntryPoint(classLoaderResolver, this.project.getGroupId(), this.project.getArtifactId(), managed == null ? this.project.getVersion() : managed, this.project.getPackaging());
            this.getLog().info((CharSequence)("Resolved entry point: " + entryPoint));
            ArrayList<ClassFileLocator> classFileLocators = new ArrayList<ClassFileLocator>(classPath.size());
            for (String string : classPath) {
                File artifact = new File(string);
                classFileLocators.add((ClassFileLocator)(artifact.isFile() ? ClassFileLocator.ForJarFile.of((File)artifact) : new ClassFileLocator.ForFolder(artifact)));
            }
            ClassFileLocator.Compound classFileLocator = new ClassFileLocator.Compound(classFileLocators);
            try {
                Plugin.Engine pluginEngine;
                this.getLog().info((CharSequence)("Processing class files located in in: " + root));
                try {
                    ClassFileVersion classFileVersion;
                    String javaVersionString = ByteBuddyMojo.findJavaVersionString(this.project, "release");
                    if (javaVersionString == null) {
                        javaVersionString = ByteBuddyMojo.findJavaVersionString(this.project, "target");
                    }
                    if (javaVersionString == null) {
                        classFileVersion = ClassFileVersion.ofThisVm((ClassFileVersion)ClassFileVersion.JAVA_V5);
                        this.getLog().warn((CharSequence)("Could not locate Java target version, build is JDK dependant: " + classFileVersion.getMajorVersion()));
                    } else {
                        classFileVersion = ClassFileVersion.ofJavaVersionString((String)javaVersionString);
                        this.getLog().debug((CharSequence)("Java version detected: " + javaVersionString));
                    }
                    pluginEngine = Plugin.Engine.Default.of((EntryPoint)entryPoint, (ClassFileVersion)classFileVersion, (MethodNameTransformer)(this.suffix == null || this.suffix.length() == 0 ? MethodNameTransformer.Suffixing.withRandomSuffix() : new MethodNameTransformer.Suffixing(this.suffix)));
                }
                catch (Throwable throwable) {
                    throw new MojoExecutionException("Cannot create plugin engine", throwable);
                }
                try {
                    summary = pluginEngine.with((Plugin.Engine.PoolStrategy)(this.extendedParsing ? Plugin.Engine.PoolStrategy.Default.EXTENDED : Plugin.Engine.PoolStrategy.Default.FAST)).with((ClassFileLocator)classFileLocator).with((Plugin.Engine.Listener)new TransformationLogger(this.getLog())).withErrorHandlers(new Plugin.Engine.ErrorHandler[]{Plugin.Engine.ErrorHandler.Enforcing.ALL_TYPES_RESOLVED, (Plugin.Engine.ErrorHandler)(this.failOnLiveInitializer ? Plugin.Engine.ErrorHandler.Enforcing.NO_LIVE_INITIALIZERS : Plugin.Engine.Listener.NoOp.INSTANCE), this.failFast ? Plugin.Engine.ErrorHandler.Failing.FAIL_FAST : Plugin.Engine.ErrorHandler.Failing.FAIL_LAST}).with((Plugin.Engine.Dispatcher.Factory)(this.threads == 0 ? Plugin.Engine.Dispatcher.ForSerialTransformation.Factory.INSTANCE : new Plugin.Engine.Dispatcher.ForParallelTransformation.WithThrowawayExecutorService.Factory(this.threads))).apply(source, (Plugin.Engine.Target)new Plugin.Engine.Target.ForFolder(root), factories);
                }
                catch (Throwable throwable) {
                    throw new MojoExecutionException("Failed to transform class files in " + root, throwable);
                }
            }
            finally {
                classFileLocator.close();
            }
            if (!summary.getFailed().isEmpty()) {
                throw new MojoExecutionException(summary.getFailed() + " type transformation(s) have failed");
            }
            if (this.warnOnEmptyTypeSet && summary.getTransformed().isEmpty()) {
                if (stalenessFilter != null && stalenessFilter.getFiltered() > 0) {
                    this.getLog().info((CharSequence)("No types were transformed during plugin execution but " + stalenessFilter.getFiltered() + " class file(s) were considered stale"));
                } else {
                    this.getLog().warn((CharSequence)"No types were transformed during plugin execution");
                }
            } else {
                this.getLog().info((CharSequence)("Transformed " + summary.getTransformed().size() + " type(s)"));
            }
            if (!((staleness.getParentFile().isDirectory() || staleness.getParentFile().mkdirs()) && (staleness.createNewFile() || staleness.delete() && staleness.createNewFile()))) {
                throw new MojoExecutionException("Failed to define instrumentation staleness: " + staleness.getAbsolutePath());
            }
            Plugin.Engine.Summary summary2 = summary;
            return summary2;
        }
        finally {
            classLoaderResolver.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discover(InputStream inputStream, Set<String> undiscoverable, List<Transformer> transformers, @MaybeNull List<String> classPath) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (undiscoverable.add(line)) {
                    transformers.add(classPath == null ? new Transformer.ForDiscoveredPlugin(line) : new Transformer.ForDiscoveredPlugin.FromClassLoader(line, classPath));
                    this.getLog().debug((CharSequence)("Registered discovered plugin: " + line));
                    continue;
                }
                this.getLog().info((CharSequence)("Skipping discovered plugin " + line + " which was previously discovered or registered"));
            }
        }
        finally {
            reader.close();
        }
    }

    @MaybeNull
    private static String findJavaVersionString(MavenProject project, String property) {
        do {
            String value;
            if ((value = project.getProperties().getProperty("maven.compiler." + property)) != null) {
                return value;
            }
            PluginManagement management = project.getPluginManagement();
            for (org.apache.maven.model.Plugin plugin : management == null ? project.getBuildPlugins() : CompoundList.of((List)project.getBuildPlugins(), (List)management.getPlugins())) {
                Xpp3Dom node;
                if (!"maven-compiler-plugin".equals(plugin.getArtifactId()) || !(plugin.getConfiguration() instanceof Xpp3Dom) || (node = ((Xpp3Dom)plugin.getConfiguration()).getChild(property)) == null) continue;
                return node.getValue();
            }
        } while ((project = project.getParent()) != null);
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class StalenessFilter
    extends ElementMatcher.Junction.ForNonNullValues<Plugin.Engine.Source.Element> {
        private final Log log;
        private final long latestTimestamp;
        private int filtered;

        protected StalenessFilter(Log log, long latestTimestamp) {
            this.log = log;
            this.latestTimestamp = latestTimestamp;
        }

        protected boolean doMatch(Plugin.Engine.Source.Element target) {
            File file = (File)target.resolveAs(File.class);
            if (file == null) {
                throw new IllegalStateException("Expected " + target + " to resolve to a file");
            }
            if (file.lastModified() < this.latestTimestamp) {
                ++this.filtered;
                this.log.debug((CharSequence)("Filtering " + file + " due to staleness: " + file.lastModified()));
                return false;
            }
            return true;
        }

        protected int getFiltered() {
            return this.filtered;
        }
    }

    protected static class Coordinate {
        private final String groupId;
        private final String artifactId;

        protected Coordinate(String groupId, String artifactId) {
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        public int hashCode() {
            int result = this.groupId.hashCode();
            result = 31 * result + this.artifactId.hashCode();
            return result;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Coordinate that = (Coordinate)other;
            if (!this.groupId.equals(that.groupId)) {
                return false;
            }
            return this.artifactId.equals(that.artifactId);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class Transformer {
        protected Transformer() {
        }

        protected abstract String getPlugin() throws MojoExecutionException;

        protected abstract List<? extends Plugin.Factory.UsingReflection.ArgumentResolver> toArgumentResolvers();

        protected abstract ClassLoader toClassLoader(ClassLoaderResolver var1, Map<Coordinate, String> var2, String var3, String var4, String var5, String var6) throws MojoFailureException, MojoExecutionException;

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class ForDiscoveredPlugin
        extends Transformer {
            private final String plugin;

            protected ForDiscoveredPlugin(String plugin) {
                this.plugin = plugin;
            }

            @Override
            protected String getPlugin() {
                return this.plugin;
            }

            @Override
            protected List<? extends Plugin.Factory.UsingReflection.ArgumentResolver> toArgumentResolvers() {
                return Collections.emptyList();
            }

            @Override
            protected ClassLoader toClassLoader(ClassLoaderResolver classLoaderResolver, Map<Coordinate, String> coordinates, String groupId, String artifactId, String version, String packaging) {
                return ByteBuddyMojo.class.getClassLoader();
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static class FromClassLoader
            extends ForDiscoveredPlugin {
                private final List<String> classPath;

                protected FromClassLoader(String plugin, List<String> classPath) {
                    super(plugin);
                    this.classPath = classPath;
                }

                @Override
                @SuppressFBWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"}, justification="The security manager is not normally used within Maven")
                protected ClassLoader toClassLoader(ClassLoaderResolver classLoaderResolver, Map<Coordinate, String> coordinates, String groupId, String artifactId, String version, String packaging) {
                    URL[] url = new URL[this.classPath.size()];
                    for (int index = 0; index < this.classPath.size(); ++index) {
                        try {
                            url[index] = new File(this.classPath.get(index)).toURI().toURL();
                            continue;
                        }
                        catch (MalformedURLException exception) {
                            throw new IllegalStateException("Failed to resolve class path element to URL: " + this.classPath.get(index), exception);
                        }
                    }
                    return new URLClassLoader(url, ByteBuddyMojo.class.getClassLoader());
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static class ForConfiguredPlugin
        extends Transformer {
            private final Transformation transformation;

            protected ForConfiguredPlugin(Transformation transformation) {
                this.transformation = transformation;
            }

            @Override
            protected String getPlugin() throws MojoExecutionException {
                return this.transformation.getPlugin();
            }

            @Override
            protected List<? extends Plugin.Factory.UsingReflection.ArgumentResolver> toArgumentResolvers() {
                return this.transformation.makeArgumentResolvers();
            }

            @Override
            protected ClassLoader toClassLoader(ClassLoaderResolver classLoaderResolver, Map<Coordinate, String> coordinates, String groupId, String artifactId, String version, String packaging) throws MojoFailureException, MojoExecutionException {
                String managed = coordinates.get(new Coordinate(this.transformation.getGroupId(groupId), this.transformation.getArtifactId(artifactId)));
                return classLoaderResolver.resolve(this.transformation.asCoordinate(groupId, artifactId, managed == null ? version : managed, packaging));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TransformationLogger
    extends Plugin.Engine.Listener.Adapter {
        private final Log log;

        protected TransformationLogger(Log log) {
            this.log = log;
        }

        public void onTransformation(TypeDescription typeDescription, List<Plugin> plugins) {
            this.log.debug((CharSequence)("Transformed " + typeDescription + " using " + plugins));
        }

        public void onError(TypeDescription typeDescription, Plugin plugin, Throwable throwable) {
            this.log.warn((CharSequence)("Failed to transform " + typeDescription + " using " + plugin), throwable);
        }

        public void onError(Map<TypeDescription, List<Throwable>> throwables) {
            this.log.warn((CharSequence)("Failed to transform " + throwables.size() + " types"));
        }

        public void onError(Plugin plugin, Throwable throwable) {
            this.log.error((CharSequence)("Failed to close " + plugin), throwable);
        }

        public void onLiveInitializer(TypeDescription typeDescription, TypeDescription definingType) {
            this.log.debug((CharSequence)("Discovered live initializer for " + definingType + " as a result of transforming " + typeDescription));
        }
    }

    protected static class MavenBuildLogger
    implements BuildLogger {
        private final Log log;

        protected MavenBuildLogger(Log log) {
            this.log = log;
        }

        public boolean isDebugEnabled() {
            return this.log.isDebugEnabled();
        }

        public void debug(String message) {
            this.log.debug((CharSequence)message);
        }

        public void debug(String message, Throwable throwable) {
            this.log.debug((CharSequence)message, throwable);
        }

        public boolean isInfoEnabled() {
            return this.log.isInfoEnabled();
        }

        public void info(String message) {
            this.log.info((CharSequence)message);
        }

        public void info(String message, Throwable throwable) {
            this.log.info((CharSequence)message, throwable);
        }

        public boolean isWarnEnabled() {
            return this.log.isWarnEnabled();
        }

        public void warn(String message) {
            this.log.warn((CharSequence)message);
        }

        public void warn(String message, Throwable throwable) {
            this.log.warn((CharSequence)message, throwable);
        }

        public boolean isErrorEnabled() {
            return this.log.isErrorEnabled();
        }

        public void error(String message) {
            this.log.error((CharSequence)message);
        }

        public void error(String message, Throwable throwable) {
            this.log.error((CharSequence)message, throwable);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Mojo(name="transform-test", defaultPhase=LifecyclePhase.PROCESS_TEST_CLASSES, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
    public static class ForTestTypes
    extends ByteBuddyMojo {
        @Override
        protected String getOutputDirectory() {
            return this.project.getBuild().getTestOutputDirectory();
        }

        @Override
        @MaybeNull
        protected String getSourceDirectory() {
            return this.project.getBuild().getTestSourceDirectory();
        }

        @Override
        protected List<String> getClassPathElements() throws MojoFailureException {
            try {
                return this.project.getTestClasspathElements();
            }
            catch (DependencyResolutionRequiredException e) {
                throw new MojoFailureException("Could not resolve test class path", (Throwable)e);
            }
        }
    }

    public static abstract class ForProductionTypes
    extends ByteBuddyMojo {
        protected String getOutputDirectory() {
            return this.project.getBuild().getOutputDirectory();
        }

        @MaybeNull
        protected String getSourceDirectory() {
            return this.project.getBuild().getSourceDirectory();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @Mojo(name="transform-extended", defaultPhase=LifecyclePhase.PROCESS_CLASSES, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
        public static class WithExtendedDependencies
        extends ForProductionTypes {
            @Override
            protected List<String> getClassPathElements() {
                ArrayList<String> classPath = new ArrayList<String>(this.project.getArtifacts().size() + 1);
                String directory = this.project.getBuild().getOutputDirectory();
                if (directory != null) {
                    classPath.add(directory);
                }
                for (Artifact artifact : this.project.getArtifacts()) {
                    File file;
                    if (!artifact.getArtifactHandler().isAddedToClasspath() || "test".equals(artifact.getScope()) || "import".equals(artifact.getScope()) || (file = artifact.getFile()) == null) continue;
                    classPath.add(file.getPath());
                }
                return classPath;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @Mojo(name="transform-runtime", defaultPhase=LifecyclePhase.PROCESS_CLASSES, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
        public static class WithRuntimeDependencies
        extends ForProductionTypes {
            @Override
            protected List<String> getClassPathElements() {
                try {
                    return this.project.getRuntimeClasspathElements();
                }
                catch (DependencyResolutionRequiredException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @Mojo(name="transform", defaultPhase=LifecyclePhase.PROCESS_CLASSES, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE)
        public static class WithoutRuntimeDependencies
        extends ForProductionTypes {
            @Override
            protected List<String> getClassPathElements() throws MojoFailureException {
                try {
                    return this.project.getCompileClasspathElements();
                }
                catch (DependencyResolutionRequiredException e) {
                    throw new MojoFailureException("Could not resolve class path", (Throwable)e);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilePrefixMatcher
    extends ElementMatcher.Junction.ForNonNullValues<Plugin.Engine.Source.Element> {
        private final List<String> names;

        private FilePrefixMatcher(List<String> names) {
            this.names = names;
        }

        protected boolean doMatch(Plugin.Engine.Source.Element target) {
            for (String name : this.names) {
                if (!target.getName().equals(name + ByteBuddyMojo.JAVA_CLASS_EXTENSION) && (!target.getName().startsWith(name + "$") || !target.getName().endsWith(ByteBuddyMojo.JAVA_CLASS_EXTENSION))) continue;
                return true;
            }
            return false;
        }
    }
}

