/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy;

public class ClassFileVersion {
    public static final ClassFileVersion JAVA_V1 = new ClassFileVersion(196653);
    public static final ClassFileVersion JAVA_V2 = new ClassFileVersion(46);
    public static final ClassFileVersion JAVA_V3 = new ClassFileVersion(47);
    public static final ClassFileVersion JAVA_V4 = new ClassFileVersion(48);
    public static final ClassFileVersion JAVA_V5 = new ClassFileVersion(49);
    public static final ClassFileVersion JAVA_V6 = new ClassFileVersion(50);
    public static final ClassFileVersion JAVA_V7 = new ClassFileVersion(51);
    public static final ClassFileVersion JAVA_V8 = new ClassFileVersion(52);
    private static final String JAVA_VERSION_PROPERTY = "java.version";
    private final int versionNumber;

    public ClassFileVersion(int versionNumber) {
        this.versionNumber = ClassFileVersion.validateVersionNumber(versionNumber);
    }

    public static ClassFileVersion forKnownJavaVersion(int javaVersion) {
        switch (javaVersion) {
            case 1: {
                return JAVA_V1;
            }
            case 2: {
                return JAVA_V2;
            }
            case 3: {
                return JAVA_V3;
            }
            case 4: {
                return JAVA_V4;
            }
            case 5: {
                return JAVA_V5;
            }
            case 6: {
                return JAVA_V6;
            }
            case 7: {
                return JAVA_V7;
            }
            case 8: {
                return JAVA_V8;
            }
        }
        throw new IllegalArgumentException("Unknown Java version: " + javaVersion);
    }

    public static ClassFileVersion forCurrentJavaVersion() {
        String versionString = System.getProperty(JAVA_VERSION_PROPERTY);
        int[] versionIndex = new int[]{-1, 0, 0};
        for (int i = 1; i < 3; ++i) {
            versionIndex[i] = versionString.indexOf(46, versionIndex[i - 1] + 1);
            if (versionIndex[i] != -1) continue;
            throw new IllegalStateException("This JVM's version string does not seem to be valid: " + versionString);
        }
        return ClassFileVersion.forKnownJavaVersion(Integer.parseInt(versionString.substring(versionIndex[1] + 1, versionIndex[2])));
    }

    private static int validateVersionNumber(int versionNumber) {
        if (versionNumber <= 0) {
            throw new IllegalArgumentException("Class version " + versionNumber + " is not valid");
        }
        return versionNumber;
    }

    public int getVersionNumber() {
        return this.versionNumber;
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.versionNumber == ((ClassFileVersion)other).versionNumber;
    }

    public int hashCode() {
        return this.versionNumber;
    }

    public String toString() {
        return "ClassFormatVersion{versionNumber=" + this.versionNumber + '}';
    }
}

