/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy;

import java.util.Collection;
import java.util.Random;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.modifier.MemberVisibility;
import net.bytebuddy.modifier.SyntheticState;
import net.bytebuddy.modifier.TypeManifestation;

public interface NamingStrategy {
    public String getName(UnnamedType var1);

    public static class Fixed
    implements NamingStrategy {
        private final String name;

        public Fixed(String name) {
            this.name = name;
        }

        @Override
        public String getName(UnnamedType UnnamedType2) {
            return this.name;
        }
    }

    public static class SuffixingRandom
    implements NamingStrategy {
        private static final String JAVA_LANG_PACKAGE = "java.lang.";
        private static final String BYTE_BUDDY_RENAME_PACKAGE = "net.bytebuddy.renamed";
        private final String suffix;
        private final String javaLangPackagePrefix;
        private final Random random;

        public SuffixingRandom(String suffix) {
            this(suffix, BYTE_BUDDY_RENAME_PACKAGE);
        }

        public SuffixingRandom(String suffix, String javaLangPackagePrefix) {
            this.suffix = suffix;
            this.javaLangPackagePrefix = javaLangPackagePrefix;
            this.random = new Random();
        }

        @Override
        public String getName(UnnamedType unnamedType) {
            String superClassName = unnamedType.getSuperClass().getName();
            if (superClassName.startsWith(JAVA_LANG_PACKAGE)) {
                superClassName = this.javaLangPackagePrefix + "." + superClassName;
            }
            return String.format("%s$$%s$$%d", superClassName, this.suffix, Math.abs(this.random.nextInt()));
        }
    }

    public static interface UnnamedType {
        public TypeDescription getSuperClass();

        public Collection<TypeDescription> getDeclaredInterfaces();

        public MemberVisibility getVisibility();

        public TypeManifestation getTypeManifestation();

        public SyntheticState getSyntheticState();

        public ClassFileVersion getClassFileVersion();
    }
}

