/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic;

import java.util.LinkedHashMap;
import java.util.Map;
import net.bytebuddy.dynamic.loading.ByteArrayClassLoader;
import net.bytebuddy.dynamic.loading.ClassLoaderByteArrayInjector;
import net.bytebuddy.instrumentation.type.TypeDescription;

public interface ClassLoadingStrategy {
    public Map<TypeDescription, Class<?>> load(ClassLoader var1, Map<TypeDescription, byte[]> var2);

    public static enum Default implements ClassLoadingStrategy
    {
        WRAPPER,
        INJECTION;


        @Override
        public Map<TypeDescription, Class<?>> load(ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
            LinkedHashMap loadedTypes = new LinkedHashMap(types.size());
            switch (this) {
                case WRAPPER: {
                    classLoader = new ByteArrayClassLoader(types, classLoader);
                    for (TypeDescription typeDescription : types.keySet()) {
                        try {
                            loadedTypes.put(typeDescription, classLoader.loadClass(typeDescription.getName()));
                        }
                        catch (ClassNotFoundException e) {
                            throw new RuntimeException("Cannot load class " + typeDescription, e);
                        }
                    }
                    break;
                }
                case INJECTION: {
                    ClassLoaderByteArrayInjector classLoaderByteArrayInjector = new ClassLoaderByteArrayInjector(classLoader);
                    for (Map.Entry<TypeDescription, byte[]> entry : types.entrySet()) {
                        loadedTypes.put(entry.getKey(), classLoaderByteArrayInjector.inject(entry.getKey().getName(), entry.getValue()));
                    }
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            return loadedTypes;
        }
    }
}

