/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.loading;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ClassLoaderByteArrayInjector {
    private static Method FIND_LOADED_CLASS_METHOD;
    private static Method LOAD_BYTE_ARRAY_METHOD;
    private static Exception EXCEPTION;
    private final ClassLoader classLoader;

    public ClassLoaderByteArrayInjector(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> inject(String name, byte[] binaryRepresentation) {
        if (FIND_LOADED_CLASS_METHOD == null || LOAD_BYTE_ARRAY_METHOD == null) {
            throw new IllegalStateException("Could not initialize class loader injector", EXCEPTION);
        }
        try {
            ClassLoader classLoader = this.classLoader;
            synchronized (classLoader) {
                Class type = (Class)FIND_LOADED_CLASS_METHOD.invoke((Object)this.classLoader, name);
                if (type != null) {
                    return type;
                }
                return (Class)LOAD_BYTE_ARRAY_METHOD.invoke((Object)this.classLoader, name, binaryRepresentation, 0, binaryRepresentation.length);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Could not access injection method", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Exception on invoking loader method", e.getCause());
        }
    }

    static {
        try {
            FIND_LOADED_CLASS_METHOD = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
            FIND_LOADED_CLASS_METHOD.setAccessible(true);
            LOAD_BYTE_ARRAY_METHOD = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            LOAD_BYTE_ARRAY_METHOD.setAccessible(true);
        }
        catch (Exception e) {
            EXCEPTION = e;
        }
    }
}

