/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.scaffold;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.bytebuddy.dynamic.scaffold.TypeWriter;
import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.attribute.MethodAttributeAppender;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.MethodList;
import net.bytebuddy.instrumentation.method.bytecode.ByteCodeAppender;
import net.bytebuddy.instrumentation.method.matcher.MethodMatcher;
import net.bytebuddy.instrumentation.method.matcher.MethodMatchers;
import net.bytebuddy.instrumentation.type.InstrumentedType;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.utility.ByteBuddyCommons;

public interface MethodRegistry {
    public MethodRegistry prepend(LatentMethodMatcher var1, Instrumentation var2, MethodAttributeAppender.Factory var3);

    public MethodRegistry append(LatentMethodMatcher var1, Instrumentation var2, MethodAttributeAppender.Factory var3);

    public Compiled compile(InstrumentedType var1, TypeWriter.MethodPool.Entry var2);

    public static class Default
    implements MethodRegistry {
        private static final int AT_BEGINNING = 0;
        private final List<Entry> entries;

        public Default() {
            this.entries = Collections.emptyList();
        }

        private Default(List<Entry> entries) {
            this.entries = entries;
        }

        @Override
        public MethodRegistry append(LatentMethodMatcher latentMethodMatcher, Instrumentation instrumentation, MethodAttributeAppender.Factory attributeAppenderFactory) {
            return new Default(ByteBuddyCommons.join(this.entries, new Entry(latentMethodMatcher, instrumentation, attributeAppenderFactory)));
        }

        @Override
        public MethodRegistry prepend(LatentMethodMatcher latentMethodMatcher, Instrumentation instrumentation, MethodAttributeAppender.Factory attributeAppenderFactory) {
            return new Default(ByteBuddyCommons.join(new Entry(latentMethodMatcher, instrumentation, attributeAppenderFactory), this.entries));
        }

        @Override
        public net.bytebuddy.dynamic.scaffold.MethodRegistry$Compiled compile(InstrumentedType instrumentedType, TypeWriter.MethodPool.Entry fallback) {
            LinkedList<Entry> additionalEntries = new LinkedList<Entry>();
            instrumentedType = this.prepareInstrumentedType(instrumentedType, additionalEntries);
            return new Compiled(instrumentedType, this.compileEntries(additionalEntries, instrumentedType), fallback);
        }

        private InstrumentedType prepareInstrumentedType(InstrumentedType instrumentedType, List<Entry> additionalEntries) {
            HashSet<Instrumentation> instrumentations = new HashSet<Instrumentation>(this.entries.size());
            for (Entry entry : this.entries) {
                if (!instrumentations.add(entry.instrumentation)) continue;
                MethodList beforePreparation = instrumentedType.getDeclaredMethods();
                instrumentedType = entry.instrumentation.prepare(instrumentedType);
                if (beforePreparation.size() >= instrumentedType.getDeclaredMethods().size()) continue;
                additionalEntries.add(new Entry(new ListDifferenceMethodMatcher(beforePreparation, instrumentedType.getDeclaredMethods()), entry.instrumentation, MethodAttributeAppender.NoOp.INSTANCE));
            }
            return instrumentedType;
        }

        private List<Compiled.Entry> compileEntries(List<Entry> additionalEntries, TypeDescription instrumentedType) {
            HashMap<Instrumentation, ByteCodeAppender> byteCodeAppenders = new HashMap<Instrumentation, ByteCodeAppender>(this.entries.size());
            LinkedList<Compiled.Entry> compiledEntries = new LinkedList<Compiled.Entry>();
            for (Entry entry : this.entries) {
                if (!byteCodeAppenders.containsKey(entry.instrumentation)) {
                    byteCodeAppenders.put(entry.instrumentation, entry.instrumentation.appender(instrumentedType));
                }
                compiledEntries.add(new Compiled.Entry(entry.latentMethodMatcher.manifest(instrumentedType), (ByteCodeAppender)byteCodeAppenders.get(entry.instrumentation), entry.attributeAppenderFactory.make(instrumentedType)));
            }
            for (Entry entry : additionalEntries) {
                compiledEntries.add(0, new Compiled.Entry(entry.latentMethodMatcher.manifest(instrumentedType), (ByteCodeAppender)byteCodeAppenders.get(entry.instrumentation), entry.attributeAppenderFactory.make(instrumentedType)));
            }
            return new ArrayList<Compiled.Entry>(compiledEntries);
        }

        private static class ListDifferenceMethodMatcher
        implements MethodMatcher,
        LatentMethodMatcher {
            private final MethodList matchedMethods;

            private ListDifferenceMethodMatcher(MethodList beforeMethods, MethodList afterMethods) {
                this.matchedMethods = afterMethods.subList(beforeMethods.size(), afterMethods.size());
            }

            @Override
            public boolean matches(MethodDescription methodDescription) {
                return this.matchedMethods.filter(MethodMatchers.is(methodDescription)).size() == 1;
            }

            @Override
            public MethodMatcher manifest(TypeDescription typeDescription) {
                return this;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.matchedMethods.equals(((ListDifferenceMethodMatcher)other).matchedMethods);
            }

            public int hashCode() {
                return this.matchedMethods.hashCode();
            }

            public String toString() {
                return "oneOf(" + this.matchedMethods + ')';
            }
        }

        private static class Entry {
            private final LatentMethodMatcher latentMethodMatcher;
            private final Instrumentation instrumentation;
            private final MethodAttributeAppender.Factory attributeAppenderFactory;

            private Entry(LatentMethodMatcher latentMethodMatcher, Instrumentation instrumentation, MethodAttributeAppender.Factory attributeAppenderFactory) {
                this.latentMethodMatcher = latentMethodMatcher;
                this.instrumentation = instrumentation;
                this.attributeAppenderFactory = attributeAppenderFactory;
            }
        }

        private static class Compiled
        implements net.bytebuddy.dynamic.scaffold.MethodRegistry$Compiled {
            private final InstrumentedType instrumentedType;
            private final List<Entry> entries;
            private final TypeWriter.MethodPool.Entry fallback;

            private Compiled(InstrumentedType instrumentedType, List<Entry> entries, TypeWriter.MethodPool.Entry fallback) {
                this.instrumentedType = instrumentedType;
                this.entries = entries;
                this.fallback = fallback;
            }

            @Override
            public TypeWriter.MethodPool.Entry target(MethodDescription methodDescription) {
                for (Entry entry : this.entries) {
                    if (!entry.matches(methodDescription)) continue;
                    return entry;
                }
                return this.fallback;
            }

            @Override
            public InstrumentedType getInstrumentedType() {
                return this.instrumentedType;
            }

            private static class Entry
            implements TypeWriter.MethodPool.Entry,
            MethodMatcher {
                private final MethodMatcher methodMatcher;
                private final ByteCodeAppender byteCodeAppender;
                private final MethodAttributeAppender attributeAppender;

                private Entry(MethodMatcher methodMatcher, ByteCodeAppender byteCodeAppender, MethodAttributeAppender attributeAppender) {
                    this.methodMatcher = methodMatcher;
                    this.byteCodeAppender = byteCodeAppender;
                    this.attributeAppender = attributeAppender;
                }

                @Override
                public boolean isDefineMethod() {
                    return true;
                }

                @Override
                public ByteCodeAppender getByteCodeAppender() {
                    return this.byteCodeAppender;
                }

                @Override
                public MethodAttributeAppender getAttributeAppender() {
                    return this.attributeAppender;
                }

                @Override
                public boolean matches(MethodDescription methodDescription) {
                    return this.methodMatcher.matches(methodDescription);
                }

                public String toString() {
                    return "MethodRegistry.Compiled.Entry{methodMatcher=" + this.methodMatcher + ", byteCodeAppender=" + this.byteCodeAppender + ", attributeAppender=" + this.attributeAppender + '}';
                }
            }
        }
    }

    public static interface LatentMethodMatcher {
        public MethodMatcher manifest(TypeDescription var1);

        public static class Simple
        implements LatentMethodMatcher {
            private final MethodMatcher methodMatcher;

            public Simple(MethodMatcher methodMatcher) {
                this.methodMatcher = methodMatcher;
            }

            @Override
            public MethodMatcher manifest(TypeDescription instrumentedType) {
                return this.methodMatcher;
            }

            public boolean equals(Object o) {
                return this == o || o != null && this.getClass() == o.getClass() && this.methodMatcher.equals(((Simple)o).methodMatcher);
            }

            public int hashCode() {
                return this.methodMatcher.hashCode();
            }

            public String toString() {
                return "LatentMethodMatcher.Simple{methodMatcher=" + this.methodMatcher + '}';
            }
        }
    }

    public static interface Compiled
    extends TypeWriter.MethodPool {
        public InstrumentedType getInstrumentedType();
    }
}

