/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.scaffold;

import java.util.Iterator;
import java.util.List;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.asm.ClassVisitorWrapper;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.attribute.FieldAttributeAppender;
import net.bytebuddy.instrumentation.attribute.MethodAttributeAppender;
import net.bytebuddy.instrumentation.attribute.TypeAttributeAppender;
import net.bytebuddy.instrumentation.field.FieldDescription;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.bytecode.ByteCodeAppender;
import net.bytebuddy.instrumentation.type.InstrumentedType;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.ClassWriter;
import net.bytebuddy.jar.asm.FieldVisitor;
import net.bytebuddy.jar.asm.MethodVisitor;

public interface TypeWriter<T> {
    public static final int ASM_MANUAL_FLAG = 0;

    public DynamicType.Unloaded<T> make();

    public static class Builder<T> {
        private final InstrumentedType instrumentedType;
        private final Instrumentation.Context instrumentationContext;
        private final ClassFileVersion classFileVersion;

        public Builder(InstrumentedType instrumentedType, Instrumentation.Context instrumentationContext, ClassFileVersion classFileVersion) {
            this.instrumentedType = instrumentedType;
            this.instrumentationContext = instrumentationContext;
            this.classFileVersion = classFileVersion;
        }

        private static int overrideModifiers(MethodDescription methodDescription, boolean appendsCode) {
            if (appendsCode && (methodDescription.isAbstract() || methodDescription.isNative())) {
                return methodDescription.getModifiers() & 0xFFFFFAFF;
            }
            if (!(appendsCode || methodDescription.isAbstract() || methodDescription.isNative())) {
                return methodDescription.getModifiers() | 0x400;
            }
            return methodDescription.getModifiers();
        }

        public InGeneralPhase<T> build(ClassVisitorWrapper classVisitorWrapper) {
            ClassWriter classWriter = new ClassWriter(0);
            ClassVisitor classVisitor = classVisitorWrapper.wrap(classWriter);
            classVisitor.visit(this.classFileVersion.getVersionNumber(), this.instrumentedType.getModifiers(), this.instrumentedType.getInternalName(), null, this.instrumentedType.getSupertype() == null ? null : this.instrumentedType.getSupertype().getInternalName(), this.instrumentedType.getInterfaces().toInternalNames());
            return new GeneralPhaseTypeWriter(classWriter, classVisitor);
        }

        private class MethodPhaseTypeWriter<S>
        extends AbstractTypeWriter<S>
        implements InMethodPhase<S> {
            private MethodPhaseTypeWriter(ClassWriter classWriter, ClassVisitor classVisitor) {
                super(classWriter, classVisitor);
            }

            @Override
            public InMethodPhase<S> write(Iterable<? extends MethodDescription> methodDescriptions, MethodPool methodPool) {
                for (MethodDescription methodDescription : methodDescriptions) {
                    MethodPool.Entry entry = methodPool.target(methodDescription);
                    if (!entry.isDefineMethod()) continue;
                    boolean appendsCode = entry.getByteCodeAppender().appendsCode();
                    MethodVisitor methodVisitor = this.classVisitor.visitMethod(Builder.overrideModifiers(methodDescription, appendsCode), methodDescription.getInternalName(), methodDescription.getDescriptor(), null, methodDescription.getExceptionTypes().toInternalNames());
                    entry.getAttributeAppender().apply(methodVisitor, methodDescription);
                    if (appendsCode) {
                        methodVisitor.visitCode();
                        ByteCodeAppender.Size size = entry.getByteCodeAppender().apply(methodVisitor, Builder.this.instrumentationContext, methodDescription);
                        methodVisitor.visitMaxs(size.getOperandStackSize(), size.getLocalVariableSize());
                    }
                    methodVisitor.visitEnd();
                }
                return this;
            }
        }

        private class FieldPhaseTypeWriter<S>
        extends AbstractTypeWriter<S>
        implements InFieldPhase<S> {
            private FieldPhaseTypeWriter(ClassWriter classWriter, ClassVisitor classVisitor) {
                super(classWriter, classVisitor);
            }

            @Override
            public InFieldPhase<S> write(Iterable<? extends FieldDescription> fieldDescriptions, FieldPool fieldPool) {
                for (FieldDescription fieldDescription : fieldDescriptions) {
                    FieldVisitor fieldVisitor = this.classVisitor.visitField(fieldDescription.getModifiers(), fieldDescription.getInternalName(), fieldDescription.getDescriptor(), null, null);
                    fieldPool.target(fieldDescription).getFieldAppenderFactory().make(Builder.this.instrumentedType).apply(fieldVisitor, fieldDescription);
                    fieldVisitor.visitEnd();
                }
                return this;
            }

            @Override
            public InMethodPhase<S> methods() {
                return new MethodPhaseTypeWriter(this.classWriter, this.classVisitor);
            }
        }

        private class GeneralPhaseTypeWriter<S>
        extends AbstractTypeWriter<S>
        implements InGeneralPhase<S> {
            private GeneralPhaseTypeWriter(ClassWriter classWriter, ClassVisitor classVisitor) {
                super(classWriter, classVisitor);
            }

            @Override
            public InGeneralPhase<S> attributeType(TypeAttributeAppender typeAttributeAppender) {
                typeAttributeAppender.apply(this.classVisitor, Builder.this.instrumentedType);
                return this;
            }

            @Override
            public InFieldPhase<S> fields() {
                return new FieldPhaseTypeWriter(this.classWriter, this.classVisitor);
            }

            @Override
            public InMethodPhase<S> methods() {
                return new MethodPhaseTypeWriter(this.classWriter, this.classVisitor);
            }
        }

        private abstract class AbstractTypeWriter<S>
        implements TypeWriter<S> {
            protected final ClassWriter classWriter;
            protected final ClassVisitor classVisitor;

            protected AbstractTypeWriter(ClassWriter classWriter, ClassVisitor classVisitor) {
                this.classWriter = classWriter;
                this.classVisitor = classVisitor;
            }

            @Override
            public DynamicType.Unloaded<S> make() {
                this.classVisitor.visitEnd();
                return new DynamicType.Default.Unloaded(Builder.this.instrumentedType.detach(), this.classWriter.toByteArray(), Builder.this.instrumentedType.getTypeInitializer(), Builder.this.instrumentationContext.getRegisteredAuxiliaryTypes());
            }
        }
    }

    public static class SameThreadCoModifiableIterable<S>
    implements Iterable<S> {
        private final List<? extends S> elements;

        public SameThreadCoModifiableIterable(List<? extends S> elements) {
            this.elements = elements;
        }

        @Override
        public Iterator<S> iterator() {
            return new SameThreadCoModifiableIterator();
        }

        private class SameThreadCoModifiableIterator
        implements Iterator<S> {
            private int index = 0;

            private SameThreadCoModifiableIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.index < SameThreadCoModifiableIterable.this.elements.size();
            }

            @Override
            public S next() {
                return SameThreadCoModifiableIterable.this.elements.get(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static interface InMethodPhase<T>
    extends TypeWriter<T> {
        public InMethodPhase<T> write(Iterable<? extends MethodDescription> var1, MethodPool var2);
    }

    public static interface InFieldPhase<T>
    extends TypeWriter<T> {
        public InFieldPhase<T> write(Iterable<? extends FieldDescription> var1, FieldPool var2);

        public InMethodPhase<T> methods();
    }

    public static interface InGeneralPhase<T>
    extends TypeWriter<T> {
        public InGeneralPhase<T> attributeType(TypeAttributeAppender var1);

        public InFieldPhase<T> fields();

        public InMethodPhase<T> methods();
    }

    public static interface MethodPool {
        public Entry target(MethodDescription var1);

        public static interface Entry {
            public boolean isDefineMethod();

            public ByteCodeAppender getByteCodeAppender();

            public MethodAttributeAppender getAttributeAppender();

            public static class Simple
            implements Entry {
                private final ByteCodeAppender byteCodeAppender;
                private final MethodAttributeAppender methodAttributeAppender;

                public Simple(ByteCodeAppender byteCodeAppender, MethodAttributeAppender methodAttributeAppender) {
                    this.byteCodeAppender = byteCodeAppender;
                    this.methodAttributeAppender = methodAttributeAppender;
                }

                @Override
                public boolean isDefineMethod() {
                    return true;
                }

                @Override
                public ByteCodeAppender getByteCodeAppender() {
                    return this.byteCodeAppender;
                }

                @Override
                public MethodAttributeAppender getAttributeAppender() {
                    return this.methodAttributeAppender;
                }

                public boolean equals(Object o) {
                    return this == o || o != null && this.getClass() == o.getClass() && this.byteCodeAppender.equals(((Simple)o).byteCodeAppender) && this.methodAttributeAppender.equals(((Simple)o).methodAttributeAppender);
                }

                public int hashCode() {
                    return 31 * this.byteCodeAppender.hashCode() + this.methodAttributeAppender.hashCode();
                }

                public String toString() {
                    return "Default{byteCodeAppender=" + this.byteCodeAppender + ", methodAttributeAppender=" + this.methodAttributeAppender + '}';
                }
            }

            public static enum Skip implements Entry
            {
                INSTANCE;


                @Override
                public boolean isDefineMethod() {
                    return false;
                }

                @Override
                public ByteCodeAppender getByteCodeAppender() {
                    throw new IllegalStateException();
                }

                @Override
                public MethodAttributeAppender getAttributeAppender() {
                    throw new IllegalStateException();
                }
            }
        }
    }

    public static interface FieldPool {
        public Entry target(FieldDescription var1);

        public static interface Entry {
            public FieldAttributeAppender.Factory getFieldAppenderFactory();

            public static class Simple
            implements Entry {
                private final FieldAttributeAppender.Factory attributeAppenderFactory;

                public Simple(FieldAttributeAppender.Factory attributeAppenderFactory) {
                    this.attributeAppenderFactory = attributeAppenderFactory;
                }

                @Override
                public FieldAttributeAppender.Factory getFieldAppenderFactory() {
                    return this.attributeAppenderFactory;
                }
            }

            public static enum NoOp implements Entry
            {
                INSTANCE;


                @Override
                public FieldAttributeAppender.Factory getFieldAppenderFactory() {
                    return FieldAttributeAppender.NoOp.INSTANCE;
                }
            }
        }
    }
}

