/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.scaffold.subclass;

import net.bytebuddy.dynamic.scaffold.MethodRegistry;
import net.bytebuddy.instrumentation.SuperMethodCall;
import net.bytebuddy.instrumentation.attribute.MethodAttributeAppender;
import net.bytebuddy.instrumentation.method.MethodList;
import net.bytebuddy.instrumentation.method.matcher.MethodMatchers;
import net.bytebuddy.instrumentation.type.TypeDescription;

public interface ConstructorStrategy {
    public MethodList extractConstructors(TypeDescription var1);

    public MethodRegistry inject(MethodRegistry var1, MethodAttributeAppender.Factory var2);

    public static enum Default implements ConstructorStrategy
    {
        NO_CONSTRUCTORS,
        DEFAULT_CONSTRUCTOR,
        IMITATE_SUPER_TYPE;


        @Override
        public MethodList extractConstructors(TypeDescription superType) {
            switch (this) {
                case NO_CONSTRUCTORS: {
                    return new MethodList.Empty();
                }
                case DEFAULT_CONSTRUCTOR: {
                    MethodList methodList = superType.getDeclaredMethods().filter(MethodMatchers.isConstructor().and(MethodMatchers.takesArguments(0)).and(MethodMatchers.isPublic().or(MethodMatchers.isProtected())));
                    if (methodList.size() == 1) {
                        return methodList;
                    }
                    throw new IllegalArgumentException(superType + " does not declare a default constructor");
                }
                case IMITATE_SUPER_TYPE: {
                    return superType.getDeclaredMethods().filter(MethodMatchers.isConstructor().and(MethodMatchers.isPublic().or(MethodMatchers.isProtected())));
                }
            }
            throw new AssertionError();
        }

        @Override
        public MethodRegistry inject(MethodRegistry methodRegistry, MethodAttributeAppender.Factory defaultMethodAttributeAppenderFactory) {
            switch (this) {
                case NO_CONSTRUCTORS: {
                    return methodRegistry;
                }
                case DEFAULT_CONSTRUCTOR: 
                case IMITATE_SUPER_TYPE: {
                    return methodRegistry.append(new MethodRegistry.LatentMethodMatcher.Simple(MethodMatchers.isConstructor()), SuperMethodCall.INSTANCE, defaultMethodAttributeAppenderFactory);
                }
            }
            throw new AssertionError();
        }
    }
}

