/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.scaffold.subclass;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.bytebuddy.dynamic.scaffold.BridgeMethodResolver;
import net.bytebuddy.dynamic.scaffold.TypeWriter;
import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.attribute.MethodAttributeAppender;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.MethodList;
import net.bytebuddy.instrumentation.method.bytecode.ByteCodeAppender;
import net.bytebuddy.instrumentation.method.bytecode.stack.Duplication;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.Throw;
import net.bytebuddy.instrumentation.method.bytecode.stack.TypeCreation;
import net.bytebuddy.instrumentation.method.bytecode.stack.constant.TextConstant;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodInvocation;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodReturn;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodVariableAccess;
import net.bytebuddy.instrumentation.method.matcher.MethodMatchers;
import net.bytebuddy.instrumentation.type.InstrumentedType;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.instrumentation.type.auxiliary.AuxiliaryType;
import net.bytebuddy.jar.asm.MethodVisitor;

public class SubclassInstrumentationContextDelegate
implements AuxiliaryType.MethodAccessorFactory,
Instrumentation.Context.Default.AuxiliaryTypeNamingStrategy,
TypeWriter.MethodPool {
    public static final String ABSTRACT_METHOD_WARNING_PREFIX = "There is no super implementation for: ";
    private static final String DEFAULT_PREFIX = "delegate";
    private final String prefix;
    private final Random random;
    private final BridgeMethodResolver bridgeMethodResolver;
    private final InstrumentedType instrumentedType;
    private final List<MethodDescription> orderedAccessorMethods;
    private final Map<MethodDescription, MethodDescription> knownTargetMethodsToAccessorMethod;
    private final Map<MethodDescription, TypeWriter.MethodPool.Entry> registeredAccessorMethodToTargetMethodCall;
    private final Map<String, MethodDescription> reachableMethods;

    public SubclassInstrumentationContextDelegate(InstrumentedType instrumentedType, BridgeMethodResolver.Factory bridgeMethodResolverFactory) {
        this(instrumentedType, bridgeMethodResolverFactory, DEFAULT_PREFIX);
    }

    public SubclassInstrumentationContextDelegate(InstrumentedType instrumentedType, BridgeMethodResolver.Factory bridgeMethodResolverFactory, String prefix) {
        this.prefix = prefix;
        this.instrumentedType = instrumentedType;
        this.random = new Random();
        MethodList reachableMethods = instrumentedType.getReachableMethods();
        this.bridgeMethodResolver = bridgeMethodResolverFactory.make(reachableMethods);
        this.reachableMethods = new HashMap<String, MethodDescription>(reachableMethods.size());
        for (MethodDescription methodDescription : reachableMethods) {
            this.reachableMethods.put(methodDescription.getUniqueSignature(), methodDescription);
        }
        this.orderedAccessorMethods = new ArrayList<MethodDescription>();
        this.knownTargetMethodsToAccessorMethod = new HashMap<MethodDescription, MethodDescription>();
        this.registeredAccessorMethodToTargetMethodCall = new HashMap<MethodDescription, TypeWriter.MethodPool.Entry>();
    }

    @Override
    public String name(AuxiliaryType auxiliaryType) {
        return String.format("%s$%s$%d", this.instrumentedType.getName(), DEFAULT_PREFIX, Math.abs(this.random.nextInt()));
    }

    @Override
    public MethodDescription requireAccessorMethodFor(MethodDescription targetMethod) {
        if ((targetMethod = this.reachableMethods.get(targetMethod.getUniqueSignature())) == null) {
            throw new IllegalArgumentException("Method is not reachable from instrumented type");
        }
        MethodDescription accessorMethod = this.knownTargetMethodsToAccessorMethod.get(targetMethod);
        if (accessorMethod != null) {
            return accessorMethod;
        }
        String name = String.format("%s$%s$%d", targetMethod.getInternalName(), this.prefix, Math.abs(this.random.nextInt()));
        accessorMethod = new MethodDescription.Latent(name, this.instrumentedType, targetMethod.getReturnType(), targetMethod.getParameterTypes(), (targetMethod.isStatic() ? 8 : 0) | 0x1000 | 0x10);
        this.knownTargetMethodsToAccessorMethod.put(targetMethod, accessorMethod);
        TypeWriter.MethodPool.Entry methodCall = (TypeWriter.MethodPool.Entry)((Object)(targetMethod.isAbstract() || targetMethod.getDeclaringType().equals(this.instrumentedType) ? AbstractMethodCall.INSTANCE : new SameSignatureMethodCall(this.bridgeMethodResolver.resolve(targetMethod), this.instrumentedType)));
        this.registeredAccessorMethodToTargetMethodCall.put(accessorMethod, methodCall);
        this.orderedAccessorMethods.add(accessorMethod);
        return accessorMethod;
    }

    public Iterable<MethodDescription> getProxiedMethods() {
        return new TypeWriter.SameThreadCoModifiableIterable<MethodDescription>(this.orderedAccessorMethods);
    }

    @Override
    public TypeWriter.MethodPool.Entry target(MethodDescription methodDescription) {
        TypeWriter.MethodPool.Entry targetMethodCall = this.registeredAccessorMethodToTargetMethodCall.get(methodDescription);
        if (targetMethodCall == null) {
            throw new IllegalArgumentException("Unknown method: " + methodDescription);
        }
        return targetMethodCall;
    }

    public String toString() {
        return "SubclassInstrumentationContextDelegate{instrumentedType=" + this.instrumentedType + ", bridgeMethodResolver=" + this.bridgeMethodResolver + ", prefix='" + this.prefix + '\'' + ", random=" + this.random + ", knownTargetMethodsToAccessorMethod=" + this.knownTargetMethodsToAccessorMethod + '}';
    }

    private static class SameSignatureMethodCall
    implements TypeWriter.MethodPool.Entry,
    ByteCodeAppender {
        private final StackManipulation targetMethodCall;

        private SameSignatureMethodCall(MethodDescription accessorMethod, TypeDescription instrumentedType) {
            this.targetMethodCall = MethodInvocation.invoke(accessorMethod).special(instrumentedType.getSupertype());
        }

        @Override
        public ByteCodeAppender getByteCodeAppender() {
            return this;
        }

        @Override
        public boolean isDefineMethod() {
            return true;
        }

        @Override
        public boolean appendsCode() {
            return true;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext, MethodDescription instrumentedMethod) {
            StackManipulation.Size stackSize = new StackManipulation.Compound(MethodVariableAccess.loadThisAndArguments(instrumentedMethod), this.targetMethodCall, MethodReturn.returning(instrumentedMethod.getReturnType())).apply(methodVisitor, instrumentationContext);
            return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
        }

        @Override
        public MethodAttributeAppender getAttributeAppender() {
            return MethodAttributeAppender.NoOp.INSTANCE;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.targetMethodCall.equals(((SameSignatureMethodCall)other).targetMethodCall);
        }

        public int hashCode() {
            return this.targetMethodCall.hashCode();
        }

        public String toString() {
            return "SameSignatureMethodCall{targetMethodCall=" + this.targetMethodCall + '}';
        }
    }

    private static enum AbstractMethodCall implements TypeWriter.MethodPool.Entry,
    ByteCodeAppender
    {
        INSTANCE;

        private final TypeDescription exceptionType = new TypeDescription.ForLoadedType(RuntimeException.class);
        private final MethodDescription constructor = this.exceptionType.getDeclaredMethods().filter(MethodMatchers.isConstructor().and(MethodMatchers.takesArguments(String.class))).getOnly();

        @Override
        public boolean isDefineMethod() {
            return true;
        }

        @Override
        public ByteCodeAppender getByteCodeAppender() {
            return this;
        }

        @Override
        public MethodAttributeAppender getAttributeAppender() {
            return MethodAttributeAppender.NoOp.INSTANCE;
        }

        @Override
        public boolean appendsCode() {
            return true;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext, MethodDescription instrumentedMethod) {
            StackManipulation.Size stackSize = new StackManipulation.Compound(TypeCreation.forType(this.exceptionType), Duplication.SINGLE, new TextConstant(SubclassInstrumentationContextDelegate.ABSTRACT_METHOD_WARNING_PREFIX + instrumentedMethod), MethodInvocation.invoke(this.constructor), Throw.INSTANCE).apply(methodVisitor, instrumentationContext);
            return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
        }
    }
}

