/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.bytecode.ByteCodeAppender;
import net.bytebuddy.instrumentation.type.InstrumentedType;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.instrumentation.type.auxiliary.AuxiliaryType;
import net.bytebuddy.jar.asm.MethodVisitor;

public interface Instrumentation {
    public InstrumentedType prepare(InstrumentedType var1);

    public ByteCodeAppender appender(TypeDescription var1);

    public static class Compound
    implements Instrumentation {
        private final Instrumentation[] instrumentation;

        public Compound(Instrumentation ... instrumentation) {
            this.instrumentation = instrumentation;
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            for (Instrumentation instrumentation : this.instrumentation) {
                instrumentedType = instrumentation.prepare(instrumentedType);
            }
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(TypeDescription instrumentedType) {
            ByteCodeAppender[] byteCodeAppender = new ByteCodeAppender[this.instrumentation.length];
            int index = 0;
            for (Instrumentation instrumentation : this.instrumentation) {
                byteCodeAppender[index++] = instrumentation.appender(instrumentedType);
            }
            return new ByteCodeAppender.Compound(byteCodeAppender);
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && Arrays.equals(this.instrumentation, ((Compound)o).instrumentation);
        }

        public int hashCode() {
            return Arrays.hashCode(this.instrumentation);
        }

        public String toString() {
            return "Compound{" + Arrays.toString(this.instrumentation) + '}';
        }
    }

    public static interface Context {
        public TypeDescription register(AuxiliaryType var1);

        public List<DynamicType> getRegisteredAuxiliaryTypes();

        public static class Default
        implements Context,
        AuxiliaryType.MethodAccessorFactory {
            private final ClassFileVersion classFileVersion;
            private final AuxiliaryTypeNamingStrategy auxiliaryTypeNamingStrategy;
            private final AuxiliaryType.MethodAccessorFactory methodAccessorFactory;
            private final Map<AuxiliaryType, DynamicType> auxiliaryTypes;
            private final Map<MethodDescription, MethodDescription> registeredAccessorMethods;

            public Default(ClassFileVersion classFileVersion, AuxiliaryTypeNamingStrategy auxiliaryTypeNamingStrategy, AuxiliaryType.MethodAccessorFactory methodAccessorFactory) {
                this.classFileVersion = classFileVersion;
                this.auxiliaryTypeNamingStrategy = auxiliaryTypeNamingStrategy;
                this.methodAccessorFactory = methodAccessorFactory;
                this.auxiliaryTypes = new HashMap<AuxiliaryType, DynamicType>();
                this.registeredAccessorMethods = new HashMap<MethodDescription, MethodDescription>();
            }

            @Override
            public TypeDescription register(AuxiliaryType auxiliaryType) {
                DynamicType dynamicType = this.auxiliaryTypes.get(auxiliaryType);
                if (dynamicType == null) {
                    dynamicType = auxiliaryType.make(this.auxiliaryTypeNamingStrategy.name(auxiliaryType), this.classFileVersion, this);
                    this.auxiliaryTypes.put(auxiliaryType, dynamicType);
                }
                return dynamicType.getDescription();
            }

            @Override
            public MethodDescription requireAccessorMethodFor(MethodDescription targetMethod) {
                MethodDescription accessorMethod = this.registeredAccessorMethods.get(targetMethod);
                if (accessorMethod == null) {
                    accessorMethod = this.methodAccessorFactory.requireAccessorMethodFor(targetMethod);
                    this.registeredAccessorMethods.put(targetMethod, accessorMethod);
                }
                return accessorMethod;
            }

            @Override
            public List<DynamicType> getRegisteredAuxiliaryTypes() {
                return Collections.unmodifiableList(new ArrayList<DynamicType>(this.auxiliaryTypes.values()));
            }

            public String toString() {
                return "Default{classFormatVersion=" + this.classFileVersion + ", auxiliaryTypeNamingStrategy=" + this.auxiliaryTypeNamingStrategy + ", methodAccessorFactory=" + this.methodAccessorFactory + ", auxiliaryTypes=" + this.auxiliaryTypes + ", registeredAccessorMethods=" + this.registeredAccessorMethods + '}';
            }

            public static interface AuxiliaryTypeNamingStrategy {
                public String name(AuxiliaryType var1);
            }
        }
    }

    public static enum ForAbstractMethod implements Instrumentation,
    ByteCodeAppender
    {
        INSTANCE;


        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(TypeDescription instrumentedType) {
            return this;
        }

        @Override
        public boolean appendsCode() {
            return false;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Context instrumentationContext, MethodDescription instrumentedMethod) {
            throw new IllegalStateException();
        }
    }
}

