/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.TypeInitializer;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.MethodList;
import net.bytebuddy.instrumentation.method.bytecode.ByteCodeAppender;
import net.bytebuddy.instrumentation.method.bytecode.bind.MethodDelegationBinder;
import net.bytebuddy.instrumentation.method.bytecode.bind.MethodNameEqualityResolver;
import net.bytebuddy.instrumentation.method.bytecode.bind.MostSpecificTypeResolver;
import net.bytebuddy.instrumentation.method.bytecode.bind.ParameterLengthResolver;
import net.bytebuddy.instrumentation.method.bytecode.bind.annotation.AllArguments;
import net.bytebuddy.instrumentation.method.bytecode.bind.annotation.Argument;
import net.bytebuddy.instrumentation.method.bytecode.bind.annotation.BindingPriority;
import net.bytebuddy.instrumentation.method.bytecode.bind.annotation.Origin;
import net.bytebuddy.instrumentation.method.bytecode.bind.annotation.Super;
import net.bytebuddy.instrumentation.method.bytecode.bind.annotation.SuperCall;
import net.bytebuddy.instrumentation.method.bytecode.bind.annotation.TargetMethodAnnotationDrivenBinder;
import net.bytebuddy.instrumentation.method.bytecode.bind.annotation.This;
import net.bytebuddy.instrumentation.method.bytecode.stack.Duplication;
import net.bytebuddy.instrumentation.method.bytecode.stack.LegalTrivialStackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.TypeCreation;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.Assigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.primitive.PrimitiveTypeAwareAssigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.primitive.VoidAwareAssigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.reference.ReferenceTypeAwareAssigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.FieldAccess;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodReturn;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodVariableAccess;
import net.bytebuddy.instrumentation.method.matcher.MethodMatcher;
import net.bytebuddy.instrumentation.method.matcher.MethodMatchers;
import net.bytebuddy.instrumentation.type.InstrumentedType;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.utility.ByteBuddyCommons;

public class MethodDelegation
implements Instrumentation {
    private static final String NO_METHODS_ERROR_MESSAGE = "The target type does not define any methods for delegation";
    private final InstrumentationDelegate instrumentationDelegate;
    private final List<TargetMethodAnnotationDrivenBinder.ParameterBinder<?>> parameterBinders;
    private final TargetMethodAnnotationDrivenBinder.DefaultsProvider<?> defaultsProvider;
    private final MethodDelegationBinder.AmbiguityResolver ambiguityResolver;
    private final Assigner assigner;
    private final MethodList methodList;

    protected MethodDelegation(InstrumentationDelegate instrumentationDelegate, List<TargetMethodAnnotationDrivenBinder.ParameterBinder<?>> parameterBinders, TargetMethodAnnotationDrivenBinder.DefaultsProvider<?> defaultsProvider, MethodDelegationBinder.AmbiguityResolver ambiguityResolver, Assigner assigner, MethodList methodList) {
        this.instrumentationDelegate = instrumentationDelegate;
        this.parameterBinders = parameterBinders;
        this.defaultsProvider = defaultsProvider;
        this.ambiguityResolver = ambiguityResolver;
        this.assigner = assigner;
        this.methodList = ByteBuddyCommons.isNotEmpty(methodList, NO_METHODS_ERROR_MESSAGE);
    }

    public static MethodDelegation to(Class<?> type) {
        if (type == null) {
            throw new NullPointerException("Type must not be null");
        }
        if (type.isInterface()) {
            throw new IllegalArgumentException("Cannot delegate to interface " + type);
        }
        if (type.isArray()) {
            throw new IllegalArgumentException("Cannot delegate to array " + type);
        }
        if (type.isPrimitive()) {
            throw new IllegalArgumentException("Cannot delegate to primitive " + type);
        }
        return new MethodDelegation(InstrumentationDelegate.ForStaticMethod.INSTANCE, MethodDelegation.defaultParameterBinders(), MethodDelegation.defaultDefaultsProvider(), MethodDelegation.defaultAmbiguityResolver(), MethodDelegation.defaultAssigner(), new TypeDescription.ForLoadedType(type).getDeclaredMethods().filter(MethodMatchers.isStatic().and(MethodMatchers.not(MethodMatchers.isPrivate()))));
    }

    public static MethodDelegation to(Object delegate) {
        return new MethodDelegation(new InstrumentationDelegate.ForStaticFieldInstance(ByteBuddyCommons.nonNull(delegate)), MethodDelegation.defaultParameterBinders(), MethodDelegation.defaultDefaultsProvider(), MethodDelegation.defaultAmbiguityResolver(), MethodDelegation.defaultAssigner(), new TypeDescription.ForLoadedType(delegate.getClass()).getReachableMethods().filter(MethodMatchers.not(MethodMatchers.isStatic().or(MethodMatchers.isPrivate()).or(MethodMatchers.isConstructor()))));
    }

    public static MethodDelegation to(Object delegate, String fieldName) {
        return new MethodDelegation(new InstrumentationDelegate.ForStaticFieldInstance(ByteBuddyCommons.nonNull(delegate), ByteBuddyCommons.isValidIdentifier(fieldName)), MethodDelegation.defaultParameterBinders(), MethodDelegation.defaultDefaultsProvider(), MethodDelegation.defaultAmbiguityResolver(), MethodDelegation.defaultAssigner(), new TypeDescription.ForLoadedType(delegate.getClass()).getReachableMethods().filter(MethodMatchers.not(MethodMatchers.isStatic().or(MethodMatchers.isPrivate()).or(MethodMatchers.isConstructor()))));
    }

    public static MethodDelegation instanceField(Class<?> type, String fieldName) {
        return new MethodDelegation(new InstrumentationDelegate.ForInstanceField(new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(type)), ByteBuddyCommons.isValidIdentifier(fieldName)), MethodDelegation.defaultParameterBinders(), MethodDelegation.defaultDefaultsProvider(), MethodDelegation.defaultAmbiguityResolver(), MethodDelegation.defaultAssigner(), new TypeDescription.ForLoadedType(type).getReachableMethods().filter(MethodMatchers.not(MethodMatchers.isStatic().or(MethodMatchers.isPrivate()).or(MethodMatchers.isConstructor()))));
    }

    public static MethodDelegation construct(Class<?> type) {
        return new MethodDelegation(new InstrumentationDelegate.ForConstruction(new TypeDescription.ForLoadedType(type)), MethodDelegation.defaultParameterBinders(), MethodDelegation.defaultDefaultsProvider(), MethodDelegation.defaultAmbiguityResolver(), MethodDelegation.defaultAssigner(), new TypeDescription.ForLoadedType(type).getDeclaredMethods().filter(MethodMatchers.isConstructor()));
    }

    private static List<TargetMethodAnnotationDrivenBinder.ParameterBinder<?>> defaultParameterBinders() {
        return Arrays.asList(Argument.Binder.INSTANCE, AllArguments.Binder.INSTANCE, Origin.Binder.INSTANCE, This.Binder.INSTANCE, Super.Binder.INSTANCE, SuperCall.Binder.INSTANCE);
    }

    private static TargetMethodAnnotationDrivenBinder.DefaultsProvider<?> defaultDefaultsProvider() {
        return Argument.NextUnboundAsDefaultsProvider.INSTANCE;
    }

    private static MethodDelegationBinder.AmbiguityResolver defaultAmbiguityResolver() {
        return MethodDelegationBinder.AmbiguityResolver.Chain.of(BindingPriority.Resolver.INSTANCE, MethodNameEqualityResolver.INSTANCE, MostSpecificTypeResolver.INSTANCE, ParameterLengthResolver.INSTANCE);
    }

    private static Assigner defaultAssigner() {
        return new VoidAwareAssigner(new PrimitiveTypeAwareAssigner(ReferenceTypeAwareAssigner.INSTANCE), false);
    }

    public MethodDelegation appendParameterBinder(TargetMethodAnnotationDrivenBinder.ParameterBinder<?> parameterBinder) {
        return new MethodDelegation(this.instrumentationDelegate, ByteBuddyCommons.join(this.parameterBinders, ByteBuddyCommons.nonNull(parameterBinder)), this.defaultsProvider, this.ambiguityResolver, this.assigner, this.methodList);
    }

    public MethodDelegation defineParameterBinder(TargetMethodAnnotationDrivenBinder.ParameterBinder<?> ... parameterBinder) {
        return new MethodDelegation(this.instrumentationDelegate, Arrays.asList((Object[])ByteBuddyCommons.nonNull(parameterBinder)), this.defaultsProvider, this.ambiguityResolver, this.assigner, this.methodList);
    }

    public MethodDelegation defaultsProvider(TargetMethodAnnotationDrivenBinder.DefaultsProvider defaultsProvider) {
        return new MethodDelegation(this.instrumentationDelegate, this.parameterBinders, ByteBuddyCommons.nonNull(defaultsProvider), this.ambiguityResolver, this.assigner, this.methodList);
    }

    public MethodDelegation appendAmbiguityResolver(MethodDelegationBinder.AmbiguityResolver ambiguityResolver) {
        return this.defineAmbiguityResolver(MethodDelegationBinder.AmbiguityResolver.Chain.of(this.ambiguityResolver, ByteBuddyCommons.nonNull(ambiguityResolver)));
    }

    public MethodDelegation defineAmbiguityResolver(MethodDelegationBinder.AmbiguityResolver ... ambiguityResolver) {
        return new MethodDelegation(this.instrumentationDelegate, this.parameterBinders, this.defaultsProvider, MethodDelegationBinder.AmbiguityResolver.Chain.of(ByteBuddyCommons.nonNull(ambiguityResolver)), this.assigner, this.methodList);
    }

    public MethodDelegation assigner(Assigner assigner) {
        return new MethodDelegation(this.instrumentationDelegate, this.parameterBinders, this.defaultsProvider, this.ambiguityResolver, ByteBuddyCommons.nonNull(assigner), this.methodList);
    }

    public MethodDelegation filter(MethodMatcher methodMatcher) {
        return new MethodDelegation(this.instrumentationDelegate, this.parameterBinders, this.defaultsProvider, this.ambiguityResolver, this.assigner, ByteBuddyCommons.isNotEmpty(this.methodList.filter(ByteBuddyCommons.nonNull(methodMatcher)), NO_METHODS_ERROR_MESSAGE));
    }

    @Override
    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        return this.instrumentationDelegate.prepare(instrumentedType);
    }

    @Override
    public ByteCodeAppender appender(TypeDescription instrumentedType) {
        MethodList methodList = this.methodList.filter(MethodMatchers.isVisibleTo(instrumentedType));
        if (methodList.size() == 0) {
            throw new IllegalStateException("No bindable method is visible to " + instrumentedType);
        }
        return new MethodDelegationByteCodeAppender(this.instrumentationDelegate.getPreparingStackAssignment(instrumentedType), instrumentedType, methodList, new MethodDelegationBinder.Processor(new TargetMethodAnnotationDrivenBinder(this.parameterBinders, this.defaultsProvider, this.assigner, this.instrumentationDelegate.getMethodInvoker(instrumentedType)), this.ambiguityResolver));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MethodDelegation that = (MethodDelegation)other;
        return this.ambiguityResolver.equals(that.ambiguityResolver) && this.assigner.equals(that.assigner) && this.defaultsProvider.equals(that.defaultsProvider) && this.instrumentationDelegate.equals(that.instrumentationDelegate) && this.methodList.equals(that.methodList) && this.parameterBinders.equals(that.parameterBinders);
    }

    public int hashCode() {
        int result = this.instrumentationDelegate.hashCode();
        result = 31 * result + this.parameterBinders.hashCode();
        result = 31 * result + this.defaultsProvider.hashCode();
        result = 31 * result + this.ambiguityResolver.hashCode();
        result = 31 * result + this.assigner.hashCode();
        result = 31 * result + this.methodList.hashCode();
        return result;
    }

    public String toString() {
        return "MethodDelegation{instrumentationDelegate=" + this.instrumentationDelegate + ", parameterBinders=" + this.parameterBinders + ", defaultsProvider=" + this.defaultsProvider + ", ambiguityResolver=" + this.ambiguityResolver + ", assigner=" + this.assigner + ", methodList=" + this.methodList + '}';
    }

    private static class MethodDelegationByteCodeAppender
    implements ByteCodeAppender {
        private final StackManipulation preparingStackAssignment;
        private final TypeDescription instrumentedType;
        private final Iterable<? extends MethodDescription> targetMethods;
        private final MethodDelegationBinder.Processor processor;

        private MethodDelegationByteCodeAppender(StackManipulation preparingStackAssignment, TypeDescription instrumentedType, Iterable<? extends MethodDescription> targetMethods, MethodDelegationBinder.Processor processor) {
            this.preparingStackAssignment = preparingStackAssignment;
            this.instrumentedType = instrumentedType;
            this.targetMethods = targetMethods;
            this.processor = processor;
        }

        @Override
        public boolean appendsCode() {
            return true;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext, MethodDescription instrumentedMethod) {
            StackManipulation.Size stackSize = new StackManipulation.Compound(this.preparingStackAssignment, this.processor.process(this.instrumentedType, instrumentedMethod, this.targetMethods), MethodReturn.returning(instrumentedMethod.getReturnType())).apply(methodVisitor, instrumentationContext);
            return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            MethodDelegationByteCodeAppender that = (MethodDelegationByteCodeAppender)other;
            return this.instrumentedType.equals(that.instrumentedType) && this.preparingStackAssignment.equals(that.preparingStackAssignment) && this.processor.equals(that.processor) && this.targetMethods.equals(that.targetMethods);
        }

        public int hashCode() {
            int result = this.preparingStackAssignment.hashCode();
            result = 31 * result + this.instrumentedType.hashCode();
            result = 31 * result + this.targetMethods.hashCode();
            result = 31 * result + this.processor.hashCode();
            return result;
        }

        public String toString() {
            return "MethodDelegationByteCodeAppender{preparingStackAssignment=" + this.preparingStackAssignment + ", instrumentedType=" + this.instrumentedType + ", targetMethods=" + this.targetMethods + ", processor=" + this.processor + '}';
        }
    }

    protected static interface InstrumentationDelegate {
        public InstrumentedType prepare(InstrumentedType var1);

        public StackManipulation getPreparingStackAssignment(TypeDescription var1);

        public MethodDelegationBinder.MethodInvoker getMethodInvoker(TypeDescription var1);

        public static class ForConstruction
        implements InstrumentationDelegate {
            private final TypeDescription typeDescription;

            public ForConstruction(TypeDescription typeDescription) {
                this.typeDescription = typeDescription;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public StackManipulation getPreparingStackAssignment(TypeDescription instrumentedType) {
                return new StackManipulation.Compound(TypeCreation.forType(this.typeDescription), Duplication.SINGLE);
            }

            @Override
            public MethodDelegationBinder.MethodInvoker getMethodInvoker(TypeDescription instrumentedType) {
                return MethodDelegationBinder.MethodInvoker.Simple.INSTANCE;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.typeDescription.equals(((ForConstruction)other).typeDescription);
            }

            public int hashCode() {
                return this.typeDescription.hashCode();
            }

            public String toString() {
                return "MethodDelegation.InstrumentationDelegate.ForConstruction{typeDescription=" + this.typeDescription + '}';
            }
        }

        public static class ForInstanceField
        implements InstrumentationDelegate {
            private final String fieldName;
            private final TypeDescription fieldType;

            public ForInstanceField(TypeDescription fieldType, String fieldName) {
                this.fieldType = fieldType;
                this.fieldName = fieldName;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType.withField(this.fieldName, this.fieldType, 1);
            }

            @Override
            public StackManipulation getPreparingStackAssignment(TypeDescription instrumentedType) {
                return new StackManipulation.Compound(MethodVariableAccess.forType(instrumentedType).loadFromIndex(0), FieldAccess.forField(instrumentedType.getDeclaredFields().named(this.fieldName)).getter());
            }

            @Override
            public MethodDelegationBinder.MethodInvoker getMethodInvoker(TypeDescription instrumentedType) {
                return new MethodDelegationBinder.MethodInvoker.Virtual(this.fieldType);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.fieldName.equals(((ForInstanceField)other).fieldName) && this.fieldType.equals(((ForInstanceField)other).fieldType);
            }

            public int hashCode() {
                return 31 * this.fieldName.hashCode() + this.fieldType.hashCode();
            }

            public String toString() {
                return "MethodDelegation.InstrumentationDelegate.ForInstanceField{fieldName='" + this.fieldName + '\'' + ", fieldType=" + this.fieldType + '}';
            }
        }

        public static class ForStaticFieldInstance
        implements InstrumentationDelegate,
        TypeInitializer {
            private static final Object STATIC_FIELD = null;
            private static final String PREFIX = "methodDelegate";
            private final String fieldName;
            private final Object delegate;

            public ForStaticFieldInstance(Object delegate) {
                this(delegate, String.format("%s$%d", PREFIX, delegate.hashCode()));
            }

            public ForStaticFieldInstance(Object delegate, String fieldName) {
                this.delegate = delegate;
                this.fieldName = fieldName;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType.withField(this.fieldName, new TypeDescription.ForLoadedType(this.delegate.getClass()), 4106).withInitializer(this);
            }

            @Override
            public StackManipulation getPreparingStackAssignment(TypeDescription instrumentedType) {
                return FieldAccess.forField(instrumentedType.getDeclaredFields().named(this.fieldName)).getter();
            }

            @Override
            public MethodDelegationBinder.MethodInvoker getMethodInvoker(TypeDescription instrumentedType) {
                return new MethodDelegationBinder.MethodInvoker.Virtual(new TypeDescription.ForLoadedType(this.delegate.getClass()));
            }

            @Override
            public void onLoad(Class<?> type) {
                try {
                    Field field = type.getDeclaredField(this.fieldName);
                    field.setAccessible(true);
                    field.set(STATIC_FIELD, this.delegate);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Cannot set static field " + this.fieldName + " on " + type, e);
                }
            }

            @Override
            public boolean isAlive() {
                return true;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.delegate.equals(((ForStaticFieldInstance)other).delegate) && this.fieldName.equals(((ForStaticFieldInstance)other).fieldName);
            }

            public int hashCode() {
                return 31 * this.fieldName.hashCode() + this.delegate.hashCode();
            }

            public String toString() {
                return "MethodDelegation.InstrumentationDelegate.ForStaticFieldInstance{fieldName='" + this.fieldName + '\'' + ", delegate=" + this.delegate + '}';
            }
        }

        public static enum ForStaticMethod implements InstrumentationDelegate
        {
            INSTANCE;


            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public StackManipulation getPreparingStackAssignment(TypeDescription instrumentedType) {
                return LegalTrivialStackManipulation.INSTANCE;
            }

            @Override
            public MethodDelegationBinder.MethodInvoker getMethodInvoker(TypeDescription instrumentedType) {
                return MethodDelegationBinder.MethodInvoker.Simple.INSTANCE;
            }
        }
    }
}

