/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation;

import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.MethodList;
import net.bytebuddy.instrumentation.method.bytecode.ByteCodeAppender;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodInvocation;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodReturn;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodVariableAccess;
import net.bytebuddy.instrumentation.method.matcher.MethodMatchers;
import net.bytebuddy.instrumentation.type.InstrumentedType;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.jar.asm.MethodVisitor;

public enum SuperMethodCall implements Instrumentation
{
    INSTANCE;


    @Override
    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        return instrumentedType;
    }

    @Override
    public ByteCodeAppender appender(TypeDescription instrumentedType) {
        if (instrumentedType.getSupertype() == null) {
            throw new IllegalArgumentException("The object type does not have a super type");
        }
        return new SuperMethodCallAppender(instrumentedType.getSupertype());
    }

    private static class SuperMethodCallAppender
    implements ByteCodeAppender {
        private final TypeDescription targetType;

        private SuperMethodCallAppender(TypeDescription targetType) {
            this.targetType = targetType;
        }

        @Override
        public boolean appendsCode() {
            return true;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext, MethodDescription instrumentedMethod) {
            MethodDescription targetMethod;
            if (instrumentedMethod.isConstructor()) {
                MethodList methodList = this.targetType.getDeclaredMethods().filter(MethodMatchers.hasSameByteCodeSignatureAs(instrumentedMethod));
                if (methodList.size() == 0) {
                    throw new IllegalArgumentException("There is no super constructor resembling " + instrumentedMethod);
                }
                targetMethod = methodList.getOnly();
            } else {
                targetMethod = instrumentedMethod;
            }
            StackManipulation.Size stackSize = new StackManipulation.Compound(MethodVariableAccess.loadThisAndArguments(instrumentedMethod), MethodInvocation.invoke(targetMethod).special(this.targetType), MethodReturn.returning(instrumentedMethod.getReturnType())).apply(methodVisitor, instrumentationContext);
            return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.targetType.equals(((SuperMethodCallAppender)other).targetType);
        }

        public int hashCode() {
            return this.targetType.hashCode();
        }

        public String toString() {
            return "SuperMethodCallAppender{targetType=" + this.targetType + '}';
        }
    }
}

