/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public interface TypeInitializer {
    public void onLoad(Class<?> var1);

    public boolean isAlive();

    public static class Compound
    implements TypeInitializer,
    Serializable {
        private final TypeInitializer[] typeInitializer;

        public Compound(TypeInitializer ... typeInitializer) {
            this.typeInitializer = typeInitializer;
        }

        public Compound(List<? extends TypeInitializer> typeInitializers) {
            this.typeInitializer = typeInitializers.toArray(new TypeInitializer[typeInitializers.size()]);
        }

        @Override
        public void onLoad(Class<?> type) {
            for (TypeInitializer typeInitializer : this.typeInitializer) {
                typeInitializer.onLoad(type);
            }
        }

        @Override
        public boolean isAlive() {
            for (TypeInitializer typeInitializer : this.typeInitializer) {
                if (!typeInitializer.isAlive()) continue;
                return true;
            }
            return false;
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && Arrays.equals(this.typeInitializer, ((Compound)o).typeInitializer);
        }

        public int hashCode() {
            return Arrays.hashCode(this.typeInitializer);
        }

        public String toString() {
            return "TypeInitializer.Compound{typeInitializer=" + Arrays.toString(this.typeInitializer) + '}';
        }
    }

    public static enum NoOp implements TypeInitializer,
    Serializable
    {
        INSTANCE;


        @Override
        public void onLoad(Class<?> type) {
        }

        @Override
        public boolean isAlive() {
            return false;
        }
    }
}

