/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import net.bytebuddy.instrumentation.ModifierReviewable;
import net.bytebuddy.instrumentation.method.ByteCodeMethod;
import net.bytebuddy.instrumentation.type.DeclaredInType;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.instrumentation.type.TypeList;
import net.bytebuddy.jar.asm.Type;

public interface MethodDescription
extends ModifierReviewable,
ByteCodeMethod,
DeclaredInType,
AnnotatedElement {
    public static final String CONSTRUCTOR_INTERNAL_NAME = "<init>";

    public TypeDescription getReturnType();

    public TypeList getParameterTypes();

    public Annotation[][] getParameterAnnotations();

    public TypeList getExceptionTypes();

    public boolean isConstructor();

    public boolean represents(Method var1);

    public boolean represents(Constructor<?> var1);

    public boolean isOverridable();

    public int getStackSize();

    public int getParameterOffset(int var1);

    public static class Latent
    extends AbstractMethodDescription {
        private final String internalName;
        private final TypeDescription declaringType;
        private final TypeDescription returnType;
        private final List<TypeDescription> parameterTypes;
        private final int modifiers;

        public Latent(String internalName, TypeDescription declaringType, TypeDescription returnType, List<TypeDescription> parameterTypes, int modifiers) {
            this.internalName = internalName;
            this.declaringType = declaringType;
            this.returnType = returnType;
            this.parameterTypes = parameterTypes;
            this.modifiers = modifiers;
        }

        @Override
        public TypeDescription getReturnType() {
            return this.returnType;
        }

        @Override
        public TypeList getParameterTypes() {
            return new TypeList.Explicit(this.parameterTypes);
        }

        @Override
        public Annotation[][] getParameterAnnotations() {
            return new Annotation[0][0];
        }

        @Override
        public TypeList getExceptionTypes() {
            return new TypeList.Empty();
        }

        @Override
        public boolean isConstructor() {
            return MethodDescription.CONSTRUCTOR_INTERNAL_NAME.equals(this.internalName);
        }

        @Override
        public boolean represents(Method method) {
            return false;
        }

        @Override
        public boolean represents(Constructor<?> constructor) {
            return false;
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
            return false;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return null;
        }

        @Override
        public Annotation[] getAnnotations() {
            return new Annotation[0];
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return new Annotation[0];
        }

        @Override
        public String getName() {
            return this.isConstructor() ? this.getDeclaringType().getName() : this.internalName;
        }

        @Override
        public String getInternalName() {
            return this.internalName;
        }

        @Override
        public TypeDescription getDeclaringType() {
            return this.declaringType;
        }

        @Override
        public int getModifiers() {
            return this.modifiers;
        }

        public String toString() {
            return "MethodDescription.Latent{internalName='" + this.internalName + '\'' + ", declaringType=" + this.declaringType + ", returnType=" + this.returnType + ", parameterTypes=" + this.parameterTypes + ", modifiers=" + this.modifiers + '}';
        }
    }

    public static class ForLoadedMethod
    extends AbstractMethodDescription {
        private final Method method;

        public ForLoadedMethod(Method method) {
            this.method = method;
        }

        @Override
        public TypeDescription getDeclaringType() {
            return new TypeDescription.ForLoadedType(this.method.getDeclaringClass());
        }

        @Override
        public TypeDescription getReturnType() {
            return new TypeDescription.ForLoadedType(this.method.getReturnType());
        }

        @Override
        public TypeList getParameterTypes() {
            return new TypeList.ForLoadedType(this.method.getParameterTypes());
        }

        @Override
        public Annotation[][] getParameterAnnotations() {
            return this.method.getParameterAnnotations();
        }

        @Override
        public TypeList getExceptionTypes() {
            return new TypeList.ForLoadedType(this.method.getExceptionTypes());
        }

        @Override
        public boolean isVarArgs() {
            return this.method.isVarArgs();
        }

        @Override
        public boolean isConstructor() {
            return false;
        }

        @Override
        public boolean isBridge() {
            return this.method.isBridge();
        }

        @Override
        public boolean represents(Method method) {
            return this.method.equals(method);
        }

        @Override
        public boolean represents(Constructor<?> constructor) {
            return false;
        }

        @Override
        public String getName() {
            return this.method.getName();
        }

        @Override
        public int getModifiers() {
            return this.method.getModifiers();
        }

        @Override
        public boolean isSynthetic() {
            return this.method.isSynthetic();
        }

        @Override
        public String getInternalName() {
            return this.method.getName();
        }

        @Override
        public String getDescriptor() {
            return Type.getMethodDescriptor(this.method);
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return this.method.getDeclaredAnnotations();
        }

        @Override
        public Annotation[] getAnnotations() {
            return this.method.getAnnotations();
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return this.method.getAnnotation(annotationClass);
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
            return this.method.isAnnotationPresent(annotationClass);
        }

        public String toString() {
            return "MethodDescription.ForLoadedMethod{" + this.method + "}";
        }
    }

    public static class ForLoadedConstructor
    extends AbstractMethodDescription {
        private final Constructor<?> constructor;

        public ForLoadedConstructor(Constructor<?> constructor) {
            this.constructor = constructor;
        }

        @Override
        public TypeDescription getDeclaringType() {
            return new TypeDescription.ForLoadedType(this.constructor.getDeclaringClass());
        }

        @Override
        public TypeDescription getReturnType() {
            return new TypeDescription.ForLoadedType(Void.TYPE);
        }

        @Override
        public TypeList getParameterTypes() {
            return new TypeList.ForLoadedType(this.constructor.getParameterTypes());
        }

        @Override
        public Annotation[][] getParameterAnnotations() {
            return this.constructor.getParameterAnnotations();
        }

        @Override
        public TypeList getExceptionTypes() {
            return new TypeList.ForLoadedType(this.constructor.getExceptionTypes());
        }

        @Override
        public boolean isVarArgs() {
            return this.constructor.isVarArgs();
        }

        @Override
        public boolean isConstructor() {
            return true;
        }

        @Override
        public boolean isBridge() {
            return false;
        }

        @Override
        public boolean represents(Method method) {
            return false;
        }

        @Override
        public boolean represents(Constructor<?> constructor) {
            return this.constructor.equals(constructor);
        }

        @Override
        public String getName() {
            return this.constructor.getName();
        }

        @Override
        public int getModifiers() {
            return this.constructor.getModifiers();
        }

        @Override
        public boolean isSynthetic() {
            return this.constructor.isSynthetic();
        }

        @Override
        public String getInternalName() {
            return MethodDescription.CONSTRUCTOR_INTERNAL_NAME;
        }

        @Override
        public String getDescriptor() {
            return Type.getConstructorDescriptor(this.constructor);
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return this.constructor.getDeclaredAnnotations();
        }

        @Override
        public Annotation[] getAnnotations() {
            return this.constructor.getAnnotations();
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return (T)this.constructor.getAnnotation(annotationClass);
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
            return this.constructor.isAnnotationPresent(annotationClass);
        }

        public String toString() {
            return "MethodDescription.ForLoadedConstructor{" + this.constructor + "}";
        }
    }

    public static abstract class AbstractMethodDescription
    extends ModifierReviewable.AbstractModifierReviewable
    implements MethodDescription {
        @Override
        public String getUniqueSignature() {
            return this.getInternalName() + this.getDescriptor();
        }

        @Override
        public int getStackSize() {
            return this.getParameterTypes().getStackSize() + (this.isStatic() ? 0 : 1);
        }

        @Override
        public String getDescriptor() {
            StringBuilder descriptor = new StringBuilder("(");
            for (TypeDescription parameterType : this.getParameterTypes()) {
                descriptor.append(parameterType.getDescriptor());
            }
            return descriptor.append(")").append(this.getReturnType().getDescriptor()).toString();
        }

        @Override
        public boolean isVisibleTo(TypeDescription typeDescription) {
            return this.isPublic() || typeDescription.equals(this.getDeclaringType()) || this.isProtected() && this.getDeclaringType().isAssignableFrom(typeDescription) || !this.isPrivate() && typeDescription.getPackageName().equals(this.getDeclaringType().getPackageName());
        }

        @Override
        public boolean isOverridable() {
            return !this.isConstructor() && !this.isFinal() && !this.isPrivate() && !this.isStatic() && !this.getDeclaringType().isFinal();
        }

        @Override
        public int getParameterOffset(int parameterIndex) {
            int offset = this.isStatic() ? 0 : 1;
            int currentIndex = 0;
            for (TypeDescription parameterType : this.getParameterTypes()) {
                if (currentIndex == parameterIndex) {
                    return offset;
                }
                ++currentIndex;
                offset += parameterType.getStackSize().getSize();
            }
            throw new IllegalArgumentException(this + " does not have a parameter of index " + parameterIndex);
        }

        public boolean equals(Object other) {
            return other == this || other instanceof MethodDescription && this.getUniqueSignature().equals(((MethodDescription)other).getUniqueSignature()) && this.getDeclaringType().equals(((MethodDescription)other).getDeclaringType());
        }

        public int hashCode() {
            return (this.getDeclaringType().getInternalName() + "." + this.getUniqueSignature()).hashCode();
        }
    }
}

