/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method.bytecode.bind.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.bytecode.bind.MethodDelegationBinder;
import net.bytebuddy.instrumentation.method.bytecode.bind.annotation.RuntimeType;
import net.bytebuddy.instrumentation.method.bytecode.bind.annotation.TargetMethodAnnotationDrivenBinder;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.Assigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.collection.ArrayFactory;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodVariableAccess;
import net.bytebuddy.instrumentation.type.TypeDescription;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface AllArguments {

    public static enum Binder implements TargetMethodAnnotationDrivenBinder.ParameterBinder<AllArguments>
    {
        INSTANCE;


        @Override
        public Class<AllArguments> getHandledType() {
            return AllArguments.class;
        }

        @Override
        public MethodDelegationBinder.ParameterBinding<?> bind(AllArguments annotation, int targetParameterIndex, MethodDescription source, MethodDescription target, TypeDescription instrumentedType, Assigner assigner) {
            TypeDescription targetType = (TypeDescription)target.getParameterTypes().get(targetParameterIndex);
            if (!targetType.isArray()) {
                throw new IllegalStateException("Expected an array type for " + targetType);
            }
            ArrayFactory arrayFactory = ArrayFactory.targeting(targetType.getComponentType());
            ArrayList<StackManipulation> stackManipulations = new ArrayList<StackManipulation>(source.getParameterTypes().size());
            int offset = source.isStatic() ? 0 : 1;
            boolean considerRuntimeType = RuntimeType.Verifier.check(target, targetParameterIndex);
            for (TypeDescription sourceParameter : source.getParameterTypes()) {
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(MethodVariableAccess.forType(sourceParameter).loadFromIndex(offset), assigner.assign(sourceParameter, arrayFactory.getComponentType(), considerRuntimeType));
                if (stackManipulation.isValid()) {
                    offset += sourceParameter.getStackSize().getSize();
                    stackManipulations.add(stackManipulation);
                    continue;
                }
                return MethodDelegationBinder.ParameterBinding.Illegal.INSTANCE;
            }
            return new MethodDelegationBinder.ParameterBinding.Anonymous(arrayFactory.withValues(stackManipulations));
        }
    }
}

