/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method.bytecode.bind.annotation;

import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Iterator;
import java.util.LinkedHashSet;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.bytecode.bind.MethodDelegationBinder;
import net.bytebuddy.instrumentation.method.bytecode.bind.MostSpecificTypeResolver;
import net.bytebuddy.instrumentation.method.bytecode.bind.annotation.RuntimeType;
import net.bytebuddy.instrumentation.method.bytecode.bind.annotation.TargetMethodAnnotationDrivenBinder;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.Assigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodVariableAccess;
import net.bytebuddy.instrumentation.type.TypeDescription;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface Argument {
    public int value();

    public BindingMechanic bindingMechanic() default BindingMechanic.UNIQUE;

    public static enum NextUnboundAsDefaultsProvider implements TargetMethodAnnotationDrivenBinder.DefaultsProvider
    {
        INSTANCE;


        private static Iterator<Integer> makeFreeIndexList(MethodDescription source, MethodDescription target) {
            LinkedHashSet<Integer> results = new LinkedHashSet<Integer>(source.getParameterTypes().size());
            for (int sourceIndex = 0; sourceIndex < source.getParameterTypes().size(); ++sourceIndex) {
                results.add(sourceIndex);
            }
            Annotation[][] annotationArray = target.getParameterAnnotations();
            int n = annotationArray.length;
            block1: for (int i = 0; i < n; ++i) {
                Annotation[] parameterAnnotation;
                for (Annotation aParameterAnnotation : parameterAnnotation = annotationArray[i]) {
                    if (aParameterAnnotation.annotationType() != Argument.class) continue;
                    results.remove(((Argument)aParameterAnnotation).value());
                    continue block1;
                }
            }
            return results.iterator();
        }

        public Iterator<Argument> makeIterator(TypeDescription typeDescription, MethodDescription source, MethodDescription target) {
            return new NextUnboundArgumentIterator(NextUnboundAsDefaultsProvider.makeFreeIndexList(source, target));
        }

        private static class NextUnboundArgumentIterator
        implements Iterator<Argument> {
            private final Iterator<Integer> iterator;

            private NextUnboundArgumentIterator(Iterator<Integer> iterator) {
                this.iterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Argument next() {
                return new DefaultArgument(this.iterator.next());
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        }

        private static class DefaultArgument
        implements Argument {
            private final int parameterIndex;

            private DefaultArgument(int parameterIndex) {
                this.parameterIndex = parameterIndex;
            }

            @Override
            public int value() {
                return this.parameterIndex;
            }

            @Override
            public BindingMechanic bindingMechanic() {
                return BindingMechanic.UNIQUE;
            }

            public Class<Argument> annotationType() {
                return Argument.class;
            }
        }
    }

    public static enum Binder implements TargetMethodAnnotationDrivenBinder.ParameterBinder<Argument>
    {
        INSTANCE;


        @Override
        public Class<Argument> getHandledType() {
            return Argument.class;
        }

        @Override
        public MethodDelegationBinder.ParameterBinding<?> bind(Argument argument, int targetParameterIndex, MethodDescription source, MethodDescription target, TypeDescription instrumentedType, Assigner assigner) {
            if (argument.value() < 0) {
                throw new IllegalArgumentException(String.format("Argument annotation on %d's argument virtual %s holds negative index", targetParameterIndex, target));
            }
            if (source.getParameterTypes().size() <= argument.value()) {
                return MethodDelegationBinder.ParameterBinding.Illegal.INSTANCE;
            }
            return argument.bindingMechanic().makeBinding((TypeDescription)source.getParameterTypes().get(argument.value()), (TypeDescription)target.getParameterTypes().get(targetParameterIndex), argument.value(), assigner, RuntimeType.Verifier.check(target, targetParameterIndex), source.getParameterOffset(argument.value()));
        }
    }

    public static enum BindingMechanic {
        UNIQUE{

            @Override
            protected MethodDelegationBinder.ParameterBinding<?> makeBinding(TypeDescription sourceType, TypeDescription targetType, int sourceParameterIndex, Assigner assigner, boolean considerRuntimeType, int parameterOffset) {
                return MethodDelegationBinder.ParameterBinding.Unique.of(new StackManipulation.Compound(MethodVariableAccess.forType(sourceType).loadFromIndex(parameterOffset), assigner.assign(sourceType, targetType, considerRuntimeType)), new MostSpecificTypeResolver.ParameterIndexToken(sourceParameterIndex));
            }
        }
        ,
        ANONYMOUS{

            @Override
            protected MethodDelegationBinder.ParameterBinding<?> makeBinding(TypeDescription sourceType, TypeDescription targetType, int sourceParameterIndex, Assigner assigner, boolean considerRuntimeType, int parameterOffset) {
                return new MethodDelegationBinder.ParameterBinding.Anonymous(new StackManipulation.Compound(MethodVariableAccess.forType(sourceType).loadFromIndex(parameterOffset), assigner.assign(sourceType, targetType, considerRuntimeType)));
            }
        };


        protected abstract MethodDelegationBinder.ParameterBinding<?> makeBinding(TypeDescription var1, TypeDescription var2, int var3, Assigner var4, boolean var5, int var6);
    }
}

