/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method.bytecode.bind.annotation;

import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import net.bytebuddy.instrumentation.method.MethodDescription;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER, ElementType.METHOD})
public @interface RuntimeType {

    public static final class Verifier {
        private Verifier() {
            throw new AssertionError();
        }

        public static boolean check(MethodDescription methodDescription) {
            for (Annotation annotation : methodDescription.getAnnotations()) {
                if (annotation.annotationType() != RuntimeType.class) continue;
                return true;
            }
            return false;
        }

        public static boolean check(MethodDescription methodDescription, int parameterIndex) {
            for (Annotation annotation : methodDescription.getParameterAnnotations()[parameterIndex]) {
                if (annotation.annotationType() != RuntimeType.class) continue;
                return true;
            }
            return false;
        }
    }
}

