/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method.bytecode.bind.annotation;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.bytecode.bind.MethodDelegationBinder;
import net.bytebuddy.instrumentation.method.bytecode.bind.annotation.IgnoreForBinding;
import net.bytebuddy.instrumentation.method.bytecode.bind.annotation.RuntimeType;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.Assigner;
import net.bytebuddy.instrumentation.type.TypeDescription;

public class TargetMethodAnnotationDrivenBinder
implements MethodDelegationBinder {
    private final DelegationProcessor delegationProcessor;
    private final DefaultsProvider<?> defaultsProvider;
    private final Assigner assigner;
    private final MethodDelegationBinder.MethodInvoker methodInvoker;

    public TargetMethodAnnotationDrivenBinder(List<ParameterBinder<?>> parameterBinders, DefaultsProvider<?> defaultsProvider, Assigner assigner, MethodDelegationBinder.MethodInvoker methodInvoker) {
        this.delegationProcessor = new DelegationProcessor(parameterBinders);
        this.defaultsProvider = defaultsProvider;
        this.assigner = assigner;
        this.methodInvoker = methodInvoker;
    }

    @Override
    public MethodDelegationBinder.MethodBinding bind(TypeDescription instrumentedType, MethodDescription source, MethodDescription target) {
        if (IgnoreForBinding.Verifier.check(target)) {
            return MethodDelegationBinder.MethodBinding.Illegal.INSTANCE;
        }
        StackManipulation returningStackManipulation = this.assigner.assign(target.isConstructor() ? target.getDeclaringType() : target.getReturnType(), source.getReturnType(), RuntimeType.Verifier.check(target));
        if (!returningStackManipulation.isValid()) {
            return MethodDelegationBinder.MethodBinding.Illegal.INSTANCE;
        }
        MethodDelegationBinder.MethodBinding.Builder methodDelegationBindingBuilder = new MethodDelegationBinder.MethodBinding.Builder(this.methodInvoker, target);
        Iterator<?> defaults = this.defaultsProvider.makeIterator(instrumentedType, source, target);
        for (int targetParameterIndex = 0; targetParameterIndex < target.getParameterTypes().size(); ++targetParameterIndex) {
            MethodDelegationBinder.ParameterBinding<?> parameterBinding = this.delegationProcessor.handler(target.getParameterAnnotations()[targetParameterIndex], defaults).handle(targetParameterIndex, source, target, instrumentedType, this.assigner);
            if (parameterBinding.isValid() && methodDelegationBindingBuilder.append(parameterBinding)) continue;
            return MethodDelegationBinder.MethodBinding.Illegal.INSTANCE;
        }
        return methodDelegationBindingBuilder.build(returningStackManipulation);
    }

    private static class DelegationProcessor {
        private final Map<Class<? extends Annotation>, ParameterBinder<?>> argumentBinders;

        private DelegationProcessor(List<ParameterBinder<?>> parameterBinders) {
            HashMap argumentBinderMap = new HashMap();
            for (ParameterBinder<?> parameterBinder : parameterBinders) {
                if (argumentBinderMap.put(parameterBinder.getHandledType(), parameterBinder) == null) continue;
                throw new IllegalArgumentException("Attempt to bind two handlers to " + parameterBinder.getHandledType());
            }
            this.argumentBinders = Collections.unmodifiableMap(argumentBinderMap);
        }

        private Handler handler(Annotation[] annotation, Iterator<? extends Annotation> defaults) {
            Handler handler = null;
            for (Annotation anAnnotation : annotation) {
                ParameterBinder<?> parameterBinder = this.argumentBinders.get(anAnnotation.annotationType());
                if (parameterBinder != null && handler != null) {
                    throw new IllegalArgumentException("Ambiguous binding for parameter annotated with two handled annotation types");
                }
                if (parameterBinder == null) continue;
                handler = this.makeDelegate(parameterBinder, anAnnotation);
            }
            if (handler == null) {
                if (defaults.hasNext()) {
                    Annotation defaultAnnotation = defaults.next();
                    ParameterBinder<?> parameterBinder = this.argumentBinders.get(defaultAnnotation.annotationType());
                    if (parameterBinder == null) {
                        return Handler.Unbound.INSTANCE;
                    }
                    handler = this.makeDelegate(parameterBinder, defaultAnnotation);
                } else {
                    return Handler.Unbound.INSTANCE;
                }
            }
            return handler;
        }

        private Handler makeDelegate(ParameterBinder<?> parameterBinder, Annotation annotation) {
            return new Handler.Bound<Annotation>(parameterBinder, annotation);
        }

        private static interface Handler {
            public MethodDelegationBinder.ParameterBinding<?> handle(int var1, MethodDescription var2, MethodDescription var3, TypeDescription var4, Assigner var5);

            public static class Bound<T extends Annotation>
            implements Handler {
                private final ParameterBinder<T> parameterBinder;
                private final T annotation;

                public Bound(ParameterBinder<T> parameterBinder, T annotation) {
                    this.parameterBinder = parameterBinder;
                    this.annotation = annotation;
                }

                @Override
                public MethodDelegationBinder.ParameterBinding<?> handle(int targetParameterIndex, MethodDescription source, MethodDescription target, TypeDescription typeDescription, Assigner assigner) {
                    return this.parameterBinder.bind(this.annotation, targetParameterIndex, source, target, typeDescription, assigner);
                }
            }

            public static enum Unbound implements Handler
            {
                INSTANCE;


                @Override
                public MethodDelegationBinder.ParameterBinding<?> handle(int targetParameterIndex, MethodDescription source, MethodDescription target, TypeDescription typeDescription, Assigner assigner) {
                    return MethodDelegationBinder.ParameterBinding.Illegal.INSTANCE;
                }
            }
        }
    }

    public static interface DefaultsProvider<T extends Annotation> {
        public Iterator<T> makeIterator(TypeDescription var1, MethodDescription var2, MethodDescription var3);

        public static enum Empty implements DefaultsProvider<Annotation>
        {
            INSTANCE;


            @Override
            public Iterator<Annotation> makeIterator(TypeDescription typeDescription, MethodDescription source, MethodDescription target) {
                return EmptyIterator.INSTANCE;
            }

            private static enum EmptyIterator implements Iterator<Annotation>
            {
                INSTANCE;


                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public Annotation next() {
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new NoSuchElementException();
                }
            }
        }
    }

    public static interface ParameterBinder<T extends Annotation> {
        public Class<T> getHandledType();

        public MethodDelegationBinder.ParameterBinding<?> bind(T var1, int var2, MethodDescription var3, MethodDescription var4, TypeDescription var5, Assigner var6);
    }
}

