/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method.bytecode.stack.assign.primitive;

import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackSize;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.Assigner;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.jar.asm.MethodVisitor;

public enum PrimitiveBoxingDelegate {
    BOOLEAN("java/lang/Boolean", StackSize.ZERO, Boolean.class, "valueOf", "(Z)Ljava/lang/Boolean;"),
    BYTE("java/lang/Byte", StackSize.ZERO, Byte.class, "valueOf", "(B)Ljava/lang/Byte;"),
    SHORT("java/lang/Short", StackSize.ZERO, Short.class, "valueOf", "(S)Ljava/lang/Short;"),
    CHARACTER("java/lang/Character", StackSize.ZERO, Character.class, "valueOf", "(C)Ljava/lang/Character;"),
    INTEGER("java/lang/Integer", StackSize.ZERO, Integer.class, "valueOf", "(I)Ljava/lang/Integer;"),
    LONG("java/lang/Long", StackSize.SINGLE, Long.class, "valueOf", "(J)Ljava/lang/Long;"),
    FLOAT("java/lang/Float", StackSize.ZERO, Float.class, "valueOf", "(F)Ljava/lang/Float;"),
    DOUBLE("java/lang/Double", StackSize.SINGLE, Double.class, "valueOf", "(D)Ljava/lang/Double;");

    private final String wrapperTypeName;
    private final StackManipulation.Size size;
    private final TypeDescription wrapperType;
    private final String boxingMethodName;
    private final String boxingMethodDescriptor;

    private PrimitiveBoxingDelegate(String wrapperTypeName, StackSize sizeDecrease, Class<?> wrapperType, String boxingMethodName, String boxingMethodDescriptor) {
        this.wrapperTypeName = wrapperTypeName;
        this.size = sizeDecrease.toDecreasingSize();
        this.wrapperType = new TypeDescription.ForLoadedType(wrapperType);
        this.boxingMethodName = boxingMethodName;
        this.boxingMethodDescriptor = boxingMethodDescriptor;
    }

    public static PrimitiveBoxingDelegate forPrimitive(TypeDescription typeDescription) {
        if (typeDescription.represents(Boolean.TYPE)) {
            return BOOLEAN;
        }
        if (typeDescription.represents(Byte.TYPE)) {
            return BYTE;
        }
        if (typeDescription.represents(Short.TYPE)) {
            return SHORT;
        }
        if (typeDescription.represents(Character.TYPE)) {
            return CHARACTER;
        }
        if (typeDescription.represents(Integer.TYPE)) {
            return INTEGER;
        }
        if (typeDescription.represents(Long.TYPE)) {
            return LONG;
        }
        if (typeDescription.represents(Float.TYPE)) {
            return FLOAT;
        }
        if (typeDescription.represents(Double.TYPE)) {
            return DOUBLE;
        }
        throw new IllegalArgumentException("Not a non-void, primitive type: " + typeDescription);
    }

    public StackManipulation assignBoxedTo(TypeDescription targetType, Assigner chainedAssigner, boolean considerRuntimeType) {
        return new BoxingStackManipulation(chainedAssigner.assign(this.wrapperType, targetType, considerRuntimeType));
    }

    private class BoxingStackManipulation
    implements StackManipulation {
        private final StackManipulation stackManipulation;

        public BoxingStackManipulation(StackManipulation stackManipulation) {
            this.stackManipulation = stackManipulation;
        }

        @Override
        public boolean isValid() {
            return this.stackManipulation.isValid();
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext) {
            methodVisitor.visitMethodInsn(184, PrimitiveBoxingDelegate.this.wrapperTypeName, PrimitiveBoxingDelegate.this.boxingMethodName, PrimitiveBoxingDelegate.this.boxingMethodDescriptor);
            return PrimitiveBoxingDelegate.this.size.aggregate(this.stackManipulation.apply(methodVisitor, instrumentationContext));
        }
    }
}

