/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method.bytecode.stack.assign.primitive;

import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackSize;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.Assigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.primitive.PrimitiveWideningDelegate;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.jar.asm.MethodVisitor;

public enum PrimitiveUnboxingDelegate implements StackManipulation
{
    BOOLEAN("java/lang/Boolean", StackSize.ZERO, Boolean.class, Boolean.TYPE, "booleanValue", "()Z"),
    BYTE("java/lang/Byte", StackSize.ZERO, Byte.class, Byte.TYPE, "byteValue", "()B"),
    SHORT("java/lang/Short", StackSize.ZERO, Short.class, Short.TYPE, "shortValue", "()S"),
    CHARACTER("java/lang/Character", StackSize.ZERO, Character.class, Character.TYPE, "charValue", "()C"),
    INTEGER("java/lang/Integer", StackSize.ZERO, Integer.class, Integer.TYPE, "intValue", "()I"),
    LONG("java/lang/Long", StackSize.SINGLE, Long.class, Long.TYPE, "longValue", "()J"),
    FLOAT("java/lang/Float", StackSize.ZERO, Float.class, Float.TYPE, "floatValue", "()F"),
    DOUBLE("java/lang/Double", StackSize.SINGLE, Double.class, Double.TYPE, "doubleValue", "()D");

    private final String wrapperTypeName;
    private final StackManipulation.Size size;
    private final TypeDescription wrapperType;
    private final TypeDescription primitiveType;
    private final String unboxingMethodName;
    private final String unboxingMethodDescriptor;

    private PrimitiveUnboxingDelegate(String wrapperTypeName, StackSize sizeIncrease, Class<?> wrapperType, Class<?> primitiveType, String unboxingMethodName, String unboxingMethodDescriptor) {
        this.wrapperTypeName = wrapperTypeName;
        this.size = sizeIncrease.toIncreasingSize();
        this.wrapperType = new TypeDescription.ForLoadedType(wrapperType);
        this.primitiveType = new TypeDescription.ForLoadedType(primitiveType);
        this.unboxingMethodName = unboxingMethodName;
        this.unboxingMethodDescriptor = unboxingMethodDescriptor;
    }

    private static PrimitiveUnboxingDelegate forPrimitive(TypeDescription typeDescription) {
        if (typeDescription.represents(Boolean.TYPE)) {
            return BOOLEAN;
        }
        if (typeDescription.represents(Byte.TYPE)) {
            return BYTE;
        }
        if (typeDescription.represents(Short.TYPE)) {
            return SHORT;
        }
        if (typeDescription.represents(Character.TYPE)) {
            return CHARACTER;
        }
        if (typeDescription.represents(Integer.TYPE)) {
            return INTEGER;
        }
        if (typeDescription.represents(Long.TYPE)) {
            return LONG;
        }
        if (typeDescription.represents(Float.TYPE)) {
            return FLOAT;
        }
        if (typeDescription.represents(Double.TYPE)) {
            return DOUBLE;
        }
        throw new IllegalArgumentException("Expected non-void primitive type instead of " + typeDescription);
    }

    public static UnboxingResponsible forReferenceType(TypeDescription typeDescription) {
        if (typeDescription.isPrimitive()) {
            throw new IllegalArgumentException("Expected reference type instead of " + typeDescription);
        }
        if (typeDescription.represents(Boolean.class)) {
            return ExplicitlyTypedUnboxingResponsible.BOOLEAN;
        }
        if (typeDescription.represents(Byte.class)) {
            return ExplicitlyTypedUnboxingResponsible.BYTE;
        }
        if (typeDescription.represents(Short.class)) {
            return ExplicitlyTypedUnboxingResponsible.SHORT;
        }
        if (typeDescription.represents(Character.class)) {
            return ExplicitlyTypedUnboxingResponsible.CHARACTER;
        }
        if (typeDescription.represents(Integer.class)) {
            return ExplicitlyTypedUnboxingResponsible.INTEGER;
        }
        if (typeDescription.represents(Long.class)) {
            return ExplicitlyTypedUnboxingResponsible.LONG;
        }
        if (typeDescription.represents(Float.class)) {
            return ExplicitlyTypedUnboxingResponsible.FLOAT;
        }
        if (typeDescription.represents(Double.class)) {
            return ExplicitlyTypedUnboxingResponsible.DOUBLE;
        }
        return new ImplicitlyTypedUnboxingResponsible(typeDescription);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext) {
        methodVisitor.visitMethodInsn(182, this.wrapperTypeName, this.unboxingMethodName, this.unboxingMethodDescriptor);
        return this.size;
    }

    private static class ImplicitlyTypedUnboxingResponsible
    implements UnboxingResponsible {
        private final TypeDescription originalType;

        private ImplicitlyTypedUnboxingResponsible(TypeDescription originalType) {
            this.originalType = originalType;
        }

        @Override
        public StackManipulation assignUnboxedTo(TypeDescription targetType, Assigner assigner, boolean considerRuntimeType) {
            PrimitiveUnboxingDelegate primitiveUnboxingDelegate = PrimitiveUnboxingDelegate.forPrimitive(targetType);
            return new StackManipulation.Compound(assigner.assign(this.originalType, primitiveUnboxingDelegate.wrapperType, considerRuntimeType), primitiveUnboxingDelegate);
        }
    }

    public static interface UnboxingResponsible {
        public StackManipulation assignUnboxedTo(TypeDescription var1, Assigner var2, boolean var3);
    }

    private static enum ExplicitlyTypedUnboxingResponsible implements UnboxingResponsible
    {
        BOOLEAN(BOOLEAN),
        BYTE(BYTE),
        SHORT(SHORT),
        CHARACTER(CHARACTER),
        INTEGER(INTEGER),
        LONG(LONG),
        FLOAT(FLOAT),
        DOUBLE(DOUBLE);

        private final PrimitiveUnboxingDelegate primitiveUnboxingDelegate;

        private ExplicitlyTypedUnboxingResponsible(PrimitiveUnboxingDelegate primitiveUnboxingDelegate) {
            this.primitiveUnboxingDelegate = primitiveUnboxingDelegate;
        }

        @Override
        public StackManipulation assignUnboxedTo(TypeDescription targetType, Assigner assigner, boolean considerRuntimeType) {
            return new StackManipulation.Compound(this.primitiveUnboxingDelegate, PrimitiveWideningDelegate.forPrimitive(this.primitiveUnboxingDelegate.primitiveType).widenTo(targetType));
        }
    }
}

