/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method.bytecode.stack.assign.primitive;

import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.method.bytecode.stack.IllegalStackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.LegalTrivialStackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackSize;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.jar.asm.MethodVisitor;

public enum PrimitiveWideningDelegate {
    BOOLEAN(LegalTrivialStackManipulation.INSTANCE, IllegalStackManipulation.INSTANCE, IllegalStackManipulation.INSTANCE, IllegalStackManipulation.INSTANCE, IllegalStackManipulation.INSTANCE, IllegalStackManipulation.INSTANCE, IllegalStackManipulation.INSTANCE, IllegalStackManipulation.INSTANCE),
    BYTE(IllegalStackManipulation.INSTANCE, LegalTrivialStackManipulation.INSTANCE, LegalTrivialStackManipulation.INSTANCE, IllegalStackManipulation.INSTANCE, LegalTrivialStackManipulation.INSTANCE, new WideningStackManipulation(133, StackSize.SINGLE.toIncreasingSize()), new WideningStackManipulation(134, StackSize.ZERO.toIncreasingSize()), new WideningStackManipulation(133, StackSize.SINGLE.toIncreasingSize())),
    SHORT(IllegalStackManipulation.INSTANCE, IllegalStackManipulation.INSTANCE, LegalTrivialStackManipulation.INSTANCE, IllegalStackManipulation.INSTANCE, LegalTrivialStackManipulation.INSTANCE, new WideningStackManipulation(133, StackSize.SINGLE.toIncreasingSize()), new WideningStackManipulation(134, StackSize.ZERO.toIncreasingSize()), new WideningStackManipulation(135, StackSize.SINGLE.toIncreasingSize())),
    CHARACTER(IllegalStackManipulation.INSTANCE, IllegalStackManipulation.INSTANCE, IllegalStackManipulation.INSTANCE, LegalTrivialStackManipulation.INSTANCE, LegalTrivialStackManipulation.INSTANCE, new WideningStackManipulation(133, StackSize.SINGLE.toIncreasingSize()), new WideningStackManipulation(134, StackSize.ZERO.toIncreasingSize()), new WideningStackManipulation(135, StackSize.SINGLE.toIncreasingSize())),
    INTEGER(IllegalStackManipulation.INSTANCE, IllegalStackManipulation.INSTANCE, IllegalStackManipulation.INSTANCE, IllegalStackManipulation.INSTANCE, LegalTrivialStackManipulation.INSTANCE, new WideningStackManipulation(133, StackSize.SINGLE.toIncreasingSize()), new WideningStackManipulation(134, StackSize.ZERO.toIncreasingSize()), new WideningStackManipulation(135, StackSize.SINGLE.toIncreasingSize())),
    LONG(IllegalStackManipulation.INSTANCE, IllegalStackManipulation.INSTANCE, IllegalStackManipulation.INSTANCE, IllegalStackManipulation.INSTANCE, IllegalStackManipulation.INSTANCE, LegalTrivialStackManipulation.INSTANCE, new WideningStackManipulation(137, StackSize.SINGLE.toDecreasingSize()), new WideningStackManipulation(138, StackSize.ZERO.toIncreasingSize())),
    FLOAT(IllegalStackManipulation.INSTANCE, IllegalStackManipulation.INSTANCE, IllegalStackManipulation.INSTANCE, IllegalStackManipulation.INSTANCE, IllegalStackManipulation.INSTANCE, IllegalStackManipulation.INSTANCE, LegalTrivialStackManipulation.INSTANCE, new WideningStackManipulation(141, StackSize.SINGLE.toIncreasingSize())),
    DOUBLE(IllegalStackManipulation.INSTANCE, IllegalStackManipulation.INSTANCE, IllegalStackManipulation.INSTANCE, IllegalStackManipulation.INSTANCE, IllegalStackManipulation.INSTANCE, IllegalStackManipulation.INSTANCE, IllegalStackManipulation.INSTANCE, LegalTrivialStackManipulation.INSTANCE);

    private final StackManipulation toBooleanStackManipulation;
    private final StackManipulation toByteStackManipulation;
    private final StackManipulation toShortStackManipulation;
    private final StackManipulation toCharacterStackManipulation;
    private final StackManipulation toIntegerStackManipulation;
    private final StackManipulation toLongStackManipulation;
    private final StackManipulation toFloatStackManipulation;
    private final StackManipulation toDoubleStackManipulation;

    private PrimitiveWideningDelegate(StackManipulation toBooleanStackManipulation, StackManipulation toByteStackManipulation, StackManipulation toShortStackManipulation, StackManipulation toCharacterStackManipulation, StackManipulation toIntegerStackManipulation, StackManipulation toLongStackManipulation, StackManipulation toFloatStackManipulation, StackManipulation toDoubleStackManipulation) {
        this.toBooleanStackManipulation = toBooleanStackManipulation;
        this.toByteStackManipulation = toByteStackManipulation;
        this.toShortStackManipulation = toShortStackManipulation;
        this.toCharacterStackManipulation = toCharacterStackManipulation;
        this.toIntegerStackManipulation = toIntegerStackManipulation;
        this.toLongStackManipulation = toLongStackManipulation;
        this.toFloatStackManipulation = toFloatStackManipulation;
        this.toDoubleStackManipulation = toDoubleStackManipulation;
    }

    public static PrimitiveWideningDelegate forPrimitive(TypeDescription typeDescription) {
        if (typeDescription.represents(Boolean.TYPE)) {
            return BOOLEAN;
        }
        if (typeDescription.represents(Byte.TYPE)) {
            return BYTE;
        }
        if (typeDescription.represents(Short.TYPE)) {
            return SHORT;
        }
        if (typeDescription.represents(Character.TYPE)) {
            return CHARACTER;
        }
        if (typeDescription.represents(Integer.TYPE)) {
            return INTEGER;
        }
        if (typeDescription.represents(Long.TYPE)) {
            return LONG;
        }
        if (typeDescription.represents(Float.TYPE)) {
            return FLOAT;
        }
        if (typeDescription.represents(Double.TYPE)) {
            return DOUBLE;
        }
        throw new IllegalArgumentException("Not a primitive, non-void type: " + typeDescription);
    }

    public StackManipulation widenTo(TypeDescription typeDescription) {
        if (typeDescription.represents(Boolean.TYPE)) {
            return this.toBooleanStackManipulation;
        }
        if (typeDescription.represents(Byte.TYPE)) {
            return this.toByteStackManipulation;
        }
        if (typeDescription.represents(Short.TYPE)) {
            return this.toShortStackManipulation;
        }
        if (typeDescription.represents(Character.TYPE)) {
            return this.toCharacterStackManipulation;
        }
        if (typeDescription.represents(Integer.TYPE)) {
            return this.toIntegerStackManipulation;
        }
        if (typeDescription.represents(Long.TYPE)) {
            return this.toLongStackManipulation;
        }
        if (typeDescription.represents(Float.TYPE)) {
            return this.toFloatStackManipulation;
        }
        if (typeDescription.represents(Double.TYPE)) {
            return this.toDoubleStackManipulation;
        }
        throw new IllegalArgumentException("Not a primitive non-void type: " + typeDescription);
    }

    private static class WideningStackManipulation
    implements StackManipulation {
        private final int conversionInstruction;
        private final StackManipulation.Size size;

        public WideningStackManipulation(int conversionInstruction, StackManipulation.Size size) {
            this.conversionInstruction = conversionInstruction;
            this.size = size;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext) {
            methodVisitor.visitInsn(this.conversionInstruction);
            return this.size;
        }
    }
}

