/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method.bytecode.stack.assign.reference;

import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.method.bytecode.stack.IllegalStackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.LegalTrivialStackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackSize;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.Assigner;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.jar.asm.MethodVisitor;

public enum ReferenceTypeAwareAssigner implements Assigner
{
    INSTANCE;


    @Override
    public StackManipulation assign(TypeDescription sourceType, TypeDescription targetType, boolean considerRuntimeType) {
        if (sourceType.isPrimitive() || targetType.isPrimitive()) {
            if (sourceType.equals(targetType)) {
                return LegalTrivialStackManipulation.INSTANCE;
            }
            return IllegalStackManipulation.INSTANCE;
        }
        if (targetType.isAssignableFrom(sourceType)) {
            return LegalTrivialStackManipulation.INSTANCE;
        }
        if (considerRuntimeType) {
            return new DownCastStackManipulation(targetType);
        }
        return IllegalStackManipulation.INSTANCE;
    }

    private static class DownCastStackManipulation
    implements StackManipulation {
        private final String targetTypeInternalName;

        private DownCastStackManipulation(TypeDescription targetType) {
            this.targetTypeInternalName = targetType.getInternalName();
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext) {
            methodVisitor.visitTypeInsn(192, this.targetTypeInternalName);
            return StackSize.ZERO.toIncreasingSize();
        }
    }
}

