/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method.bytecode.stack.constant;

import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackSize;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.jar.asm.Type;

public class ClassConstant
implements StackManipulation {
    private final TypeDescription typeDescription;

    public ClassConstant(TypeDescription typeDescription) {
        this.typeDescription = typeDescription;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext) {
        methodVisitor.visitLdcInsn(Type.getType(this.typeDescription.getDescriptor()));
        return StackSize.SINGLE.toIncreasingSize();
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.typeDescription.equals(((ClassConstant)other).typeDescription);
    }

    public int hashCode() {
        return this.typeDescription.hashCode();
    }

    public String toString() {
        return "ClassConstant{typeDescription=" + this.typeDescription + '}';
    }
}

