/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method.bytecode.stack.member;

import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.jar.asm.MethodVisitor;

public enum MethodInvocation {
    VIRTUAL(182),
    INTERFACE(185),
    STATIC(184),
    SPECIAL(183);

    private final int invocationOpcode;

    private MethodInvocation(int callOpcode) {
        this.invocationOpcode = callOpcode;
    }

    public static WithImplicitInvocationTargetType invoke(MethodDescription methodDescription) {
        if (methodDescription.isStatic()) {
            MethodInvocation methodInvocation = STATIC;
            ((Object)((Object)methodInvocation)).getClass();
            return methodInvocation.new Invocation(methodDescription);
        }
        if (methodDescription.isPrivate() || methodDescription.isConstructor()) {
            MethodInvocation methodInvocation = SPECIAL;
            ((Object)((Object)methodInvocation)).getClass();
            return methodInvocation.new Invocation(methodDescription);
        }
        if (methodDescription.getDeclaringType().isInterface()) {
            MethodInvocation methodInvocation = INTERFACE;
            ((Object)((Object)methodInvocation)).getClass();
            return methodInvocation.new Invocation(methodDescription);
        }
        MethodInvocation methodInvocation = VIRTUAL;
        ((Object)((Object)methodInvocation)).getClass();
        return methodInvocation.new Invocation(methodDescription);
    }

    private class Invocation
    implements WithImplicitInvocationTargetType {
        private final TypeDescription typeDescription;
        private final MethodDescription methodDescription;
        private final StackManipulation.Size size;

        private Invocation(MethodDescription methodDescription) {
            this(methodDescription, methodDescription.getDeclaringType());
        }

        private Invocation(MethodDescription methodDescription, TypeDescription typeDescription) {
            this.typeDescription = typeDescription;
            this.methodDescription = methodDescription;
            int parameterSize = methodDescription.getStackSize();
            int returnValueSize = methodDescription.getReturnType().getStackSize().getSize();
            this.size = new StackManipulation.Size(returnValueSize - parameterSize, Math.max(0, returnValueSize - parameterSize));
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext) {
            methodVisitor.visitMethodInsn(MethodInvocation.this.invocationOpcode, this.typeDescription.getInternalName(), this.methodDescription.getInternalName(), this.methodDescription.getDescriptor());
            return this.size;
        }

        @Override
        public StackManipulation virtual(TypeDescription invocationTarget) {
            this.validateNonStaticAndTypeCompatibleCall(invocationTarget);
            if (this.methodDescription.isPrivate() || this.methodDescription.isConstructor()) {
                throw new IllegalArgumentException("Cannot invoke " + this.methodDescription + " virtually");
            }
            if (invocationTarget.isInterface()) {
                MethodInvocation methodInvocation = INTERFACE;
                ((Object)((Object)methodInvocation)).getClass();
                return methodInvocation.new Invocation(this.methodDescription, invocationTarget);
            }
            MethodInvocation methodInvocation = VIRTUAL;
            ((Object)((Object)methodInvocation)).getClass();
            return methodInvocation.new Invocation(this.methodDescription, invocationTarget);
        }

        @Override
        public StackManipulation special(TypeDescription invocationTarget) {
            this.validateNonStaticAndTypeCompatibleCall(invocationTarget);
            if (this.methodDescription.isAbstract()) {
                throw new IllegalStateException("Cannot call INVOKESPECIAL on abstract method " + this.methodDescription);
            }
            if (this.methodDescription.isPrivate() || this.methodDescription.isConstructor()) {
                if (this.typeDescription.equals(invocationTarget)) {
                    return this;
                }
                throw new IllegalArgumentException("Cannot apply special invocation for " + this.methodDescription + " on " + invocationTarget);
            }
            MethodInvocation methodInvocation = SPECIAL;
            ((Object)((Object)methodInvocation)).getClass();
            return methodInvocation.new Invocation(this.methodDescription, invocationTarget);
        }

        private void validateNonStaticAndTypeCompatibleCall(TypeDescription typeDescription) {
            if (this.methodDescription.isStatic()) {
                throw new IllegalStateException("Method " + this.methodDescription + " is bound to " + this.typeDescription);
            }
            if (!this.typeDescription.isAssignableFrom(typeDescription)) {
                throw new IllegalArgumentException("Method " + this.methodDescription + " cannot be called on " + typeDescription);
            }
        }

        @Override
        public MethodInvocation getImplicitInvocationType() {
            return MethodInvocation.this;
        }
    }

    public static interface WithImplicitInvocationTargetType
    extends StackManipulation {
        public StackManipulation virtual(TypeDescription var1);

        public StackManipulation special(TypeDescription var1);

        public MethodInvocation getImplicitInvocationType();
    }
}

