/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method.matcher;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.bytecode.bind.annotation.RuntimeType;
import net.bytebuddy.instrumentation.method.matcher.JunctionMethodMatcher;
import net.bytebuddy.instrumentation.method.matcher.MethodMatcher;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.instrumentation.type.TypeList;

public final class MethodMatchers {
    private MethodMatchers() {
        throw new AssertionError();
    }

    public static JunctionMethodMatcher named(String name) {
        return new MethodNameMethodMatcher(name, MatchMode.EQUALS_FULLY);
    }

    public static JunctionMethodMatcher namedIgnoreCase(String name) {
        return new MethodNameMethodMatcher(name, MatchMode.EQUALS_FULLY_IGNORE_CASE);
    }

    public static JunctionMethodMatcher nameStartsWith(String prefix) {
        return new MethodNameMethodMatcher(prefix, MatchMode.STARTS_WITH);
    }

    public static JunctionMethodMatcher nameStartsWithIgnoreCase(String prefix) {
        return new MethodNameMethodMatcher(prefix, MatchMode.STARTS_WITH_IGNORE_CASE);
    }

    public static JunctionMethodMatcher nameEndsWith(String suffix) {
        return new MethodNameMethodMatcher(suffix, MatchMode.ENDS_WITH);
    }

    public static JunctionMethodMatcher nameEndsWithIgnoreCase(String suffix) {
        return new MethodNameMethodMatcher(suffix, MatchMode.ENDS_WITH_IGNORE_CASE);
    }

    public static JunctionMethodMatcher nameContains(String infix) {
        return new MethodNameMethodMatcher(infix, MatchMode.CONTAINS);
    }

    public static JunctionMethodMatcher nameContainsIgnoreCase(String infix) {
        return new MethodNameMethodMatcher(infix, MatchMode.CONTAINS_IGNORE_CASE);
    }

    public static JunctionMethodMatcher nameMatches(String regex) {
        return new MethodNameMethodMatcher(regex, MatchMode.MATCHES);
    }

    public static JunctionMethodMatcher isPublic() {
        return new ModifierMethodMatcher(1);
    }

    public static JunctionMethodMatcher isProtected() {
        return new ModifierMethodMatcher(4);
    }

    public static JunctionMethodMatcher isPackagePrivate() {
        return MethodMatchers.not(MethodMatchers.isPublic().or(MethodMatchers.isProtected()).or(MethodMatchers.isPrivate()));
    }

    public static JunctionMethodMatcher isPrivate() {
        return new ModifierMethodMatcher(2);
    }

    public static JunctionMethodMatcher isFinal() {
        return new ModifierMethodMatcher(16);
    }

    public static JunctionMethodMatcher isStatic() {
        return new ModifierMethodMatcher(8);
    }

    public static JunctionMethodMatcher isSynchronized() {
        return new ModifierMethodMatcher(32);
    }

    public static JunctionMethodMatcher isNative() {
        return new ModifierMethodMatcher(256);
    }

    public static JunctionMethodMatcher isStrict() {
        return new ModifierMethodMatcher(2048);
    }

    public static JunctionMethodMatcher isVarArgs() {
        return new ModifierMethodMatcher(128);
    }

    public static JunctionMethodMatcher isSynthetic() {
        return new ModifierMethodMatcher(4096);
    }

    public static JunctionMethodMatcher isBridge() {
        return new ModifierMethodMatcher(64);
    }

    public static JunctionMethodMatcher returns(Class<?> type) {
        return new ReturnTypeMatcher(new TypeDescription.ForLoadedType(type));
    }

    public static JunctionMethodMatcher returns(TypeDescription type) {
        return new ReturnTypeMatcher(type);
    }

    public static JunctionMethodMatcher returnsSubtypeOf(Class<?> type) {
        return MethodMatchers.returnsSubtypeOf(new TypeDescription.ForLoadedType(type));
    }

    public static JunctionMethodMatcher returnsSubtypeOf(TypeDescription type) {
        return new ReturnSubtypeMatcher(type);
    }

    public static JunctionMethodMatcher returnsSupertypeOf(Class<?> type) {
        return MethodMatchers.returnsSupertypeOf(new TypeDescription.ForLoadedType(type));
    }

    public static JunctionMethodMatcher returnsSupertypeOf(TypeDescription type) {
        return new ReturnSupertypeMatcher(type);
    }

    public static JunctionMethodMatcher takesArguments(Class<?> ... types) {
        return MethodMatchers.takesArguments(new TypeList.ForLoadedType(types));
    }

    public static JunctionMethodMatcher takesArguments(TypeDescription ... types) {
        return MethodMatchers.takesArguments(Arrays.asList(types));
    }

    public static JunctionMethodMatcher takesArguments(List<? extends TypeDescription> types) {
        return new ParameterTypeMatcher(types);
    }

    public static JunctionMethodMatcher takesArguments(int number) {
        return new ParameterCountMatcher(number);
    }

    public static JunctionMethodMatcher takesArgumentsAsSubtypesOf(Class<?> ... types) {
        return MethodMatchers.takesArgumentsAsSubtypesOf(new TypeList.ForLoadedType(types));
    }

    public static JunctionMethodMatcher takesArgumentsAsSubtypesOf(TypeDescription ... types) {
        return MethodMatchers.takesArgumentsAsSubtypesOf(Arrays.asList(types));
    }

    public static JunctionMethodMatcher takesArgumentsAsSubtypesOf(List<? extends TypeDescription> types) {
        return new ParameterSubtypeMatcher(types);
    }

    public static JunctionMethodMatcher takesArgumentsAsSuperTypesOf(Class<?> ... types) {
        return MethodMatchers.takesArgumentsAsSuperTypesOf(new TypeList.ForLoadedType(types));
    }

    public static JunctionMethodMatcher takesArgumentsAsSuperTypesOf(TypeDescription ... types) {
        return MethodMatchers.takesArgumentsAsSuperTypesOf(Arrays.asList(types));
    }

    public static JunctionMethodMatcher takesArgumentsAsSuperTypesOf(List<? extends TypeDescription> types) {
        return new ParameterSuperTypeMatcher(types);
    }

    public static JunctionMethodMatcher canThrow(Class<? extends Throwable> exceptionType) {
        if (RuntimeException.class.isAssignableFrom(exceptionType) || Error.class.isAssignableFrom(exceptionType)) {
            return new BooleanMethodMatcher(true);
        }
        return new ExceptionMethodMatcher(new TypeDescription.ForLoadedType(exceptionType));
    }

    public static JunctionMethodMatcher canThrow(TypeDescription exceptionType) {
        if (exceptionType.isAssignableTo(Throwable.class)) {
            if (exceptionType.isAssignableTo(RuntimeType.class) || exceptionType.isAssignableTo(Error.class)) {
                return new BooleanMethodMatcher(true);
            }
            return new ExceptionMethodMatcher(exceptionType);
        }
        throw new IllegalArgumentException(exceptionType + " is not an exception type");
    }

    public static JunctionMethodMatcher is(Method method) {
        return new MethodEqualityMethodMatcher(method);
    }

    public static JunctionMethodMatcher is(Constructor<?> constructor) {
        return new ConstructorEqualityMethodMatcher(constructor);
    }

    public static JunctionMethodMatcher is(MethodDescription methodDescription) {
        return new MethodDescriptionMatcher(methodDescription);
    }

    public static JunctionMethodMatcher isMethod() {
        return new IsMethodMethodMatcher();
    }

    public static JunctionMethodMatcher isConstructor() {
        return MethodMatchers.not(MethodMatchers.isMethod());
    }

    public static JunctionMethodMatcher isVisibleTo(Class<?> typeDescription) {
        return MethodMatchers.isVisibleTo(new TypeDescription.ForLoadedType(typeDescription));
    }

    public static JunctionMethodMatcher isVisibleTo(TypeDescription typeDescription) {
        return new VisibilityMethodMatcher(typeDescription);
    }

    public static JunctionMethodMatcher isDeclaredBy(TypeDescription type) {
        return new DeclaringTypeMethodMatcher(type);
    }

    public static JunctionMethodMatcher isDeclaredBy(Class<?> type) {
        return new DeclaringTypeMethodMatcher(type);
    }

    public static JunctionMethodMatcher isSetter() {
        return MethodMatchers.takesArguments(1).and(MethodMatchers.nameStartsWith("set")).and(MethodMatchers.returns(Void.TYPE));
    }

    public static JunctionMethodMatcher isSetter(Class<?> type) {
        return MethodMatchers.isSetter(new TypeDescription.ForLoadedType(type));
    }

    public static JunctionMethodMatcher isSetter(TypeDescription type) {
        return MethodMatchers.isSetter().and(MethodMatchers.takesArguments(type));
    }

    public static JunctionMethodMatcher isGetter() {
        return MethodMatchers.takesArguments(0).and(MethodMatchers.not(MethodMatchers.returns(Void.TYPE))).and(MethodMatchers.nameStartsWith("get").or(MethodMatchers.nameStartsWith("is").and(MethodMatchers.returns(Boolean.TYPE).or(MethodMatchers.returns(Boolean.class)))));
    }

    public static JunctionMethodMatcher isGetter(Class<?> type) {
        return MethodMatchers.isGetter(new TypeDescription.ForLoadedType(type));
    }

    public static JunctionMethodMatcher isGetter(TypeDescription type) {
        return MethodMatchers.isGetter().and(MethodMatchers.returns(type));
    }

    public static JunctionMethodMatcher hasSameByteCodeSignatureAs(Method method) {
        return MethodMatchers.hasSameByteCodeSignatureAs(new MethodDescription.ForLoadedMethod(method));
    }

    public static JunctionMethodMatcher hasSameByteCodeSignatureAs(Constructor<?> constructor) {
        return MethodMatchers.hasSameByteCodeSignatureAs(new MethodDescription.ForLoadedConstructor(constructor));
    }

    public static JunctionMethodMatcher hasSameByteCodeSignatureAs(MethodDescription methodDescription) {
        return new MethodSignatureMethodMatcher(methodDescription);
    }

    public static JunctionMethodMatcher hasSameJavaCompilerSignatureAs(Method method) {
        return MethodMatchers.hasSameJavaCompilerSignatureAs(new MethodDescription.ForLoadedMethod(method));
    }

    public static JunctionMethodMatcher hasSameJavaCompilerSignatureAs(Constructor<?> constructor) {
        return MethodMatchers.hasSameJavaCompilerSignatureAs(new MethodDescription.ForLoadedConstructor(constructor));
    }

    public static JunctionMethodMatcher hasSameJavaCompilerSignatureAs(MethodDescription methodDescription) {
        return (methodDescription.isConstructor() ? MethodMatchers.isConstructor() : MethodMatchers.named(methodDescription.getName())).and(MethodMatchers.takesArguments(methodDescription.getParameterTypes()));
    }

    public static JunctionMethodMatcher isBridgeMethodCompatibleTo(Method method) {
        return MethodMatchers.isBridgeMethodCompatibleTo(new MethodDescription.ForLoadedMethod(method));
    }

    public static JunctionMethodMatcher isAnnotatedBy(Class<? extends Annotation> annotationType) {
        return new AnnotationMethodMatcher(annotationType);
    }

    public static JunctionMethodMatcher isBridgeMethodCompatibleTo(MethodDescription methodDescription) {
        return (methodDescription.isConstructor() ? MethodMatchers.isConstructor() : MethodMatchers.named(methodDescription.getName())).and(MethodMatchers.returnsSubtypeOf(methodDescription.getReturnType())).and(MethodMatchers.takesArgumentsAsSubtypesOf(methodDescription.getParameterTypes()));
    }

    public static JunctionMethodMatcher isOverridable() {
        return new OverridableMethodMatcher();
    }

    public static JunctionMethodMatcher isDefaultFinalizer() {
        return new DefaultFinalizeMethodMatcher();
    }

    public static JunctionMethodMatcher isFinalizer() {
        return MethodMatchers.named("finalize").and(MethodMatchers.takesArguments(0)).and(MethodMatchers.returns(Void.TYPE));
    }

    public static JunctionMethodMatcher not(MethodMatcher methodMatcher) {
        return new NegatingMethodMatcher(methodMatcher);
    }

    public static JunctionMethodMatcher any() {
        return new BooleanMethodMatcher(true);
    }

    public static JunctionMethodMatcher none() {
        return new BooleanMethodMatcher(false);
    }

    private static class NegatingMethodMatcher
    extends JunctionMethodMatcher.AbstractBase {
        private final MethodMatcher methodMatcher;

        public NegatingMethodMatcher(MethodMatcher methodMatcher) {
            this.methodMatcher = methodMatcher;
        }

        @Override
        public boolean matches(MethodDescription methodDescription) {
            return !this.methodMatcher.matches(methodDescription);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.methodMatcher.equals(((NegatingMethodMatcher)other).methodMatcher);
        }

        public int hashCode() {
            return this.methodMatcher.hashCode();
        }

        public String toString() {
            return "not(" + this.methodMatcher + ')';
        }
    }

    private static class BooleanMethodMatcher
    extends JunctionMethodMatcher.AbstractBase {
        private final boolean matches;

        private BooleanMethodMatcher(boolean matches) {
            this.matches = matches;
        }

        @Override
        public boolean matches(MethodDescription methodDescription) {
            return this.matches;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.matches == ((BooleanMethodMatcher)other).matches;
        }

        public int hashCode() {
            return this.matches ? 1 : 0;
        }

        public String toString() {
            return Boolean.toString(this.matches);
        }
    }

    private static class AnnotationMethodMatcher
    extends JunctionMethodMatcher.AbstractBase {
        private final Class<? extends Annotation> annotationType;

        private AnnotationMethodMatcher(Class<? extends Annotation> annotationType) {
            this.annotationType = annotationType;
        }

        @Override
        public boolean matches(MethodDescription methodDescription) {
            return methodDescription.isAnnotationPresent(this.annotationType);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.annotationType.equals(((AnnotationMethodMatcher)other).annotationType);
        }

        public int hashCode() {
            return this.annotationType.hashCode();
        }

        public String toString() {
            return "isAnnotatedBy(" + this.annotationType + ')';
        }
    }

    private static class DeclaringTypeMethodMatcher
    extends JunctionMethodMatcher.AbstractBase {
        private final TypeDescription declaringType;

        private DeclaringTypeMethodMatcher(Class<?> declaringType) {
            this.declaringType = new TypeDescription.ForLoadedType(declaringType);
        }

        private DeclaringTypeMethodMatcher(TypeDescription declaringType) {
            this.declaringType = declaringType;
        }

        @Override
        public boolean matches(MethodDescription methodDescription) {
            return methodDescription.getDeclaringType().equals(this.declaringType);
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && this.declaringType.equals(((DeclaringTypeMethodMatcher)o).declaringType);
        }

        public int hashCode() {
            return this.declaringType.hashCode();
        }

        public String toString() {
            return "declaredBy(" + this.declaringType + ')';
        }
    }

    private static class VisibilityMethodMatcher
    extends JunctionMethodMatcher.AbstractBase {
        private final TypeDescription typeDescription;

        private VisibilityMethodMatcher(TypeDescription typeDescription) {
            this.typeDescription = typeDescription;
        }

        @Override
        public boolean matches(MethodDescription methodDescription) {
            return methodDescription.isVisibleTo(this.typeDescription);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.typeDescription.equals(((VisibilityMethodMatcher)other).typeDescription);
        }

        public int hashCode() {
            return this.typeDescription.hashCode();
        }

        public String toString() {
            return "visibleTo(" + this.typeDescription + ')';
        }
    }

    private static class DefaultFinalizeMethodMatcher
    extends JunctionMethodMatcher.AbstractBase {
        private static final String FINALIZE_METHOD_NAME = "finalize";

        private DefaultFinalizeMethodMatcher() {
        }

        @Override
        public boolean matches(MethodDescription methodDescription) {
            return methodDescription.getDeclaringType().represents(Object.class) && methodDescription.getName().equals(FINALIZE_METHOD_NAME) && methodDescription.getParameterTypes().size() == 0;
        }

        public boolean equals(Object other) {
            return other == this || other instanceof DefaultFinalizeMethodMatcher;
        }

        public String toString() {
            return "isDefaultFinalizer()";
        }

        public int hashCode() {
            return 54;
        }
    }

    private static class OverridableMethodMatcher
    extends JunctionMethodMatcher.AbstractBase {
        private OverridableMethodMatcher() {
        }

        @Override
        public boolean matches(MethodDescription methodDescription) {
            return methodDescription.isOverridable();
        }

        public boolean equals(Object other) {
            return other == this || other instanceof OverridableMethodMatcher;
        }

        public String toString() {
            return "isOverridable()";
        }

        public int hashCode() {
            return 51;
        }
    }

    private static class IsMethodMethodMatcher
    extends JunctionMethodMatcher.AbstractBase {
        private IsMethodMethodMatcher() {
        }

        @Override
        public boolean matches(MethodDescription methodDescription) {
            return !methodDescription.isConstructor();
        }

        public boolean equals(Object other) {
            return other == this || other instanceof IsMethodMethodMatcher;
        }

        public String toString() {
            return "isMethod()";
        }

        public int hashCode() {
            return 47;
        }
    }

    private static class MethodSignatureMethodMatcher
    extends JunctionMethodMatcher.AbstractBase {
        private final MethodDescription methodDescription;

        private MethodSignatureMethodMatcher(MethodDescription methodDescription) {
            this.methodDescription = methodDescription;
        }

        @Override
        public boolean matches(MethodDescription methodDescription) {
            return methodDescription.getInternalName().equals(this.methodDescription.getInternalName()) && methodDescription.getReturnType().equals(this.methodDescription.getReturnType()) && methodDescription.getParameterTypes().equals(this.methodDescription.getParameterTypes());
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.methodDescription.equals(((MethodSignatureMethodMatcher)other).methodDescription);
        }

        public int hashCode() {
            return this.methodDescription.hashCode();
        }

        public String toString() {
            return "signatureOf(" + this.methodDescription + ')';
        }
    }

    private static class ConstructorEqualityMethodMatcher
    extends JunctionMethodMatcher.AbstractBase {
        private final Constructor<?> constructor;

        public ConstructorEqualityMethodMatcher(Constructor<?> constructor) {
            this.constructor = constructor;
        }

        @Override
        public boolean matches(MethodDescription methodDescription) {
            return methodDescription.represents(this.constructor);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.constructor.equals(((ConstructorEqualityMethodMatcher)other).constructor);
        }

        public int hashCode() {
            return this.constructor.hashCode();
        }

        public String toString() {
            return "is(" + this.constructor + ')';
        }
    }

    private static class MethodEqualityMethodMatcher
    extends JunctionMethodMatcher.AbstractBase {
        private final Method method;

        public MethodEqualityMethodMatcher(Method method) {
            this.method = method;
        }

        @Override
        public boolean matches(MethodDescription methodDescription) {
            return methodDescription.represents(this.method);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.method.equals(((MethodEqualityMethodMatcher)other).method);
        }

        public int hashCode() {
            return this.method.hashCode();
        }

        public String toString() {
            return "is(" + this.method + ')';
        }
    }

    private static class MethodDescriptionMatcher
    extends JunctionMethodMatcher.AbstractBase {
        private final MethodDescription methodDescription;

        private MethodDescriptionMatcher(MethodDescription methodDescription) {
            this.methodDescription = methodDescription;
        }

        @Override
        public boolean matches(MethodDescription methodDescription) {
            return methodDescription.equals(this.methodDescription);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.methodDescription.equals(((MethodDescriptionMatcher)other).methodDescription);
        }

        public int hashCode() {
            return this.methodDescription.hashCode();
        }

        public String toString() {
            return "is(" + this.methodDescription + ')';
        }
    }

    private static class ExceptionMethodMatcher
    extends JunctionMethodMatcher.AbstractBase {
        private final TypeDescription exceptionType;

        public ExceptionMethodMatcher(TypeDescription exceptionType) {
            this.exceptionType = exceptionType;
        }

        @Override
        public boolean matches(MethodDescription methodDescription) {
            for (TypeDescription exceptionType : methodDescription.getExceptionTypes()) {
                if (!exceptionType.isAssignableFrom(this.exceptionType)) continue;
                return true;
            }
            return false;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.exceptionType.equals(((ExceptionMethodMatcher)other).exceptionType);
        }

        public int hashCode() {
            return this.exceptionType.hashCode();
        }

        public String toString() {
            return "canThrow(" + this.exceptionType + ')';
        }
    }

    private static class ReturnSupertypeMatcher
    extends JunctionMethodMatcher.AbstractBase {
        private final TypeDescription returnType;

        public ReturnSupertypeMatcher(TypeDescription returnType) {
            this.returnType = returnType;
        }

        @Override
        public boolean matches(MethodDescription methodDescription) {
            return methodDescription.getReturnType().isAssignableFrom(this.returnType);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.returnType.equals(((ReturnSupertypeMatcher)other).returnType);
        }

        public int hashCode() {
            return this.returnType.hashCode();
        }

        public String toString() {
            return "returnsSupertypeOf(" + this.returnType + ')';
        }
    }

    private static class ReturnSubtypeMatcher
    extends JunctionMethodMatcher.AbstractBase {
        private final TypeDescription returnType;

        public ReturnSubtypeMatcher(TypeDescription returnType) {
            this.returnType = returnType;
        }

        @Override
        public boolean matches(MethodDescription methodDescription) {
            return methodDescription.getReturnType().isAssignableTo(this.returnType);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.returnType.equals(((ReturnSubtypeMatcher)other).returnType);
        }

        public int hashCode() {
            return this.returnType.hashCode();
        }

        public String toString() {
            return "returnsSubtypeOf(" + this.returnType + ')';
        }
    }

    private static class ReturnTypeMatcher
    extends JunctionMethodMatcher.AbstractBase {
        private final TypeDescription returnType;

        public ReturnTypeMatcher(TypeDescription returnType) {
            this.returnType = returnType;
        }

        @Override
        public boolean matches(MethodDescription methodDescription) {
            return methodDescription.getReturnType().equals(this.returnType);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.returnType.equals(((ReturnTypeMatcher)other).returnType);
        }

        public int hashCode() {
            return this.returnType.hashCode();
        }

        public String toString() {
            return "returns(" + this.returnType + ')';
        }
    }

    private static class ParameterCountMatcher
    extends JunctionMethodMatcher.AbstractBase {
        private final int numberOfParameters;

        private ParameterCountMatcher(int numberOfParameters) {
            this.numberOfParameters = numberOfParameters;
        }

        @Override
        public boolean matches(MethodDescription methodDescription) {
            return methodDescription.getParameterTypes().size() == this.numberOfParameters;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.numberOfParameters == ((ParameterCountMatcher)other).numberOfParameters;
        }

        public int hashCode() {
            return this.numberOfParameters;
        }

        public String toString() {
            return "parameterCount(" + this.numberOfParameters + ')';
        }
    }

    private static class ParameterSuperTypeMatcher
    extends JunctionMethodMatcher.AbstractBase {
        private final List<? extends TypeDescription> parameterTypes;

        private ParameterSuperTypeMatcher(List<? extends TypeDescription> parameterTypes) {
            this.parameterTypes = parameterTypes;
        }

        @Override
        public boolean matches(MethodDescription methodDescription) {
            TypeList parameterTypes = methodDescription.getParameterTypes();
            if (parameterTypes.size() != this.parameterTypes.size()) {
                return false;
            }
            int currentIndex = 0;
            for (TypeDescription parameterType : parameterTypes) {
                if (parameterType.isAssignableFrom(this.parameterTypes.get(currentIndex++))) continue;
                return false;
            }
            return true;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.parameterTypes.equals(((ParameterSuperTypeMatcher)other).parameterTypes);
        }

        public int hashCode() {
            return this.parameterTypes.hashCode();
        }

        public String toString() {
            return "parametersAssignableFrom(" + this.parameterTypes + ')';
        }
    }

    private static class ParameterSubtypeMatcher
    extends JunctionMethodMatcher.AbstractBase {
        private final List<? extends TypeDescription> parameterTypes;

        private ParameterSubtypeMatcher(List<? extends TypeDescription> parameterTypes) {
            this.parameterTypes = parameterTypes;
        }

        @Override
        public boolean matches(MethodDescription methodDescription) {
            TypeList parameterTypes = methodDescription.getParameterTypes();
            if (parameterTypes.size() != this.parameterTypes.size()) {
                return false;
            }
            int currentIndex = 0;
            for (TypeDescription parameterType : parameterTypes) {
                if (parameterType.isAssignableTo(this.parameterTypes.get(currentIndex++))) continue;
                return false;
            }
            return true;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.parameterTypes.equals(((ParameterSubtypeMatcher)other).parameterTypes);
        }

        public int hashCode() {
            return this.parameterTypes.hashCode();
        }

        public String toString() {
            return "parametersAssignableTo(" + this.parameterTypes + ')';
        }
    }

    private static class ParameterTypeMatcher
    extends JunctionMethodMatcher.AbstractBase {
        private final List<? extends TypeDescription> parameterTypes;

        private ParameterTypeMatcher(List<? extends TypeDescription> parameterTypes) {
            this.parameterTypes = parameterTypes;
        }

        @Override
        public boolean matches(MethodDescription methodDescription) {
            return methodDescription.getParameterTypes().equals(this.parameterTypes);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.parameterTypes.equals(((ParameterTypeMatcher)other).parameterTypes);
        }

        public int hashCode() {
            return this.parameterTypes.hashCode();
        }

        public String toString() {
            return "parameters(" + this.parameterTypes + ')';
        }
    }

    private static class ModifierMethodMatcher
    extends JunctionMethodMatcher.AbstractBase {
        private final int modifiers;

        public ModifierMethodMatcher(int modifiers) {
            this.modifiers = modifiers;
        }

        @Override
        public boolean matches(MethodDescription methodDescription) {
            return (methodDescription.getModifiers() & this.modifiers) != 0;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.modifiers == ((ModifierMethodMatcher)other).modifiers;
        }

        public String toString() {
            return "modifiers(" + this.modifiers + ')';
        }

        public int hashCode() {
            return this.modifiers;
        }
    }

    private static class MethodNameMethodMatcher
    extends JunctionMethodMatcher.AbstractBase {
        private final String name;
        private final MatchMode matchMode;

        public MethodNameMethodMatcher(String name, MatchMode matchMode) {
            this.name = name;
            this.matchMode = matchMode;
        }

        @Override
        public boolean matches(MethodDescription methodDescription) {
            return this.matchMode.matches(this.name, methodDescription.getName());
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.matchMode == ((MethodNameMethodMatcher)other).matchMode && this.name.equals(((MethodNameMethodMatcher)other).name);
        }

        public int hashCode() {
            return 31 * this.name.hashCode() + this.matchMode.hashCode();
        }

        public String toString() {
            return this.matchMode.getDescription() + '(' + this.name + ')';
        }
    }

    private static enum MatchMode {
        EQUALS_FULLY("named"),
        EQUALS_FULLY_IGNORE_CASE("namedIgnoreCase"),
        STARTS_WITH("startsWith"),
        STARTS_WITH_IGNORE_CASE("startsWithIgnoreCase"),
        ENDS_WITH("endsWith"),
        ENDS_WITH_IGNORE_CASE("endsWithIgnoreCase"),
        CONTAINS("contains"),
        CONTAINS_IGNORE_CASE("containsIgnoreCase"),
        MATCHES("matches");

        private final String description;

        private MatchMode(String description) {
            this.description = description;
        }

        private String getDescription() {
            return this.description;
        }

        private boolean matches(String left, String right) {
            switch (this) {
                case EQUALS_FULLY: {
                    return right.equals(left);
                }
                case EQUALS_FULLY_IGNORE_CASE: {
                    return right.equalsIgnoreCase(left);
                }
                case STARTS_WITH: {
                    return right.startsWith(left);
                }
                case STARTS_WITH_IGNORE_CASE: {
                    return right.toLowerCase().startsWith(left.toLowerCase());
                }
                case ENDS_WITH: {
                    return right.endsWith(left);
                }
                case ENDS_WITH_IGNORE_CASE: {
                    return right.toLowerCase().endsWith(left.toLowerCase());
                }
                case CONTAINS: {
                    return right.contains(left);
                }
                case CONTAINS_IGNORE_CASE: {
                    return right.toLowerCase().contains(left.toLowerCase());
                }
                case MATCHES: {
                    return right.matches(left);
                }
            }
            throw new AssertionError((Object)("Unknown match mode: " + (Object)((Object)this)));
        }
    }
}

